
/*
 * lpsd -- dedicated line printer daemon for supporting the lps utility.
 *
 * Listen for a connection and perform the requested operation.
 * Operations are:
 *	\3printer [users ...] [jobs ...]\n
 *		return the current state of the queue (short form).
 */

#include "lp.h"
#define LPSDMASTERLOCK "/usr/spool/lpsd.lock"
#define LPSDSOCKETNAME "/dev/lpsd"
/*#define DEBUG 0*/

int	lflag;				/* log requests flag */
int	reapchild();
int	mcleanup();

main(argc, argv)
	int argc;
	char **argv;
{
	int f, funix, finet, options, defreadfds, fromlen;
	struct sockaddr_un xxsun, fromunix;
	struct sockaddr_in sin, frominet;
	int omask, lfd;
	int pid;

	gethostname(host, sizeof(host));
	name = argv[0];

	while (--argc > 0) {
		argv++;
		if (argv[0][0] == '-')
			switch (argv[0][1]) {
			case 'd':
				options |= SO_DEBUG;
				break;
			case 'l':
				lflag++;
				break;
			}
	}

#ifndef DEBUG
	/*
	 * Set up standard environment by detaching from the parent.
	 */
	if (fork())
		exit(0);
	for (f = 0; f < 5; f++)
		(void) close(f);
	(void) open("/dev/null", O_RDONLY);
	(void) open("/dev/null", O_WRONLY);
	(void) dup(1);
	f = open("/dev/tty", O_RDWR);
	if (f > 0) {
		ioctl(f, TIOCNOTTY, 0);
		(void) close(f);
	}
#endif

	openlog("lpsd", LOG_PID, LOG_LPR);
	(void) umask(0);
	lfd = open(LPSDMASTERLOCK, O_WRONLY|O_CREAT, 0644);
	if (lfd < 0) {
		syslog(LOG_ERR, "%s: %m", LPSDMASTERLOCK);
		exit(1);
	}
	if (flock(lfd, LOCK_EX|LOCK_NB) < 0) {
		if (errno == EWOULDBLOCK)	/* active deamon present */
			exit(0);
		syslog(LOG_ERR, "%s: %m", LPSDMASTERLOCK);
		exit(1);
	}
	ftruncate(lfd, 0);
	/*
	 * write process id for others to know
	 */
	sprintf(line, "%u\n", getpid());
	f = strlen(line);
	if (write(lfd, line, f) != f) {
		syslog(LOG_ERR, "%s: %m", LPSDMASTERLOCK);
		exit(1);
	}
	signal(SIGCHLD, reapchild);
	(void) unlink(LPSDSOCKETNAME);
	funix = socket(AF_UNIX, SOCK_STREAM, 0);
	if (funix < 0) {
		syslog(LOG_ERR, "socket: %m");
		exit(1);
	}
#define	mask(s)	(1 << ((s) - 1))
	omask = sigblock(mask(SIGHUP)|mask(SIGINT)|mask(SIGQUIT)|mask(SIGTERM));
	signal(SIGHUP, mcleanup);
	signal(SIGINT, mcleanup);
	signal(SIGQUIT, mcleanup);
	signal(SIGTERM, mcleanup);
	xxsun.sun_family = AF_UNIX;
	strcpy(xxsun.sun_path, LPSDSOCKETNAME);
	if (bind(funix, &xxsun, strlen(xxsun.sun_path) + 2) < 0) {
		syslog(LOG_ERR, "ubind: %m");
		exit(1);
	}
	sigsetmask(omask);
	defreadfds = 1 << funix;
	listen(funix, 5);
	finet = socket(AF_INET, SOCK_STREAM, 0);
	if (finet >= 0) {
		struct servent *sp;

		if (options & SO_DEBUG)
			if (setsockopt(finet, SOL_SOCKET, SO_DEBUG, 0, 0) < 0) {
				syslog(LOG_ERR, "setsockopt (SO_DEBUG): %m");
				mcleanup();
			}
		sp = getservbyname("printer_status", "tcp");
		if (sp == NULL) {
			syslog(LOG_ERR, "lps/tcp: unknown service");
			mcleanup();
		}
		bzero((char *)&sin, sizeof(struct sockaddr_in));
		sin.sin_family = AF_INET;
		sin.sin_port = (unsigned short)sp->s_port;
		if (bind(finet, (struct sockaddr *)&sin, sizeof(sin), 0) < 0) {
			syslog(LOG_ERR, "bind: %m");
			mcleanup();
		}
		defreadfds |= 1 << finet;
		listen(finet, 5);
	}
	/*
	 * Main loop: accept, do a request, continue.
	 */
	for (;;) {
		int domain, nfds, s, readfds = defreadfds;

		nfds = select(20, &readfds, 0, 0, 0);
		if (nfds <= 0) {
			if (nfds < 0 && errno != EINTR)
				syslog(LOG_WARNING, "select: %m");
			continue;
		}
		if (readfds & (1 << funix)) {
			domain = AF_UNIX, fromlen = sizeof(fromunix);
			s = accept(funix, &fromunix, &fromlen);
		} else if (readfds & (1 << finet)) {
			domain = AF_INET, fromlen = sizeof(frominet);
			s = accept(finet, &frominet, &fromlen);
		}
		if (s < 0) {
			if (errno != EINTR)
				syslog(LOG_WARNING, "accept: %m");
			continue;
		}
		if ((pid = fork()) == 0) {
			signal(SIGCHLD, SIG_IGN);
			signal(SIGHUP, SIG_IGN);
			signal(SIGINT, SIG_IGN);
			signal(SIGQUIT, SIG_IGN);
			signal(SIGTERM, SIG_IGN);
			dup2(s, 1);
			dup2(s, 2);
			if (domain == AF_INET){
			    chkhost(&frominet);
			    (void) close(finet);
			}
			else if (domain == AF_UNIX)
			    (void) close(funix);
			doit();
			fprintf(stderr,"FATAL - returned from doit()");
			fatal("Returned from doit()");
			exit();
		    }
		else
		    syslog(LOG_INFO, "fork returned pid of %d", pid);
		(void) close(s);
	}
}

reapchild()
{
	union wait status;

	while (wait3(&status, WNOHANG, 0) > 0)
		;
}

mcleanup()
{
	if (lflag)
		syslog(LOG_INFO, "exiting");
	unlink(LPSDSOCKETNAME);
	exit(0);
}

/*
 * Stuff for handling job specifications
 */
char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */
char	*person;		/* name of person doing lprm */

char	fromb[32];	/* buffer for client's machine name */
char	cbuf[BUFSIZ];	/* command line buffer */
char	*cmdnames[] = {
	"null",
	"printjob",
	"recvjob",
	"displayq short",
	"displayq long",
	"rmjob"
};

doit()
{
    register char *cp;
    register int n;
    
    for (;;) {
	cp = cbuf;
	cp[0] = '\0';
	do {
	    if (cp >= &cbuf[sizeof(cbuf) - 1])
		fatal("Command line too long");
	    if ((n = read(1, cp, 1)) != 1) {
		syslog(LOG_INFO, "read returned %s with status of %d & errno =%d", cp, n, errno);
		if (n < 0)
		    fatal("Lost connection");
		return;
	    }
#ifdef DEBUG
	    cp[1]='\0';
	    syslog(LOG_INFO, "read ret %d byte msg of 0xd%hi %s", n, (short)cp[0], cp);
#endif
	} while (*cp++ != '\n');
	*--cp = '\0';
	cp = cbuf;
	if (lflag) {
	    if (*cp >= '\1' && *cp <= '\5')
		syslog(LOG_INFO, "%s requests %s %s",
		       from, cmdnames[*cp], cp+1);
	    else
		syslog(LOG_INFO, "bad request (%d) from %s",
		       *cp, from);
	}
	switch (*cp++) {
	    
	case '\3':	/* display the queue (short form) */
	    
	    printer = cp;
	    while (*cp) {
		if (*cp != ' ') {
		    cp++;
		    continue;
		}
		*cp++ = '\0';
		while (isspace(*cp))
		    cp++;
		if (*cp == '\0')
		    break;
		if (isdigit(*cp)) {
		    if (requests >= MAXREQUESTS)
			fatal("Too many requests");
		    requ[requests++] = atoi(cp);
		} else {
		    if (users >= MAXUSERS)
			fatal("Too many users");
		    user[users++] = cp;
		}
	    }
	    displayq(cbuf[0] - '\3');
	    puts ("/eof/");	                            /* mark end of transmission */
	    fflush(stdout);
	    break;
	default:
	    fatal("Illegal service request");
	}
    }
}


#define DUMMY ":nobody::"

/*
 * Check to see if the from host has access to the line printer.
 */
chkhost(f)
	struct sockaddr_in *f;
{
	register struct hostent *hp;
	register FILE *hostf;
	register char *cp, *sp;
	char ahost[50];
	int first = 1;
	extern char *inet_ntoa();
	int baselen = -1;

	f->sin_port = ntohs(f->sin_port);
	if (f->sin_family != AF_INET || f->sin_port >= IPPORT_RESERVED)
		fatal("Malformed from address");
	hp = gethostbyaddr(&f->sin_addr, sizeof(struct in_addr), f->sin_family);
	if (hp == 0)
		fatal("Host name for your address (%s) unknown",
			inet_ntoa(f->sin_addr));

	strcpy(fromb, hp->h_name);
	from = fromb;
	if (!strcmp(from, host))
		return;
	return;
}
