.TH editprintcap 1 "Display and/or Modify /etc/printcap data" "X11R4"
.SH Name
editprintcap \- X-based /etc/printcap database display/modification program.
.SH Description
An X-based program for displaying the contents of the /etc/printcap
database, and to optionally allow a priviliged user to modify the data.
.PP
Builds a screen with one horizontal line for each queue defined in
/etc/printcap and one vertical colume for each parameter defined for that
(all) queues. Users with root privilages may modify this file.  All
modifications are menu based and changes are not committed to the file
unless confirmed by the user. Uncommitted changes are shown in reverse
video on the users screen, and committed changes are shown in grey-scale.
.SH Appearance and Screen Utilization
Upon invocation \fIeditprintcap\fP builds a complex form window located across
the entire upper portion of the display screen. Down the left hand side of
this window is a vertical stationary list of all queues defined in /etc/printcap.
Immediately to the right of this list is a horizontally scrolled section
displaying all of the switches and options found defined in /etc/printcap
for each queue. The user must scroll the display to view the entire list,
which is usually larger than the screen by a factor of five or more, using
the scrollbar immediately above this area.
.PP
As the user moves the mouse cursor around in the scrolled areas, a prompt
window located just below the quit command button (in the upper left hand
portion of the window) is continuously updated. Depressing the left mouse
button will cause a popup window to appear immediately below the entry
to be affected that contains a list of all allowable changes to that entry.
Moving the cursor up and down this list will cause each choice to highlight
as the cursor passes through. Clicking the left mouse on any one of these
choices will cause that choice to replace the entry in that field \fIon the
display screen ONLY\fP. The new entry now appears in reverse video and a
\fICommit Changes\fP command button will appear next to the quit command
button. 
.PP
The \fICommit Changes\fP command button will appear in sharp outline if 
the \fIeditprintcap\fP program was invoked from a root account, indicating that clicking on
this button will cause the changes to be committed. Conversely, the
\fICommit Changes\fP button will appear in shadow outline if 
the \fIeditprintcap\fP program was invoked by other than root, indicating that this
command button is not active and will not accept commands.
.PP
In the upper right hand portion of the window may appear a small warning
window stating that "Printcap file opened READONLY - You must be ROOT for
write access". Obviously this window appears only when the program was
invoked from an account other than root.
.PP
Clicking on the \fICommit Changes\fP command button (if enabled) will cause
all changes entered so far (indicated in reverse video) to be made to the
file. If the writing of a new file succeeds, then all of the changes will
switch from reverse video to grey-scale.
.PP
Clicking on the Quit command button will cause a quit confirmation window
to appear, and may also cause an information window to appear stating
"WARNING - Changes have been made and NOT saved!". Clicking on \fIYES\fP in
the quit confirmation window causes the program to exit, clicking on
\fINO\fP returns you back to browse and edit mode.
.SH Syntax
editprintcap [any standard X-window command line switch or option]
.SH Options
Although \fIeditprintcap\fP will accept most standard X-window command line
switches or options, the user should refrain from attempting to alter the
window size or default fonts. 
.SH Example
editprintcap -geom +0+0
.SH Environment
This suite of programs has been built and run under most SunOs and DEC
ULTRIX systems using TWM and TVWM window managers. Running the program
under Motif or OpenLook can produce some weird results, depending on the
settings of certain(??) window manager variables. We have not attempted to
run these programs under the DECWINDOWS Window Manager.

.SH See Also
lps(1), lpsV2(1), server(1), outputAge(1), lpinfo(1)
.SH Errors
All error messages are sent to stderr.
.SH Bugs
Does not handle window resizes or geometry changes gracefully.
.SH Copyright
1991 at NASA-Ames Research Center. Some portions of this program were
taken from the Berkeley spooler programs and from certain programs
contained in the MIT X11R4 release. Individual copyrights have been
reproduced for those portions affected.
.SH Author
.EX
Roger Smith
NASA-Ames Research Center
Mail Stop 233-10
Moffett Field, Ca. 94035
EMAIL: rsmith@george.arc.nasa.gov

REFER ANY PROBELMS OR BUG REPORTS TO:
	Roger Smith  x4-3583 or rsmith@george.arc.nasa.gov
	Ken Burgess  x4-6347 or kburgess@franklin.arc.nasa.gov
.EE

.SH Release
V1-1 March 1991
