.TH XHTALK 1 local
.SH NAME
xhtalk \- simple talk interface ..
.SH SYNOPSIS
.B xhtalk
[
.I -toolkitoption ...
][ -f
.I filename
][ -timeout
.I seconds
][ -update
.I minutes
][ -idle
.I minutes
][ -prog
.I program
][ -all ][+/-tty ][ +/-info ][ +/-dIdle][ +/-dLight ][ +/-color ]
[ -idleOneCol
.I color
][ -idleTwoCol
.I color
][ -idleThreeCol
.I color
][ -buttonFont
.I font
][ -debug ][ -help ]
.PP
.SH DESCRIPTION
.I Xhtalk
looks periodically for several users on a number of hosts using the
finger protocol. The found users
are displayed in the xhtalk-window. By clicking on a user's name with the
left mouse-button, a talk or a xhchat (similar to xtalk, but better)
or a user-defined command will be executed.
.br
The middle or right mouse-button pops up a small info window with the
complete line of the finger-info of the corresponding user.
.br
The usernames and hostnames are stored in a file.
.br
On default, users which are idle for more than one hour are not
displayed. A Timeout mechanism in the finger-routines interrupts
the connection to a host after 20 seconds (default). The requests
are canceled after 20 seconds.

.PP
.SH OPTIONS
Xhtalk accepts all of the standard X Toolkit command line options
as well as the following:
.br
.TP 15
.B "\-f \fI filename"
This option sets the filename of the xhtalk configuration file. The
default is ".xhtalk" in the user's $HOME directory.
A full pathname is required.
.br
.TP 15
.B "\-timeout \fI seconds"
This option sets the timeout value for the finger-routine.
The default value is 20 seconds.
.br
.TP 15
.B "\-update \fI minutes"
This option sets the update interval of xhtalk. The default value
is 3 minutes. It should not be useful to join a smaller update interval
than 2 minutes, because the request to only one host could take more than
five seconds. If a large amount of hosts (to be defined in the configuration
file) have to be requested, xhtalk reacts very sluggish on mouse clicks.
.TP 15
.B "\-idle \fI minutes"
This option sets the idle time value of xhtalk. 
If the idle time of a user's tty is greater than this value, the
user will not be displayed. The default value is 60 minutes.
The idle option can be turned
.I off
by a value <= 0.
.TP 15
.B "\-tty | +tty"
If this option is unset (-tty), users are displayed only if they are logged
on console. 
On default (+tty), a user is displayed for one host, if logged
.I only
on a tty, but not on console
.I or
if logged on console.
.TP 15
.B "\-prog \fI program"
This option defines an additional program or shellscript to be called
instead of talk or xhchat. The activation executes a string of the form:
<program><username>@<hostname>.
.TP 15
.B "\-all"
If this option is turned on, more than one console can be displayed for
.I one
user. If not, the console with the smallest idle time is displayed.
.TP 15
.B "\-info | +info"
This option sets or unsets the additional info option.
If the additional info is turned on, a small rectangle (X11R5) is displayed on the
left of each user, who is logged on console. The info option is
automatically turned off, if the tty option is set.
.TP 15
.B "\-dIdle | +dIdle"
If the dIdle option is set by +dIdle (default), the user's idle time is
displayed on the right of the username of each button.
.TP 15
.B "\-dLight | +dLight"
This option turns off/on the activity light. The activity light is
displayed as a small arrow in the top left corner of the xhtalk label
when the finger requests are running.
.TP 15
.B "\-color | +color"
This option turns off/on the idle-colors. There are three colors:
idleOneColor for less than a 1/3 idle, idleTwoColor for more than
1/3 idle and less than 2/3 idle and idleThreeColor for more than 2/3 idle.
The color values can be set by resources or via commandline-options.
.TP 15
.B "\-idleOneCol \fI   color"
.TP 15
.B "\-idleTwoCol \fI color"
.TP 15
.B "\-idleThreeCol \fI color"
These options set the three idleColors. They only work when the
idle-color option is turned on.
.TP 15
.B "\-buttonFont \fI font"
This option sets the font of the user-buttons, the talk-menue and
the info-menue of xhtalk.
.TP 15
.B "\-debug"
This option turns the debug mode on. In the debug mode, all error-
and timeout messages from finger routines are printed to stderr.
.TP 15
.B "\-help | \-h"
Prints a help message with settable options.
.PP
.SH RESOURCES
Xhtalk understands all of the core X Toolkit resource names and classes
as well as:
.TP 15
.B "update (class UpdateVal)"
Specifies the update interval. (number)
.TP 15
.B "idle (class Idle)"
Specifies the idle interval. (number)
.TP 15
.B "tty (class Tty)"
If set False, only users, logged on console, are displayed.  (True/False)
.TP 15
.B "config (class Config)"
Specifies the configuration file name. (string)
.TP 15
.B "timeout (class Timeout)"
Specifies the finger-cmd timeout in seconds. (number)
.TP 15
.B "debug (class Debug)"
"True" turns the debug mode on.  (True/False)
.TP 15
.B "info (class Info)"
Sets the info option. (True/False)
.TP 15
.B "dIdle (class DIdle)"
Sets the dIdle option. (True/False)
.TP 15
.B "listall (class Listall)"
Sets the all option. (True/False)

.TP 15
.B "useColor (class UseColor)
Sets the idle-color  option. (True/False)
.TP 15
.B "idleOneColor (class IdleOneColor)"
Sets the color for no-idle. (Colorname)
.TP 15
.B "idleTwoColor (class IdleTwoColor)"
Sets the color for half-idle. (Colorname)
.TP 15
.B "idleThreeColor (class IdleThreeColor)"
Sets the color for half-idle. (Colorname)
.TP 15
.B "buttonFont (class ButtonFont)"
Sets the font of user-buttons, talk-menue and info-menue. (Fontname)
.PP
.SH SYNTAX OF CONFIGURATION FILE
The configuration file specifies the usernames, to be searched for and the
hosts, to be searched on. /* Comments in c-syntax are allowed. */
.br

.I configfile
::
host {
.I hostlist
}
name {
.I namelist
}
.br

.I hostlist
::
.I string
|
.I hostlist
,
.I string
.br
.I namelist
::
.I string
|
.I namelist
,
.I string
.br

A
.I string
must be laced by '"'. The usernames in the
.I namelist
have to be the login names. The hosts can be defined by their names
or their internet addresses.
.PP
.SH EXAMPLE CONFIGURATION FILE
.br

.nf
host {
	"i60s15","i60s25",
	"mykene","bassai",
	"prydain","nimrud",
	"129.13.11.121",
	"pythagoras",
	"ftp.uni-kl.de"
}
name {
	"joggerst",
	"regitz",
 	"nolting",
	"riedel",
	"mauch",
	"kdh",
	"eiberger",
	"ub"
}



.br
.TT
.SH FILES (DEFAULT)
.TP 15
"$HOME/.xhtalk"
xhtalk configuration file.
.TT
.SH AUTOR
Klaus Hartenstein, Uni Karlsruhe F.R.G. kdh@ira.uka.de
.br
November 1992
.br

