/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	xftp_trdir.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
	
	
#include 	<xftp.h>

#ifdef	SUN
#include 	<sys/dirent.h>
#endif

typedef	struct {
	char	*name;
	char	*time;
	char	*wd;
	char	*month;
	char	*size;
	char	*flag;
	char	is_dir;
}dir_list;

#define	MAX_STR_LEN	125

format_dir(char *dir_e[MAX_DIR_ENTRY],char *t_file,int status)
{

	dir_list	d_l[MAX_DIR_ENTRY];
	int		x;
	int	i;

	init_field(d_l);
	if(!status)
	{
		if(simple_list)
		{
			if((x=read_tmp_file(d_l,t_file)) == -1)
				return -1;
		}
		else
		{
			if((x=read_simple_tmp_file(dir_e,t_file)) == -1)
				return -1;
			
			return x;
		}
	}
	else
	{
		if((x=xread_dir(d_l,t_file)) == -1)
			return -1;
	}
	
 	x=f_dir(dir_e,d_l,x);

	return x;
}

init_field(dir_list d_l[MAX_DIR_ENTRY])
{
	int	i;

	for(i=0;i<MAX_DIR_ENTRY-1;i++)
	{
		d_l[i].name=NULL;
		d_l[i].time=NULL;
		d_l[i].wd=NULL;
		d_l[i].month=NULL;
		d_l[i].size=NULL;
		d_l[i].flag=NULL;
		d_l[i].is_dir=FALSE;
	}
}

xread_dir(dir_list d_l[MAX_DIR_ENTRY],char *xdir)
{
	int		a;
	static	char	*DStr[]={
					"Jan","Feb","Mar","Apr","Mai","Jun","Jul",
					"Aug","Sep","Oct","Nov","Dec"};
	char	*tstr=NULL;
	char	*tstr2=NULL;
	struct	tm	*zeit;
	struct passwd *pp;
	struct group  *gg;
	struct	stat	stbuf;
	struct dirent	*entry;
	DIR		*dir;
	int		ptr=0;

	if((dir = opendir(xdir)) == NULL)
		return -1;
	
	tstr= XtMalloc(2048);

	dir_info.files=0;
	dir_info.subdirs=0;
	dir_info.size=0L;
	while((entry = readdir(dir)) != NULL)
	{
		if(entry->d_ino == 0L)
			continue;

		if(entry->d_name[0] == '.' && !entry->d_name[1] ) 
			continue;

		if(entry->d_name[0] == '.' && entry->d_name[1] == '.')
			continue;	
		stat(entry->d_name,&stbuf);

		zeit = localtime(&stbuf.st_mtime);

		if ((stbuf.st_mode & S_IFMT) == S_IFDIR)
		{
			d_l[ptr].is_dir=TRUE;
			dir_info.subdirs++;
		}
		else
			dir_info.files++;

		d_l[ptr].flag =  XtMalloc(2);
		strcpy(d_l[ptr].flag," ");

		d_l[ptr].name =   XtMalloc(strlen(entry->d_name)+1);
		strcpy(d_l[ptr].name,entry->d_name);

		sprintf(tstr,"%02d:%02d ",zeit->tm_hour,zeit->tm_min);

		d_l[ptr].time =  XtMalloc(strlen(tstr)+1);
		strcpy(d_l[ptr].time,tstr);

		sprintf(tstr,"%02d",zeit->tm_mday);

		d_l[ptr].wd =   XtMalloc(strlen(tstr)+1);
		strcpy(d_l[ptr].wd,tstr);

		d_l[ptr].month =   XtMalloc(strlen(DStr[zeit->tm_mon])+1);
		strcpy(d_l[ptr].month,DStr[zeit->tm_mon]);

		dir_info.size+=stbuf.st_size;
		sprintf(tstr,"%10u",stbuf.st_size);
		d_l[ptr].size =   XtMalloc(strlen(tstr)+1);
		strcpy(d_l[ptr].size,tstr);

		if(ptr >= MAX_DIR_ENTRY-1)
		{
			tstr2=XtMalloc(80);
			sprintf(tstr2,"Can't read more than %d items",MAX_DIR_ENTRY);
			ftp_error(tstr2);
			XtFree(tstr2);
			break;
		}
		ptr++;
	}
	closedir(dir);
	XtFree(tstr);
	return ptr;	
}

f_dir(char	*dir_e[MAX_DIR_ENTRY], dir_list d_l[MAX_DIR_ENTRY],int x)
{
	int		i,a,b;
	int		y;
	char	tstr[512];

	a=strlen(d_l[0].name);
	for(i=1;i<x;i++)
	{
		b=strlen(d_l[i].name);
		a=(b>a)?b:a;
	}

	a=(a > MAX_STR_LEN)?MAX_STR_LEN:a;


	if(!a)
		sprintf(tstr,"D ..");
	else	
		sprintf(tstr,"D %-*.*s                           ",a,a,"..");
	dir_e[0]=  XtMalloc(strlen(tstr)+1);
	strcpy(dir_e[0],tstr);
	for(i=1;i<x+1;i++)
	{
		if(d_l[i-1].is_dir)
			sprintf(tstr,"D %-*.*s  %10.10s %s %2.2s %s  %s",
				a,a,d_l[i-1].name, d_l[i-1].size, d_l[i-1].month,
				d_l[i-1].wd, d_l[i-1].time, d_l[i-1].flag);
		else
			sprintf(tstr,"  %-*.*s  %10.10s %s %2.2s %s  %s",
				a,a,d_l[i-1].name, d_l[i-1].size, d_l[i-1].month,
				d_l[i-1].wd, d_l[i-1].time, d_l[i-1].flag);

		dir_e[i]=  XtMalloc(strlen(tstr)+1);
		strcpy(dir_e[i],tstr);
		XtFree(d_l[i-1].name);
		XtFree(d_l[i-1].time);
		XtFree(d_l[i-1].wd);
		XtFree(d_l[i-1].month);
		XtFree(d_l[i-1].size);
		XtFree(d_l[i-1].flag);
		d_l[i-1].is_dir=FALSE;
	}


	for(y=0;y<x;y++)
		if(dir_e[y][0] == 'D')
			dir_e[y][0] = 1;
	quick_array(dir_e, i);
	for(y=0;y<x;y++)
		if(dir_e[y][0] == 1)
			dir_e[y][0] = 'D';
	return i;
}

read_simple_tmp_file(char  *dir_e[MAX_DIR_ENTRY],char *t_file)
{

	FILE	*fp;
	char	tstr[1024];
	char	*tstr2=NULL;
	int		x=0;
	int		ptr=0;
	int		a;

	if(!(fp=fopen(t_file,"r")))
	{
		ftp_error("Can't open tmp file !");
		return -1;
	}
	while(1)
	{
		if(!(fgets(tstr,1023,fp)))
			break;
		strip_lf(tstr);
		dir_e[ptr]=  XtMalloc(strlen(tstr)+1);
		strcpy(dir_e[ptr],tstr);
		if(ptr >= MAX_DIR_ENTRY-1)
		{
			tstr2=XtMalloc(80);
			sprintf(tstr2,"Can't read more than %d items",MAX_DIR_ENTRY);
			ftp_error(tstr2);
			XtFree(tstr2);
			break;
		}
		ptr++;

	}
	fclose(fp);
	return ptr;
}
read_tmp_file(dir_list *d_l,char *t_file)
{

	FILE	*fp;
	char	*tstr2=NULL;
	char	tstr[1024];
	char	*subject="^[dl-][r-][w-][xsStT-]";
	char	*pattern;
	char	*cut_invers();
	int		x=0;
	int		ptr=0;
	char	ttp[20][500];
	int		a;

	if(!(fp=fopen(t_file,"r")))
	{
		ftp_error("Can't open tmp file !");
		return -1;
	}

	while(1)
	{
		if(!(fgets(tstr,1023,fp)))
			break;
		
		strip_lf(tstr);

		strcat(tstr," ");

#if defined(SUN) || defined(linux)
		pattern=(char *) re_comp(subject);
		if(!(re_exec(tstr)))
#else
		pattern=(char *)regcmp(subject,NULL);
		if(!(regex(pattern,tstr ,NULL)))
#endif
			continue;
		x=cut(tstr,ttp);

		if(tstr[0] == 'l')
		{
			d_l[ptr].flag = (char *) XtMalloc( strlen(ttp[x-3])+
											strlen(ttp[x-2])+
											strlen(ttp[x-1])+5);
			sprintf(d_l[ptr].flag,"%s %s %s",ttp[x-3],ttp[x-2],ttp[x-1]);
			x-=2;
		}
		else
		{
			d_l[ptr].flag = (char *) XtMalloc(2);
			strcpy(d_l[ptr].flag," ");
		}

		if(tstr[0] == 'd')
			d_l[ptr].is_dir=TRUE;
		d_l[ptr].name = (char *) XtMalloc(strlen(ttp[x-1])+1);
		strcpy(d_l[ptr].name,ttp[x-1]);
		d_l[ptr].time = (char *) XtMalloc(strlen(ttp[x-2])+1);
		strcpy(d_l[ptr].time,ttp[x-2]);
		d_l[ptr].wd = (char *) XtMalloc(strlen(ttp[x-3])+1);
		strcpy(d_l[ptr].wd,ttp[x-3]);
		d_l[ptr].month = (char *) XtMalloc(strlen(ttp[x-4])+1);
		strcpy(d_l[ptr].month,ttp[x-4]);
		d_l[ptr].size = (char *) XtMalloc(strlen(ttp[x-5])+1);
		strcpy(d_l[ptr].size,ttp[x-5]);
		
		if(ptr >= MAX_DIR_ENTRY-1 )
		{
			tstr2=XtMalloc(20);
			sprintf(tstr2,"Can't read more than %d items",MAX_DIR_ENTRY);
			ftp_error(tstr2);
			XtFree(tstr2);
			break;
		}
		ptr++;
	}
	fclose(fp);
	return ptr;

}


strip_lf(char	*s)
{
	if(s[strlen(s)-1] == '\n')
		s[strlen(s)-1]=0;
}

cut(char *inp,char ttp[20][500])
{
	int		t_t=0;
	int		lp=0,b=0;
	int		a;

	for (a = 1; a < strlen(inp); a++)	{
		if (inp[a] == ' ')	{
			while(inp[a] == ' ')
				a++;
			a--;
			strcpy(ttp[t_t],&inp[lp]);
			lp = a+1;
			for (b = 0; b < strlen(ttp[t_t]); b++)	{
				if (ttp[t_t][b] == ' ')	{
					ttp[t_t][b] = 0;
					t_t++;
					break;
					}
				}
			}
		}	
	return t_t;
}


char *mk_nstring(long wert)
{
	static	char tmp1[50];
	char tmp[30];
	int a;
	int b;
	int c;

	sprintf(tmp,"%ld",wert);
	strcpy(tmp1,"                      ");
	b = 20;
	c = 0;
	tmp1[21] = tmp1[20] = 0;
	for (a = strlen(tmp)-1; a >= 0; a--)    
	{
		if (c == 3)     
		{
			tmp1[b] = '.';
			b--;
			c = 0;
		}
		tmp1[b] = tmp[a];
		b--;
		c++;
	}
	ltrim(tmp1);

	return (char *) tmp1;
}

ltrim (char str[])
{
	int a;
	char *po;
	int	l;
	po = (char *)malloc(strlen(str)+1);
	strcpy(po,str);
	for (a = 0;po[a] ; a++)        
	{
		if (po[a] != ' ')       
		{
			strcpy(str,&po[a]);
			break;
		}
	}
	free(po);
}

quick_array(char **posten, int zaehler)
{
	qs_array(posten,0 , zaehler -1 );
}

qs_array(char **posten, int links, int rechts)
{

	register int i, j;
	char *x,*y;


	i = links; j = rechts;
	x=posten[(links+rechts)/2];

	do
	{
		while(strcmp(posten[i], x) < 0 && i < rechts) i++;
		while(strcmp(posten[j], x) > 0 && j > links) j--;
		if(i <= j)
		{
			y=posten[i];
			posten[i]=posten[j];
			posten[j]=y;
			i++;j--;
		}
	} while(i <= j);

	if(links < j) qs_array(posten, links, j);
	if(i < rechts) qs_array(posten, i, rechts);

}

