/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	xftp_mainb.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
	
	

#include	"xftp.h"


Widget	ls_bb;
Widget	txt_w;
Widget	ok_button;


create_main_input(Widget parent)
{
	Widget		button;	
	int			l_search();
	int			r_search();
	int			l_input();
	int			create_master_command();

	static XtCallbackRec rinputCB[] = {
		{ (XtCallbackProc) create_master_command,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec lsearchCB[2];
	static XtCallbackRec rsearchCB[2];

	lsearchCB[0].callback=(XtCallbackProc) l_search;
	lsearchCB[0].closure=(caddr_t) 0;
	lsearchCB[1].callback=(XtCallbackProc) NULL;
	lsearchCB[1].closure=(caddr_t) NULL;

	rsearchCB[0].callback=(XtCallbackProc) r_search;
	rsearchCB[0].closure=(caddr_t) 1;
	rsearchCB[1].callback=(XtCallbackProc) NULL;
	rsearchCB[1].closure=(caddr_t) NULL;


 	main_line[0]=XtVaCreateManagedWidget("mainLineLeft",
				xmFormWidgetClass,parent,
				/* XmNtopWidget,L_List,
				XmNtopAttachment,XmATTACH_WIDGET,*/
				NULL);

	search_left_button =XtVaCreateManagedWidget("searchButtonLeft",
				xmPushButtonWidgetClass,main_line[0],
				XmNleftAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,lsearchCB,
				NULL);

 	main_line[1]=XtVaCreateManagedWidget("mainLineRight",
				xmFormWidgetClass,parent,
				/* XmNtopWidget,R_List,
				XmNtopAttachment,XmATTACH_WIDGET,*/
				NULL);

	search_right_button =XtVaCreateManagedWidget("searchButtonRight",
				xmPushButtonWidgetClass,main_line[1],
				XmNleftAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,rsearchCB,
				NULL);

	command_right_button=XtVaCreateManagedWidget("inputButtonRight",
				xmPushButtonWidgetClass,main_line[1],
				XmNleftWidget,search_right_button,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,rinputCB,
				NULL);
}

create_master_command()
{
 	static	Widget	csw;

	if(csw == (Widget)0)
	{
		csw=XmCreateDialogShell(top_level,"commandDialog",
						NULL,0);
		co_bb=XmCreateBulletinBoard(csw,"commandBB",
						NULL,0);
		create_command_win(co_bb);
	}

	set_main_butt_off();
	XtManageChild(co_bb);
}

create_command_win(Widget parent)
{
	Widget	sep_top,sep_bottom,buttons,title;
	Widget	master_form;
	Widget	line;
	Widget	button;
	Cardinal n;
	int		i;
	static	int	bla;
	void	cancel_command();
	int		command_get_file();
	int		command_cd_dir();

	static XtCallbackRec cancelCB[] = {
		{ (XtCallbackProc) cancel_command,NULL },
		{NULL,NULL}
	};
	static XtCallbackRec getfCB[] = {
		{ (XtCallbackProc) command_get_file,NULL },
		{NULL,NULL}
	};
	static XtCallbackRec cddCB[] = {
		{ (XtCallbackProc) command_cd_dir,NULL },
		{NULL,NULL}
	};
	
	master_form=XtVaCreateManagedWidget("commandBase",
					xmRowColumnWidgetClass, parent,
					XmNorientation, XmVERTICAL,
					NULL);
 
	title = XtVaCreateManagedWidget("commandBaseTitle",
					xmLabelWidgetClass,master_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNalignment, XmALIGNMENT_CENTER,
					NULL);

	sep_top = XtCreateManagedWidget("sep_top",xmSeparatorWidgetClass,
					master_form,NULL,0);

	txt_command=CreateInput(master_form,"lineCommand","labelCommand",
										"Command",1024);

	
	XtVaSetValues(txt_command, XmNvalue,point_to_simple_entry, NULL);

	sep_bottom = XtCreateManagedWidget("sep_bottom",
							xmSeparatorWidgetClass,master_form,NULL,0);

 	line=XtVaCreateManagedWidget("lineCommand",
				xmFormWidgetClass,parent,
				XmNy,90,
				XmNx,10,
				NULL);

	button=XtVaCreateManagedWidget("commandCdButton",
				xmPushButtonWidgetClass,line,
				XmNleftAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,cddCB,
				NULL);

	button=XtVaCreateManagedWidget("commandGetButton",
				xmPushButtonWidgetClass,line,
				XmNleftWidget,button,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,getfCB,
				NULL);

	button=XtVaCreateManagedWidget("commandCancelButton",
				xmPushButtonWidgetClass,line,
				XmNleftWidget,button,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,cancelCB,
				NULL);


	XtManageChild(master_form);
}

command_get_file(Widget parent, caddr_t client_data, 
			XmAnyCallbackStruct *call_data)
{
	char	*s= (char *) XmTextGetString(txt_command);	
	static	char	tstr[1024];
	static	char	tstr2[1024];

	strcpy(tstr2,s);
	XtFree(s);

	if(!tstr2[0])
	{
		ftp_error("No file selected !");
		return -1;
	}
	sprintf(tstr,"%s/%s",local_dir,tstr2);
	unmanage_win(co_bb);

	sprintf(remote_file,"%s/%s",remote_dir,tstr2);

#ifdef	DEBUG
printf("[%s] [%s] [%s]\n",remote_file,tstr2,tstr);
#endif

	if(get_file(tstr2,tstr) == -1)
		return -1;

}

command_cd_dir(Widget parent, caddr_t client_data, 
			XmAnyCallbackStruct *call_data)
{
	char	*new_dir=(char *) XmTextGetString(txt_command);

	set_busy_cursor(top_level);
	unmanage_win(co_bb);

	if(chdir_remote(new_dir) == -1)
	{
		ftp_error("Can't change directory !");
		put_remote_dir_info();
		XtFree(new_dir);
		return -1;
	}

	if(!simple_list)
		if(get_simple_dir() == -1)
			return -1;
	else
		if(get_dir() == -1)
			return -1;

	delete_list(R_List);
	fill_list(R_List,0);
	put_remote_dir_info();

	set_default_cursor(top_level);
	XtFree(new_dir);
}


l_search(Widget parent, caddr_t client_data, 
			XmAnyCallbackStruct *call_data)
{
	create_master_search((int *) client_data);
}

r_search(Widget parent, caddr_t client_data, 
			XmAnyCallbackStruct *call_data)
{
	create_master_search((int *) client_data);
}

create_master_search(int status)
{
	Arg		arg[6];
	int		n;
 	static	Widget	lsw;
	static XtCallbackRec okCB[2];
	int		search_entry();	

	okCB[0].callback=(XtCallbackProc)search_entry;
	okCB[0].closure=(caddr_t) status;
	okCB[1].callback=(XtCallbackProc)NULL;
	okCB[1].closure=(caddr_t) NULL;

	if(lsw == (Widget)0)
	{
		lsw=XmCreateDialogShell(top_level,"searchDialog",
						NULL,0);
		ls_bb=XmCreateBulletinBoard(lsw,"searchBB",
						NULL,0);
		create_search_win(ls_bb);
	}

	XtVaSetValues(ok_button,XmNactivateCallback,okCB,NULL);
	XtVaSetValues(txt_w,
			XmNactivateCallback,okCB,
			XmNtraversalOn,TRUE,
			NULL);

	set_main_butt_off();
	
/*	XmProcessTraversal(txt_w,XmTRAVERSE_CURRENT);*/
	XtManageChild(ls_bb);
/*	move_pointer(top_level,ok_button);*/
}

create_search_win(Widget parent)
{

	Widget	sep_top,sep_bottom,buttons,title;
	Widget	master_form;
	Widget	line;
	Widget	button;
	Cardinal n;
	int		i;
	void	cancel_search();
	static	int	bla;

	static XtCallbackRec cancelCB[] = {
		{ (XtCallbackProc) cancel_search,NULL },
		{NULL,NULL}
	};
	
	master_form=XtVaCreateManagedWidget("searchBase",
					xmRowColumnWidgetClass, parent,
					XmNorientation, XmVERTICAL,
					NULL);
 
	title = XtVaCreateManagedWidget("searchBaseTitle",
					xmLabelWidgetClass,master_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNalignment, XmALIGNMENT_CENTER,
					NULL);

	sep_top = XtCreateManagedWidget("sep_top",xmSeparatorWidgetClass,
					master_form,NULL,0);

	txt_w=CreateInput(master_form,"lineSearch","labelSearch",
										"Search",1024);

	
	sep_bottom = XtCreateManagedWidget("sep_bottom",
							xmSeparatorWidgetClass,master_form,NULL,0);

 	line=XtVaCreateManagedWidget("lineSearch",
				xmFormWidgetClass,parent,
				XmNy,90,
				XmNx,10,
				NULL);

	ok_button=XtVaCreateManagedWidget("searchOkButton",
				xmPushButtonWidgetClass,line,
				XmNleftAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_FORM,
	/*			XmNactivateCallback,okCB,*/
				NULL);

	button=XtVaCreateManagedWidget("searchCancelButton",
				xmPushButtonWidgetClass,line,
				XmNleftWidget,ok_button,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,cancelCB,
				NULL);


	XtManageChild(master_form);
}


search_entry(Widget parent, caddr_t client_data, 
				XmAnyCallbackStruct *call_data)
{

	char		*s=NULL;
	XmString	list_entry;	
	int			i;
	char		fn=FALSE;
	char		*tstr;
	struct		_list_p {
		Widget	widget;
		char	**p;
	} list_p;	
	int			*status=(int *) client_data;
	int		ls_ptr=0;
	int		**pp_list;
	int		*pp_count;

	if(!status)
	{
		list_p.p=local_list;
		list_p.widget=L_List;
	}
	else
	{
		list_p.p=remote_list;
		list_p.widget=R_List;
	}

	ls_ptr= (!XmListGetSelectedPos(list_p.widget,
			(int **) &pp_list,(int *) &pp_count))?(int)0: 
			(int)pp_list[0];

	set_busy_cursor(top_level);
	s=XmTextGetString(txt_w);

	if(!s)
	{
		ftp_error("What string do you search ??? Nothing !?!?");
		return -1;
	}
	for(i=ls_ptr;list_p.p[i];i++)
		if(strstr(list_p.p[i],s))
		{
			fn=TRUE;
			break;
		}

	if(fn)
	{
		XmListSetPos(list_p.widget,i+1);
		XmListSelectPos(list_p.widget,i+1,TRUE);
	}
	else
	{
		tstr=XtMalloc(strlen(s)+15);
		sprintf(tstr,"Cant find %s !",s);
		ftp_error(tstr);
		XtFree(tstr);
	}
	
	set_default_cursor(top_level);

}

void cancel_command()
{
	unmanage_win(co_bb);
}

void cancel_search()
{
	unmanage_win(ls_bb);
}

r_input(Widget parent, caddr_t data, XmAnyCallbackStruct *call_data)
{
	printf("Input right\n");
}

/* 
move_pointer(Widget src,Widget dest)
{
	Window	*root_return,*child_return;
	int		rootX,rootY,winX,winY,mask_return;

	XQueryPointer(dpy,XtWindow(src),&root_return,&child_return,
			&rootX,&rootY,&winX,&winY,&mask_return);

	XWarpPointer(dpy,XtWindow(src),XtWindow(dest),winX,winY,0,
			0,15,40);
}

*/
mstrcmp(s1,s2)
char s1[],s2[];
{
	char *ss;

	if (strlen(s2) < strlen(s1))
		return (0);

	ss = (char *)malloc (strlen(s2)+1);
	if (ss == NULL)
		return (0);
	strcpy(ss,s2);
	ss[strlen(s1)] = 0;
	if (!strcmp(s1,ss))	{
		free(ss);
		return (1);
		}
	free(ss);
	return (0);
}

set_main_butt_off()
{
	XtSetSensitive(search_left_button,FALSE);

	if(connected)
	{
		XtSetSensitive(command_right_button,FALSE);
		XtSetSensitive(search_right_button,FALSE);
	}
}


set_main_butt_on()
{
	XtSetSensitive(search_left_button,TRUE);

	if(connected)
	{
		XtSetSensitive(command_right_button,TRUE);
		XtSetSensitive(search_right_button,TRUE);
	}
}

unmanage_win(Widget w)
{
	XtUnmanageChild(w);
	set_main_butt_on();
}
