/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	xftp_io.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
	
	

#include	<xftp.h>

read_defaults()
{

	FILE	*fp;
	char	*file;

	if(!home)
	{
		fprintf(stderr,"Can't get EnvVar HOME. Using defaults.\n");
		set_defaults();
		return -1;
	}

	file=XtMalloc(strlen(home)+strlen(RC_FILE)+5);

	sprintf(file,"%s/%s",home,RC_FILE);

	if(!(fp=fopen(file,"r")))
	{
		set_defaults();
		write_rc();
		XtFree(file);
		return -1;
	}
	XtFree(file);


	if(fread(&tool_f,sizeof(struct tool_flags),1,fp) != 1)
	{
		fprintf(stderr,"Can't read %s !\n",RC_FILE);
		fclose(fp);
		set_defaults();
		return -1;
	}

	change_saved_dir();
}

change_saved_dir()
{
	if(tool_f.start_dir[0])
		chdir(tool_f.start_dir);
}

write_rc()
{

	FILE	*fp;
	char	*file;
	int		x;

	if(!home)
	{
		fprintf(stderr,"Can't get EnvVar HOME. Using defaults.\n");
		return -1;
	}

	file=XtMalloc(strlen(home)+strlen(RC_FILE)+5);
	sprintf(file,"%s/%s",home,RC_FILE);

	if(!(fp=fopen(file,"w")))
	{
		fprintf(stderr,"Can't open %s !\n",file);
		return -1;
	}
	XtFree(file);

	
	if((x=fwrite(&tool_f,sizeof(struct tool_flags),1,fp)) != 1)
		fprintf(stderr,"Can't write %s. Error : %d. \n",RC_FILE,x);

	fclose(fp);
}

set_defaults()
{
	tool_f.r_unique=TRUE;
	tool_f.l_unique=TRUE;
	tool_f.conf_del=TRUE;
	tool_f.conf_over=TRUE;
	tool_f.conf_send=TRUE;
	tool_f.conf_receive=TRUE;
	tool_f.quit_conf=TRUE;
	tool_f.save_local_dir=TRUE;
	tool_f.show_trans=TRUE;
	strcpy(tool_f.viewer,DEFAULT_PAGER);
	strcpy(tool_f.view_file,DEFAULT_TMP_VIEW_FILE);
	strcpy(tool_f.dbg_file,DEFAULT_DEBUG_FILE);
}
