/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	xftp_getapw.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
	
	

#include	"xftp.h"

int	h_alarm;

void *host_alarm()
{
	fprintf(stderr,"xftp: Can't get my hostbyname() !\n");
	exit(1);
}


int	get_ano_pw(char *s)
{
	struct	hostent	*ht;
	struct	utsname ut;
	struct	passwd	*pw;

	if(uname(&ut) == -1)
	{
		printf("Error : %d by getting utsname !\n",errno);
		return	FALSE;
	}
	h_alarm=0;
	signal(SIGALRM,(void *) host_alarm);
	alarm(10);
	if(!(ht=gethostbyname(ut.nodename)))
	{
		printf("Error by getting host_by_name !\n");
		return FALSE;
	}
	alarm(0);
	pw=getpwuid(getuid());
	sprintf(s,"%s@%s",pw->pw_name,ht->h_name);
	sprintf(my_host,"%.60s",ht->h_name);
	endpwent();

	return TRUE;

}
