/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	xftp.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1993, 1994 Free Software Association of Germany.\n";


static char sccsid[] = "@(#) xftp Version 0.9a04 Fri Mar 11 14:29:28 GMT 1994\n";
#endif /* not lint */

	
extern	void 		hd_canc();
	
#include	"xftp.h"

#ifdef	EDITRES
#include <X11/Xmu/Editres.h>
#endif

Widget	top_level;
Widget	trans_BB;
Widget	main_widget;
Widget	host_BB;
Widget	R_List,L_List;
Widget	local_label_info;
Widget	menu_button[20];
Widget	a_tr_size_label;
Widget	b_tr_size_label;
Widget	tr_status_label2;
Widget	trans_ok_button;
Widget	time_inf_value_label;
Widget	left_host,right_host;
Widget	text_win;
Widget	text_widget;
Widget	text_field[3];
Widget	dir_input[2];
Widget	props_BB;
Widget	menu_bar;
Widget	list_form;
Widget	L_Title;
Widget	R_Title;
Widget	main_line[2];
Widget	anonymous_button;
Widget	search_left_button,search_right_button,command_right_button;
Widget	txt_command;
Widget	co_bb;
char	pw_ano[80];
char	pword[80];
char	FIRST_IN=FALSE;
char	global_error[100];
char	*tmp_file;
char	normal_tmp_file[80];
char	simple_tmp_file[80];
char	connected=FALSE;
char	my_host[80];
char	debug=FALSE;
char	*dbg_file;
char	local_dir[2048];
char	remote_dir[2048];
char	local_file[2048];
char	local_name[2048];
char	remote_file[2048];
char	*home;
char	*point_to_simple_entry=NULL;
char	n_list=FALSE;

void sigcatch();
void sig_message();
Pixmap 		logo();
XtTimerCallbackProc 	act_time();

#define	CON_TIMEOUT	60
#define	SERVER_TIMEOUT	421

#ifdef	DEBUG
int		tok_out=0;
#endif

FILE	*dbg_fp;

long	bytes_trans;		
long	bytes_total;

char	simple_list;
int		trans_direction;
int		text_pos=0;
int		men_but_ptr=0;
int		pw_ptr=0;
int		hptr;
int		c_hd,d_hd;
int		hv_sigint=0;
int		hv_alarm=0;
int		old_ptr;


Cursor busy_cursor;

XmString	search_arr[MAX_HOSTS];
char		*local_list[MAX_DIR_ENTRY],*remote_list[MAX_DIR_ENTRY];
char		*simple_remote_list[MAX_DIR_ENTRY];

void	have_alarm(int a)
{
	hv_alarm=1;
	ftp_error("Timeout !");
}

#ifdef	XPM
#include <fsag.xpm>

typedef struct _XpmIcon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
}XpmIcon;

#else
#include	<fsag.xbm>
#endif

#include <data.xpm>
#include <Xm/LabelG.h>
#ifdef	XPM
XpmIcon	dic;
Pixmap	l_icon;
#endif

void main(int argc, char **argv)
{

	Arg			args[20];
	Cardinal	argcount;
	Widget		new_menu;
	XmString	lo_la_inf;
	int			max_entry;
	int			i;
	char		tstr[80];
	int			con_win();
	Widget		sep_top;
	int			input_ch_local_dir();
	int			input_ch_remote_dir();
	int			view_local_file();
	int			view_remote_file();
	int			disconnect();
	int			props_win();
	int			put_file_quest();
	int			delete_file_quest();
	char		*arg_host,*arg_user;
	int			n;
	int			handle_local_files();
	int			handle_remote_files();
	int			sc();
	int			set_selected_file_name();

	static 		XtCallbackRec input_LdirCB[] = {
					{ (XtCallbackProc) input_ch_local_dir,NULL },
					{NULL,NULL}
				};
	static 		XtCallbackRec input_RdirCB[] = {
					{ (XtCallbackProc) input_ch_remote_dir,NULL },
					{NULL,NULL}
				};
	men_pt		files[]={
					"delete",delete_file_quest,NULL,
					"quit",quit_action,NULL,
					NULL,NULL,NULL
				};
	men_pt		views[]={
					"remoteFile",view_remote_file,NULL,
					"localFile",view_local_file,NULL,
					NULL,NULL,NULL
					};

	men_pt		props[]={
					"tool",props_win,NULL,
					NULL,NULL,NULL
					};
	men_pt		connect[]={
					"connect",con_win,NULL,
					"disconnect",disconnect,NULL,
					NULL,NULL,NULL
					};
	/* sigcatch();*/

	home=(char *) getenv("HOME");
	read_defaults();

	if(argc > 1)
	{
		for(n=1;n < argc;n++)
		{
			if(argv[n][1] == 'D' )
			{
				debug=TRUE;
				if(argv[n][2] == '=')
				{
					dbg_file = &argv[n][3];
					if(!(dbg_fp = fopen(dbg_file,"w")))
					{
						fprintf(stderr,"Can't open debug-file %s !\n",dbg_file);
						fprintf(stderr,"Using default debug-file %s.\n",
											tool_f.dbg_file);
						if(!(dbg_fp = fopen(tool_f.dbg_file,"w")))
						{
							fprintf(stderr,"Can't open default debug-file %s.\n",
											tool_f.dbg_file);
							fprintf(stderr,"Using stderr for debugoutput.\n");
							dbg_fp=(FILE *)stderr;
						}	
					}
				}
				else
					dbg_fp=(FILE *)stderr;
			}

			if(!strcmp(&argv[n][1],"arghost"))
				arg_host=&argv[n][9];
			if(!strcmp(&argv[n][1],"arguser"))
				arg_user=&argv[n][9];
		}

	}

	bzero(( char *) &local_list, sizeof(local_list));
	bzero(( char *) &remote_list, sizeof(remote_list));


	main_widget = XtAppInitialize(&appContext, "Xftp",
				NULL,
				0,
				&argc, argv,
				NULL,
				NULL, 0);
#ifdef	EDITRES
	XtAddEventHandler (main_widget, (EventMask) 0, 
					TRUE, _XEditResCheckMessages, NULL);
#endif

	busy_cursor = XCreateFontCursor (XtDisplay (main_widget), XC_watch);

	top_level=XtVaCreateManagedWidget("Main",
				xmMainWindowWidgetClass, main_widget,
				NULL);

	hptr=get_host_list();
	
	sprintf(normal_tmp_file,"/tmp/xftp.%d",getpid());
	sprintf(simple_tmp_file,"/tmp/xftp_simple.%d",getpid());

	tmp_file=normal_tmp_file;
	if(get_ano_pw(pw_ano) == -1)
		pw_ano[0]=0;

	menu_bar = XmCreateMenuBar(top_level,"Menubar",NULL,0);
	XtManageChild(menu_bar);

 	new_menu=MakeMenuPane("file",menu_bar,files);
	AttachToCascade(menu_bar,"fileMenu",new_menu);

 	new_menu=MakeMenuPane("view",menu_bar,views);
	AttachToCascade(menu_bar,"viewMenu",new_menu);

 	new_menu=MakeMenuPane("properties",menu_bar,props);
	AttachToCascade(menu_bar,"propertiesMenu",new_menu);

 	new_menu=MakeMenuPane("connect",menu_bar,connect);
	AttachToCascade(menu_bar,"connectMenu",new_menu);

	list_form=XtVaCreateManagedWidget("listForm",
				xmFormWidgetClass, top_level,
				NULL);

 	L_Title = XtVaCreateManagedWidget("localLabel",
				xmLabelWidgetClass,list_form,
			 	XmNorientation, XmVERTICAL,
				XmNalignment, XmALIGNMENT_BEGINNING,
				XmNx,12,
				XmNy,8,
				NULL);

	R_Title = XtVaCreateManagedWidget("remoteLabel",
				xmLabelWidgetClass,list_form,
			 	XmNorientation, XmVERTICAL,
				XmNalignment, XmALIGNMENT_BEGINNING,
				XmNx,392,
				XmNy,8,
				NULL);

	dir_input[0] = XtVaCreateManagedWidget("localTextDir",
		xmTextWidgetClass,list_form,
		XmNtopWidget,L_Title,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNactivateCallback,input_LdirCB,
		NULL);

	dir_input[1] = XtVaCreateManagedWidget("remoteTextDir",
		xmTextWidgetClass,list_form,
		XmNtopWidget,R_Title,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNactivateCallback,input_RdirCB,
		NULL);
		

 	sprintf(tstr,"%.60s",my_host);	
	lo_la_inf = XmStringCreateLtoR(tstr,charset);
	left_host = XtVaCreateManagedWidget("leftHost",
				xmLabelWidgetClass,list_form,
				XmNtopWidget,dir_input[0],
				XmNtopAttachment,XmATTACH_WIDGET,
			 	XmNorientation, XmVERTICAL,
				XmNalignment, XmALIGNMENT_BEGINNING,
				XmNstringDirection,XmSTRING_DIRECTION_L_TO_R,
				XmNlabelString,lo_la_inf,
				XmNx,12,
				XmNy,80,
				NULL);
	XmStringFree(lo_la_inf);

 	sprintf(tstr,"%60.60s"," ");	
	lo_la_inf = XmStringCreateLtoR(tstr,charset);
	right_host = XtVaCreateManagedWidget("rightHost",
				xmLabelWidgetClass,list_form,
				XmNtopWidget,dir_input[1],
				XmNtopAttachment,XmATTACH_WIDGET,
			 	XmNorientation, XmVERTICAL,
				XmNalignment, XmALIGNMENT_BEGINNING,
				XmNstringDirection,XmSTRING_DIRECTION_L_TO_R,
				XmNlabelString,lo_la_inf,
				XmNx,390,
				XmNy,80,
				NULL);
	XmStringFree(lo_la_inf);

	n=0;
	XtSetArg(args[n],XmNvisibleItemCount,25);n++;
	XtSetArg(args[n],XmNlistSizePolicy,XmCONSTANT);n++;
	XtSetArg(args[n],XmNscrollBarDisplayPolicy,XmSTATIC);n++;
	XtSetArg(args[n],XmNtopWidget,left_host);n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);n++;
	L_List = XmCreateScrolledList(list_form, "localList", args, n);
	XtAddCallback(L_List,XmNdefaultActionCallback,
					(XtCallbackProc)handle_local_files, NULL);
	XtAddCallback(L_List,XmNbrowseSelectionCallback,
					(XtCallbackProc)set_selected_file_name,(XtPointer)1);
	n=0;
	XtSetArg(args[n],XmNvisibleItemCount,25);n++;
	XtSetArg(args[n],XmNlistSizePolicy,XmCONSTANT);n++;
	XtSetArg(args[n],XmNscrollBarDisplayPolicy,XmSTATIC);n++;
	XtSetArg(args[n],XmNtopWidget,right_host);n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);n++;
	R_List = XmCreateScrolledList(list_form, "remoteList", args, n);
	XtAddCallback(R_List,XmNdefaultActionCallback,
					(XtCallbackProc)handle_remote_files, NULL);
	XtAddCallback(R_List,XmNbrowseSelectionCallback,
					(XtCallbackProc)set_selected_file_name,(XtPointer) 0);


	XtManageChild(L_List);
	XtManageChild(R_List);


	put_logo();

	create_main_input(list_form);

 	fill_list(L_List,1);

	put_local_dir_info();


	set_sensitive_off();


	XtRealizeWidget(main_widget);

	if(arg_user || arg_host)
	{
		con_win((Widget) top_level,(caddr_t) 0,
					(XmAnyCallbackStruct* ) NULL);

		if(arg_host)
		{
			XtVaSetValues(text_field[0],
				XmNvalue,(String) arg_host,
				NULL);
			XmProcessTraversal(text_field[1],XmTRAVERSE_CURRENT);
		}

		if(arg_user)
		{
			XtVaSetValues(text_field[1],
				XmNvalue,(String) arg_user,
				NULL);
			XmProcessTraversal(text_field[2],XmTRAVERSE_CURRENT);
		}

		if(arg_user && arg_host)
			XmProcessTraversal(text_field[2],XmTRAVERSE_CURRENT);
		else
			if(arg_user )
				XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
		else
			if(arg_host)
				XmProcessTraversal(text_field[1],XmTRAVERSE_CURRENT);

		if(arg_user && arg_host)
			if(!strcmp(arg_user,"anonymous"))
			{
				ano_host((Widget) top_level,(caddr_t) 0,
							(XmAnyCallbackStruct* ) NULL);
				con_host((Widget) top_level,(caddr_t) 0,
							(XmAnyCallbackStruct* ) NULL);
			}
	}

	XtAppMainLoop(appContext);
}

put_logo()
{
	XtVaSetValues(R_List, XmNbackgroundPixmap,
					logo(list_form), NULL);
}

put_back_logo()
{
	XtVaSetValues(R_List,
		XmNbackgroundPixmap,XmUNSPECIFIED_PIXMAP,
		NULL);
}

Pixmap logo(Widget parent)
{
	Pixmap	px;
	Widget	logo_frame;
#ifdef	XPM
	XpmIcon	logo;
	bzero((char *) &logo,sizeof(logo));
	XpmCreatePixmapFromData(dpy,root,fsag_xpm, &logo.pixmap,
			   &logo.mask, &logo.attributes );
	px=logo.pixmap;
#else

	unsigned int depth;
	unsigned long bgpix, fgpix;
	Arg	arg;

	XtSetArg(arg,XmNbackground,&bgpix);
	XtGetValues(parent,&arg,1);

	XtSetArg(arg,XmNforeground,&fgpix);
	XtGetValues(parent,&arg,1);


	depth=DefaultDepth(dpy,DefaultScreen(dpy));

	px=XCreatePixmapFromBitmapData(dpy,root,fsag_bits,fsag_width,
				fsag_height, fgpix,bgpix,depth);

#endif
	return (Pixmap) px;
}



create_textwin(Widget parent)
{

	Arg	arg[10];
	int	n=0;

/* 	text_win = XtVaCreateManagedWidget("textWindow",
					xmTextWidgetClass,parent,
					XmNrows,5,
					XmNcolumns,100,
					XmNmaxLength,1024,
					XmNscrollHorizontal,TRUE,
					XmNscrollVertical,TRUE,
					XmNscrollTopSide,TRUE,
					XmNscrollLeftSide,TRUE,
					XmNeditMode,XmMULTI_LINE_EDIT,
					XmNx,10,
					XmNy,480,
					NULL);*/

	XtSetArg(arg[n],XmNrows,5);n++;
	XtSetArg(arg[n],XmNcolumns,100);n++;
	XtSetArg(arg[n],XmNmaxLength,1024);n++;
/* 	XtSetArg(arg[n],XmNscrollHorizontal,TRUE);n++;
	XtSetArg(arg[n],XmNscrollVertical,TRUE);n++;*/
	XtSetArg(arg[n],XmNeditMode,XmMULTI_LINE_EDIT);n++;
	XtSetArg(arg[n],XmNx,10);n++;
	XtSetArg(arg[n],XmNy,480);n++;

	text_win = XmCreateScrolledText(parent,
				"textWindow",arg,n);


	XtManageChild(text_win);

}

int read_one_blk()
{
	int	a;
	int	l;
	unsigned	char	buff[16386];

	a=read(blk_in,buff,16384);
	if(a == 0)
		return 1;
	if(a < 0)
	{
		ftp_error("Error in read !");
		return -1;
	}
	if((l=write(blk_out,buff,a)) != a)
	{
		ftp_error("Error in write !");
		return -2;
	}
	bytes_trans+=a;
		
	return 0;
}


XtTimerCallbackProc 	act_time()
{
	XmString	s;
	int			i;
	Arg			arg[2];
	int			n;
	int			prz=0;
	int			x;
	int			a;
	char	tstr[200];
	char	tstr2[50];

	if(trans_direction)
		a=read_one_blk();
	else
		a=write_one_blk();

	if(a)
	{
		if(tool_f.show_trans)
		{
			if(a<0)
			{
				sprintf(tstr,"%*.*s",F_B,F_B,global_error);
				s = XmStringCreateLtoR(global_error,charset);
				XtVaSetValues(tr_status_label2,
					XmNlabelString,s,
					NULL);
			}
			else
			{
				sprintf(tstr,"%*.*s",F_B,F_B,"Successful");
				s = XmStringCreateLtoR(tstr,charset);
				XtVaSetValues(tr_status_label2,
					XmNlabelString,s,
					NULL);
				XmStringFree(s);
				gettimeofday(&t_stop, (struct timezone *)0);

				ptransfer(tstr, bytes_total, &t_start, &t_stop);
				sprintf(tstr2,"%*.*s",F_B,F_B,tstr);
				s = XmStringCreateLtoR(tstr2,charset);
				XtVaSetValues(time_inf_value_label,
					XmNlabelString,s,
					NULL);
			}
			XmStringFree(s);
			XtSetSensitive(trans_ok_button,TRUE);
		}
		bytes_trans=0;
		close(blk_in);
		close(blk_out);

		/* set_win_active();*/

		if(read_line(tstr,CON_TIMEOUT,-1) == -1)
			return ( XtTimerCallbackProc ) NULL;
		if(a>0)
		{
			if(trans_direction)
			{
				delete_list(L_List);
				fill_list(L_List,1);
				put_local_dir_info();
			}
			else
			{
				if(get_dir() != -1)
				{
					delete_list(R_List);
					fill_list(R_List,0);
					put_remote_dir_info();
				}
				else
					ftp_error(global_error);
			}
		}
		trans_active();
		return ( XtTimerCallbackProc ) NULL;
	}
		
	if( b_tr_size_label != (Widget) 0)
	{
		tstr[0]=0;

		sprintf(tstr,"%*.*s",F_B,F_B, mk_nstring(bytes_trans));
		s = XmStringCreateLtoR(tstr,charset);
		
		XtVaSetValues(b_tr_size_label,
			XmNlabelString,s,
			NULL);
		XmStringFree(s);
	}
	XtAppAddTimeOut(appContext,25,(XtTimerCallbackProc)act_time,NULL);
}


int write_one_blk()
{
	int	a;
	unsigned	char	buff[16384];

	a=read(blk_in,buff,16384);
	if(a < 0)
	{
		ftp_error("Error in read !");
		return -1;
	}
	if(write(blk_out,buff,a) != a)
	{
		ftp_error("Error in write !");
		return -2;
	}
	bytes_trans+=a;
	if(a == 0)
		return 1;
		
	return 0;
}

int	trans_win()
{

	static Widget	trans_dialog;
	int				y_point;
	Widget			trans_form;
	Widget			fi_tr_frame,fi_trans_label;
	Widget			fi2_tr_frame;
	Widget			a_tr_frame,a_trans_label;
	Widget			a_tr_size_frame;
	Widget			b_tr_frame,b_trans_label;
	Widget			b_tr_size_frame;
	Widget			title_label;
	Widget			trans_sep_top;
	Widget			trans_sep_bottom;
	Widget			tr_status_frame1,tr_status_label1;
	Widget			tr_status_frame2;
	Widget			time_inf_frame,time_inf_label,time_inf_value_frame;
	XmString		label_s,label_size,label_string;
	void			trans_ok();
	char			tstr[F_B+1];

	static	Widget	fi2_trans_label;



	trans_inactive();
	if(tool_f.show_trans)
	{
		static XtCallbackRec trokCB[] = {
			{ (XtCallbackProc) trans_ok,NULL },
			{NULL,NULL}
		};

		if(trans_dialog == (Widget)0)
		{

			sprintf(tstr,"%*.*s",F_B,F_B," ");
			label_string = XmStringCreateLtoR(tstr,charset);

			sprintf(tstr,"%*.*s0 ",F_B-2,F_B-2," ");
			label_size = XmStringCreateLtoR(tstr,charset);


			trans_dialog=XtVaCreateManagedWidget("transDialog",
							xmDialogShellWidgetClass,top_level,
							NULL,0);


			trans_BB=XtVaCreateManagedWidget("transBB",
							xmBulletinBoardWidgetClass,trans_dialog,
							XmNwidth,406,
							XmNheight,330,
							NULL);

			trans_form=XtVaCreateManagedWidget("transForm",
							xmFormWidgetClass,trans_BB,
							NULL);

			title_label = XtVaCreateManagedWidget("titleTrans",
							xmLabelWidgetClass,trans_form,
							XmNleftAttachment,XmATTACH_FORM,
							XmNrightAttachment,XmATTACH_FORM,
							XmNalignment, XmALIGNMENT_CENTER,
							XmNx,10,
							XmNy,10,
							NULL);

		
			trans_sep_top = XtVaCreateManagedWidget("transSeparatorTop",
							xmSeparatorWidgetClass, trans_form,
							XmNleftAttachment,XmATTACH_FORM,
							XmNrightAttachment,XmATTACH_FORM,
							XmNx,10,
							XmNy,40,
							NULL);

			/* File Label */

			y_point=60;
			fi_tr_frame = XtVaCreateManagedWidget("transFrameFi",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,1,
							XmNy,y_point,
							NULL);

			label_s = XmStringCreateLtoR(" File to send/receive ",charset);
			fi_trans_label = XtVaCreateManagedWidget("transLabelFi",
							xmLabelWidgetClass,fi_tr_frame,
							XmNlabelString,label_s,
							NULL);
			XmStringFree(label_s);

			/* File	Info */

			fi2_tr_frame = XtVaCreateManagedWidget("transFileFrame",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,170,
							XmNy,y_point,
							NULL);

			fi2_trans_label = XtVaCreateManagedWidget("transFileLabel",
							xmLabelWidgetClass,fi2_tr_frame,
							XmNlabelString,label_string,
							NULL);

			/* Total Bytes Label */
			y_point+=40;
			a_tr_frame = XtVaCreateManagedWidget("transFrameA",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,1,
							XmNy,y_point,
							NULL);

			label_s = XmStringCreateLtoR(" Total bytes          ",charset);
			a_trans_label = XtVaCreateManagedWidget("transLabelA",
							xmLabelWidgetClass,a_tr_frame,
							XmNlabelString,label_s,
							NULL);
			XmStringFree(label_s);

			/* Total Bytes Info */
			a_tr_size_frame = XtVaCreateManagedWidget("transSizeFrameA",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,170,
							XmNy,y_point,
							NULL);

			a_tr_size_label = XtVaCreateManagedWidget("transSizeLabelA",
							xmLabelWidgetClass,a_tr_size_frame,
							XmNlabelString,label_string,
							NULL);

			/* Transfer Bytes Label */

			y_point+=40;
			b_tr_frame = XtVaCreateManagedWidget("transFrameB",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,1,
							XmNy,y_point,
							NULL);

			label_s = XmStringCreateLtoR(" Bytes sent/received  ",charset);

			b_trans_label = XtVaCreateManagedWidget("transLabelB",
							xmLabelWidgetClass,b_tr_frame,
							XmNlabelString,label_s,
							NULL);
			XmStringFree(label_s);
			/* Transfer Bytes Info */

			b_tr_size_frame = XtVaCreateManagedWidget("transSizeFrameB",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,170,
							XmNy,y_point,
							NULL);

			b_tr_size_label = XtVaCreateManagedWidget("transSizeLabelB",
							xmLabelWidgetClass,b_tr_size_frame,
							XmNlabelString,label_size,
							NULL);


			/* Report Label */

			y_point+=40;
			time_inf_frame = XtVaCreateManagedWidget("timeInfFrame",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,1,
							XmNy,y_point,
							NULL);

			label_s = XmStringCreateLtoR(" Report               ",charset);
			time_inf_label = XtVaCreateManagedWidget("timeInfLabel",
							xmLabelWidgetClass,time_inf_frame,
							XmNlabelString,label_s,
							NULL);
			XmStringFree(label_s);

			/* Report Info */

			time_inf_value_frame = XtVaCreateManagedWidget("timeInfValueFrame",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,170,
							XmNy,y_point,
							NULL);

			time_inf_value_label = XtVaCreateManagedWidget("timeInfValueLabel",
							xmLabelWidgetClass,time_inf_value_frame,
							XmNlabelString,label_string,
							NULL);


			/* Transfer Status Label */

			y_point+=40;
			tr_status_frame1 = XtVaCreateManagedWidget("transStatusFrame1",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,1,
							XmNy,y_point,
							NULL);
			label_s = XmStringCreateLtoR(" Transfer Status      ",charset);
			tr_status_label1 = XtVaCreateManagedWidget("transStatusLabel1",
							xmLabelWidgetClass,tr_status_frame1,
							XmNlabelString,label_s,
							NULL);
			XmStringFree(label_s);

			/* Transfer Status Info */

			tr_status_frame2 = XtVaCreateManagedWidget("transStatusFrame2",
							xmFrameWidgetClass,trans_form,
							XmNshadowThickness,2,
							XmNshadowType,XmSHADOW_IN,
							XmNx,170,
							XmNy,y_point,
							NULL);

			tr_status_label2 = XtVaCreateManagedWidget("transStatusLabel2",
							xmLabelWidgetClass,tr_status_frame2,
							XmNlabelString,label_size,
							NULL);


			y_point+=40;
			trans_sep_bottom = XtVaCreateManagedWidget("transSeparatorBottom",
							xmSeparatorWidgetClass, trans_form,
							XmNleftAttachment,XmATTACH_FORM,
							XmNrightAttachment,XmATTACH_FORM,
							XmNx,10,
							XmNy,y_point,
							NULL);

			trans_ok_button=XtVaCreateManagedWidget("transOkButton",
							xmPushButtonWidgetClass,trans_form,
							XmNactivateCallback,trokCB,
							XmNx,170,
							XmNy,y_point+20,
							NULL);
			XmStringFree(label_size);
			XmStringFree(label_string);
		}
		if(!trans_direction)
			sprintf(tstr,"%*.*s",F_B,F_B,crf(local_file));
		else
			sprintf(tstr,"%*.*s",F_B,F_B,crf(remote_file));
		label_string = XmStringCreateLtoR(tstr,charset);

		XtVaSetValues(fi2_trans_label,
			XmNlabelString,label_string,
			NULL);
		XmStringFree(label_string);

 		sprintf(tstr,"%*.*s",F_B,F_B,mk_nstring(bytes_total));
		label_s = XmStringCreateLtoR(tstr,charset);
		
		XtVaSetValues(a_tr_size_label,
			XmNlabelString,label_s,
			NULL);
		XmStringFree(label_s);

		sprintf(tstr,"%*.*s",F_B,F_B," ");
		label_s = XmStringCreateLtoR(tstr,charset);
		XtVaSetValues(tr_status_label2,
			XmNlabelString,label_s,
			NULL);
		XtVaSetValues(time_inf_value_label,
			XmNlabelString,label_s,
			NULL);
		XmStringFree(label_s);
		gettimeofday(&t_start, (struct timezone *)0);

		XtSetSensitive(trans_ok_button,FALSE);

		XtManageChild(trans_BB);
		XFlush(XtDisplay(trans_BB));
		act_time();
	}
 	else
	{
		gettimeofday(&t_start, (struct timezone *)0);
		act_time();
	}
}

trans_inactive()
{
	set_busy_cursor(top_level);
	XtSetSensitive(R_List,FALSE);
	XtSetSensitive(L_List,FALSE);
	XtSetSensitive(menu_bar,FALSE);
	XtSetSensitive(dir_input[0],FALSE);
	XtSetSensitive(dir_input[1],FALSE);
}

trans_active()
{
	set_default_cursor(top_level);
	XtSetSensitive(R_List,TRUE);
	XtSetSensitive(L_List,TRUE);
	XtSetSensitive(menu_bar,TRUE);
	XtSetSensitive(dir_input[0],TRUE);
	XtSetSensitive(dir_input[1],TRUE);
}


void	trans_ok()
{
	XtUnmanageChild(trans_BB);
}

int	view_remote_file()
{

	char	*tstr;

	if(!connected)
	{
		ftp_error("You're not connected !");
		return -1;
	}

	if(!remote_file[0])
	{
		ftp_error("No remote file selected !");
		return -1;
	}

	set_busy_cursor(top_level);
  	tstr=XtMalloc(strlen(DEFAULT_PAGER)+
						strlen(DEFAULT_TMP_VIEW_FILE)+10);
	if(get_view_file(remote_file,DEFAULT_TMP_VIEW_FILE) == -1)
		return -1;

/* 	if(!strcmp(tool_f.viewer,"builtin+"))
		view_file(DEFAULT_TMP_VIEW_FILE);
	else
	{*/
		sprintf(tstr,"%s %s",tool_f.viewer,DEFAULT_TMP_VIEW_FILE);
		system(tstr);
	/*}*/
  	XtFree(tstr);
	unlink(DEFAULT_TMP_VIEW_FILE);
	set_default_cursor(top_level);
}


int delete_file_quest()
{
	static		Widget  	quest_box;
	XmString	quest;
	char		*tstr;
	int	delete_local_file();

	if(!local_file[0])
	{
		ftp_error("No local file selected !");
		return -1;
	}

	if(tool_f.conf_del)
	{
		if(quest_box == (Widget) 0)
		{
			quest_box = XmCreateQuestionDialog(top_level,
					"deleteFileQuestBox",NULL,0);
			XtAddCallback(quest_box,XmNcancelCallback,(XtCallbackProc)hd_canc,
					(XtPointer) quest_box);
			XtAddCallback(quest_box,XmNokCallback, (XtCallbackProc)delete_local_file, 
					(XtPointer) NULL);
		}
		tstr=XtMalloc(strlen(local_file)+25);
		sprintf(tstr,"Do you want to delete %s ?",local_file);
		quest = XmStringCreateLtoR(tstr,charset);

		XtVaSetValues(quest_box,
			XmNmessageString,quest,
			NULL);
		XmStringFree(quest);
		XtFree(tstr);

		XtManageChild(quest_box);
	}
	else
		delete_local_file();

}

delete_local_file()
{
	char	*tstr;

	set_busy_cursor(top_level);


	if(unlink(local_file) == -1)
	{
		tstr=XtMalloc(strlen(local_file)+20);
		sprintf(tstr,"Can't unlink %s !\n",local_file);
		ftp_error(tstr);
		XtFree(tstr);
		return -1;
	}
	local_file[0]=0;
	delete_list(L_List);
	fill_list(L_List,1);
	put_local_dir_info();
	set_default_cursor(top_level);
	local_file[0]=0;

}


int	view_local_file()
{

	char	*tstr;


	if(!local_file[0])
	{
		ftp_error("No local file selected !");
		return -1;
	}

	set_default_cursor(top_level);
	tstr=XtMalloc(strlen(DEFAULT_PAGER)+strlen(local_file)+5);

	if(!strcmp(tool_f.viewer,"builtin+"))
		view_file(local_file);
	else
	{
		sprintf(tstr,"%s %s",tool_f.viewer,local_file);
		system(tstr);
	}

	XtFree(tstr);

	set_default_cursor(top_level);


}

set_sensitive_off()
{
	/* XtSetSensitive(menu_button[FILES_COPY],FALSE);
	XtSetSensitive(menu_button[FILES_DELETE],FALSE);*/
	XtSetSensitive(menu_button[VIEWS_REMOTE_FILE],FALSE);
/*	XtSetSensitive(menu_button[VIEWS_LOG_SESSION],FALSE);
	XtSetSensitive(menu_button[VIEWS_HOST_INFO],FALSE);
	XtSetSensitive(menu_button[PROPS_REMOTE_FILE],FALSE);*/
	XtSetSensitive(menu_button[CONNECT_DISCONNECT],FALSE);

	XtSetSensitive(menu_button[FILES_QUIT],TRUE);
	XtSetSensitive(menu_button[CONNECT_CONNECT],TRUE);
	XtSetSensitive(dir_input[1],FALSE);
	XtSetSensitive(command_right_button,FALSE);
	XtSetSensitive(search_right_button,FALSE);

}


set_sensetive_on()
{
	XtSetSensitive(menu_button[CONNECT_DISCONNECT],TRUE);
	XtSetSensitive(menu_button[CONNECT_CONNECT],FALSE);
	XtSetSensitive(menu_button[FILES_QUIT],FALSE);

/* 	XtSetSensitive(menu_button[FILES_COPY],TRUE);
	XtSetSensitive(menu_button[FILES_DELETE],TRUE);*/
	XtSetSensitive(menu_button[VIEWS_REMOTE_FILE],TRUE);
/*	XtSetSensitive(menu_button[VIEWS_LOG_SESSION],TRUE);
	XtSetSensitive(menu_button[VIEWS_HOST_INFO],TRUE);
	XtSetSensitive(menu_button[VIEWS_TRANS_STAT],TRUE);
	XtSetSensitive(menu_button[PROPS_REMOTE_FILE],TRUE);*/
	XtSetSensitive(menu_button[CONNECT_DISCONNECT],TRUE);
	XtSetSensitive(dir_input[1],TRUE);
	XtSetSensitive(command_right_button,TRUE);
	XtSetSensitive(search_right_button,TRUE);
}

int disconnect(Widget parent, caddr_t data, XmAnyCallbackStruct *call_data)
{
	XmString	s;
	char		tstr[61];

	if(close_conn() == -1)
	{
		fprintf(stderr,"4 Ftp-Error : %s \n",global_error);
		return -1;
	}
	set_sensitive_off();
	XmTextSetString(dir_input[1],"");
	delete_list(R_List);

	sprintf(tstr,"%60.60s"," ");
	s = XmStringCreateLtoR(tstr,charset);
	XtVaSetValues(right_host,
		XmNlabelString,s,
		NULL);
	XmStringFree(s);
	put_logo();
}


int con_win(Widget parent, caddr_t data, XmAnyCallbackStruct *call_data)
{
 	static Widget	host_dialog;

	if(host_dialog == (Widget)0)
	{
		host_dialog=XmCreateDialogShell(top_level,"hostDialog",
						NULL,0);
		host_BB=XmCreateBulletinBoard(host_dialog,"hostBB",
						NULL,0);
		CreateForm(host_BB);	
	}

	/* move_pointer(list_form,anonymous_button);*/
	XtManageChild(host_BB);

}

Widget CreateForm(Widget parent)
{

	Widget	sep_top,sep_bottom,buttons,title;
	Widget	master_form;
	Cardinal n;
	int		i;
	Widget	textw;
	int		verify_in();
	void		jump_pw();
	void		jump_user();

	static XtCallbackRec jumppwCB[] = {
		{ (XtCallbackProc) jump_pw,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec jumpusrCB[] = {
		{ (XtCallbackProc) jump_user,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec testCB[] = {
		{ (XtCallbackProc) verify_in,NULL },
		{NULL,NULL}
	};
	static XtCallbackRec conCB[] = {
		{ (XtCallbackProc) con_host,NULL },
		{NULL,NULL}
	};
	
	master_form=XtVaCreateManagedWidget("hostBase",
						xmRowColumnWidgetClass, parent,
						XmNorientation, XmVERTICAL,
						NULL);
 
	title = XtVaCreateManagedWidget("title",
					xmLabelWidgetClass,master_form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNalignment, XmALIGNMENT_CENTER,
					NULL);

	sep_top = XtCreateManagedWidget("sep_top",xmSeparatorWidgetClass,
					master_form,NULL,0);

	FIRST_IN=TRUE;
	text_field[0]=CreateInput(master_form,"lineRHost","labelRHost",
										"RHost",80);
	text_field[1]=CreateInput(master_form,"lineRLogin","labelRLogin",
										"RLogin",80);
	text_field[2]=CreateInput(master_form,"lineRPwd","labelRPwd",
										"RPwd",80);


	XtVaSetValues(text_field[0],
		XmNactivateCallback,jumpusrCB,
		NULL);

	XtVaSetValues(text_field[1],
		XmNactivateCallback,jumppwCB,
		NULL);

	XtVaSetValues(text_field[2],
		XmNactivateCallback,conCB,
		XmNmodifyVerifyCallback,testCB,NULL);
	

	init_text_field("","","");

	sep_bottom = XtCreateManagedWidget("sep_bottom",
							xmSeparatorWidgetClass,master_form,NULL,0);

  	buttons = CreateCommands(master_form);

	XtManageChild(master_form);
	return (master_form);
}


int verify_in(Widget w, caddr_t data,
	XmTextVerifyCallbackStruct *call_data)
{
	int		key_i=call_data->event->xkey.keycode;
	
	if(strlen(pword) < 79)
	{
			pword[pw_ptr]=call_data->text->ptr[0];
			pword[pw_ptr+1]=0;
			pw_ptr++;
	}
	call_data->doit=FALSE;
}

void	jump_user()
{
	XmProcessTraversal(text_field[1],XmTRAVERSE_CURRENT);
}

void	jump_pw()
{
	XmProcessTraversal(text_field[2],XmTRAVERSE_CURRENT);
}



init_text_field(char *s1,char *s2,char *s3)
{
	XmTextSetString(text_field[0],s1);
	XmTextSetString(text_field[1],s2);

	XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
}

Widget CreateInput(Widget parent, char *line_name,char *label_name,
				char *text_name,int bla)
{

	Widget	line,label,text;
	Arg		arg[4];
	Cardinal	n;

	n=0;
 	XtSetArg(arg[n],XmNorientation, XmHORIZONTAL);n++;
 	XtSetArg(arg[n],XmNy, 20);n++;

	line = XtCreateManagedWidget(line_name, 
				xmRowColumnWidgetClass,
				parent, arg ,n);
	n=0;
 	XtSetArg(arg[n],XmNmarginHeight, 10);n++;
	label = XtCreateManagedWidget(label_name, xmLabelWidgetClass,
				line, arg ,n);
	n=0;
	XtSetArg(arg[n],XmNmaxLength,bla);n++;
	XtSetArg(arg[n],XmNcolumns,30);n++;
	text = XtCreateManagedWidget(text_name, xmTextWidgetClass,
				line, arg ,n);

	return (text);

}

Widget CreateCommands(Widget parent)
{

	Widget	line;
	Widget	button;
	Arg		arg[3];
	Cardinal	n;
	int		i;
	int		new_host();
	int		ano_host();
	int		hosts_host();
	int		abort_host();
	
	static XtCallbackRec newCB[] = {
		{ (XtCallbackProc) new_host,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec anoCB[] = {
		{ (XtCallbackProc) ano_host,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec hostsCB[] = {
		{ (XtCallbackProc) hosts_host,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec abortCB[] = {
		{ (XtCallbackProc) abort_host,NULL },
		{NULL,NULL}
	};

	static XtCallbackRec conCB[] = {
		{ (XtCallbackProc) con_host,NULL },
		{NULL,NULL}
	};

	line=XtVaCreateManagedWidget("buttons",
						xmFormWidgetClass,parent,
						XmNbottomAttachment,XmATTACH_FORM,
						XmNleftAttachment,XmATTACH_FORM,
						XmNrightAttachment,XmATTACH_FORM,
						NULL);


	button=XtVaCreateManagedWidget("fb1",
						xmPushButtonWidgetClass,line,
						XmNleftAttachment,XmATTACH_FORM,
						XmNtopAttachment,XmATTACH_FORM,
						XmNactivateCallback,newCB,
						NULL);

	anonymous_button = XtVaCreateManagedWidget("fb2",
						xmPushButtonWidgetClass, line,
						XmNleftWidget,button,
						XmNleftAttachment,XmATTACH_WIDGET,
						XmNtopAttachment,XmATTACH_FORM,
						XmNactivateCallback,anoCB,
						NULL);
	
	button = XtVaCreateManagedWidget("fb3",
						xmPushButtonWidgetClass, line,
						XmNleftAttachment,XmATTACH_WIDGET,
						XmNtopAttachment,XmATTACH_FORM,
						XmNleftWidget,anonymous_button,
						XmNactivateCallback,hostsCB,
						NULL);

	button = XtVaCreateManagedWidget("fb4",
						xmPushButtonWidgetClass,line,
						XmNleftWidget,button,
						XmNleftAttachment,XmATTACH_WIDGET,
						XmNtopAttachment,XmATTACH_FORM,
						XmNactivateCallback,conCB,
						NULL);

	button = XtVaCreateManagedWidget("fb5",
						xmPushButtonWidgetClass,line,
						XmNleftWidget,button,
						XmNleftAttachment,XmATTACH_WIDGET,
						XmNtopAttachment,XmATTACH_FORM,
						XmNactivateCallback,abortCB,
						NULL);

	return (line);
}

int new_host(Widget w, caddr_t data, XmAnyCallbackStruct *call_data)
{ 
	init_text_field("","","");
	pw_ptr=0;
	pword[pw_ptr]=0;
}
int ano_host(Widget w, caddr_t data, XmAnyCallbackStruct *call_data)
{
	char	*s=XmTextGetString(text_field[0]);

	if(s[0])
		init_text_field(s,"anonymous",pw_ano);
	else
	{
		init_text_field("","anonymous",pw_ano);
		hosts_host();
	}
	strcpy(pword,pw_ano);
	pw_ptr=strlen(pword)-1;
}

int hosts_host()
{ 
	char	tmpstr[80];
	int		i;
	static	Widget	list_w;
	static	Widget	apply;
	int		list_host();
	Arg		arg[10];
	int		n;


	if(list_w == (Widget)0 )
	{
		for(i=0;i<hptr;i++)
		{
			sprintf(tmpstr,"%-30.30s   %-10.10s",host_list[i].host,host_list[i].alias);
			search_arr[i] = XmStringCreateLtoR(tmpstr,charset);
		}

		n=0;
		XtSetArg(arg[n],XmNtextColumns,10);n++;
		XtSetArg(arg[n],XmNlistItems,search_arr);n++;
		XtSetArg(arg[n],XmNlistItemCount,i);n++;
		XtSetArg(arg[n],XmNlistVisibleItemCount,((i>10)?10:i));n++;
		
		list_w = XmCreateSelectionDialog(top_level,
									"hostList",arg,n);

		XtAddCallback(list_w,XmNokCallback,(XtCallbackProc)list_host, host_list);
 		apply=XmSelectionBoxGetChild(list_w,XmDIALOG_APPLY_BUTTON);
		XtUnmanageChild(apply);

		n=i;
		for(i=0;i<n;i++)
			XmStringFree(search_arr[i]);
		
	}

	XtManageChild(list_w);
}

int		set_selected_file_name(Widget parent, caddr_t data, 
		XmListCallbackStruct *call_data)
{
	char	*s;
	int		i;

	XmStringGetLtoR(call_data->item,charset,&s);
	if(!s[0])
		return 0;
	if(s[0] == 'D')
	{
		if(data)
			local_file[0]=0;
		else
			remote_file[0]=0;
		
		return 0;
	}

	for(i=2;s[i];i++)
		if(s[i] == ' ')
			break;
	s[i]=0;

#ifdef	DEBUG
printf("data = (%d)\n",data);
#endif
	if(data)
		sprintf(local_file,"%s/%s",local_dir,&s[2]);
	else
		sprintf(remote_file,"%s/%s",remote_dir,&s[2]);

	XtFree(s);
#ifdef	DEBUG
printf("remote_file = (%s)\n",remote_file);
printf("local_file  = (%s)\n",local_file);
#endif

}

delete_list(Widget parent)
{
	XmListDeleteAllItems(parent);
}

int input_ch_remote_dir(Widget parent, caddr_t data, XmAnyCallbackStruct *call_data)
{

	char	*new_dir;

	set_busy_cursor(top_level);
	new_dir=XmTextGetString(parent);

	if(chdir_remote(new_dir) == -1)
	{
		ftp_error("Can't change directory !");
		put_remote_dir_info();
		XtFree(new_dir);
		return -1;
	}
	if(get_dir() == -1)
		return -1;
	delete_list(R_List);
	fill_list(R_List,0);
	put_remote_dir_info();

	set_default_cursor(top_level);
	XtFree(new_dir);
}



int input_ch_local_dir(Widget parent, caddr_t data, XmAnyCallbackStruct *call_data)
{

	char	*new_dir;

	set_busy_cursor(top_level);
	new_dir=XmTextGetString(parent);

	if(chdir(new_dir) == -1)
	{
		ftp_error("Can't change directory !");
		put_local_dir_info();
		XtFree(new_dir);
		return -1;
	}
	delete_list(L_List);
	fill_list(L_List,1);
	put_local_dir_info();

	set_default_cursor(top_level);
	XtFree(new_dir);
}


fill_list(Widget parent,int status)
{

	char		*dir_e[MAX_DIR_ENTRY];
	int			ptr;
	int			i,n;
	XmString	list_arr[MAX_DIR_ENTRY];
	XmString	string;

	if(status)
	{
		if((ptr=format_dir(dir_e,".",1)) == -1)
			return -1;
		for(i=0;i<ptr;i++)
		{
			local_list[i]=XtRealloc(local_list[i],strlen(dir_e[i])+2);
			strcpy(local_list[i],dir_e[i]);
		}
	}
	else
	{
		if((ptr=format_dir(dir_e,tmp_file,0)) == -1)
			return -1;
		for(i=0;i<ptr;i++)
		{
			remote_list[i]=XtRealloc(remote_list[i],strlen(dir_e[i])+2);
			strcpy(remote_list[i],dir_e[i]);

		}
	}

	for(i=0;i<ptr;i++)
		list_arr[i] = XmStringCreateLtoR(dir_e[i],charset);

 	XmListAddItems(parent,list_arr,i,0);

	n=i;
	for(i=0;i<n;i++)
	{
	 	XmStringFree(list_arr[i]);
		XtFree(dir_e[i]);
	}
}


int list_host(Widget w, caddr_t client_data, 
			XmSelectionBoxCallbackStruct *call_data)
{
	char	*s=NULL;
	int		i;

 	XmStringGetLtoR(call_data->value,charset,&s);

	if(!s[0])
		return -1;

	for(i=0;s[i];i++)
		if(s[i] == ' ')
			break;
	s[i]=0;

	XmTextSetString(text_field[0],s);
	XmProcessTraversal(text_field[1],XmTRAVERSE_CURRENT);
	XtFree(s);

}

put_remote_dir_info()
{
	get_pwd();
	XmTextSetString(dir_input[1],remote_dir);
 	XmTextSetInsertionPosition(dir_input[1],strlen(remote_dir));

}

put_local_dir_info()
{
	XmTextPosition	first,last;
	XmString	lo_la_inf;
	char	tstr[100];
	char	tstr2[31];


	getcwd(local_dir,2047);
	XmTextSetString(dir_input[0],local_dir);
 	XmTextSetInsertionPosition(dir_input[0],strlen(local_dir));

/*	sprintf(tstr,"Files : %3d Subdirs : %3d Size: %11s",dir_info.files,
				dir_info.subdirs,mk_nstring(dir_info.size));
 
	lo_la_inf = XmStringCreateLtoR(tstr,charset);
	XtVaSetValues(local_label_info,
		XmNlabelString,lo_la_inf,
		NULL);
	
	XmStringFree(lo_la_inf);*/

}



handle_remote_files(Widget w, caddr_t client_data, 
			XmSelectionBoxCallbackStruct *call_data)
{
	char	*s=NULL;
	int		i;
	static	char	tstr[100],tstr2[1024];
	static	char	tstr4[1024];

 	XmStringGetLtoR(call_data->value,charset,&s);

	strcpy(tstr4,s);

	if(!simple_list)
	{
		XtFree(s);
		up_to_low(tstr4);
		for(i=0;simple_remote_list[i];i++)
			if(strstr(tstr4,simple_remote_list[i]))
				break;
		point_to_simple_entry=simple_remote_list[i];

		if(co_bb != (Widget)0)
			XtVaSetValues(txt_command, XmNvalue,point_to_simple_entry, 
			NULL);

		create_master_command();
		return 0;
	}

	for(i=2;s[i];i++)
		if(s[i] == ' ')
			break;
	s[i]=0;
	
	strcpy(tstr,&s[2]);

	if(s[0] == 'D')
	{
		set_busy_cursor(top_level);
 		if(chdir_remote(tstr) == -1)
			return -1;
		if(get_dir() == -1)
			return -1;
		delete_list(R_List);
		fill_list(R_List,0);
		put_remote_dir_info();
		set_default_cursor(top_level);
		XtFree(s);
	}
	else
	{
		if(simple_list)
			bytes_total=atoi(get_remote_file_size(tstr4));
		sprintf(tstr2,"%s/%s",local_dir,tstr);
		XtFree(s);
		if(get_file(tstr,tstr2) == -1)
			return -1;
	}
}

up_to_low(char *s)
{
	int		i;
	for(i=0;s[i];i++)
		s[i]=tolower(s[i]);
}

char	*get_remote_file_size(char *s)
{
	int				i,x;

	for(i=2;s[i];i++)
		if(s[i] == 32)
		{
			for(x=i;s[x];x++)
				if(s[x] != 32)
					return &s[x];
			break;
		}
	return NULL;
}

handle_local_files(Widget w, caddr_t client_data, 
			XmSelectionBoxCallbackStruct *call_data)
{
	char	*s=NULL;
	int		i;
	char	tstr[100];

 	XmStringGetLtoR(call_data->value,charset,&s);

	for(i=2;s[i];i++)
		if(s[i] == ' ')
			break;
	s[i]=0;
	strcpy(tstr,&s[2]);

	if(s[0] == 'D')
	{
		XtFree(s);
		set_busy_cursor(top_level);
		if(chdir(tstr) == -1)
		{
			ftp_error("Can't change directory !");
			return -1;
		}
		delete_list(L_List);
		fill_list(L_List,1);
		put_local_dir_info();
		set_default_cursor(top_level);
	}
	else
	{
		XtFree(s);
		if(!connected)
		{
			ftp_error("You're not connected !");
			return -1;
		}
		bytes_total=(off_t)get_local_file_size(tstr);
		strcpy(local_name,tstr);
#ifdef	DEBUG
printf("handle_local_files=(%s)\n",local_name);
#endif

		if(put_file() == -1)
		{
			set_win_active();
			return -1;
		}
	}
}

get_local_file_size(char *s)
{
	struct	stat	stbuf;

	if(stat(s,&stbuf))
		return -1;
	return ((off_t) stbuf.st_size);
}

set_win_inactive()
{
	set_busy_cursor(top_level);
	XtSetSensitive(menu_bar,FALSE);
	XtSetSensitive(R_List,FALSE);
	XtSetSensitive(L_List,FALSE);
	XtSetSensitive(dir_input[0],FALSE);
	XtSetSensitive(dir_input[1],FALSE);
}

set_win_active()
{
	set_default_cursor(top_level);
	XtSetSensitive(menu_bar,TRUE);
	XtSetSensitive(R_List,TRUE);
	XtSetSensitive(L_List,TRUE);
	XtSetSensitive(dir_input[0],TRUE);
	XtSetSensitive(dir_input[1],TRUE);
}

int con_host(Widget w, caddr_t data, XmAnyCallbackStruct *call_data)
{ 

	static	char	*s1,*s2,*s3;
	XmString	s;
	char	tstr[80];

	set_busy_cursor(host_BB);
	set_busy_cursor(top_level);
	simple_list=TRUE;

 	s1=XmTextGetString(text_field[0]);
	s2=XmTextGetString(text_field[1]);
	s3=pword;


	if(!s2[0])
	{
 		ftp_error("Username must be entered !");
		XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
		pword[0]=0;
		pw_ptr=0;
		set_default_cursor(host_BB);
		set_default_cursor(top_level);
		return -1;
	}

	if(open_con(s1,s2,s3) == -1)
	{
		XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
		pword[0]=0;
		pw_ptr=0;
		set_default_cursor(host_BB);
		set_default_cursor(top_level);
		return -1;
	}

	pword[0]=0;
	pw_ptr=0;
	put_remote_dir_info();

	sprintf(tstr,"%s",s1);
	s = XmStringCreateLtoR(tstr,charset);
	XtVaSetValues(right_host,
		XmNlabelString,s,
		NULL);
	XmStringFree(s);

	if(get_dir() == -1)
	{
		ftp_error(global_error);
		close_conn();
		XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
		set_default_cursor(host_BB);
		set_default_cursor(top_level);
		return -1;
	}

	if(!check_entry())
	{
		simple_list=FALSE;
		if(get_simple_dir() == -1)
			return -1;

	}

	put_back_logo();
 	fill_list(R_List,0);

	XtUnmanageChild(host_BB);

	set_default_cursor(host_BB);
	set_default_cursor(top_level);
	set_sensetive_on();
	return 0;
}

get_simple_dir()
{
	n_list=TRUE;
	tmp_file=simple_tmp_file;
	if(get_dir() == -1)
	{
		ftp_error(global_error);
		close_conn();
		XmProcessTraversal(text_field[0],XmTRAVERSE_CURRENT);
		set_default_cursor(host_BB);
		set_default_cursor(top_level);
		return -1;
	}
	read_simple_list();
	tmp_file=normal_tmp_file;
	n_list=FALSE;

	return 0;
}
	
read_simple_list()
{
	FILE	*fp;
	int		ptr=0;
	char	tstr[1024];


	if(!(fp=fopen(tmp_file,"r")))
	{
		ftp_error("Can't open tmp file !");
		return -1;
	}

	bzero(( char *) &simple_remote_list, sizeof(simple_remote_list));
	while(1)
	{
		if(ptr >= MAX_DIR_ENTRY)
			break;
		if(!(fgets(tstr,1023,fp)))
			break;
		strip_lf(tstr);
		simple_remote_list[ptr]=XtRealloc(simple_remote_list[ptr],
							strlen(tstr)+1);
		strcpy(simple_remote_list[ptr],tstr);
		ptr++;
	}
}

get_pwd()
{

	char	tstr[100];
	int		i;	

	strcpy(tstr,"PWD");

	if(get_command(tstr,257) == -1)
	{
		fprintf(stderr,"4 Ftp-Error : %s \n",global_error);
		return -1;
	}

	if(atoi(tstr) == 257)
	{
		for(i=0;tstr[i];i++)
			if(tstr[i] == '"')
			{
				strcpy(remote_dir,&tstr[i+1]);
				break;
			}

		for(i=0;remote_dir[i];i++)
			if(remote_dir[i] == '"')
			{
				remote_dir[i]=0;
				break;
			}
	}
	else
	{
		ftp_error("Can't get cwd !");
		return -1;
	}
	
	return 0;
}

chdir_remote(char *s)
{
	char	tstr[100];
	int		i;	

	sprintf(tstr,"CWD %s",s);

	if(get_command(tstr,250) == -1)
	{
		fprintf(stderr,"%s\n",global_error);
		return -1;
	}

	return 0;
}



read_tmp_dir()
{

	FILE	*fp;
	char	tstr[2048];


	if(!(fp=fopen(tmp_file,"r")))
	{
		ftp_error("Can't open tmp_file !");
		return -1;
	}

	while((fgets(tstr,2047,fp)))
		printf("%s",tstr);

	fclose(fp);

}


check_entry()
{
	FILE	*fp;
	char	tstr[100];
	char	*subject="^[dl-][r-][w-][xsStT-]";
	char	*ret;
	char	*pattern;

	if(!(fp=fopen(tmp_file,"r")))
	{
		ftp_error("Can't open tmp_file !");
		return -1;
	}

	fgets(tstr,99,fp);
	fgets(tstr,99,fp);
	fclose(fp);

#if defined(SUN) || defined(linux)
		pattern=(char *) re_comp(subject);
		return (int) (re_exec (tstr));
#else
	pattern=(char *) regcmp(subject,NULL);
	return (int) (ret=(char *) regex (pattern, tstr ,NULL));
#endif

}

open_con(char *s1,char *s2,char *s3)
{
	char	tstr[100];
	char	tstr2[100];

	if((c_hd=tcp_open(s1,"ftp",21)) <= 0)
	{
		ftp_error("Unknown host");
		return -1;
	}

	connected=TRUE;

#ifdef	DEBUG
	fprintf(stderr,"Connected (%d)\n",c_hd);
#endif

	if(read_line(tstr,CON_TIMEOUT,-1))
		return -1;

	sprintf(tstr,"USER %s",s2);
	if(write_line(tstr))
		return -1;
	while(1)
	{
		if(read_line(tstr,CON_TIMEOUT,-1))
			return -1;
		strcpy(tstr2,&tstr[4]);

		switch(atoi(tstr))
		{
			case 500 :
			case 220 : 
			break;
			
			case 530 :  ftp_error(tstr2);
						close_conn();
						return -1;
						
			case 331 : sprintf(tstr,"PASS %s",s3);
						if(write_line(tstr))
							return -1;
						if(read_line(tstr,CON_TIMEOUT,-1))
							return -1;
						if(atoi(tstr) != 230)
						{
							ftp_error(tstr2);
							close_conn();
							return -1;
						}
						return 0;
			break;
		}
	}
	return 0;
}


ftp_error(char *s)
{
	static	Widget  	error_box;
	static	Widget		help,cancel;
	XmString	comp_text;


	if(XtIsRealized(main_widget))
	{
		set_default_cursor(top_level);

		if( error_box == (Widget)0)
		{
			error_box = XmCreateErrorDialog(top_level,
					"errorMessageBox",NULL,0);
			help=XmMessageBoxGetChild(error_box,XmDIALOG_HELP_BUTTON);
			cancel=XmMessageBoxGetChild(error_box,XmDIALOG_CANCEL_BUTTON);
			
			XtUnmanageChild(help);
			XtUnmanageChild(cancel);
		}

		comp_text = XmStringLtoRCreate(s, charset);
		XtVaSetValues(error_box, XmNmessageString,comp_text, NULL);
		XmStringFree(comp_text);

		XtManageChild(error_box);
	}
	else
		fprintf(stderr,"xftp: %s\n",s);
}

close_conn()
{

	char	tstr[100];

	strcpy(tstr,"QUIT");
	if(write_line(tstr))
		return -1;

	while(connected)
		if(read_line(tstr,CON_TIMEOUT,-1))
			return 1;
}

get_command(char *s,int stat)
{
	if(write_line(s) == -1)
		return -1;
	if(read_line(s,CON_TIMEOUT,stat) == -1)
		return -1;

	return 0;
}

put_file()
{
 	if(tool_f.conf_send)
		put_file_quest();
	else
		f_put_file(local_name);
}

f_put_file(char *lname)
{
	char	tstr[1024];
	int		hd;
	FILE	*fp;
	int		i;
	char	a=FALSE;

	set_win_inactive();
	if(write_line("TYPE i") == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	if(initconn() == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	hd=open(lname,O_RDONLY,0666);
	if(hd<=0)
	{
		ftp_error("Can't open local file ");
		return -1;
	}

	if(tool_f.r_unique)
		sprintf(tstr,"STOU %s",lname);
	else
		sprintf(tstr,"STOR %s",lname);
	if(write_line(tstr) == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,150) == -1)
		return -1;
	if(!(fp=dataconn("w",d_hd)))
	{
		ftp_error("Can't open data connection");
		return -1;
	}
	write_binary(fp,hd);
	return 0;
}

put_file_quest()
{
	static		Widget  	quest_box;
	void		hd_canc();
	void		hd_ok();
	XmString	quest;

	if(quest_box == (Widget) 0)
	{
		quest_box = XmCreateQuestionDialog(top_level,
				"putFileQuestBox",NULL,0);
 		XtAddCallback(quest_box,XmNcancelCallback,(XtCallbackProc)hd_canc,
				(caddr_t) quest_box);
		XtAddCallback(quest_box,XmNokCallback,(XtCallbackProc)hd_ok, NULL);
	}
	XtManageChild(quest_box);
}

void hd_canc(Widget parent,caddr_t client_data,caddr_t call_data)
{
	XtUnmanageChild(XtParent(parent));
}

void hd_ok(Widget parent,caddr_t client_data,caddr_t call_data)
{
	XtUnmanageChild(XtParent(parent));
	f_put_file(local_name);
}

get_file(char *rname,char *lname)
{
	static		Widget  	quest_box;
	void 		hd_canc();
	int 		get_ok();
	XmString	quest;
	static		char		*param[2];

	if(tool_f.conf_receive)
	{
		param[0]=rname;
		param[1]=lname;

		if(quest_box == (Widget) 0)
		{
			quest_box = XmCreateQuestionDialog(top_level,
					"getFileQuestBox",NULL,0);
			XtAddCallback(quest_box,XmNcancelCallback, (XtCallbackProc)hd_canc,
					(caddr_t) quest_box);
			XtAddCallback(quest_box,XmNokCallback,(XtCallbackProc)get_ok, 
							(caddr_t) param);
		}
		XtManageChild(quest_box);
	}
	else
		f_get_file(rname,lname);
}

int get_ok(Widget parent,caddr_t client_data,caddr_t call_data)
{
	char **param=(char **) client_data;
	XtUnmanageChild(XtParent(parent));
	f_get_file(param[0],param[1]);
}

f_get_file(char *rname,char *lname)
{
	char	tstr[1024];
	int		hd;
	FILE	*fp;
	int		i;
	char	a=FALSE;
	char	*new_file;


	if(file_da(lname) && tool_f.l_unique)
	{
		new_file= XtMalloc(strlen(lname)+4);
		for(i=0;i<99;i++)
		{
			sprintf(new_file,"%s.%d",lname,i);
			if(!file_da(new_file))
			{
				a=TRUE;
				break;
			}
		}
		if(!a)
		{
			ftp_error("To many temp files !");
			return -1;
		}
	}
	else
	{
		new_file=XtMalloc(strlen(lname)+1);
		strcpy(new_file,lname);
	}

	if(write_line("TYPE i") == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	if(initconn() == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;

	sprintf(tstr,"RETR %s",rname);
	if(write_line(tstr) == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,150) == -1)
		return -1;

	hd=open(new_file,O_WRONLY|O_TRUNC|O_CREAT,0666);
	XtFree(new_file);
	if(hd<=0)
	{
		ftp_error("Can't open local file ");
		return -1;
	}

	if(!(fp=dataconn("r",d_hd)))
	{
		ftp_error("Can't open data connection");
		return -1;
	}
	read_binary(fp,hd);

	return 0;
}


get_view_file(char *rname,char *lname)
{
	char	tstr[1024];
	int		hd;
	FILE	*fp;
	int		i;
	char	a=FALSE;
	char	*new_file;

	new_file=XtMalloc(strlen(lname)+1);
	strcpy(new_file,lname);

	if(write_line("TYPE i") == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	if(initconn() == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	hd=open(new_file,O_WRONLY|O_TRUNC|O_CREAT,0666);
	XtFree(new_file);
	if(hd<=0)
	{
		ftp_error("Can't open local file ");
		return -1;
	}

	sprintf(tstr,"RETR %s",rname);
	if(write_line(tstr) == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,150) == -1)
		return -1;
	if(!(fp=dataconn("r",d_hd)))
	{
		ftp_error("Can't open data connection");
		return -1;
	}
	read_view_file(fp,hd);

	return 0;
}


unsigned long read_view_file(FILE *fp, int out)
{
	int	a;
	int	l;
	unsigned	char	buff[16386];
	char	*tstr;


	blk_in=fileno(fp);
	blk_out=out;

	while((a=read(blk_in,buff,16384)))
	{
		if(a < 0)
		{
			ftp_error("Error in read !");
			break;
		}
		if((l=write(blk_out,buff,a)) != a)
		{
			ftp_error("Error in write !");
			break;
		}
	}

	close(blk_in);
	close(blk_out);
	tstr=XtMalloc(200);
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	XtFree(tstr);
}

file_da(char	*s)
{
	FILE	*fp;

	if(!(fp=fopen(s,"r")))
		return FALSE;

	fclose(fp);
	return TRUE;

}

get_dir()
{
	char	tstr[100];
	int		hd;
	FILE	*fp;


	if(write_line("TYPE a") == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	if(initconn() == -1)
		return -1;
	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;

	hd=open(tmp_file,O_WRONLY|O_TRUNC|O_CREAT,0666);
	if(hd<=0)
	{
		ftp_error("Can't open tmp file ");
		return -1;
	}

 	if(!n_list)
		sprintf(tstr,"LIST");
 	else
		sprintf(tstr,"NLST");

	if(write_line(tstr) == -1)
		return -1;

	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	if(!(fp=dataconn("r",d_hd)))
	{
		ftp_error("Can't open data connection");
		return -1;
	}
	read_asci(fp,hd);

	close(d_hd);
	fclose(fp);
	close(hd);

	if(read_line(tstr,CON_TIMEOUT,-1) == -1)
		return -1;
	return 0;

}

int sendport = -1;		

initconn()
{
	register char *p, *a;
	char tmp[100];
	int result, len, tmpno = 0;
	int on = 1;

	data_addr = myctladdr;
	if (sendport)
		data_addr.sin_port = 0;	/* let system pick one */ 

	if (d_hd != -1)
		(void) close (d_hd);

	d_hd = socket(AF_INET, SOCK_STREAM, 0);

	if (d_hd < 0) {
		ftp_error("sftp: socket");
		return -1;
		}

	if (!sendport)
		if (setsockopt(d_hd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on)) < 0) {
			ftp_error("ftp: setsockopt (reuse address)");
			return (-1);
			}

	if (bind(d_hd, (struct sockaddr *)&data_addr, sizeof (data_addr)) < 0) {
		ftp_error("ftp: bind");
		(void) close(d_hd);
		d_hd = -1;
		return (-1);
		}
/*	if (options & SO_DEBUG &&
	    setsockopt(d_hd, SOL_SOCKET, SO_DEBUG, (char *)&on, sizeof (on)) < 0)
		ftp_error("ftp: setsockopt (ignored)"); */

	len = sizeof (data_addr);
	if (getsockname(d_hd, (struct sockaddr *)&data_addr, &len) < 0) {
		ftp_error("ftp: getsockname");
		(void) close(d_hd);
		d_hd = -1;
		return (-1);
		}

	if (listen(d_hd, 1) < 0)
		ftp_error("ftp: listen");

	if (sendport) {
		a = (char *)&data_addr.sin_addr;
		p = (char *)&data_addr.sin_port;


#define	UC(b)	(((int)b)&0xff)
		 sprintf(tmp,"PORT %d,%d,%d,%d,%d,%d",
		      UC(a[0]), UC(a[1]), UC(a[2]), UC(a[3]),
		      UC(p[0]), UC(p[1]));
		if(write_line(tmp) == -1)	
			return -1;
		}
	return (0);
}




write_line(char *s)
{
	char	tstr[100];

	if(debug)
	{
		fprintf(dbg_fp,"Debug_out: %s\n",s);
		fflush(dbg_fp);
	}
	

	sprintf(tstr,"%s\r\n",s);

	if(write(c_hd,tstr,strlen(tstr)) != strlen(tstr))
	{
		ftp_error("write error !");
		return -1;
	}
	
	return 0;
}

read_line(char *s,int timo,int ret_stat)
{

	unsigned char c;
	int	a;
	int	la=0;
	char	tstr[500];
	int		x;

#ifdef	DEBUG
	if(tok_out)
		printf("(YOP 1)\n",c);
		fflush(stdout);
#endif
	
	signal(SIGALRM,(void *)have_alarm);
	hv_alarm = 0;
	while(1)
	{
		while(1)
		{
			alarm(timo);
#ifdef	DEBUG
	if(tok_out)
		printf("(YOP 2)\n",c);
		fflush(stdout);
#endif

			a=read(c_hd,&c,1);

#ifdef	DEBUG
	if(tok_out)
		printf("(YOP 3)\n",c);
		fflush(stdout);
	if(tok_out)
		printf("(%c)",c);
		fflush(stdout);
#endif
			alarm(0);
 			if(c == 13)
				continue;
			if(a <= 0 || hv_alarm || c == 10 )
				break;
			if(la < 98)
				s[la++]=c;
		}
		s[la]=0;
		if(hv_alarm)
			return -1;
		if(atoi(s) != 0 && s[3] == '-')
		{
			fprintf(stderr,"[%s]\n",s);
			la=0;
			continue;
		}
		break;
	}

	if(debug)
	{
		fprintf(dbg_fp,"Debug_in : %s\n",s);
		fflush(dbg_fp);
	}

 	if(ret_stat != -1)
	{
		x=atoi(s);
		if(x != ret_stat)
		{
			strcpy(tstr,&s[4]);
			ftp_error(tstr);
			if(x == SERVER_TIMEOUT)
				clean_remote_win();
			return -1;
		}
	}
	
	if(atoi(s) == 221)
		connected=FALSE;
	if(hv_alarm)
		return -1;

	return 0;

}

clean_remote_win()
{
	XmString	s;
	char		tstr[61];

	set_sensitive_off();
	XmTextSetString(dir_input[1],"");
	delete_list(R_List);

	sprintf(tstr,"%60.60s"," ");
	s = XmStringCreateLtoR(tstr,charset);
	XtVaSetValues(right_host,
		XmNlabelString,s,
		NULL);
	XmStringFree(s);
	put_logo();
}




int abort_host(Widget w, caddr_t data, XmAnyCallbackStruct *call_data)
{ 

	XtUnmanageChild(host_BB);
	printf("abort_host\n");
}


Widget MakeMenuPane( char *name, Widget parent, men_pt menu[])
{
	Widget	new_menu;
	int		i=0;

	new_menu = XmCreatePulldownMenu(parent, name, NULL, 0);

	while(menu[i].label != NULL)
	{
		menu_button[men_but_ptr] = XmCreatePushButton(new_menu,menu[i].label,
					NULL,0);
		XtAddCallback(menu_button[men_but_ptr],XmNactivateCallback,
				(XtCallbackProc) menu[i].fnc,menu[i].args);
		XtManageChild(menu_button[men_but_ptr]);
		men_but_ptr++;
		i++;
	}

	return (new_menu);
}

void AttachToCascade(Widget parent, char *label, Widget sub_menu)
{

	Arg	args[10];
	Cardinal	argcount;
	Widget	cbutton;

	argcount=0;
	XtSetArg(args[argcount],XmNsubMenuId, sub_menu);
	argcount++;
	cbutton = XmCreateCascadeButton(parent, label,
					args, argcount);
	
	XtManageChild(cbutton);
}

int quit_action(Widget w, caddr_t data,
	XmAnyCallbackStruct *call_data)
{
	static		Widget  	message_box;

	if(tool_f.quit_conf)
	{
		if(message_box == (Widget) 0)
		{
			message_box = XmCreateQuestionDialog(top_level,
					"quitAction",NULL,0);
			XtAddCallback(message_box,XmNcancelCallback,
					(XtCallbackProc)HandleCancel,
					(caddr_t) message_box);
			XtAddCallback(message_box,XmNokCallback,
					(XtCallbackProc)quit,
					(caddr_t) message_box);
		}
		XtManageChild(message_box);
	}
	else
		quit(w,(caddr_t) NULL,(XmAnyCallbackStruct *) NULL);	
		
}

void HandleCancel(Widget w, caddr_t client_data,
		XmAnyCallbackStruct *call_data)
{
	XtUnmanageChild ((Widget) client_data);
}

void quit(Widget w, caddr_t data,
	XmAnyCallbackStruct *call_data)
{
	XtCloseDisplay(XtDisplay(w));

	if(tool_f.save_local_dir)
	{
		strcpy(tool_f.start_dir,local_dir);
		write_rc();
	}
	
	unlink(normal_tmp_file);
	unlink(simple_tmp_file);
	exit(0);
}


ptransfer(char *s2, unsigned long bytes, struct timeval *t0, struct timeval *t1)
{
	struct timeval td;
	float s, bs;

	tvsub(&td, t1, t0);
	s = td.tv_sec + (td.tv_usec / 1000000.);
#define	nz(x)	((x) == 0 ? 1 : (x))
	bs = bytes / nz(s);
	 sprintf(s2,"%.2g s / %.2g Kb/s",  s, bs / 1024.);
}


tvsub(struct timeval *tdiff, struct timeval *t1, struct timeval *t0)
{

	tdiff->tv_sec = t1->tv_sec - t0->tv_sec;
	tdiff->tv_usec = t1->tv_usec - t0->tv_usec;
	if (tdiff->tv_usec < 0)
		tdiff->tv_sec--, tdiff->tv_usec += 1000000;
}

void set_cursor(Widget widget,Cursor new_cursor)
{

	XDefineCursor (XtDisplay (widget), XtWindow (widget), new_cursor);
	XFlush (XtDisplay(widget));

}

set_busy_cursor(Widget w)
{
	set_cursor(w,busy_cursor);
}

set_default_cursor(Widget w)
{
	set_cursor(w,(Cursor) NULL);
}

char 	*crf(char *s)
{
	int	x,i;

	x=strlen(s)-1;
	for(i=x;s[i];i--)
		if(s[i] == '/')
			return (char *) &s[i+1];

	return (char *) s;
}


void sigcatch()
{
	int	 Counter;
	void sig_message();

	for(Counter=1;Counter<16;Counter++)
		signal(Counter,sig_message);
}

void sig_message(i)
int i;
{
	fprintf(stderr,"Signal received by Signal [%d]\n",i);
	fflush(stderr);
}
