/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   6000 Frankfurt/Main 80, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* 	sftp.c 
	Written by Ruediger & Michaela Merz <styx||misch@eurom.rhein-mein.de> */
	
	
	
#include	<xftp.h>



#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

int	blk_in,blk_out;


char *get_serr(int x);

tcp_open(host, service,port)
char *host;
char *service;
int port;
{
	unsigned long ip_addr;
	int len;
	int fd, resvport;
	unsigned long inaddr;
	struct servent *sp;
	struct hostent *hp;

	bzero(( char *) &tcp_srv_addr, sizeof(tcp_srv_addr));
	tcp_srv_addr.sin_family = AF_INET;

	if (service != NULL)	{
		if (( sp = getservbyname(service,"tcp")) == NULL)	{
			strcpy(global_error,get_serr(errno));
			return (-1);
			}
		tcp_serv_info = *sp;
		if (port > 0)
			tcp_srv_addr.sin_port = htons(port);
		else
			tcp_srv_addr.sin_port = sp->s_port;
		} 
	else	{
		if (port <= 0)	{
			strcpy(global_error,"no port defined");
			return (-2);
			}
		tcp_srv_addr.sin_port = htons(port);
		}

	if ((inaddr = inet_addr(host)) != INADDR_NONE)	{
		bcopy((char *) &inaddr, (char *) &tcp_srv_addr.sin_addr,
			sizeof(inaddr));
		tcp_host_info.h_name = NULL;
		}
	else	{
		if (( hp = gethostbyname(host)) == NULL)	{
			strcpy(global_error,"00 Unknown host");
			return (-3);	
			}
		tcp_host_info = *hp;
		bcopy(hp->h_addr, (char *) &tcp_srv_addr.sin_addr,
			hp->h_length);
		}

	ip_addr = tcp_srv_addr.sin_addr.s_addr;

	if (port >= 0)	{
		if ((fd = socket(AF_INET, SOCK_STREAM,0)) < 0)	{
			strcpy(global_error,get_serr(errno));
			return (-4);
			}
		}
	else if (port < 0)	{
		resvport = IPPORT_RESERVED -1;
		if (( fd = rresvport(&resvport) < 0))	{
			strcpy(global_error,get_serr(errno));
			return (-5);
			}
		}
	if (connect(fd, (struct sockaddr *) &tcp_srv_addr,
		sizeof(tcp_srv_addr)) < 0)	{
		strcpy(global_error,get_serr(errno));
		close(fd);
		return (-6);
		}

	len = sizeof (myctladdr);
	if (getsockname(fd, (struct sockaddr *)&myctladdr, &len) < 0) {
		perror("ftp: getsockname");
		close(fd);
		return(-7);
		}
	return (fd);
}


char *get_serr(int x)
{
	static char me[100];
	int a;

	sprintf(me,"%d Undefined error",x);
	for (a = 0; a < 300; a++)	{
		if (atoi(s_err[a]) == 0)
			break;
		if (atoi(s_err[a]) == x)	{
			strcpy(me,s_err[a]);
			break;
			}
		}
	return (me);
}


FILE *
dataconn(char *mode,int hd)
{
	struct sockaddr_in from;
	int s, fromlen = sizeof (from);

	s = accept(d_hd, (struct sockaddr *) &from, &fromlen);
	if (s < 0) {
		perror("ftp: accept");
		(void) close(d_hd), d_hd = -1;
		return (NULL);
		}
	(void) close(d_hd);
	d_hd = s;
	return (fdopen(d_hd, mode));
}

unsigned long read_binary(FILE *fp, int out)
{
	bytes_trans=0;

	trans_direction=TRUE;
	blk_in=fileno(fp);
	blk_out=out;
	trans_win();
	hv_sigint = 0;
}

unsigned long write_binary( FILE *fp,int in)
{
	bytes_trans=0;

	trans_direction=FALSE;
	blk_in=in;
	blk_out=fileno(fp);
	trans_win();
	hv_sigint = 0;
}

unsigned long read_asci(FILE *fp, int out)
{
	int a,c,d;
	char in;
	unsigned long by = 0;
	int prob = 0;
	char lout[1024];
	char buffer[513];
	char ob[1024];
	int b,o = 0;
	int l_o = 0;


	hv_sigint = 0;

	while (1)	{
		if (hv_sigint)	{
			prob = 1;
			break;
			}	
		a = read(fileno(fp), &in,1);
		if (a <= 0)
			break;
		by++;
		if (in == '\r')
			continue;
		if (in == '\n' || o > 1000)	{
			ob[o] = 0;
			o = 0;
			rtrim(ob);
			if (write(out,ob,strlen(ob)) != strlen(ob))	{
				fprintf(stderr,"? local write error\n");
				prob = 1;
				break;
				}
			}
		ob[o++] = in;
		}
	if (prob)
		return (0L);
	return (by);
}


rtrim(char *s)
{
	int a;

	for (a = strlen(s); a > 0; a--)	{
		if (s[a] != ' ' && s[a] != 0)
			break;
		}
	s[a+1] = 0;
}
