/*
 * gif.c
 * kirk johnson
 * july 1993
 *
 * RCS $Id: gif.c,v 1.1 1993/07/19 10:32:19 tuna Exp $
 *
 * Copyright 1993 by Kirk Lauritz Johnson (see the included file
 * "kljcpyrt.h" for complete copyright information)
 */

#include "xearth.h"
#include "giflib.h"
#include "kljcpyrt.h"

static uchar *dith;


void gif_setup(s)
     FILE *s;
{
  int  i;
  int  rtn;
  BYTE cmap[3][256];

  dither_setup(64);
  dith = (uchar *) malloc(wdth);
  assert(dith != NULL);

  for (i=0; i<dither_ncolors; i++)
  {
    cmap[0][i] = dither_colormap[i*3+0];
    cmap[1][i] = dither_colormap[i*3+1];
    cmap[2][i] = dither_colormap[i*3+2];
  }

  rtn = gifout_open_file(s, wdth, hght, dither_ncolors, cmap, 0);
  assert(rtn == GIFLIB_SUCCESS);

  rtn = gifout_open_image(0, 0, wdth, hght);
  assert(rtn == GIFLIB_SUCCESS);
}


void gif_row(row)
     uchar *row;
{
  int i;

  dither_row(row, dith);

  for (i=0; i<wdth; i++)
    gifout_put_pixel(dith[i]);
}


void gif_cleanup()
{
  int rtn;

  rtn = gifout_close_image();
  assert(rtn == GIFLIB_SUCCESS);

  rtn = gifout_close_file();
  assert(rtn == GIFLIB_SUCCESS);

  dither_cleanup();
  free(dith);
}
