/* xdatplot.c -- look at data files					*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

#include "xdatplot.h"
#include "fallback.h"

#define	BELLVOL	(100)			/* bell volume			*/

#ifdef	__STDC__
static	void	usage(void);
static	void	PU_error_cb(Widget, String, XmAnyCallbackStruct *);
static	void	PU_help_cb(Widget, String, XmAnyCallbackStruct *);
static	void	ask_user_cb(Widget, ANSWER *, XmAnyCallbackStruct *);
#else	__STDC__
static	void	usage();
static	void	PU_error_cb();
static	void	PU_help_cb();
static	void	ask_user_cb();
#endif	__STDC__

/*
 * to add a new option:
 *
 * (1) Add it to the AppData structure defined in xdatplot.h.
 * (2) Add the command line option to options below.
 * (3) Add the resource to resources.
 */
XrmOptionDescRec options[] = {
    {"-file", "*dataFile", XrmoptionSepArg, NULL},
    {"-buffer_size", "*bufferSize", XrmoptionSepArg, NULL},
    {"-print_command", "*printCommand", XrmoptionSepArg, NULL},
    {"-help_print_command", "*helpPrintCommand", XrmoptionSepArg, NULL},
    {"-time", "*time", XrmoptionSepArg, NULL},
    {"-t_units", "*tUnits", XrmoptionSepArg, NULL},
    {"-t_tics", "*tTics", XrmoptionSepArg, NULL},
    {"-t_ticlen", "*tTicLength", XrmoptionSepArg, NULL},
    {"-t_multiplier", "*tMultiplier", XrmoptionSepArg, NULL},
    {"-t_gain", "*tGain", XrmoptionSepArg, NULL},
    {"-t_width", "*tWidth", XrmoptionSepArg, NULL},
    {"-v_units", "*vUnits", XrmoptionSepArg, NULL},
    {"-v_tics", "*vTics", XrmoptionSepArg, NULL},
    {"-v_ticlen", "*vTicLength", XrmoptionSepArg, NULL},
    {"-v_multiplier", "*vMultiplier", XrmoptionSepArg, NULL},
    {"-v_gain", "*vGain", XrmoptionSepArg, NULL},
    {"-v_height", "*vHeight", XrmoptionSepArg, NULL},
    {"-top_margin", "*topMargin", XrmoptionSepArg, NULL},
    {"-bottom_margin", "*bottomMargin", XrmoptionSepArg, NULL},
    {"-right_margin", "*rightMargin", XrmoptionSepArg, NULL},
    {"-left_margin", "*leftMargin", XrmoptionSepArg, NULL},
    {"-autoscale_always", "*autoscaleAlways", XrmoptionNoArg, "True"},
    {"-plot_font", "*plotFont", XrmoptionSepArg, NULL},
    {"-plot_heading_font", "*plotHeadingFont", XrmoptionSepArg, NULL},
    {"-cursor_color", "*CURSORColor", XrmoptionSepArg, NULL},
    {"-mark_color", "*markColor", XrmoptionSepArg, NULL},
    {"-mark_size", "*markSize", XrmoptionSepArg, NULL},
    {"-mark_thickness", "*markThickness", XrmoptionSepArg, NULL},
    {"-mcf2", "*markCommentFormat2", XrmoptionSepArg, NULL},
    {"-mcf3", "*markCommentFormat3", XrmoptionSepArg, NULL},
    {"-debug", "*debug", XrmoptionNoArg, "True"},
    {"-plotbg", "*plot.background", XrmoptionSepArg, NULL},
    {"-plotfg", "*plot.foreground", XrmoptionSepArg, NULL}
};

XtResource resources[] = {
    {
	"dataFile",
	"DataFile",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, data_file),
	XmRString,
	NULL
    },
    {
	"xdpFile",
	"XDpFile",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, xdp_file),
	XmRString,
	NULL
    },
    {
	"uncompress",
	"Uncompress",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, uncompress),
	XmRString,
	".Z: zcat %s > %s\n.z: gunzip -qc %s > %s\n.gz: gunzip -qc %s > %s"
    },
    {
	"fileConvert",
	"FileConvert",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, file_convert),
	XmRString,
	""
    },
    {
	"saveList",
	"SaveList",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, save_list),
	XmRString,
	""
    },
    {
	"bufferSize",
	"BufferSize",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, xd_bufsiz),
	XmRImmediate,
	(XtPointer) V_BUFSIZ
    },
    {
	"printLimit",
	"PrintLimit",
	XmRCardinal,
	sizeof(Cardinal),
	XtOffsetOf(AppData, print_limit),
	XmRImmediate,
	(XtPointer) 0xffff
    },
    {
	"printCommand",
	"PrintCommand",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, print_cmd),
	XmRString,
	"lpr"
    },
    {
	"helpPrintCommand",
	"HelpPrintCommand",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, help_print_cmd),
	XmRString,
	"lpr"
    },
    {
	"helpViewer",
	"HelpViewer",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, help_viewer),
	XmRString,
	"mosaic -home"
    },
    {
	"helpURL",
	"HelpURL",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, help_URL),
	XmRString,
	""
    },
    {
	"helpPid",
	"HelpPid",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, help_pid),
	XmRImmediate,
	(XtPointer) 0
    },
    {
	"helpTmp",
	"HelpTmp",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, help_tmp),
	XmRString,
	NULL
    },
    {
	"helpWait",
	"HelpWait",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, help_wait),
	XmRImmediate,
	(XtPointer) 0
    },
    {
	"time",
	"Time",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, t_time),
	XmRString,
	"NaN"
    },
    {
	"tUnits",
	"TUnits",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, t_units),
	XmRString,
	""
    },
    {
	"tTics",
	"TTics",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, t_tics),
	XmRImmediate,
	(XtPointer) 3
    },
    {
	"tTicLength",
	"TTicLength",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, t_ticlen),
	XmRImmediate,
	(XtPointer) 5
    },
    {
	"tMultiplier",
	"TMultiplier",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, t_multiplier),
	XmRString,
	"NaN"
    },
    {
	"tGain",
	"TGain",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, t_gain),
	XmRString,
	"1.0"
    },
    {
	"tWidth",
	"TWidth",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, t_width),
	XmRString,
	"5.0"
    },
    {
	"vUnits",
	"VUnits",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, v_units),
	XmRString,
	""
    },
    {
	"vTics",
	"VTics",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, v_tics),
	XmRImmediate,
	(XtPointer) 3
    },
    {
	"vTicLength",
	"VTicLength",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, v_ticlen),
	XmRImmediate,
	(XtPointer) 5
    },
    {
	"vMultiplier",
	"VMultiplier",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, v_multiplier),
	XmRString,
	"NaN"
    },
    {
	"vGain",
	"VGain",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, v_gain),
	XmRString,
	"1.0"
    },
    {
	"vHeight",
	"VHeight",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, v_height),
	XmRString,
	"NaN"
    },
    {
	"peakHeight",
	"PeakHeight",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, peak_height),
	XmRString,
	"0.5"
    },
    {
	"troughDepth",
	"PeakHeight",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, trough_depth),
	XmRString,
	"0.5"
    },
    {
	"peakHalfWidth",
	"HalfWidth",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, peak_half_width),
	XmRString,
	"0.01"
    },
    {
	"troughHalfWidth",
	"HalfWidth",
	XtRDouble,
	sizeof(double),
	XtOffsetOf(AppData, trough_half_width),
	XmRString,
	"0.01"
    },
    {
	"topMargin",
	"TopMargin",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, top_margin),
	XmRImmediate,
	(XtPointer) 50
    },
    {
	"bottomMargin",
	"BottomMargin",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, bottom_margin),
	XmRImmediate,
	(XtPointer) 50
    },
    {
	"rightMargin",
	"RightMargin",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, right_margin),
	XmRImmediate,
	(XtPointer) 100
    },
    {
	"leftMargin",
	"LeftMargin",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, left_margin),
	XmRImmediate,
	(XtPointer) 100
    },
    {
	"autoscaleAlways",
	"AutoscaleAlways",
	XmRBool,
	sizeof(Bool),
	XtOffsetOf(AppData, autoscale_always),
	XmRString,
	"False"
    },
    {
	"debug",
	"Debug",
	XmRBool,
	sizeof(Bool),
	XtOffsetOf(AppData, debug),
	XmRString,
	"False"
    },
    {
	"plotFont",
	"PlotFont",
	XmRFont,
	sizeof(Font),
	XtOffsetOf(AppData, plot_font),
	XmRString,
	"fixed"
    },
    {
	"plotHeadingFont",
	"PlotHeadingFont",
	XmRFont,
	sizeof(Font),
	XtOffsetOf(AppData, plot_heading_font),
	XmRString,
	"9x15bold"
    },
    {
	"markColor",
	"MarkColor",
	XmRPixel,
	sizeof(Pixel),
	XtOffsetOf(AppData, mark_color),
	XmRString,
	"blue"
    },
    {
	"markColor2",
	"MarkColor2",
	XmRPixel,
	sizeof(Pixel),
	XtOffsetOf(AppData, mark_color_2),
	XmRString,
	"medium sea green"
    },
    {
	"markColor3",
	"MarkColor3",
	XmRPixel,
	sizeof(Pixel),
	XtOffsetOf(AppData, mark_color_3),
	XmRString,
	"saddle brown"
    },
    {
	"markColor4",
	"MarkColor4",
	XmRPixel,
	sizeof(Pixel),
	XtOffsetOf(AppData, mark_color_4),
	XmRString,
	"yellow"
    },
    {
	"color2Marks",
	"Color2Marks",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, color_2_marks),
	XmRString,
	"pt"
    },
    {
	"color3Marks",
	"Color3Marks",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, color_3_marks),
	XmRString,
	"0123456789"
    },
    {
	"color4Marks",
	"Color4Marks",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, color_4_marks),
	XmRString,
	""
    },
    {
	"markSize",
	"MarkSize",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, mark_size),
	XmRImmediate,
	(XtPointer) 20
    },
    {
	"markThickness",
	"MarkThickness",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, mark_thickness),
	XmRImmediate,
	(XtPointer) 3
    },
    {
	"CURSORColor",
	"CursorColor",
	XmRPixel,
	sizeof(Pixel),
	XtOffsetOf(AppData, cursor_color),
	XmRString,
	"red"
    },
    {
	"tempFileName",
	"TempFileName",
	XmRString,
	sizeof(String),
	XtOffsetOf(AppData, tfname),
	XmRImmediate,
	(XtPointer) NULL
    },
    {
	"plotFilter",
	"PlotFilter",
	XtRPointer,
	sizeof(FILTER *),
	XtOffsetOf(AppData, c_filter),
	XmRImmediate,
	(XtPointer) &DF_FIL
    },
    {
	"plotGC",
	"PlotGC",
	XtRPointer,
	sizeof(GC),
	XtOffsetOf(AppData, plot_gc),
	XmRImmediate,
	(XtPointer) NULL
    },
    {
	"axesGC",
	"AxesGC",
	XtRPointer,
	sizeof(GC),
	XtOffsetOf(AppData, axes_gc),
	XmRImmediate,
	(XtPointer) NULL
    },
    {
	"plotFontInfo",
	"PlotFontInfo",
	XtRPointer,
	sizeof(XFontStruct *),
	XtOffsetOf(AppData, pfinfo),
	XmRImmediate,
	(XtPointer) NULL
    },
    {
	"plotHeadingFontInfo",
	"PlotHeadingFontInfo",
	XtRPointer,
	sizeof(XFontStruct *),
	XtOffsetOf(AppData, phfinfo),
	XmRImmediate,
	(XtPointer) NULL
    },
    {
	"cursorExists",
	"CursorExists",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, is_cursor),
	XmRImmediate,
	(XtPointer) FALSE
    },
    {
	"cursorRegionExists",
	"CursorRegionExists",
	XmRInt,
	sizeof(int),
	XtOffsetOf(AppData, is_cursor_end),
	XmRImmediate,
	(XtPointer) FALSE
    },
    {
	"filterChain",
	"FilterChain",
	XtRFilterChain,
	sizeof(FILTER),
	XtOffsetOf(AppData, df_fil),
	XmRString,
	""
    },
    {
	"markCommentFormat2",
	"MarkCommentFormat",
	XtRString,
	sizeof(String),
	XtOffsetOf(AppData, mark_comment_format_2),
	XmRString,
	"t = %g, V = %g"
    },
    {
	"markCommentFormat3",
	"MarkCommentFormat",
	XtRString,
	sizeof(String),
	XtOffsetOf(AppData, mark_comment_format_3),
	XmRString,
	"t = %g, V = %g, area = %g, height = %g"
    },
    {
	"markList",
	"MarkList",
	XtRMarkList,
	sizeof(MARKLIST),
	XtOffsetOf(AppData, mark_list),
	XmRString,
	""
    }
};
Bool		free_res[XtNumber(resources)];
int		num_app_resources = XtNumber(resources);
#include "xdatplot.xbm"

String		PROGNAME;		/* for error messages		*/
Status		ret;			/* return status		*/
XtAppContext	app;			/* the application context	*/
AppData		app_data;		/* application data		*/
int		debug;			/* produce debugging output	*/
int		indent = 0;		/* debug msg indentation	*/

Widget		toplevel;		/* main window Shell widget	*/
Widget		plot;			/* Drawing Area for plot	*/
Widget		vsb;			/* vertical scroll bar		*/
Widget		hsb;			/* horizontal scroll bar	*/
/*
 * Widgets with values we need to set or read
 */
Widget		t_field = NO_WIDGET;	/* t text field for CURSOR	*/
Widget		v_field = NO_WIDGET;	/* v text field for CURSOR	*/

main(argc, argv)
int	argc;
char	*argv[];
{
    Atom		WM_DELETE_WINDOW;
    Atom		WM_PROTOCOLS;
    XtResource		*res_list;

    ON_EXIT(exit_cleanup, NULL);
    toplevel = XtVaAppInitialize(&app, CLASS, options,
	XtNumber(options), &argc, argv, fallback,
	XmNdeleteResponse, XmDO_NOTHING,
    NULL);
    WM_DELETE_WINDOW = XmInternAtom(XtDisplay(toplevel),
				    "WM_DELETE_WINDOW", FALSE);
    WM_PROTOCOLS = XmInternAtom(XtDisplay(toplevel),
				"WM_PROTOCOLS", FALSE);
    XmAddProtocolCallback(toplevel,
			  WM_PROTOCOLS, WM_DELETE_WINDOW,
			  (XtCallbackProc) exit_program, NULL);
    app_data.icon = XCreatePixmapFromBitmapData(XtDisplay(toplevel),
	RootWindowOfScreen(XtScreen(toplevel)),
	xdatplot_bits, xdatplot_width, xdatplot_height,
	BlackPixelOfScreen(XtScreen(toplevel)),
	WhitePixelOfScreen(XtScreen(toplevel)), 1);
    XtVaSetValues(toplevel, XmNiconPixmap, app_data.icon, NULL);
    inactivate_filter(&DF_FIL);
    add_converters(NULL);
    /*
     * XtVaGetApplicationResources trashes the XtResourceList passed
     * to it.  But we want to use ours later for saving xdp files.  So
     * we make a copy.
     */
    res_list = (XtResource *)
	XtMalloc(XtNumber(resources) * sizeof(XtResource));
    bcopy(resources, res_list, XtNumber(resources) * sizeof(XtResource));
    XtVaGetApplicationResources(toplevel,
	&app_data,
	res_list,
	XtNumber(resources),
    NULL);
    Free(res_list);
    bzero(free_res, sizeof(free_res));
    debug = app_data.debug;
    STARTUP;
    if (debug) {
	XSynchronize(XtDisplay(toplevel), True);
    }
    if (1 == argc) DATA_FILE = argv[0];
    if (1 < argc) usage();
    inactivate_filter(&DF_FIL);
    create_main_window(toplevel);
    new_file(app_data.data_file);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    exit_program();
}

/* usage -- complain about incorrect command line			*/
static void
usage()
{
    register int	i;

    fprintf(stderr, "%s usage: %s", PROGNAME, PROGNAME);
    for(i=0; i<XtNumber(options); i++) {
	fprintf(stderr, " [%s]", options[i].option);
    }
    fprintf(stderr, " [<filename>]\n");
    exit(ERROR);
}

/* exit_program -- clean up and leave					*/
void
exit_program()
{
    exit_cleanup();
    EXITOK;
}

/* exit_cleanup -- clean up for exit (but don't exit)
 *
 * Anyone who needs cleanup processing should insert a call to the
 * cleanup routine here.  (Would be nice to have a call to register
 * cleanup routines without changing source code: maybe next version.)
 * This routine may be called multiple times on exit, so clean-up
 * routines should determine whether cleanup is actually necessary
 * (e.g. setting pointers to NULL when data are freed, and checking
 * them on cleanup) before proceeding.
 */
void
exit_cleanup()
{
    marks_filter_drop();
    clear_all_marks();
    kill_filters();
    rm_help_tmp();
    close_file(NULL);
}

/* unmap_shell -- callback to unmap shell (passed as client data)	*/
void
unmap_shell(widget, shell, cbs)
Widget			widget;
Widget			shell;
XmAnyCallbackStruct	*cbs;
{
    XtPopdown(shell);
}

/* PU_error -- report a non-fatal error					*/
void
PU_error(errmsg, help_URL)
String		errmsg;
String		help_URL;
{
    Atom		WM_DELETE_WINDOW;
    char		lbuf[LLEN];
    String		s;
    Widget		popup;
    Arg			args[1];

    XtSetArg(args[0], XmNautoUnmanage, False);
    popup = XmCreateErrorDialog(toplevel, "error", args, 1);
    XtVaGetValues(toplevel, XmNtitle, &s, NULL);
    sprintf(lbuf, "%s Error", s);
    s = XtNewString(errmsg);
    XtVaSetValues(popup,
	XmNdeleteResponse, XmDO_NOTHING,
	XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	XtVaTypedArg, XmNmessageString, XmRString,
	s, strlen(s)+1,
	XtVaTypedArg, XmNdialogTitle, XmRString,
	lbuf, strlen(lbuf)+1,
    NULL);
    WM_DELETE_WINDOW = XmInternAtom(XtDisplay(toplevel),
				    "WM_DELETE_WINDOW", FALSE);
    XmAddWMProtocolCallback(toplevel, WM_DELETE_WINDOW,
			    (XtCallbackProc) PU_error_cb, s);
    XtUnmanageChild(XmMessageBoxGetChild(popup, XmDIALOG_CANCEL_BUTTON));
    if (NULL != help_URL) {
	AddCallback(popup, XmNhelpCallback, PU_help_cb, help_URL);
    }
    else {
	XtSetSensitive(XmMessageBoxGetChild(popup, XmDIALOG_HELP_BUTTON),
		       FALSE);
    }
    AddCallback(popup, XmNokCallback, PU_error_cb, s);
    XtManageChild(popup);
    XtPopup(XtParent(popup), XtGrabNone);
    Bell;
}

static void
PU_error_cb(widget, msg, cbs)
Widget			widget;
String			msg;
XmAnyCallbackStruct	*cbs;
{
    Free(msg);
    XtDestroyWidget(widget);
}

static void
PU_help_cb(widget, help_URL, cbs)
Widget			widget;
String			help_URL;
XmAnyCallbackStruct	*cbs;
{
    help_window(help_URL);
}

/* ask_user -- ask user a question
 *
 * String	msg;
 * if (ask_user(msg)) ...
 *
 * Pop up a question dialog with the specified message.  Return True
 * if the user clicks OK, False if Cancel.
 */
Bool
ask_user(msg)
String	msg;
{
    Arg			args[1];
    Widget		popup;
    String		s;
    char		tbuf[LLEN];
    ANSWER		answer = DUNNO;

    XtSetArg(args[0], XmNautoUnmanage, True);
    popup = XmCreateQuestionDialog(toplevel, "askUser", args, 1);
    XtVaGetValues(toplevel, XmNtitle, &s, NULL);
    sprintf(tbuf, "%s Question", s);
    XtVaSetValues(popup,
	XmNdeleteResponse, XmDESTROY,
	XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	XtVaTypedArg, XmNmessageString, XmRString,
	msg, strlen(msg)+1,
	XtVaTypedArg, XmNdialogTitle, XmRString,
	tbuf, strlen(tbuf)+1,
    NULL);
    XtSetSensitive(XmMessageBoxGetChild(popup, XmDIALOG_HELP_BUTTON),
		   FALSE);
    AddCallback(popup, XmNokCallback, ask_user_cb, &answer);
    AddCallback(popup, XmNcancelCallback, ask_user_cb, &answer);
    XtManageChild(popup);
    XtPopup(XtParent(popup), XtGrabNone);
    Bell;
    while(DUNNO == answer) {
	XtAppProcessEvent(app, XtIMAll);
    }
    return(YES == answer);
}

static void
ask_user_cb(widget, ap, cbs)
Widget			widget;
ANSWER			*ap;
XmAnyCallbackStruct	*cbs;
{
    switch(cbs->reason) {
    case XmCR_OK:
	*ap = YES;
	break;
    case XmCR_CANCEL:
	*ap = NO;
	break;
    }
    XtDestroyWidget(widget);
}
