/* help.c -- routines for presenting help				*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */
#include "xdatplot.h"

#ifdef	__STDC__
static	void	start_help(void);
#else	/* __STDC__ */
static	void	start_help();
#endif	/* __STDC__ */

/* help_window -- display help window					*/
void
help_window(subject)
String		subject;
{
    char		lbuf[LLEN];
    FILE		*mcmd;

    if (0 == app_data.help_pid) {	/* need to start help		*/
	start_help();
    }
    if (
	(EOF == kill(app_data.help_pid, 0)) &&
	(ESRCH == errno)
    ) {					/* it was there but died	*/
	wait();				/* reap it			*/
	rm_help_tmp();
	start_help();			/* start another		*/
    }
    if (0 >= app_data.help_pid) return;
    if (NULL == app_data.help_tmp) {
	sprintf(lbuf, "/tmp/Mosaic.%d", app_data.help_pid);
	app_data.help_tmp = XtNewString(lbuf);
    }
    if (
	(NULL == (mcmd = fopen(app_data.help_tmp, "w"))) ||
	(EOF == fprintf(mcmd, "goto\n%s\n", subject)) ||
	(EOF == fclose(mcmd)) ||
	(EOF == kill(app_data.help_pid, SIGUSR1))
    ) PU_error("unable to talk to help viewer", NULL);
}

static void
start_help()
{
    char	lbuf[LLEN];

    if (0 == (app_data.help_pid = VFORK())) {
	String	shell;

	/*
	 * child process: exec help viewer
	 */
	if (EOF == execlp(app_data.help_viewer, app_data.help_viewer,
			  "-home", app_data.help_URL, NULL)) {
	    sprintf(lbuf, "unable to exec %s -home %s", app_data.help_viewer,
		    app_data.help_URL);
	    error(lbuf);
	}
    }
    /*
     * parent process: done
     */
    if (EOF == app_data.help_pid) {
	app_data.help_pid = 0;
	PU_error("Unable to start help viewier", NULL);
    }
    /*
     * give it a little time to get started
     */
    sleep(app_data.help_wait);
}

void
rm_help_tmp()
{
    if (NULL != app_data.help_tmp) {
	unlink(app_data.help_tmp);
	XtFree(app_data.help_tmp);
    }
    app_data.help_tmp = NULL;
}
