.TH xcursor 1 "21 April 1993"
.SH NAME
xcursor \- set cursor in an X window
.SH SYNOPSIS
.nf
xcursor [-v][-l][-id id] [-name name] [-display display] [-r] [-fg color]
        [-bg color] [-p cursor_file mask_file] [-s nnxmm] [cursor]
.fi
.SH DESCRIPTION
.I Xcursor
allows the cursor for a window to be set to one of the standard X
cursors, a user supplied bitmap or lists the available cursors. If no
window id or name is specified,
.I xcursor
will prompt the user to selct a window with the pointer. If no cursor
name is given, the default cursor selected at the time
.I xcursor 
was built will be used. Cursors are extracted from the file
cursorfont.h. Both foreground and background colors may be specified.
.SH OPTIONS
.nf
\-l 		This causes a list of the standard X cursors to be
		given on standard output.

\-v		Prints the version number.

\-id		Denotes that the next option is the window id of the
		window whose cursor will be effected. May be entered
		in decimal, octal or hexadecimal.

\-display       Denotes that the named display should be used.

\-name          Denotes that named window should be operated on.

\-r             Selects the root window.

\-fg            Selects the cursor's foreground color. The 
                default is black.

\-bg            Selects the cursor's background color. The 
                default is white.

\-p             The next two items are the names of the cursor bitmap
                file and the mask bitmap file. The hot spot for the
                cursor is taken from the cursor file.

\-s             This returns the results of querying the X server for
                best cursor size match. The size is specified as width
                x height.
.fi
.SH FILES
Requires read access to the cursorfonts.h file (located in the X
includes path).
.SH BUGS AND WARNINGS
Not all windows will allow their cursor to be reset in this fashion
and some will only function with one of the methods. Since the hot
spot location is taken from the cursor bitmap file, cursors may not
"point" as exspected.
.SH AUTHOR
.nf
Richard Neitzel
National Center for Atmospheric Research
Box 3000
Boulder, CO 80307
thor@thor.atd.ucar.edu
.fi
The selection of named windows and pointing to windows was stolen from
code by Mark Lillibridge.
