/*
  Module: xcursor.h
  Author: Richard Neitzel
  Date:   12 May 1989

revision history
----------------
1.0,12may89,rekn      Written.
2.0,25may89,rekn      Added support for named windows and selection by 
                      pointer.
3.0,8june89,rekn      Added color and bitmap support.
4.0,14apr93,rekn      Made path name a define.
4.1,21apr93,rekn      Added the -s option.
*/
#ifndef INCxcursor
#define INCxcursor

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>

Display *display;
Window window;
int screen;

#ifndef CURSORFILE
char cursor_file[] = "/usr/include/X11/cursorfont.h";
#else
char cursor_file[] = CURSORFILE;
#endif

char default_cursor[] = "XC_gumby";

char version_number[] = "4.1";

char *find_cursor;

int lflg = 0;

int wflg = 0;

char *bcolor = 0;
char *fcolor = 0;

char *source = 0;
char *mask = 0;

XColor bg;
XColor fg;

#define BUFSIZE 100

void print_vers(), local_help(), work(), setCursorColor(), pixCursor(),
bestSize();
Window window_by_name(), point_to_window();

#endif
