#ifndef _PREVIEW_H_
#define _PREVIEW_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

/*
 *  Type declarations:
 */

enum PreviewStates 
{ 
	PREVIEW_LEVEL, 
	PREVIEW_TEXT, 
	PREVIEW_WAIT, 
	PREVIEW_FINISH 
};

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void SetUpPreviewLevel(Display *display, Window window, Colormap colormap);
void PreviewLevel(Display *display, Window window);
void RedrawPreviewLevel(Display *display, Window window);
void FreePreviewLevel(Display *display);
void ResetPreviewLevel(void);
#else
void SetUpPreviewLevel();
void PreviewLevel();
void RedrawPreviewLevel();
void FreePreviewLevel();
void ResetPreviewLevel();
#endif

extern 	enum PreviewStates PreviewState;


#endif
