#ifndef _MISC_H_
#define _MISC_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

#define ms_sleep(ms)                \
{                                   \
    struct timeval tv;              \
    tv.tv_sec=((ms)/1000);          \
    tv.tv_usec=(((ms)%1000)*1000);  \
    select(1,NULL,NULL,NULL,&tv);   \
}

/*
 *  Type declarations:
 */

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void DrawText(Display *display, Window window, int x, int y, XFontStruct *font,
	int colour, char *text, int numChar);
void DrawTextFast(Display *display, Window window, int x, int y, 
	XFontStruct *font, int colour, char *text, int numChar);
void DrawLine(Display *display, Window window, int x, int y, int x2, int y2,
	int colour, int width);
void RenderShape(Display *display, Window window, Pixmap pixmap,
	Pixmap mask, int x, int y, int w, int h, int clear);
void DrawShadowCentredText(Display *display, Window window, XFontStruct *font,
	char *string, int y, int colour, int width);
void DrawShadowText(Display *display, Window window, XFontStruct *font,
	char *string, int x, int y, int colour);
int ColourNameToPixel(Display *display, Colormap colormap, char *colourName);
void FreeMisc(Display *display);
char *getUsersFullName(void);
char *GetHomeDir(void);
int ResizeMainWindow(Display *display, Window window, int width, int height);
int ObtainWindowWidthHeight(Display *display, Window window,
	int *width, int *height);
void sleepSync(Display *display, unsigned long ms);
int ObtainMousePosition(Display *display, Window window, int *x, int *y);
int YesNoDialogue(Display *display, char *message);
#else
int YesNoDialogue();
int ObtainMousePosition();
void sleepSync();
int ObtainWindowWidthHeight();
int ResizeMainWindow();
char *GetHomeDir();
char *getUsersFullName();
void FreeMisc();
int ColourNameToPixel();
void DrawText();
void DrawTextFast();
void DrawLine();
void RenderShape();
void DrawShadowCentredText();
void DrawShadowText();
#endif

#endif
