#ifndef _KEYSEDIT_H_
#define _KEYSEDIT_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

/*
 *  Type declarations:
 */

enum KeysEditStates 
{ 
	KEYSEDIT_TITLE, 
	KEYSEDIT_TEXT, 
	KEYSEDIT_SPARKLE, 
	KEYSEDIT_WAIT, 
	KEYSEDIT_FINISH 
};

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void SetUpKeysEdit(Display *display, Window window, Colormap colormap);
void KeysEdit(Display *display, Window window);
void RedrawKeysEdit(Display *display, Window window);
void FreeKeyEditControl(Display *display);
void ResetKeysEdit(void);
#else
void SetUpKeysEdit();
void KeysEdit();
void RedrawKeysEdit();
void FreeKeyEditControl();
void ResetKeysEdit();
#endif

extern enum KeysEditStates KeysEditState;

#endif
