#ifndef _FILE_H_
#define _FILE_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <stdio.h>
#include <time.h>

/*
 *  Constants and macros:
 */

#define SAVE_VERSION 	2

/*
 *  Type declarations:
 */

typedef struct
{
	u_long 	version;	/* Version of save game format */
    u_long  score;      /* Score so far */
    u_long  level;      /* level number */
	int		levelTime;	/* Time left for level */
    time_t  gameTime;   /* Time taken to complete game so far */
	int		livesLeft;	/* Number of lives left */
	int		startLevel;	/* Level game started on */
	int		paddleSize;	/* The current paddle size */
	int 	numBullets;	/* Number of bullets in store */
} saveGameStruct;

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
int ReadNextLevel(Display *display, Window window, char *levelName, int draw);
void SetupStage(Display *display, Window window);
int SaveLevelDataFile(Display *display, char *levelName);
int SaveCurrentGame(Display *display, Window window);
int LoadSavedGame(Display *display, Window window);
#else
int SaveLevelDataFile();
int SaveCurrentGame();
int LoadSavedGame();
void SetupStage();
int ReadNextLevel();
#endif

#endif
