#ifndef _EYEDUDE_H_
#define _EYEDUDE_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

#define EYEDUDE_WIDTH       32
#define EYEDUDE_HEIGHT      32
#define EYEDUDE_WC          (EYEDUDE_WIDTH / 2)
#define EYEDUDE_HC          (EYEDUDE_HEIGHT / 2)

#define EYEDUDE_FRAME_RATE  30

#define WALK_LEFT           1
#define WALK_RIGHT          2
#define WALK_DEAD          	3

#define EYEDUDE_HIT_BONUS	10000

/*
 *  Type declarations:
 */

typedef enum EyeDudeStates
{
	EYEDUDE_RESET,
	EYEDUDE_WAIT,
	EYEDUDE_NONE,
	EYEDUDE_DIE,
	EYEDUDE_WALK,
	EYEDUDE_TURN
} eyeDudeStates;

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void InitialiseEyeDudes(Display *display, Window window, Colormap colormap);
void FreeEyeDudes(Display *display);
void HandleEyeDudeMode(Display *display, Window window);
void ChangeEyeDudeMode(eyeDudeStates state);
eyeDudeStates getEyeDudeMode(void);
void GetEyeDudePosition(int *x, int *y);
int CheckBallEyeDudeCollision(Display *display, Window window, int j);
#else
int CheckBallEyeDudeCollision();
void GetEyeDudePosition();
eyeDudeStates getEyeDudeMode();
void InitialiseEyeDudes();
void FreeEyeDudes();
void HandleEyeDudeMode();
void ChangeEyeDudeMode();
#endif

#endif
