#ifndef _EDITOR_H_
#define _EDITOR_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

#define EDITOR_TOOL_WIDTH 	120

/*
 *  Type declarations:
 */

enum EditStates 
{ 
	EDIT_LEVEL, 
	EDIT_NONE, 
	EDIT_TEST, 
	EDIT_WAIT, 
	EDIT_FINISH 
};

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void SetUpEditor(Display *display, Window window, Colormap colormap);
void Editor(Display *display, Window window);
void RedrawEditor(Display *display, Window window);
void FreeEditor(Display *display);
void ResetEditor(void);
void handleEditorKeys(Display *display, KeySym keysym);
void HandleEditorMouseButtons(Display *display, XEvent event, int Down);
void HandleButtonMotion(Display *display, XEvent event);
#else
void HandleButtonMotion();
void HandleEditorMouseButtons();
void handleEditorKeys();
void SetUpEditor();
void Editor();
void RedrawEditor();
void FreeEditor();
void ResetEditor();
#endif

extern 	enum EditStates EditState;


#endif
