#ifndef _DIALOGUE_H_
#define _DIALOGUE_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

#define DIALOGUE_WIDTH 		((int) (PLAY_WIDTH / 1.3))
#define DIALOGUE_HEIGHT 	120

#define DISK_ICON			1
#define TEXT_ICON			2

#define TEXT_ENTRY_ONLY		1
#define NUMERIC_ENTRY_ONLY	2
#define ALL_ENTRY			3
#define YES_NO_ENTRY		4

/*
 *  Type declarations:
 */

enum DialogueStates
{
    DIALOGUE_MAP,
    DIALOGUE_UNMAP,
    DIALOGUE_TEXT,
    DIALOGUE_NONE,
    DIALOGUE_FINISHED
};

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void ProcessDialogue(Display *display);
void handleDialogueKeys(Display *display, XEvent event);
char *UserInputDialogueMessage(Display *display, char *message, int type,
	int entryValidation);
void FreeDialoguePixmaps(Display *display);
void InitialiseDialoguePixmaps(Display *display, Window window, 
		Colormap colormap);
#else
void FreeDialoguePixmaps();
void InitialiseDialoguePixmaps();
char *UserInputDialogueMessage();
void ProcessDialogue();
void handleDialogueKeys();
#endif

extern Pixmap question, questionM;
extern Pixmap floppy, floppyM;
extern Pixmap text, textM;

#endif
