/*
 * Programm XBLAST V1.00 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * January 2nd 1994
 * started August 1993
 *
 * File: blastincl.h
 * constants and macros for all files.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 1; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

  /* constants */


#define MAX_PLAYER 4
#define MAX_PS 4

#define LEVEL_MAX 10


#define MAX_ANIME 16
#define WINNER_ANIME 15


#define STEP_HORI 8
#define STEP_VERT 6
#define DEFAULT_DELAY 5


#define MAX_EXPLOSION 18



#define SIZE_OF_SPRITE 414
#define SIZE_OF_WINNER 552
#define SIZE_OF_BLOCK  384
#define SIZE_OF_LED 32
#define SIZE_OF_BIG 2016

#define SIZE_OF_X 16


#define BLOCK_WIDTH 64 
#define BLOCK_HEIGHT 48
#define CHARW 3
#define CHARH 5
#define CHAR_ANIME 7

#define MAZE_W 15
#define MAZE_H 13

#if 0
#define MAZE_X (MAZE_W-2)
#define MAZE_Y (MAZE_H-2)
#endif


#define SPRITE_UP    ( 0 )
#define SPRITE_DOWN  (PIXH - 3 *BLOCK_HEIGHT)
#define SPRITE_LEFT   BLOCK_WIDTH
#define SPRITE_RIGHT (PIXW - 2 * BLOCK_WIDTH)

  /* Blocktypen */


#define BTFree      0
#define BTShadow    1
#define BTBlock     2
#define BTExtra     3
#define BTExtraOpen 4
#define BTBomb      5
#define BTRange     6
#define BTSick      7
#define BTSpecial   8
#define BTEvil      9 /* No Real Block, */

#define MAX_BLOCK 9

#define Healthy 0
#define IllBomb 1
#define IllSlow 2
#define IllRun 3
#define IllMini 4
#define IllEmpty 5
#define MAX_ILL 5


#define ILL_X 32
#define ILL_Y 32
#define ILLTIME 256
#define BOMB_PROB 32

  /* Scorebitmaps */

#define SBVoid      0
#define SBTextLeft  1
#define SBTextMid   2
#define SBTextRight 3
#define SBDead      4
#define SBSick      8
#define SBPlayer    12
#define SBLives     (SBPlayer + MAX_PLAYER)

#define MAX_SCORE_TILES (SBLives + 1)

  /* Blockbitmaps */

#define BLKaroLight      0
#define BLKaroDark       1
#define BLPyramid        2
#define BLWall           3
#define BLExtra          4
#define BLRange          5
#define BLBomb           6
#define BLChest          7
#define BLTrap           8
#define BLHex            9
#define BLHexExtra       10
#define BLHexWall        11
#define BLLegoFloor      12
#define BLLegoWhite      13
#define BLLegoBlack      14
#define BLScoreRightUp   15
#define BLScoreRightDown 16
#define BLScoreMidUp     17
#define BLScoreMidDown   18
#define BLScoreLeftUp    19
#define BLScoreLeftDown  20
#define BLBricks         20
#define BLScoreFloor     21
#define BLIronFloor      22
#define BLDarkBlock      23
#define BLDarkHouse      24
#define BLLightHouse     25
#define BLCityFree       26
#define BLControlNum     27
#define BLControlAlpha   28
#define BLDisplay        29
#define BLSphereLight    30
#define BLSphereDark     31
#define BLSphereHalf     32
#define BLInvincible     33
#define BLTemple         34
#define BLRemoteControl  35
#define BLBookShelf      36
#define BLChessFloor     37
#define BLChessSphere    38
#define BLPumpkin        39
#define BLRIP            40
#define BLDarkWay        41
#define BLKaroLight_S    42
#define BLExtra_O        43
#define BLKaroDark_S     44
#define BLChest_O        45
#define BLIronFloor_S    46
#define BLBricks_O       47
#define BLSphereHalf_S   48
#define BLSphereLight_O  49
#define BLHexExtra_O     50
#define BLChessFloor_S   51
#define BLChessSphere_O  52
#define BLLegoFloor_S    53
#define BLLegoBlack_O    54
#define BLCityFree_S     55
#define BLLightHouse_O   56
#define BLDarkWay_S      57
#define BLPumpkin_O      58
#define MAX_BLOCK_TILES  59

#define MAX_EXTRA   2

  /* SpriteTypen */

#define STPlayer 0
#define STExplosion 1

  /* ExitMasks fuer wait_event */

#define EMKey    (01<<0)
#define EMExpose (01<<1)

  /* Walk-Directions */

#define GoStop (-1)
#define GoUp    0
#define GoLeft  1
#define GoDown  2
#define GoRight 3

  /* extras */

#define EXNone 0




  /* Makros */



#define MAX(a,b) ( (a)>=(b) ? (a) : (b) )
#define MIN(a,b) ( (a)<=(b) ? (a) : (b) )
#define ABS(a)   ( (a)>=0 ? (a) : (-(a)) )









