/*
 * Programm XBLAST V1.00 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * January 2nd 1994
 * started August 1993
 *
 * File: blastblock.c
 * bitmap data of blocks
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 1; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "blastincl.h"

/* block bitmaps fuer bakcground */

unsigned char block_tile[MAX_BLOCK_TILES][SIZE_OF_BLOCK] = 
{
  {
    /* karo light */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x75, 0x5c, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x1d, 0x71, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x02, 0xc0, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xc0, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x55, 0x55, 0x35, 0x11, 0x11, 0x5d, 0x55, 0x55, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x55, 0x55, 0x4d, 0x44, 0x44, 0x64, 0x55, 0x55, 
    0x00, 0x00, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00, 
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 
    0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
    0x55, 0x75, 0x44, 0x44, 0x44, 0x44, 0x5c, 0x55, 
    0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x55, 0x1d, 0x11, 0x11, 0x11, 0x11, 0x71, 0x55, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 
    0x55, 0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55, 
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x35, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x5d, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x4d, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x64, 
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x4d, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x64, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x75, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x59, 
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x55, 0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55, 
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0x55, 0x1d, 0x11, 0x11, 0x11, 0x11, 0x71, 0x55, 
    0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x55, 0x75, 0x44, 0x44, 0x44, 0x44, 0x5c, 0x55, 
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 
    0x00, 0x00, 0x06, 0x00, 0x00, 0x80, 0x00, 0x00, 
    0x55, 0x55, 0x4d, 0x44, 0x44, 0x64, 0x55, 0x55, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x55, 0x55, 0x75, 0x11, 0x11, 0x59, 0x55, 0x55, 
    0x00, 0x00, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x06, 0x80, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x1d, 0x71, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x75, 0x5c, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x80, 0x06, 0x00, 0x00, 0x00}, 
  
  
  {
    /* kara dark */
    0x00, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x00, 
    0x44, 0x44, 0x44, 0x64, 0x4d, 0x44, 0x44, 0x44, 
    0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x11, 0x11, 0x11, 0x5d, 0x35, 0x11, 0x11, 0x11, 
    0x00, 0x00, 0x00, 0x02, 0xc0, 0x00, 0x00, 0x00, 
    0x44, 0x44, 0x44, 0x55, 0x55, 0x45, 0x44, 0x44, 
    0x00, 0x00, 0xc0, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x11, 0x11, 0x71, 0x55, 0x55, 0x1d, 0x11, 0x11, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x44, 0x44, 0x5c, 0x55, 0x55, 0x75, 0x44, 0x44, 
    0x00, 0x00, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00, 
    0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 0x11, 0x11, 
    0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
    0x44, 0x64, 0x55, 0x55, 0x55, 0x55, 0x4d, 0x44, 
    0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x11, 0x5d, 0x55, 0x55, 0x55, 0x55, 0x35, 0x11, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 
    0x44, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45, 
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x71, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x1d, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x5c, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x5c, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x71, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x1d, 
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x44, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45, 
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0x11, 0x59, 0x55, 0x55, 0x55, 0x55, 0x75, 0x11, 
    0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x44, 0x64, 0x55, 0x55, 0x55, 0x55, 0x4d, 0x44, 
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
    0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 0x11, 0x11, 
    0x00, 0x00, 0x06, 0x00, 0x00, 0x80, 0x00, 0x00, 
    0x44, 0x44, 0x5c, 0x55, 0x55, 0x75, 0x44, 0x44, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x11, 0x11, 0x71, 0x55, 0x55, 0x1d, 0x11, 0x11, 
    0x00, 0x00, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 
    0x44, 0x44, 0x44, 0x55, 0x55, 0x45, 0x44, 0x44, 
    0x00, 0x00, 0x00, 0x06, 0x80, 0x00, 0x00, 0x00, 
    0x11, 0x11, 0x11, 0x59, 0x75, 0x11, 0x11, 0x11, 
    0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x44, 0x44, 0x44, 0x64, 0x4d, 0x44, 0x44, 0x44, 
    0x00, 0x00, 0x00, 0x80, 0x06, 0x00, 0x00, 0x00, 
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11}, 
  
  {
    /* pyramid */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 
    0xc5, 0x57, 0x55, 0x55, 0x55, 0x55, 0xd5, 0xd7, 
    0x01, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xaa, 
    0x11, 0xd1, 0x57, 0x55, 0x55, 0xd5, 0x57, 0xd5, 
    0x01, 0x00, 0x3c, 0x00, 0x00, 0xbc, 0xaa, 0xaa, 
    0x45, 0x44, 0xc4, 0x57, 0xd5, 0x57, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x3c, 0xbc, 0xaa, 0xaa, 0xaa, 
    0x11, 0x11, 0x11, 0xd1, 0x57, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x40, 0xac, 0xaa, 0xaa, 0xaa, 
    0x11, 0x11, 0x11, 0x71, 0x5d, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x10, 0xb0, 0xaa, 0xaa, 0xaa, 
    0x45, 0x44, 0x44, 0x5c, 0x75, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x04, 0xc0, 0xaa, 0xaa, 0xaa, 
    0x11, 0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x02, 0x80, 0xaa, 0xaa, 0xaa, 
    0x45, 0x44, 0x44, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x80, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 
    0x11, 0x11, 0x51, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x40, 0x00, 0x00, 0xac, 0xaa, 0xaa, 
    0x45, 0x44, 0x64, 0x55, 0x55, 0x5d, 0x55, 0xd5, 
    0x01, 0x00, 0x10, 0x00, 0x00, 0xb0, 0xaa, 0xaa, 
    0x11, 0x11, 0x59, 0x55, 0x55, 0x75, 0x55, 0xd5, 
    0x01, 0x00, 0x04, 0x00, 0x00, 0xc0, 0xaa, 0xaa, 
    0x45, 0x44, 0x54, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x02, 0x00, 0x00, 0x80, 0xaa, 0xaa, 
    0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 
    0x45, 0x44, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0xac, 0xaa, 
    0x11, 0x71, 0x55, 0x55, 0x55, 0x55, 0x5d, 0xd5, 
    0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xaa, 
    0x45, 0x5c, 0x55, 0x55, 0x55, 0x55, 0x75, 0xd5, 
    0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xaa, 
    0x11, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x80, 0xaa, 
    0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 
    0x51, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 
    0x65, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdd, 
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x59, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  {
    /* wall */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x45, 0x44, 0x45, 0x44, 0x45, 0x44, 0x45, 0xc4, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x91, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x45, 0x44, 0x45, 0x44, 0x45, 0x44, 0x45, 0xc4, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x45, 0x44, 0x45, 0x44, 0x55, 0x55, 0x45, 0xc4, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 0x11, 0x91, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x45, 0x44, 0x45, 0x44, 0x55, 0x55, 0x45, 0xc4, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x01, 0x00, 0xab, 0xaa, 0x01, 0x00, 0x81, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  
  
  {
    /* ?-Block */
    /* Bitmap x=128 y=0 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdd, 
    0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 
    0x91, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 
    0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0xfc, 0x5f, 0x44, 0xc4, 0xd5, 
    0x01, 0x01, 0x00, 0x04, 0x20, 0x00, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0xf3, 0x4f, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0xf9, 0x9f, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0xc4, 0xfc, 0x3f, 0x45, 0xc4, 0xd5, 
    0x01, 0x01, 0x80, 0xfe, 0x7f, 0x01, 0x80, 0xaa, 
    0x11, 0x11, 0x91, 0x7e, 0x7e, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x80, 0x3e, 0x7c, 0x01, 0x80, 0xaa, 
    0x45, 0x45, 0xc4, 0x9e, 0x7c, 0x45, 0xc4, 0xd5, 
    0x01, 0x01, 0x80, 0x4c, 0x7e, 0x01, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0x61, 0x7f, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0x3e, 0x3f, 0x01, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0xa4, 0x9f, 0x44, 0xc4, 0xd5, 
    0x01, 0x01, 0x00, 0x90, 0x5f, 0x00, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0xd1, 0x4f, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0xd0, 0x2f, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0xd4, 0x67, 0x44, 0xc4, 0xd5, 
    0x01, 0x01, 0x00, 0xd0, 0x17, 0x00, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0xd1, 0x17, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0x90, 0x13, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0x24, 0x48, 0x44, 0xc4, 0xd5, 
    0x01, 0x01, 0x00, 0x90, 0x13, 0x00, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0xd1, 0x17, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0xd0, 0x17, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0xd4, 0x57, 0x44, 0xc4, 0xd5, 
    0x01, 0x01, 0x00, 0x90, 0x13, 0x00, 0x80, 0xaa, 
    0x11, 0x11, 0x11, 0x31, 0x18, 0x11, 0x91, 0xd5, 
    0x01, 0x01, 0x00, 0xc0, 0x07, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x44, 0x44, 0x44, 0x44, 0xc4, 0xd5, 
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 
    0x91, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xab, 
    0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd7, 
    0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 
    0x71, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdd, 
    0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  /* Extra Range */
  {
    /* Bitmap x=128 y=96 w=64 h=48 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x57, 0xd7, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xed, 0x6a, 0xab, 0x0a, 
    0x50, 0x55, 0x55, 0x75, 0x75, 0x5b, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x1a, 0x0c, 0x06, 0xab, 0x0a, 
    0x50, 0x55, 0x55, 0x57, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x01, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x51, 0x55, 0x05, 
    0xa0, 0xaa, 0x2a, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x55, 0x45, 0x44, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x1a, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x5d, 0x11, 0x11, 0x51, 0x55, 0x05, 
    0xa0, 0xaa, 0x06, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x55, 0x04, 0x00, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x06, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x17, 0x01, 0x00, 0x50, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x57, 0x00, 0x00, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0x00, 0xab, 0x0a, 
    0x50, 0x55, 0x15, 0x00, 0x00, 0x50, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0x80, 0xaa, 0x0a, 
    0x50, 0x55, 0x57, 0x00, 0x00, 0xd4, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0x80, 0xaa, 0x0a, 
    0x50, 0x55, 0x17, 0x01, 0x00, 0xd1, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0xc0, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x04, 0x40, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x06, 0x00, 0x00, 0xc0, 0xaa, 0x0a, 
    0x50, 0x55, 0x5d, 0x11, 0x10, 0x75, 0x55, 0x05, 
    0xa0, 0xaa, 0x0a, 0x00, 0x00, 0xb0, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0x2a, 0x00, 0x00, 0xa8, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x01, 0x00, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x5f, 0xd5, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xfa, 0xbe, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, 
  
  /* Extra Bombe */
  {
    /* Bitmap x=128 y=48 w=64 h=48 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x51, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x05, 0x50, 0x4c, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xf0, 0x23, 0x8e, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0xfc, 0x0f, 0x47, 0x55, 0x05, 
    0xa0, 0xaa, 0x2a, 0xff, 0xbf, 0xa3, 0xaa, 0x0a, 
    0x50, 0x55, 0x95, 0xff, 0xdf, 0x51, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xf9, 0xef, 0xa8, 0xaa, 0x0a, 
    0x50, 0x55, 0xe5, 0xf0, 0x6f, 0x51, 0x55, 0x05, 
    0xa0, 0xaa, 0x62, 0xf0, 0x9f, 0xa9, 0xaa, 0x0a, 
    0x50, 0x55, 0x75, 0xf8, 0xff, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xf2, 0xfc, 0xff, 0xa3, 0xaa, 0x0a, 
    0x50, 0x55, 0xf9, 0xff, 0xff, 0x57, 0x55, 0x05, 
    0xa0, 0xaa, 0xfa, 0xff, 0xff, 0xa7, 0xaa, 0x0a, 
    0x50, 0x55, 0xf9, 0xff, 0xff, 0x57, 0x55, 0x05, 
    0xa0, 0xaa, 0xfa, 0xff, 0xff, 0xa7, 0xaa, 0x0a, 
    0x50, 0x55, 0xf9, 0xff, 0xff, 0x57, 0x55, 0x05, 
    0xa0, 0xaa, 0xf2, 0xff, 0xff, 0xa3, 0xaa, 0x0a, 
    0x50, 0x55, 0xf5, 0xff, 0xff, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xe2, 0xff, 0xff, 0xa9, 0xaa, 0x0a, 
    0x50, 0x55, 0xe5, 0xff, 0xff, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xff, 0xff, 0xa8, 0xaa, 0x0a, 
    0x50, 0x55, 0x95, 0xff, 0x7f, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x2a, 0xff, 0x3f, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0xfc, 0x0f, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xf0, 0xa3, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x05, 0x50, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* Chest */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0xb5, 0x6a, 0x55, 0x55, 0x55, 0x55, 0xab, 0xd6, 
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0x31, 0x62, 0x11, 0x11, 0x11, 0x11, 0x23, 0x96, 
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0xa5, 0x48, 0x44, 0x44, 0x44, 0x44, 0x8a, 0xc4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x31, 0x40, 0x11, 0x11, 0x11, 0x11, 0x03, 0x94, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x25, 0x40, 0x44, 0x44, 0x44, 0x44, 0x02, 0xc4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x31, 0x40, 0x11, 0x11, 0x11, 0x11, 0x03, 0x94, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x25, 0x40, 0x44, 0x44, 0x44, 0x44, 0x02, 0xc4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x31, 0x40, 0x11, 0x11, 0x11, 0x11, 0x03, 0x94, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0x35, 0x40, 0x55, 0x55, 0x55, 0x55, 0x03, 0xd4, 
    0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x84, 
    0xa5, 0x48, 0x44, 0x44, 0x44, 0x44, 0x8a, 0xc4, 
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0x31, 0x62, 0x11, 0x11, 0x11, 0x11, 0x23, 0x96, 
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0xbf, 0xc8, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xfc, 
    0x21, 0x40, 0x00, 0x02, 0x40, 0x00, 0x02, 0x84, 
    0xb5, 0x6a, 0x55, 0x03, 0x40, 0x55, 0xab, 0xd6, 
    0x21, 0x40, 0x00, 0xe2, 0x47, 0x00, 0x02, 0x84, 
    0xb5, 0x6a, 0x55, 0x73, 0x4e, 0x55, 0xab, 0xd6, 
    0x21, 0x40, 0x00, 0x02, 0x4e, 0x00, 0x02, 0x84, 
    0xbf, 0xea, 0xff, 0x83, 0xc7, 0xff, 0xab, 0xfe, 
    0x2b, 0xc0, 0xaa, 0xc2, 0xc3, 0xaa, 0x02, 0xac, 
    0xb5, 0x6a, 0x55, 0x03, 0x40, 0x55, 0xab, 0xd6, 
    0x2b, 0xc0, 0xaa, 0xc2, 0xc3, 0xaa, 0x02, 0xac, 
    0xb5, 0x6a, 0x55, 0x03, 0x40, 0x55, 0xab, 0xd6, 
    0x2b, 0xc0, 0xaa, 0xfe, 0xff, 0xaa, 0x02, 0xac, 
    0xb5, 0x6a, 0x55, 0x55, 0x55, 0x55, 0xab, 0xd6, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff} ,
  
  /* Extra Trap */
  {
    /* Bitmap x=128 y=144 w=64 h=48 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xfe, 0xff, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x03, 0x80, 0x57, 0x55, 0x05, 
    0xa0, 0xaa, 0x7a, 0x00, 0x00, 0xbc, 0xaa, 0x0a, 
    0x50, 0x55, 0x1d, 0x00, 0x00, 0x70, 0x55, 0x05, 
    0xa0, 0xaa, 0x0e, 0x00, 0x00, 0xe0, 0xaa, 0x0a, 
    0x50, 0x55, 0x05, 0x00, 0x00, 0x40, 0x55, 0x05, 
    0xa0, 0xaa, 0x06, 0x00, 0x00, 0xc0, 0xaa, 0x0a, 
    0x50, 0x55, 0x03, 0x00, 0x00, 0x80, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x00, 0x00, 0x80, 0xaa, 0x0a, 
    0x50, 0x55, 0x03, 0x00, 0x00, 0x80, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x3c, 0x78, 0x80, 0xaa, 0x0a, 
    0x50, 0x55, 0x03, 0x7e, 0xfc, 0x80, 0x55, 0x05, 
    0xa0, 0xaa, 0x02, 0x7e, 0xfc, 0x80, 0xaa, 0x0a, 
    0x50, 0x55, 0x03, 0x7e, 0xfc, 0x80, 0x55, 0x05, 
    0xa0, 0xaa, 0x06, 0x7e, 0xfc, 0xc0, 0xaa, 0x0a, 
    0x50, 0x55, 0x05, 0x7e, 0xfc, 0x40, 0x55, 0x05, 
    0xa0, 0xaa, 0x0e, 0x7e, 0xfc, 0xe0, 0xaa, 0x0a, 
    0x50, 0x55, 0x0d, 0x7e, 0xfc, 0x60, 0x55, 0x05, 
    0xa0, 0xaa, 0x1a, 0x7e, 0xfc, 0xb0, 0xaa, 0x0a, 
    0x50, 0x55, 0x35, 0x3c, 0x78, 0x58, 0x55, 0x05, 
    0xa0, 0xaa, 0x2a, 0x00, 0x00, 0xac, 0xaa, 0x0a, 
    0x50, 0x55, 0x75, 0x00, 0x00, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0xea, 0x00, 0x00, 0xae, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0xa9, 0x2a, 0x57, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xa9, 0x2a, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x03, 0x80, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xfe, 0xff, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* Hex */
    /* Bitmap x=256 y=144 w=64 h=48 */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0xd5, 
    0x06, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0x60, 
    0x5d, 0x55, 0x55, 0x5d, 0x5d, 0x55, 0x55, 0x5d, 
    0x60, 0x00, 0x00, 0xae, 0x6a, 0x00, 0x00, 0x06, 
    0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 
    0x00, 0x06, 0xe0, 0xaa, 0xaa, 0x06, 0x60, 0x00, 
    0x55, 0x5d, 0x5d, 0x55, 0x55, 0x5d, 0x5d, 0x55, 
    0x00, 0x60, 0xae, 0xaa, 0xaa, 0x6a, 0x06, 0x00, 
    0x55, 0xd5, 0x55, 0x55, 0x55, 0xd5, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0xab, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0x55, 0x55, 
    0x00, 0xc0, 0xae, 0xaa, 0xaa, 0x6a, 0x06, 0x00, 
    0x55, 0x75, 0x5d, 0x55, 0x55, 0x5d, 0x5d, 0x55, 
    0x00, 0x0c, 0xe0, 0xaa, 0xaa, 0x06, 0x60, 0x00, 
    0x55, 0x57, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 
    0xc0, 0x00, 0x00, 0xae, 0x6a, 0x00, 0x00, 0x06, 
    0x75, 0x55, 0x55, 0x5d, 0x5d, 0x55, 0x55, 0x5d, 
    0x0c, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0x60, 
    0x57, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00}, 
  
#if 0  
  {
    /* Bitmap x=256 y=192 w=64 h=48 */
    0x55, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x7d, 0x5c, 0x55, 0x55, 0x55, 
    0x01, 0x04, 0x00, 0x0e, 0x60, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0xd5, 0x13, 0x91, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0xe0, 0x00, 0x00, 0x06, 0x00, 0x00, 
    0x55, 0x55, 0x7d, 0x44, 0x44, 0x5c, 0x55, 0x55, 
    0x01, 0x00, 0x0e, 0xe0, 0x1f, 0x60, 0x00, 0x00, 
    0x55, 0xd5, 0x13, 0x11, 0x20, 0x91, 0x55, 0xd5, 
    0x06, 0x60, 0x01, 0xe8, 0x5f, 0x00, 0x07, 0x60, 
    0x5d, 0x1d, 0x45, 0xf4, 0xbf, 0x44, 0x5d, 0x5d, 
    0x60, 0x06, 0x01, 0x7a, 0x78, 0x01, 0x6b, 0x06, 
    0xd5, 0x01, 0x11, 0xbd, 0xf7, 0x12, 0xd5, 0x55, 
    0x00, 0x01, 0x01, 0x5a, 0xec, 0x02, 0xab, 0x01, 
    0x55, 0x01, 0x45, 0x64, 0xf3, 0x46, 0x55, 0x55, 
    0x00, 0x01, 0x01, 0x98, 0x7c, 0x01, 0xab, 0x01, 
    0x55, 0x01, 0x11, 0x51, 0x9f, 0x11, 0x55, 0x55, 
    0x00, 0x01, 0x01, 0xa0, 0x67, 0x00, 0xab, 0x01, 
    0x55, 0x01, 0x45, 0xa4, 0x5b, 0x44, 0x55, 0x55, 
    0x00, 0x01, 0x01, 0xa0, 0x0b, 0x00, 0xab, 0x01, 
    0x55, 0x01, 0x11, 0xb1, 0x1b, 0x11, 0x55, 0x55, 
    0x00, 0x01, 0x01, 0xa0, 0x0b, 0x00, 0xab, 0x01, 
    0x55, 0x01, 0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 
    0x00, 0x01, 0x01, 0xa0, 0x0b, 0x00, 0xab, 0x01, 
    0x55, 0x01, 0x13, 0xb1, 0x1b, 0x11, 0x55, 0x55, 
    0x00, 0x81, 0x0c, 0xa0, 0x0b, 0xc0, 0xaa, 0x01, 
    0x55, 0x81, 0x74, 0x44, 0x44, 0x74, 0x57, 0x55, 
    0x00, 0x41, 0xc0, 0x80, 0x03, 0x0c, 0xac, 0x01, 
    0x55, 0x21, 0x11, 0x13, 0x11, 0x57, 0x5d, 0x55, 
    0x00, 0x21, 0x00, 0x0c, 0xc0, 0x00, 0xa8, 0x01, 
    0x55, 0x51, 0x44, 0x74, 0x74, 0x55, 0x55, 0x55, 
    0x00, 0x09, 0x00, 0xc0, 0x0c, 0x00, 0xa0, 0x01, 
    0x55, 0x19, 0x11, 0x11, 0x57, 0x55, 0x75, 0x55, 
    0x00, 0x05, 0x00, 0x00, 0x01, 0x00, 0xc0, 0x01, 
    0x55, 0x47, 0x44, 0x44, 0x55, 0x55, 0xd5, 0x55, 
    0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x80, 0x01, 
    0x55, 0x13, 0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 
    0xc0, 0x0c, 0x00, 0x00, 0x01, 0x00, 0xc0, 0x06, 
    0x75, 0x75, 0x44, 0x44, 0x55, 0x55, 0x75, 0x5d, 
    0x0c, 0xc0, 0x00, 0x00, 0x01, 0x00, 0x0c, 0x60, 
    0x57, 0x55, 0x13, 0x11, 0x55, 0x55, 0x57, 0xd5, 
    0x01, 0x00, 0x0c, 0x00, 0x01, 0xc0, 0x00, 0x00, 
    0x55, 0x55, 0x75, 0x44, 0x55, 0x75, 0x55, 0x55, 
    0x01, 0x00, 0xc0, 0x00, 0x01, 0x0c, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x13, 0x55, 0x57, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0x0c, 0xc1, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x75, 0x75, 0x55, 0x55, 0x55, 
    0x01, 0x00, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x00}, 
  
#else  
  {
    /* HexExtra */
    /* Bitmap x=256 y=240 w=64 h=48 */
    0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 
    0x01, 0x80, 0x06, 0x00, 0x00, 0xe0, 0x02, 0x00, 
    0x55, 0xd5, 0x5c, 0x55, 0x55, 0x5d, 0x57, 0x55, 
    0x01, 0x40, 0x60, 0x00, 0x00, 0xae, 0x06, 0x00, 
    0x55, 0x35, 0x91, 0x55, 0xd5, 0x55, 0x5d, 0x55, 
    0x01, 0x20, 0x00, 0x06, 0xe0, 0xaa, 0x0a, 0x00, 
    0x55, 0x55, 0x44, 0x5c, 0x5d, 0x55, 0x55, 0x55, 
    0x01, 0x08, 0x00, 0x60, 0xae, 0xaa, 0x2a, 0x00, 
    0x55, 0x1d, 0x11, 0x91, 0x55, 0x55, 0x75, 0xd5, 
    0x06, 0x04, 0x00, 0x60, 0xaf, 0xaa, 0x6a, 0x60, 
    0x5d, 0x47, 0x44, 0x9c, 0x5e, 0x55, 0xd5, 0x5d, 
    0x60, 0x02, 0x00, 0x86, 0xe2, 0xaa, 0xaa, 0x06, 
    0xd5, 0x11, 0x91, 0x41, 0xd5, 0x55, 0x55, 0x55, 
    0x80, 0x00, 0x60, 0x40, 0x04, 0xae, 0xaa, 0x02, 
    0xd5, 0x44, 0x1c, 0x40, 0x54, 0x5d, 0x55, 0x57, 
    0x40, 0x00, 0x06, 0x20, 0x08, 0xe0, 0xaa, 0x06, 
    0x35, 0x91, 0x01, 0x20, 0x59, 0xd5, 0x55, 0x5d, 
    0x20, 0x60, 0x00, 0x10, 0x10, 0x00, 0xae, 0x0a, 
    0x55, 0x1c, 0x00, 0x50, 0x54, 0x55, 0x5d, 0x55, 
    0x08, 0x06, 0x00, 0x10, 0x10, 0x00, 0xe0, 0x2a, 
    0x9d, 0x01, 0x00, 0x18, 0x71, 0x55, 0xd5, 0x75, 
    0x64, 0x00, 0x00, 0x08, 0x20, 0x00, 0x00, 0x6e, 
    0x1f, 0x00, 0x00, 0x44, 0x44, 0x55, 0x55, 0xdd, 
    0x06, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0xe0, 
    0x01, 0x00, 0x00, 0x14, 0x51, 0x55, 0x55, 0xd5, 
    0x02, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x80, 
    0x03, 0x00, 0x00, 0x46, 0xc4, 0x55, 0x55, 0xd5, 
    0x04, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x40, 
    0x0d, 0x00, 0x00, 0x11, 0x11, 0x55, 0x55, 0x75, 
    0x08, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x20, 
    0x15, 0x00, 0x80, 0x44, 0x44, 0x56, 0x55, 0x55, 
    0x20, 0x00, 0x80, 0x00, 0x00, 0x02, 0x00, 0x08, 
    0x35, 0x00, 0x40, 0x11, 0x11, 0x55, 0x55, 0x5d, 
    0x40, 0x00, 0x40, 0x00, 0x00, 0x04, 0x00, 0x04, 
    0xd5, 0x00, 0x40, 0x44, 0x44, 0x54, 0x55, 0x57, 
    0x80, 0x00, 0x20, 0x00, 0x00, 0x08, 0x00, 0x02, 
    0x55, 0x01, 0x20, 0x11, 0x11, 0x59, 0x55, 0x55, 
    0xc0, 0x02, 0x10, 0x00, 0x00, 0x10, 0x80, 0x06, 
    0x75, 0x03, 0x50, 0x44, 0x44, 0x54, 0xd5, 0x5d, 
    0x0c, 0x04, 0x10, 0x00, 0x00, 0x10, 0x40, 0x60, 
    0x57, 0x0d, 0x18, 0x11, 0x11, 0x71, 0x75, 0xd5, 
    0x01, 0x08, 0x08, 0x00, 0x00, 0x20, 0x20, 0x00, 
    0x55, 0x15, 0x44, 0x44, 0x44, 0x44, 0x55, 0x55, 
    0x01, 0x20, 0x04, 0x00, 0x00, 0x40, 0x08, 0x00, 
    0x55, 0x35, 0x14, 0x11, 0x11, 0x51, 0x5d, 0x55, 
    0x01, 0x40, 0x02, 0x00, 0x00, 0x80, 0x04, 0x00, 
    0x55, 0xd5, 0x46, 0x44, 0x44, 0xc4, 0x57, 0x55, 
    0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00}, 
#endif
  
  {
    /* HexWall */
    /* Bitmap x=256 y=288 w=64 h=48 */
    0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 
    0x01, 0x80, 0x56, 0x55, 0x55, 0xf5, 0x03, 0x00, 
    0x55, 0xd5, 0xfd, 0xff, 0xff, 0xff, 0x57, 0x55, 
    0x01, 0xc0, 0x6a, 0x55, 0x55, 0x77, 0x07, 0x00, 
    0x55, 0x75, 0xd5, 0xff, 0xff, 0xff, 0x5f, 0x55, 
    0x01, 0xa0, 0xaa, 0x56, 0xf5, 0xdd, 0x0d, 0x00, 
    0x55, 0x55, 0x55, 0xfd, 0xff, 0xff, 0x5f, 0x55, 
    0x01, 0xa8, 0xaa, 0x6a, 0x77, 0x77, 0x37, 0x00, 
    0x55, 0x5d, 0x55, 0xd5, 0xff, 0xff, 0x7f, 0xd5, 
    0x06, 0xac, 0xaa, 0x6a, 0xdf, 0xdd, 0x5d, 0x60, 
    0x5d, 0x57, 0x55, 0xdd, 0xff, 0xff, 0xff, 0x5d, 
    0x60, 0xaa, 0xaa, 0x86, 0xf6, 0x77, 0xf7, 0x06, 
    0xd5, 0x55, 0xd5, 0x55, 0xfd, 0xff, 0xff, 0x55, 
    0x80, 0xaa, 0x6a, 0xc0, 0x56, 0xdf, 0xdd, 0x03, 
    0xd5, 0x55, 0x5d, 0x55, 0xfd, 0xff, 0xff, 0x57, 
    0xc0, 0xaa, 0x06, 0xa0, 0x5a, 0xf5, 0x77, 0x07, 
    0x75, 0xd5, 0x55, 0x75, 0xfd, 0xff, 0xff, 0x5f, 
    0xa0, 0x6a, 0x00, 0xb0, 0x5a, 0x55, 0xdf, 0x0d, 
    0x55, 0x5d, 0x55, 0x55, 0xf5, 0xff, 0xff, 0x5f, 
    0xa8, 0x06, 0x00, 0xb0, 0x5a, 0x55, 0xf5, 0x37, 
    0xdd, 0x55, 0x55, 0x5d, 0xf5, 0xff, 0xff, 0x7f, 
    0x6c, 0x00, 0x00, 0xa8, 0x6a, 0x55, 0x55, 0x5f, 
    0x5f, 0x55, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0x06, 0x00, 0x00, 0xac, 0x6a, 0x55, 0x55, 0xf5, 
    0x55, 0x55, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0x02, 0x00, 0x00, 0xaa, 0xaa, 0x55, 0x55, 0xd5, 
    0x57, 0x55, 0x55, 0x57, 0xd5, 0xff, 0xff, 0xff, 
    0x04, 0x00, 0x00, 0xab, 0xaa, 0x55, 0x55, 0x55, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0x7f, 
    0x08, 0x00, 0x00, 0xab, 0xaa, 0x55, 0x55, 0x35, 
    0x55, 0x55, 0xd5, 0x55, 0x55, 0xff, 0xff, 0x5f, 
    0x20, 0x00, 0x80, 0xaa, 0xaa, 0x56, 0x55, 0x0d, 
    0x75, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff, 0x5f, 
    0x40, 0x00, 0xc0, 0xaa, 0xaa, 0x56, 0x55, 0x05, 
    0xd5, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff, 0x57, 
    0x80, 0x00, 0xa0, 0xaa, 0xaa, 0x5a, 0x55, 0x03, 
    0x55, 0x55, 0x75, 0x55, 0x55, 0xfd, 0xff, 0x55, 
    0xc0, 0x02, 0xb0, 0xaa, 0xaa, 0x5a, 0xd5, 0x06, 
    0x75, 0x57, 0x55, 0x55, 0x55, 0xf5, 0xff, 0x5d, 
    0x0c, 0x04, 0xb0, 0xaa, 0xaa, 0x5a, 0x55, 0x60, 
    0x57, 0x5d, 0x5d, 0x55, 0x55, 0xf5, 0x7f, 0xd5, 
    0x01, 0x08, 0xa8, 0xaa, 0xaa, 0x6a, 0x35, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0x5f, 0x55, 
    0x01, 0x20, 0xac, 0xaa, 0xaa, 0x6a, 0x0d, 0x00, 
    0x55, 0x75, 0x55, 0x55, 0x55, 0xd5, 0x5f, 0x55, 
    0x01, 0x40, 0xaa, 0xaa, 0xaa, 0xaa, 0x05, 0x00, 
    0x55, 0xd5, 0x57, 0x55, 0x55, 0xd5, 0x57, 0x55, 
    0x01, 0x80, 0xab, 0xaa, 0xaa, 0xaa, 0x03, 0x00}, 
  
  {
    /* Lego Floor */
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0,
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba,
    0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0,
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57,
    0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 
    0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57,
    0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0,
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc,
    0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 
    0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d,
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa},
  
  {
    /* LegoWhite */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x19, 0x0c, 0x18, 0x0c, 0x18, 0x0c, 0x18, 0x8c, 
    0x05, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x90,
    0x05, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x90, 
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0, 
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0,
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0, 
    0x07, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0xb0, 
    0x07, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0xb0,
    0x1b, 0x2c, 0x1a, 0x2c, 0x1a, 0x2c, 0x1a, 0xac, 
    0xf5, 0x17, 0xf4, 0x17, 0xf4, 0x17, 0xf4, 0x97, 
    0x05, 0x1a, 0x04, 0x1a, 0x04, 0x1a, 0x04, 0x9a,
    0x59, 0x0d, 0x58, 0x0d, 0x58, 0x0d, 0x58, 0x8d, 
    0xe1, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x83, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xe1, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x83, 
    0x19, 0x0c, 0x18, 0x0c, 0x18, 0x0c, 0x18, 0x8c,
    0x05, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x90, 
    0x05, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x90, 
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0,
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0, 
    0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xa0, 
    0x07, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0xb0,
    0x07, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0xb0, 
    0x1b, 0x2c, 0x1a, 0x2c, 0x1a, 0x2c, 0x1a, 0xac, 
    0xf5, 0x17, 0xf4, 0x17, 0xf4, 0x17, 0xf4, 0x97,
    0x05, 0x1a, 0x04, 0x1a, 0x04, 0x1a, 0x04, 0x9a, 
    0x59, 0x0d, 0x58, 0x0d, 0x58, 0x0d, 0x58, 0x8d, 
    0xe1, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x83,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  
  {
    /* LegoBlack */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xe6, 0xf3, 0xe7, 0xf3, 0xe7, 0xf3, 0xe7, 0x73, 
    0xfa, 0xaf, 0xfa, 0xaf, 0xfa, 0xaf, 0xfa, 0x2f,
    0xfa, 0xef, 0xfb, 0xef, 0xfb, 0xef, 0xfb, 0x6f, 
    0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x1f, 
    0xfc, 0xdf, 0xfd, 0xdf, 0xfd, 0xdf, 0xfd, 0x5f,
    0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x1f, 
    0xf8, 0xcf, 0xf9, 0xcf, 0xf9, 0xcf, 0xf9, 0x4f, 
    0xf8, 0x8f, 0xf8, 0x8f, 0xf8, 0x8f, 0xf8, 0x0f,
    0xe4, 0xd3, 0xe5, 0xd3, 0xe5, 0xd3, 0xe5, 0x53, 
    0x12, 0xac, 0x12, 0xac, 0x12, 0xac, 0x12, 0x2c, 
    0xea, 0xef, 0xeb, 0xef, 0xeb, 0xef, 0xeb, 0x6f,
    0xa2, 0xa3, 0xa2, 0xa3, 0xa2, 0xa3, 0xa2, 0x23, 
    0x1e, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f, 0x7c, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x0a, 0xa8, 0x0a, 0xa8, 0x0a, 0xa8, 0x0a, 0x28, 
    0xe6, 0xf3, 0xe7, 0xf3, 0xe7, 0xf3, 0xe7, 0x73,
    0xfa, 0xaf, 0xfa, 0xaf, 0xfa, 0xaf, 0xfa, 0x2f, 
    0xfa, 0xef, 0xfb, 0xef, 0xfb, 0xef, 0xfb, 0x6f, 
    0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x1f,
    0xfc, 0xdf, 0xfd, 0xdf, 0xfd, 0xdf, 0xfd, 0x5f, 
    0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x9f, 0xfc, 0x1f, 
    0xf8, 0xcf, 0xf9, 0xcf, 0xf9, 0xcf, 0xf9, 0x4f,
    0xf8, 0x8f, 0xf8, 0x8f, 0xf8, 0x8f, 0xf8, 0x0f, 
    0xe4, 0xd3, 0xe5, 0xd3, 0xe5, 0xd3, 0xe5, 0x53, 
    0x12, 0xac, 0x12, 0xac, 0x12, 0xac, 0x12, 0x2c,
    0xea, 0xef, 0xeb, 0xef, 0xeb, 0xef, 0xeb, 0x6f, 
    0xa2, 0xa3, 0xa2, 0xa3, 0xa2, 0xa3, 0xa2, 0x23, 
    0x1e, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f, 0x7c,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  
  
  {
    /* ScoreLeftUp */
    /* Bitmap x=0 y=288 w=64 h=48 */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* ScoreLeftDown */
    /* Bitmap x=0 y=240 w=64 h=48 */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  {
    /* ScoreMidUp */
    /* Bitmap x=128 y=240 w=64 h=48 */
    0x55, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x3e, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x77, 0xf7, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x3e, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0x3e, 0xbe, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x77, 0xf7, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0x3e, 0xbe, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x55,
    0x00, 0x80, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55,
    0x00, 0x80, 0x00, 0x80, 0x3e, 0xbe, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x77, 0xf7, 0x55, 0x55,
    0x00, 0x80, 0x00, 0x80, 0x3e, 0xbe, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0xff, 0xff,
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0x55, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0xff, 0xff, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x3e, 0xbe, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x77, 0xf7, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x3e, 0xbe, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x3e, 0xbe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x77, 0xf7, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x3e, 0xbe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80}, 
  
  
  {
    /* ScoreMidDown */
    /* Bitmap x=128 y=288 w=64 h=48 */
    0x00, 0x80, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x54, 0xd5, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0xaa, 0xaa, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0x54, 0xd5, 0x3e, 0xbe, 0x00, 0x80, 0x00, 0x80, 
    0xaa, 0xaa, 0x77, 0xf7, 0x55, 0xd5, 0x55, 0xd5, 
    0x54, 0xd5, 0x3e, 0xbe, 0x00, 0x80, 0x00, 0x80, 
    0xaa, 0xaa, 0x55, 0xd5, 0x55, 0xd5, 0x55, 0xd5, 
    0xff, 0xff, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x80, 0x00, 0x80, 0x80, 0x55, 0xd5, 0x55, 0xd5, 
    0xd5, 0x54, 0xd5, 0xd4, 0x00, 0x80, 0x00, 0x80, 
    0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0xd5, 0x55, 0xd5, 
    0xd5, 0x54, 0xd5, 0xd4, 0x3e, 0xbe, 0x00, 0x80, 
    0xaa, 0xaa, 0xaa, 0xaa, 0x77, 0xf7, 0x55, 0xd5, 
    0xd5, 0x54, 0xd5, 0xd4, 0x3e, 0xbe, 0x00, 0x80, 
    0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0xd5, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x80, 0x00, 0x80, 
    0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x55, 0xd5, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x00, 0x80, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0xd5, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x3e, 0xbe, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 0xf7, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x3e, 0xbe, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x80, 
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  {
    /* ScoreRightUp */
    /* Bitmap x=64 y=240 w=64 h=48 */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, 
  
  
  {
    /* ScoreRightDown */
    /* Bitmap x=64 y=288 w=64 h=48 */
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  {
    /* ScoreFloor */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    
  },
  
  
  {
    /* IronFloor */
    /* Bitmap x=0 y=336 w=64 h=48 */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x73, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73, 
    0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 
    0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  
  {
    /* DarkBlock */
    /* Bitmap x=384 y=192 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x6b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x77, 
    0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x77, 
    0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xab, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdf, 
    0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x6b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x6b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdd, 
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x5b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  {
    /* DarkHouse */
    /* Bitmap x=320 y=96 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x0d, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0xc0, 
    0x75, 0x55, 0x55, 0x55, 0x55, 0xbb, 0x55, 0xf5, 
    0xc1, 0x00, 0x00, 0x00, 0x00, 0xba, 0x00, 0xac, 
    0x11, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff, 0xd7, 
    0x01, 0x01, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xab, 
    0xc5, 0x55, 0x55, 0x55, 0x55, 0xd7, 0x55, 0xd7, 
    0x81, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x00, 0xaa, 
    0x51, 0x55, 0x55, 0x55, 0x55, 0xd7, 0x55, 0xd5, 
    0x41, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x00, 0xac, 
    0x45, 0x55, 0x55, 0x55, 0x55, 0xff, 0x55, 0xd5, 
    0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 
    0x71, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xdd, 
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x59, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xff, 0xff, 0xd4, 
    0xeb, 0xff, 0xff, 0xaa, 0x6a, 0x00, 0x80, 0xaa, 
    0xd5, 0xaa, 0xaa, 0x54, 0x55, 0x3f, 0xbf, 0xd4, 
    0xeb, 0xaa, 0xaa, 0xa9, 0x6a, 0x39, 0xbd, 0xab, 
    0xff, 0xbb, 0xbb, 0xfe, 0x7f, 0x3d, 0xbf, 0xff, 
    0xc1, 0xee, 0xee, 0x80, 0x40, 0x3f, 0xbf, 0x80, 
    0xd5, 0xaa, 0xaa, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xeb, 0xaa, 0xaa, 0xa8, 0x6a, 0x00, 0x80, 0xaa, 
    0xd5, 0xbb, 0xbb, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xeb, 0xee, 0xee, 0xa8, 0x6a, 0x3d, 0xbd, 0xaa, 
    0xd5, 0xaa, 0xbe, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xeb, 0xaa, 0xa2, 0xa9, 0x6a, 0x3f, 0xbf, 0xaa, 
    0xff, 0xbb, 0xa3, 0xfe, 0x7f, 0x3f, 0xbf, 0xff, 
    0xc1, 0xee, 0xfe, 0x00, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0xff, 0xff, 0xd4, 
    0xeb, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0xbb, 0xbb, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xeb, 0xee, 0xee, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xeb, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  {
    /* LightHouse */
    /* Bitmap x=320 y=144 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xad, 0xaa, 0xaa, 0xaa, 0xaa, 0x82, 0xaa, 0xea, 
    0x75, 0x55, 0x55, 0x55, 0x55, 0xbb, 0x55, 0xfd, 
    0xc1, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xae, 
    0x55, 0xff, 0xff, 0xff, 0xff, 0x83, 0xff, 0xff, 
    0x01, 0xab, 0xaa, 0xaa, 0xaa, 0xfe, 0xaa, 0xab, 
    0xd5, 0x55, 0x55, 0x55, 0x55, 0xd7, 0x55, 0xff, 
    0x81, 0xaa, 0xaa, 0xaa, 0xaa, 0x82, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0xd7, 0x55, 0xff, 
    0xc1, 0xaa, 0xaa, 0xaa, 0xaa, 0x82, 0xaa, 0xae, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 0x55, 0xfd, 
    0xa1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x75, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0xb1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0xb1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0xa9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xad, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xa9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0x81, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xff, 0xff, 0xd4, 
    0xc1, 0xff, 0xff, 0x00, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0x55, 0x3f, 0xbf, 0xd4, 
    0xc1, 0xaa, 0xaa, 0x00, 0x40, 0x39, 0xbd, 0x80, 
    0xff, 0xbb, 0xbb, 0xfc, 0x7f, 0x3d, 0xbf, 0xff, 
    0xc1, 0xee, 0xee, 0x80, 0x40, 0x3f, 0xbf, 0x80, 
    0xd5, 0xaa, 0xaa, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xc1, 0xaa, 0xaa, 0x80, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xbb, 0xbb, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xc1, 0xee, 0xee, 0x80, 0x40, 0x3d, 0xbd, 0x80, 
    0xd5, 0xaa, 0xbe, 0xd4, 0x54, 0x3f, 0xbf, 0xd5, 
    0xc1, 0xaa, 0xa2, 0x80, 0x40, 0x3f, 0xbf, 0x80, 
    0xff, 0xbb, 0xa3, 0xfc, 0x7f, 0x3f, 0xbf, 0xff, 
    0xc1, 0xee, 0xfe, 0x00, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0xff, 0xff, 0xd4, 
    0xc1, 0xaa, 0xaa, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xd5, 0xbb, 0xbb, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xc1, 0xee, 0xee, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xc1, 0xaa, 0xaa, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  
  
  {
    /* CityFree */
    /* Bitmap x=384 y=144 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x51, 0x15, 0x11, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x45, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x11, 0x55, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x45, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 0x54, 0x54,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x11, 0x11, 0x11, 0x51, 0x15, 0x11, 0x11, 0x11, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 0x54, 0x54, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x45, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x11, 0x55, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x45, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x55, 0x54, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x15, 0x11, 0x11, 0x11, 0x11, 0x51, 0x15, 0x51,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x54, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10},

  {
    /* control_num */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xad, 0x1a, 0x40, 0x00, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x0e, 0x55, 0x55, 0x55, 0xb5, 
    0xad, 0x1a, 0x40, 0x11, 0x01, 0x04, 0xb0, 0xaa,
    0x55, 0x55, 0x55, 0x11, 0x55, 0x55, 0x55, 0xb5, 
    0xad, 0x1a, 0x40, 0x0e, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x11, 0x55, 0x55, 0x55, 0xb5,
    0xad, 0x1a, 0x40, 0x11, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x0e, 0x55, 0x55, 0x55, 0xb5, 
    0xad, 0x1a, 0x40, 0x00, 0x01, 0x04, 0xb0, 0xaa,
    0x55, 0xf5, 0xff, 0xff, 0xff, 0x57, 0x55, 0xb5, 
    0xad, 0xfa, 0xff, 0xff, 0xff, 0x07, 0xb0, 0xaa, 
    0x55, 0x15, 0x40, 0x00, 0x01, 0x54, 0x55, 0xb5,
    0xad, 0x1a, 0x42, 0x1f, 0x39, 0x04, 0xb0, 0xaa, 
    0x55, 0x15, 0x43, 0x01, 0x45, 0x54, 0x55, 0xb5, 
    0xad, 0x9a, 0x42, 0x01, 0x05, 0x04, 0xb0, 0xaa,
    0x55, 0x55, 0x42, 0x0e, 0x3d, 0x54, 0x55, 0xb5, 
    0xad, 0xda, 0x47, 0x10, 0x45, 0x04, 0xb0, 0xaa, 
    0x55, 0x15, 0x42, 0x11, 0x45, 0x54, 0x55, 0xb5,
    0xad, 0x1a, 0x42, 0x0e, 0x39, 0x04, 0xb0, 0xaa, 
    0x55, 0x15, 0x40, 0x00, 0x01, 0x54, 0x55, 0xb5, 
    0xad, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xaa,
    0x55, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xb5, 
    0xad, 0x1a, 0x40, 0x00, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x0e, 0x55, 0x55, 0x55, 0xb5,
    0xad, 0x1a, 0x40, 0x11, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x10, 0x55, 0x55, 0x55, 0xb5, 
    0xad, 0x1a, 0x40, 0x18, 0x01, 0x04, 0xb0, 0xaa,
    0x55, 0x55, 0x55, 0x06, 0x55, 0x55, 0x55, 0xb5, 
    0xad, 0x1a, 0x40, 0x01, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0x55, 0x55, 0x1f, 0x55, 0x55, 0x55, 0xb5,
    0xad, 0x1a, 0x40, 0x00, 0x01, 0x04, 0xb0, 0xaa, 
    0x55, 0xf5, 0xff, 0xff, 0xff, 0x57, 0x55, 0xb5, 
    0xad, 0xfa, 0xff, 0xff, 0xff, 0x07, 0xb0, 0xaa,
    0x55, 0x15, 0x00, 0x00, 0x01, 0x54, 0x55, 0xb5, 
    0xad, 0x9a, 0x03, 0x00, 0x55, 0x05, 0xb0, 0xaa, 
    0x55, 0x55, 0x04, 0x00, 0x01, 0x54, 0x55, 0xb5,
    0xad, 0x5a, 0x04, 0x00, 0x55, 0x05, 0xb0, 0xaa, 
    0x55, 0x55, 0x04, 0x00, 0x01, 0x54, 0x55, 0xb5, 
    0xad, 0x5a, 0x04, 0x00, 0x55, 0x05, 0xb0, 0xaa,
    0x55, 0x55, 0x04, 0x00, 0x01, 0x54, 0x55, 0xb5, 
    0xad, 0x9a, 0x03, 0x00, 0x55, 0x05, 0xb0, 0xaa, 
    0x55, 0x15, 0x00, 0x00, 0x01, 0x54, 0x55, 0xb5,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
 
  {
    /* ControlAlpha */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0x0d, 0x20, 0x80, 0x01, 0x0c, 0x60, 0x00, 0xa3, 
    0xad, 0xaa, 0xaa, 0x7d, 0xac, 0x6a, 0x55, 0xab, 
    0x0d, 0x20, 0x80, 0x11, 0x0c, 0x60, 0x00, 0xa3,
    0xad, 0xaa, 0xaa, 0x11, 0xac, 0x6a, 0x55, 0xab, 
    0x0d, 0x20, 0x80, 0x11, 0x0c, 0x60, 0x00, 0xa3, 
    0xad, 0xaa, 0xaa, 0x11, 0xac, 0x6a, 0x55, 0xab,
    0x0d, 0x20, 0x80, 0x11, 0x0c, 0x60, 0x00, 0xa3, 
    0xad, 0xaa, 0xaa, 0x11, 0xac, 0x6a, 0x55, 0xab, 
    0x0d, 0x20, 0x80, 0x01, 0x0c, 0x60, 0x00, 0xa3,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x85, 0x00, 0x02, 0x18, 0xc0, 0x00, 0x06, 0xb0,
    0xad, 0xaa, 0xfa, 0x98, 0xc3, 0x22, 0x56, 0xb5, 
    0x85, 0x00, 0x0a, 0x58, 0xc4, 0x22, 0x06, 0xb0, 
    0xad, 0xaa, 0x0a, 0x58, 0xc0, 0x22, 0x56, 0xb5,
    0x85, 0x00, 0x7a, 0x58, 0xc7, 0x3e, 0x06, 0xb0, 
    0xad, 0xaa, 0x0a, 0x58, 0xc4, 0x22, 0x56, 0xb5, 
    0x85, 0x00, 0x0a, 0x58, 0xc4, 0x22, 0x06, 0xb0,
    0xad, 0xaa, 0x0a, 0x98, 0xc3, 0x22, 0x56, 0xb5, 
    0x85, 0x00, 0x02, 0x18, 0xc0, 0x00, 0x06, 0xb0, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x05, 0x10, 0x40, 0x00, 0x01, 0x04, 0x30, 0xa0, 
    0x55, 0x55, 0x55, 0x55, 0x3d, 0x54, 0xb5, 0xaa,
    0x05, 0x10, 0x40, 0x00, 0x45, 0x04, 0x30, 0xa0, 
    0x55, 0x55, 0x55, 0x55, 0x45, 0x54, 0xb5, 0xaa, 
    0x05, 0x10, 0x40, 0x00, 0x3d, 0x04, 0x30, 0xa0,
    0x55, 0x55, 0x55, 0x55, 0x45, 0x54, 0xb5, 0xaa, 
    0x05, 0x10, 0x40, 0x00, 0x45, 0x04, 0x30, 0xa0, 
    0x55, 0x55, 0x55, 0x55, 0x3d, 0x54, 0xb5, 0xaa,
    0x05, 0x10, 0x40, 0x00, 0x01, 0x04, 0x30, 0xa0, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x55, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,
    0x55, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x55, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,
    0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x55, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},

  {
    /* Display */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 
    0x11, 0x55, 0x55, 0x55, 0x55, 0x55, 0x8d, 0x88,
    0x51, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0x8a, 0x88, 
    0x51, 0x55, 0x55, 0x55, 0x55, 0x55, 0x8d, 0x88, 
    0xf1, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0x8a, 0x88,
    0x51, 0x55, 0x55, 0x55, 0x55, 0x55, 0x0d, 0x89, 
    0xb1, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x0b, 0x8a, 
    0x51, 0x35, 0xfe, 0xff, 0xff, 0x57, 0x0d, 0x88,
    0xb1, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x8f, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a,
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d,
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a,
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d,
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a,
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d,
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a,
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d,
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a, 
    0x51, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8d, 
    0xb1, 0x06, 0x00, 0x00, 0x00, 0x00, 0xab, 0x8a,
    0x51, 0xfd, 0xff, 0xff, 0xff, 0xff, 0x55, 0x8d, 
    0xb1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x8a, 
    0x51, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x8d,
    0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0x80,
    0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0x80, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  
  {
    /* Sphere Light */
    /* Bitmap x=384 y=336 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xee, 0xea, 0xaa, 0xaa, 0xee, 0xee, 0xfe, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xbb, 0xab, 0xaa, 0xaa, 0xaa, 0xbb, 0xff, 
    0xff, 0xff, 0x57, 0x55, 0x55, 0xd5, 0xff, 0xff, 
    0xff, 0xef, 0xab, 0x00, 0xaa, 0xaa, 0xef, 0xff, 
    0xff, 0x7f, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0x02, 0x00, 0x80, 0xaa, 0xfa, 0xff, 
    0xff, 0x5f, 0x55, 0x55, 0x55, 0x55, 0xf5, 0xff, 
    0xff, 0x2f, 0x00, 0x00, 0x00, 0xa8, 0xea, 0xff, 
    0xff, 0x57, 0x45, 0x44, 0x55, 0x55, 0xd5, 0xff, 
    0xff, 0x0b, 0x00, 0x00, 0x00, 0xa0, 0xaa, 0xff, 
    0xff, 0x15, 0x11, 0x11, 0x55, 0x55, 0x55, 0xff, 
    0xff, 0x02, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xfe, 
    0xff, 0x45, 0x00, 0x44, 0x44, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xfe, 
    0x7f, 0x15, 0x00, 0x10, 0x51, 0x55, 0x55, 0xfd, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xfa, 
    0x5f, 0x05, 0x00, 0x40, 0x44, 0x55, 0x55, 0xf5, 
    0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xea, 
    0x5f, 0x01, 0x00, 0x00, 0x11, 0x55, 0x55, 0xf5, 
    0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xea, 
    0x57, 0x05, 0x00, 0x40, 0x44, 0x55, 0x55, 0xd5, 
    0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xea, 
    0x57, 0x11, 0x00, 0x10, 0x11, 0x55, 0x55, 0xd5, 
    0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x57, 0x45, 0x00, 0x44, 0x44, 0x55, 0x55, 0xd5, 
    0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x57, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 0xd5, 
    0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x55, 0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 
    0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x55, 0x15, 0x11, 0x11, 0x51, 0x55, 0x55, 0x55, 
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x55, 0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 
    0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x57, 0x55, 0x11, 0x11, 0x51, 0x55, 0x55, 0xd5, 
    0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x57, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 0xd5, 
    0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xee, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xbf, 0x03, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xfb, 
    0xff, 0x5f, 0x55, 0x55, 0x55, 0x55, 0xf5, 0xff, 
    0xef, 0x2e, 0x00, 0x00, 0x00, 0xa0, 0xee, 0xee, 
    0xff, 0xff, 0x5f, 0x55, 0x55, 0xf5, 0xff, 0xff, 
    0xbf, 0xbb, 0xaa, 0x02, 0x80, 0xba, 0xbb, 0xfb}, 
  
  
  {
    /* Sphere Dark */
    /* Bitmap x=448 y=336 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xee, 0xea, 0xee, 0xee, 0xee, 0xee, 0xfe, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xef, 0xef, 0xaa, 0xee, 0xee, 0xef, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbf, 0xab, 0xaa, 0xaa, 0xbb, 0xfb, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xef, 0xaa, 0xaa, 0xaa, 0xee, 0xee, 0xff, 
    0xff, 0xff, 0x57, 0xd5, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbb, 0xaa, 0xaa, 0xaa, 0xba, 0xbb, 0xff, 
    0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 0xff, 
    0xff, 0xae, 0x00, 0xaa, 0xaa, 0xea, 0xee, 0xfe, 
    0xff, 0x5f, 0x55, 0x55, 0xf5, 0xff, 0xff, 0xff, 
    0xff, 0x2b, 0x00, 0xa8, 0xaa, 0xaa, 0xbb, 0xff, 
    0xff, 0x57, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0xff, 0x0a, 0x00, 0xa0, 0xaa, 0xaa, 0xee, 0xfe, 
    0xff, 0x57, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0xbf, 0x0a, 0x00, 0xa0, 0xaa, 0xaa, 0xba, 0xfb, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 
    0xaf, 0x0a, 0x00, 0xa0, 0xaa, 0xaa, 0xea, 0xee, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 
    0xbf, 0x0a, 0x00, 0xa0, 0xaa, 0xaa, 0xba, 0xfb, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 
    0xaf, 0x2a, 0x00, 0xa8, 0xaa, 0xaa, 0xea, 0xee, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 
    0xab, 0xaa, 0x82, 0xaa, 0xaa, 0xaa, 0xaa, 0xbb, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 
    0xaf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 0xee, 
    0xff, 0x57, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0xbb, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0xbb, 
    0xff, 0x57, 0x55, 0x55, 0xd5, 0xff, 0xff, 0xff, 
    0xaf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 0xee, 
    0xff, 0x5f, 0x55, 0x55, 0xf5, 0xff, 0xff, 0xff, 
    0xbb, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0xbb, 
    0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 0xff, 
    0xaf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 0xee, 
    0xff, 0xff, 0x57, 0xd5, 0xff, 0xff, 0xff, 0xff, 
    0xbb, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0xbb, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xef, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xee, 0xee, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xbf, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xbb, 0xfb, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xef, 0xae, 0xaa, 0xaa, 0xaa, 0xea, 0xee, 0xee, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xbf, 0xbb, 0xaa, 0xaa, 0xaa, 0xba, 0xbb, 0xfb}, 
  
  
  {
    /* Sphere Half */
    /* Bitmap x=512 y=336 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xee, 0xea, 0xaa, 0xaa, 0xee, 0xee, 0xfe, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xbb, 0xfb, 0xaa, 0xaa, 0xba, 0xbb, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xef, 0xee, 0xaa, 0xaa, 0xee, 0xee, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xbf, 0xfb, 0xaa, 0xaa, 0xba, 0xfb, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xee, 0xaa, 0xaa, 0xee, 0xfe, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xfb, 0xaa, 0xaa, 0xba, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
    0xff, 0x7f, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff, 
    0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0xff, 
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 
    0xff, 0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xbf, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xfb, 
    0xff, 0x7f, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff, 
    0xef, 0xee, 0x01, 0x00, 0x00, 0x00, 0xee, 0xee, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xbf, 0xbb, 0xea, 0xaa, 0xaa, 0xbe, 0xbb, 0xfb}, 
  

  
  {
    /* Extra Invincible */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xab, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x55, 0x56, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x6a, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x35, 0x54, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0xaa, 0x2a, 0xac, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x35, 0x54, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x1a, 0xa8, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x15, 0x58, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x0a, 0xb0, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xff, 0x0f, 0xf0, 0x7f, 0x55, 0x05,
    0xa0, 0xaa, 0x02, 0x20, 0x04, 0xc0, 0xaa, 0x0a, 
    0x50, 0x55, 0x0d, 0x70, 0x0e, 0x70, 0x55, 0x05, 
    0xa0, 0xaa, 0x1a, 0x70, 0x0e, 0xa8, 0xaa, 0x0a,
    0x50, 0x55, 0x75, 0x70, 0x0e, 0x56, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x20, 0x04, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x03, 0xc0, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0xaa, 0x16, 0xa8, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x23, 0x44, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xc2, 0xc3, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x01, 0x80, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0x80, 0x01, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x60, 0x06, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0x6a, 0xb8, 0x1a, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x35, 0x56, 0x75, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0x9a, 0xab, 0xaa, 0xa9, 0xaa, 0x0a,
    0x50, 0x55, 0x75, 0x55, 0x55, 0x5f, 0x55, 0x05, 
    0xa0, 0xaa, 0xba, 0xaa, 0xaa, 0xba, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  

  {
    /* Temple */
    /* Bitmap x=448 y=96 w=64 h=48 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x71, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xf4, 
    0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 
    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 
    0x81, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xd6, 
    0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 
    0x41, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xd5, 
    0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 
    0x61, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xdc, 
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xd1, 
    0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x49, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xe4, 
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xd1, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x47, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xc4, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x03, 0xc0, 0x02, 0xc0, 0x02, 0xc0, 0x02, 0xc0, 
    0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 0x03, 0xa8, 
    0x05, 0x40, 0x04, 0x40, 0x04, 0x40, 0x04, 0xc0, 
    0x0d, 0x68, 0x0d, 0x68, 0x0d, 0x68, 0x0d, 0xe8, 
    0x31, 0x18, 0x30, 0x18, 0x30, 0x18, 0x30, 0x98, 
    0xd5, 0x57, 0xd5, 0x57, 0xd5, 0x57, 0xd5, 0xd7, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, 
  
  /* RemoteControl */
  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x01, 0x40, 0x55, 0x55, 0x05,
    0xa0, 0xaa, 0x2a, 0xa8, 0x0a, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0x15, 0x55, 0x55, 0x54, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x01, 0x40, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0x22, 0xa8, 0x0a, 0xa2, 0xaa, 0x0a, 
    0x50, 0x55, 0x15, 0x55, 0x55, 0x54, 0x55, 0x05,
    0xa0, 0xaa, 0x8a, 0xaa, 0xaa, 0xa8, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x15, 0x00, 0x00, 0x50, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xff, 0xff, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05,
    0xa0, 0xaa, 0xca, 0xea, 0xab, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x3f, 0xfc, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0x0a, 0xb0, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0xd5, 0x0f, 0xf0, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0x0a, 0xb0, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x3f, 0xfc, 0x53, 0x55, 0x05,
    0xa0, 0xaa, 0xca, 0xca, 0xbb, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0x0f, 0xf4, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0x3a, 0xac, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05,
    0xa0, 0xaa, 0xca, 0xff, 0xff, 0xab, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05, 
    0xa0, 0xaa, 0xca, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x50, 0x55, 0xd5, 0xff, 0xff, 0x53, 0x55, 0x05,
    0xa0, 0xaa, 0x0a, 0x00, 0x00, 0xa8, 0xaa, 0x0a, 
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
    0x50, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 
    0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,},
  
  {
    /* BookShelf */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0xf5, 0xff, 0x5f, 0x55, 0x55, 0xd5,
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x75, 0x55, 0x5f, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa,
    0x55, 0x55, 0x75, 0x55, 0x5f, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x75, 0x55, 0x5f, 0x55, 0x55, 0xd5,
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x75, 0x55, 0x5f, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa,
    0x55, 0x55, 0x75, 0x55, 0x5f, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x2a, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0xf5, 0xff, 0x5f, 0x55, 0x55, 0xd5,
    0xab, 0xaa, 0x6a, 0x00, 0xa8, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x75, 0x00, 0x58, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xea, 0xff, 0xaf, 0xaa, 0xaa, 0xaa,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xdf, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xfd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xdf, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xfd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xdf, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xfd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xdf, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xfd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 
    0xbb, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xb8, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,},

#if 0
  {
    /* ChessFloor */
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, },
#else
  {
    /* Chess Floor */
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, },

#endif

  {
    /* Chess Sphere */
    0xff, 0x55, 0xd5, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0xf0, 0xaa, 0xaa, 0x02, 0x00, 0xaa, 
    0xff, 0x55, 0x7d, 0x55, 0x55, 0x5d, 0x55, 0xff,
    0xaa, 0x00, 0xac, 0xaa, 0xaa, 0x2a, 0x00, 0xaa, 
    0xff, 0x55, 0x57, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0xab, 0x00, 0xaa, 0xaa, 0x03, 0xaa,
    0x55, 0xff, 0x55, 0x55, 0x55, 0x55, 0xfd, 0x55, 
    0x00, 0xaa, 0x02, 0x00, 0x80, 0xaa, 0xaa, 0x00, 
    0x55, 0x5f, 0x55, 0x55, 0x55, 0x55, 0xf5, 0x55,
    0x00, 0x2a, 0x00, 0x00, 0x00, 0xa8, 0xaa, 0x00, 
    0x55, 0x57, 0x45, 0x44, 0x55, 0x55, 0xd5, 0x55, 
    0x00, 0x0a, 0x00, 0x00, 0x00, 0xa0, 0xaa, 0x00,
    0x55, 0x15, 0x11, 0x11, 0x55, 0x55, 0x55, 0x55, 
    0x80, 0x02, 0x00, 0x00, 0x00, 0x80, 0xaa, 0x02, 
    0xd5, 0x45, 0x00, 0x44, 0x44, 0x55, 0x55, 0x57,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x06, 
    0x55, 0x15, 0x00, 0x10, 0x51, 0x55, 0x55, 0x5d, 
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x1a,
    0x55, 0x05, 0x00, 0x40, 0x44, 0x55, 0x55, 0xf5, 
    0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x5f, 0x01, 0x00, 0x00, 0x11, 0x55, 0x55, 0xf5,
    0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x57, 0x05, 0x00, 0x40, 0x44, 0x55, 0x55, 0xd5, 
    0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xea,
    0x57, 0x11, 0x00, 0x10, 0x11, 0x55, 0x55, 0xd5, 
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x57, 0x45, 0x00, 0x44, 0x44, 0x55, 0x55, 0xd5,
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x57, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 0xd5, 
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa,
    0x55, 0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x55, 0x15, 0x11, 0x11, 0x51, 0x55, 0x55, 0x55,
    0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xaa, 
    0x55, 0x45, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 
    0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa,
    0x57, 0x55, 0x11, 0x11, 0x51, 0x55, 0x55, 0xd5, 
    0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 
    0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 0xd5,
    0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x2a, 
    0x75, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5d, 
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x02,
    0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xaa, 0x06, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xaa, 
    0xff, 0x5d, 0x55, 0x55, 0x55, 0x55, 0x75, 0xff,
    0xaa, 0x38, 0x00, 0x00, 0x00, 0xa0, 0x1e, 0xaa, 
    0xff, 0xf5, 0x5f, 0x55, 0x55, 0xf5, 0x57, 0xff, 
    0xaa, 0x80, 0xba, 0x02, 0x80, 0x1a, 0x00, 0xaa, },

#if 0
  {
    /* pumpkin */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xea, 0x43, 0xf8, 0xaf, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xd5, 0x55, 0xfd, 0xff, 0xff,
    0xaa, 0xaa, 0x03, 0x8e, 0x8a, 0xc8, 0xab, 0xaa, 
    0xff, 0x7f, 0x11, 0xd1, 0xd7, 0xff, 0xff, 0xff, 
    0xaa, 0x1a, 0x00, 0x90, 0xb2, 0xaa, 0xaa, 0xaa,
    0xff, 0x4f, 0xe4, 0xe7, 0xff, 0x57, 0xf5, 0xff, 
    0xaa, 0x02, 0x1e, 0x10, 0x88, 0xbc, 0xea, 0xaa, 
    0xff, 0xd1, 0x11, 0x9f, 0xfb, 0xd5, 0xd5, 0xff,
    0xaa, 0x30, 0xe0, 0xe0, 0x3f, 0x27, 0xae, 0xab, 
    0x7f, 0x4c, 0x5c, 0x5d, 0x75, 0x5d, 0x5d, 0xff, 
    0x2a, 0x06, 0x04, 0x04, 0xa0, 0xa8, 0xb8, 0xae,
    0x1f, 0x11, 0x57, 0x57, 0x55, 0x55, 0x55, 0xfd, 
    0x8a, 0x00, 0x01, 0x01, 0x40, 0xa2, 0xa2, 0xba, 
    0x4f, 0xc4, 0x55, 0x55, 0xd5, 0x55, 0x55, 0xf5,
    0x26, 0x40, 0x80, 0x00, 0x80, 0x88, 0x8a, 0xaa, 
    0x37, 0x71, 0xd5, 0x55, 0xd5, 0x55, 0x55, 0xf5, 
    0x12, 0x20, 0x80, 0x00, 0x00, 0x23, 0x26, 0xee,
    0x57, 0x54, 0x55, 0x55, 0x55, 0x55, 0x5d, 0xdd, 
    0x0a, 0x10, 0x40, 0x00, 0x00, 0x89, 0x88, 0xe8, 
    0x19, 0x59, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0x09, 0x08, 0x4a, 0x00, 0x00, 0xa3, 0x32, 0xb2, 
    0x4d, 0x5c, 0x5b, 0x55, 0x55, 0x95, 0x55, 0xd5, 
    0x09, 0x04, 0x31, 0x00, 0x00, 0x0a, 0x99, 0xb8,
    0x19, 0x55, 0x61, 0x55, 0x55, 0x07, 0x76, 0xd5, 
    0x09, 0x84, 0x20, 0x00, 0x00, 0x06, 0x26, 0xb2, 
    0x4d, 0xd4, 0x7f, 0x55, 0x55, 0xff, 0x77, 0xd5,
    0x09, 0x44, 0x40, 0x00, 0x00, 0x06, 0xa8, 0xb8, 
    0x1b, 0xd5, 0xff, 0x55, 0x55, 0xff, 0x7f, 0xd5, 
    0x0a, 0x04, 0x20, 0x00, 0x00, 0x22, 0x22, 0xf2,
    0x4f, 0x54, 0x75, 0x55, 0x55, 0x57, 0x75, 0xd5, 
    0x16, 0x04, 0x20, 0x00, 0x00, 0x8a, 0xa8, 0xb8, 
    0x17, 0x55, 0x75, 0x55, 0x55, 0x57, 0x75, 0xed,
    0x1a, 0x04, 0x20, 0x00, 0x00, 0x22, 0x26, 0xba, 
    0x5f, 0x5c, 0x75, 0x55, 0x55, 0x57, 0x57, 0xfd, 
    0x3a, 0x08, 0x22, 0x38, 0xb0, 0xcb, 0x9c, 0xa8,
    0x3f, 0x59, 0x5d, 0xc7, 0x0d, 0x36, 0x5b, 0xfd, 
    0x6a, 0x08, 0xf1, 0x01, 0x63, 0xc8, 0x2c, 0xae, 
    0xff, 0xd4, 0x42, 0x1c, 0x98, 0x31, 0x5f, 0xff,
    0xaa, 0x11, 0xc5, 0x63, 0x66, 0xce, 0x8c, 0xaa, 
    0xff, 0x73, 0x3b, 0x9c, 0xd9, 0x71, 0xd5, 0xff, 
    0xaa, 0x2e, 0xc4, 0x63, 0x86, 0x2e, 0xb2, 0xaa,
    0xff, 0x5f, 0x7d, 0xd5, 0xd5, 0x55, 0xfd, 0xff, 
    0xaa, 0xea, 0x00, 0x01, 0xc0, 0x88, 0xae, 0xaa, 
    0xff, 0xff, 0x57, 0x57, 0x55, 0xf5, 0xff, 0xff,
    0xaa, 0xaa, 0x1e, 0x04, 0x20, 0xbe, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0x5b, 0xd5, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xfe, 0xbf, 0xaa, 0xaa, 0xaa, },
#else
  {
    /* Pumpkin */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xea, 0x43, 0xf8, 0xaf, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xd5, 0x55, 0xfd, 0xff, 0xff,
    0xaa, 0xaa, 0x03, 0x8e, 0x8a, 0xc8, 0xab, 0xaa, 
    0xff, 0x7f, 0x11, 0xd1, 0xd7, 0xff, 0xff, 0xff, 
    0xaa, 0x1a, 0x00, 0x90, 0xb2, 0xaa, 0xaa, 0xaa,
    0xff, 0x4f, 0xe4, 0xe7, 0xff, 0x57, 0xf5, 0xff, 
    0xaa, 0x02, 0x1e, 0x10, 0x88, 0xbc, 0xea, 0xaa, 
    0xff, 0xd1, 0x11, 0x9f, 0xfb, 0xd5, 0xd5, 0xff,
    0xaa, 0x30, 0xe0, 0xe0, 0x3f, 0x27, 0xae, 0xff, 
    0x7f, 0x4c, 0x5c, 0x5d, 0x75, 0x5d, 0x5d, 0xff, 
    0x2a, 0x06, 0x04, 0x04, 0xa0, 0xa8, 0xb8, 0xfe,
    0x1f, 0x11, 0x57, 0x57, 0x55, 0x55, 0x55, 0xfd, 
    0x8a, 0x00, 0x01, 0x01, 0x40, 0xa2, 0xa2, 0xfa, 
    0x4f, 0xc4, 0x55, 0x55, 0xd5, 0x55, 0x55, 0xf5,
    0x26, 0x40, 0x80, 0x00, 0x80, 0x88, 0x8a, 0xea, 
    0x37, 0x71, 0xd5, 0x55, 0xd5, 0x55, 0x55, 0xf5, 
    0x12, 0x20, 0x80, 0x00, 0x00, 0x23, 0x26, 0xee,
    0x57, 0x54, 0x55, 0x55, 0x55, 0x55, 0x5d, 0xdd, 
    0x0a, 0x10, 0x40, 0x00, 0x00, 0x89, 0x88, 0xe8, 
    0x19, 0x59, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0x09, 0x08, 0x4a, 0x00, 0x00, 0xa3, 0x32, 0xb2, 
    0x4d, 0x5c, 0x5b, 0x55, 0x55, 0x95, 0x55, 0xd5, 
    0x09, 0x04, 0x31, 0x00, 0x00, 0x0a, 0x99, 0xb8,
    0x19, 0x55, 0x61, 0x55, 0x55, 0x07, 0x76, 0xd5, 
    0x09, 0x84, 0x20, 0x00, 0x00, 0x06, 0x26, 0xb2, 
    0x4d, 0xd4, 0x7f, 0x55, 0x55, 0xff, 0x77, 0xd5,
    0x09, 0x44, 0x40, 0x00, 0x00, 0x06, 0xa8, 0xb8, 
    0x1b, 0xd5, 0xff, 0x55, 0x55, 0xff, 0x7f, 0xd5, 
    0x0a, 0x04, 0x20, 0x00, 0x00, 0x22, 0x22, 0xe2,
    0x4f, 0x54, 0x75, 0x55, 0x55, 0x57, 0x75, 0xd5, 
    0x16, 0x04, 0x20, 0x00, 0x00, 0x8a, 0xa8, 0xe8, 
    0x17, 0x55, 0x75, 0x55, 0x55, 0x57, 0x75, 0xf5,
    0x1a, 0x04, 0x20, 0x00, 0x00, 0x22, 0x26, 0xfa, 
    0x5f, 0x5c, 0x75, 0x55, 0x55, 0x57, 0x57, 0xfd, 
    0x3a, 0x08, 0x22, 0x38, 0xb0, 0xcb, 0x9c, 0xf8,
    0x3f, 0x59, 0x5d, 0xc7, 0x0d, 0x36, 0x5b, 0xfd, 
    0x6a, 0x08, 0xf1, 0x01, 0x63, 0xc8, 0x2c, 0xfe, 
    0xff, 0xd4, 0x42, 0x1c, 0x98, 0x31, 0x5f, 0xff,
    0xaa, 0x11, 0xc5, 0x63, 0x66, 0xce, 0x8c, 0xff, 
    0xff, 0x73, 0x3b, 0x9c, 0xd9, 0x71, 0xd5, 0xff, 
    0xaa, 0x2e, 0xc4, 0x63, 0x86, 0x2e, 0xf2, 0xff,
    0xff, 0x5f, 0x7d, 0xd5, 0xd5, 0x55, 0xfd, 0xff, 
    0xaa, 0xea, 0x00, 0x01, 0xc0, 0x88, 0xfe, 0xff, 
    0xff, 0xff, 0x57, 0x57, 0x55, 0xf5, 0xff, 0xff,
    0xaa, 0xaa, 0x1f, 0x04, 0x20, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x5b, 0xd5, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, },
#endif

  {
    /* RIP */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xfe, 0xff, 
    0xaa, 0x23, 0x22, 0x22, 0x22, 0xff, 0xa7, 0xab, 
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x57, 0xff,
    0x9a, 0x88, 0x88, 0x88, 0x88, 0xf8, 0x89, 0xa8, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5, 
    0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xb2,
    0x57, 0x55, 0x55, 0x5d, 0x55, 0x55, 0x55, 0xf5, 
    0x8a, 0x88, 0x88, 0x9e, 0x88, 0x88, 0x88, 0xc8, 
    0x57, 0xff, 0xff, 0xf7, 0xff, 0xff, 0x7f, 0xd5,
    0xa2, 0xab, 0xaa, 0xab, 0xaa, 0xaa, 0xaa, 0xe3, 
    0x75, 0x55, 0x55, 0x7f, 0x55, 0x55, 0x55, 0xd7, 
    0xb9, 0xaa, 0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0x8a,
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xad, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5,
    0xa9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xa9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea,
    0x5d, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xad, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0xf5, 0x5f, 0xf5, 0xd5, 0x7f, 0x55, 0xd5, 
    0xab, 0xea, 0xbe, 0xea, 0xaa, 0xfb, 0xaa, 0xea,
    0x55, 0x75, 0x5d, 0x75, 0xd5, 0x75, 0x55, 0xf5, 
    0xab, 0xea, 0xba, 0xea, 0xaa, 0xeb, 0xaa, 0xaa, 
    0x55, 0x75, 0x5d, 0x75, 0xd5, 0x75, 0x55, 0xf5,
    0xab, 0xea, 0xae, 0xea, 0xaa, 0xbb, 0xaa, 0xba, 
    0x55, 0xf5, 0x57, 0x75, 0xd5, 0x5f, 0x55, 0xf5, 
    0xab, 0xea, 0xae, 0xea, 0xaa, 0xab, 0xaa, 0xaa,
    0x55, 0x75, 0x5d, 0x75, 0xd5, 0x55, 0x55, 0xf5, 
    0xab, 0xea, 0xba, 0xea, 0xaa, 0xab, 0xaa, 0xea, 
    0x55, 0x75, 0x5d, 0x75, 0xd5, 0x55, 0x5d, 0xd5,
    0xab, 0xea, 0xba, 0xeb, 0xae, 0xab, 0xab, 0xaa, 
    0x55, 0xf5, 0x75, 0xf7, 0xdd, 0x57, 0x57, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xaf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },

  {
    /* DarkWay */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa,
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff,
    0xaa, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba,
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5,
    0x02, 0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa0, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba,
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xaa, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x53, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5,
    0x02, 0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa0, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa,
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff,
    0xaa, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, },
 
  {
    /* karo light shadow */
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x75, 0x5c, 0x55, 0x55, 0x55,
    0xaa, 0x0a, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x1d, 0x71, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x02, 0xc0, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0xc0, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x55, 0x55, 0x35, 0x11, 0x11, 0x5d, 0x55, 0x55,
    0xaa, 0x0a, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x55, 0x55, 0x4d, 0x44, 0x44, 0x64, 0x55, 0x55, 
    0xaa, 0x0a, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00,
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 
    0xaa, 0xca, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
    0x55, 0x75, 0x44, 0x44, 0x44, 0x44, 0x5c, 0x55,
    0xaa, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x55, 0x03, 0x11, 0x11, 0x11, 0x11, 0x71, 0x55, 
    0xaa, 0x15, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00,
    0xd5, 0x40, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55, 
    0x6a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x15, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x5d,
    0x5e, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0x03, 0x40, 0x44, 0x44, 0x44, 0x44, 0x44, 0x64, 
    0x55, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
    0x07, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x5a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x15, 0x40, 0x44, 0x44, 0x44, 0x44, 0x44, 0x64,
    0x6a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
    0xd5, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x59, 
    0xaa, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
    0x55, 0x47, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55, 
    0xaa, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0x55, 0x15, 0x11, 0x11, 0x11, 0x11, 0x71, 0x55,
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x55, 0x75, 0x44, 0x44, 0x44, 0x44, 0x5c, 0x55, 
    0xaa, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x55, 0x55, 
    0xaa, 0x0a, 0x06, 0x00, 0x00, 0x80, 0x00, 0x00, 
    0x55, 0x55, 0x4d, 0x44, 0x44, 0x64, 0x55, 0x55,
    0xaa, 0x0a, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x55, 0x55, 0x75, 0x11, 0x11, 0x59, 0x55, 0x55, 
    0xaa, 0x0a, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x45, 0x44, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x06, 0x80, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x1d, 0x71, 0x55, 0x55, 0x55,
    0xaa, 0x0a, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 
    0x55, 0x55, 0x55, 0x75, 0x5c, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x80, 0x06, 0x00, 0x00, 0x00, },
  
  {
    /* ?-Block, damaged */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xe0, 
    0x5d, 0xd5, 0x55, 0x55, 0x55, 0x55, 0xd7, 0xdd,
    0x61, 0xa0, 0x06, 0x00, 0x00, 0x80, 0x1b, 0xae, 
    0x91, 0xdf, 0xf9, 0xff, 0xff, 0x7f, 0x15, 0xd5, 
    0x01, 0xa1, 0x09, 0x00, 0x00, 0xc0, 0xfe, 0xa8,
    0x45, 0x65, 0x57, 0xfc, 0x5f, 0x64, 0x57, 0xdf, 
    0x01, 0xc1, 0x12, 0x04, 0x20, 0xa0, 0x01, 0xac, 
    0x11, 0x51, 0x15, 0xf3, 0x4f, 0xd1, 0x55, 0xd7,
    0x01, 0x81, 0x2a, 0xfd, 0x9f, 0x70, 0xf8, 0xaa, 
    0x45, 0x45, 0xf5, 0xdb, 0x3f, 0x7d, 0xc7, 0xd5, 
    0x01, 0x01, 0x1b, 0xe6, 0x7f, 0xa5, 0x81, 0xaa,
    0x11, 0x11, 0xf7, 0x79, 0x7e, 0x57, 0x91, 0xd5, 
    0x01, 0x01, 0x6a, 0x3c, 0xff, 0x49, 0x80, 0xaa, 
    0x45, 0xe5, 0x57, 0xde, 0x55, 0x55, 0xc4, 0xd5,
    0x01, 0x1f, 0x28, 0x3d, 0x00, 0x22, 0x80, 0xaa, 
    0xd1, 0x55, 0x95, 0xc9, 0xff, 0x77, 0x91, 0xd5, 
    0x31, 0x00, 0x90, 0xbe, 0xaa, 0x86, 0x81, 0xaa,
    0xcd, 0xff, 0x4f, 0x5c, 0xd5, 0x5d, 0xdf, 0xd5, 
    0x3f, 0x00, 0x4b, 0xf0, 0xfe, 0x0a, 0xe0, 0xaa, 
    0x59, 0xd5, 0x35, 0xd1, 0x6f, 0x7d, 0x55, 0xd5,
    0x61, 0x70, 0x27, 0xd0, 0xbf, 0xc3, 0x07, 0xaa, 
    0xc5, 0xcf, 0x55, 0xd4, 0xdf, 0x55, 0x7d, 0xd5, 
    0x01, 0x81, 0x12, 0xd0, 0x6f, 0xfc, 0xc3, 0xa9,
    0x11, 0x91, 0x1b, 0xd1, 0x77, 0x13, 0x5d, 0xdf, 
    0x01, 0x81, 0x0a, 0x90, 0x9b, 0x00, 0x30, 0xae, 
    0x45, 0x45, 0x4f, 0x24, 0x66, 0x44, 0xc4, 0xd5,
    0x01, 0xc1, 0x0a, 0x90, 0x17, 0x00, 0x80, 0xaa, 
    0x11, 0x51, 0x1b, 0xd1, 0x15, 0x11, 0x91, 0xd5, 
    0x01, 0x81, 0x0a, 0xd0, 0x26, 0x00, 0x80, 0xaa,
    0x45, 0xc5, 0x57, 0xd4, 0x65, 0x44, 0xc4, 0xd5, 
    0x01, 0x81, 0x12, 0x90, 0x26, 0x00, 0x80, 0xaa, 
    0x11, 0x91, 0x33, 0xb1, 0x55, 0x11, 0x91, 0xd5,
    0x01, 0x01, 0x27, 0xc0, 0x86, 0x00, 0x80, 0xaa, 
    0x45, 0x45, 0x45, 0xc4, 0xcd, 0x44, 0xc4, 0xd5, 
    0x01, 0xff, 0xc7, 0xff, 0x0a, 0xff, 0xff, 0xaa,
    0x91, 0x55, 0x5f, 0xd5, 0x15, 0x55, 0x55, 0xd5, 
    0xf1, 0x00, 0x2a, 0x00, 0x1b, 0x01, 0x00, 0xab, 
    0xdd, 0x55, 0x6d, 0x55, 0x55, 0x55, 0x55, 0xd7,
    0x7d, 0x01, 0x3c, 0x00, 0x1a, 0x01, 0x00, 0xac, 
    0x75, 0x55, 0x7d, 0x55, 0x17, 0x55, 0x55, 0xd5, 
    0x25, 0x01, 0x18, 0x00, 0x9c, 0x00, 0x00, 0xa8,
    0x95, 0x55, 0x55, 0x55, 0xf5, 0x55, 0x55, 0xdd, 
    0xd5, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0xb0, 
    0x7d, 0x55, 0x55, 0x55, 0xbd, 0x55, 0x55, 0xf5,
    0x0d, 0x00, 0x00, 0x00, 0xa8, 0x00, 0x00, 0xa0, 
    0x57, 0x55, 0x55, 0x55, 0x75, 0x55, 0x55, 0xd5, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },

  {
    /* Karo Dark Shadow */
    0x55, 0x05, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x00, 
    0x22, 0x42, 0x44, 0x64, 0x4d, 0x44, 0x44, 0x44, 
    0x55, 0x05, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00,
    0x88, 0x18, 0x11, 0x5d, 0x35, 0x11, 0x11, 0x11, 
    0x55, 0x05, 0x00, 0x02, 0xc0, 0x00, 0x00, 0x00, 
    0x22, 0x42, 0x44, 0x55, 0x55, 0x45, 0x44, 0x44,
    0x55, 0x05, 0xc0, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x88, 0x18, 0x71, 0x55, 0x55, 0x1d, 0x11, 0x11, 
    0x55, 0x05, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x22, 0x42, 0x5c, 0x55, 0x55, 0x75, 0x44, 0x44, 
    0x55, 0x05, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00, 
    0x88, 0x18, 0x55, 0x55, 0x55, 0x55, 0x11, 0x11,
    0x55, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
    0x22, 0x62, 0x55, 0x55, 0x55, 0x55, 0x4d, 0x44, 
    0x55, 0x15, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x88, 0x58, 0x55, 0x55, 0x55, 0x55, 0x35, 0x11, 
    0x55, 0x0d, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 
    0x22, 0x5b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45,
    0xd5, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0xe8, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x1d, 
    0x55, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0xaa, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0x57, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0xa9, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xae, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x75, 
    0x5d, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0xb0, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x1d, 
    0x75, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0xa2, 0x5a, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45,
    0x55, 0x07, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
    0x88, 0x5e, 0x55, 0x55, 0x55, 0x55, 0x75, 0x11, 
    0x55, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x22, 0x62, 0x55, 0x55, 0x55, 0x55, 0x4d, 0x44, 
    0x55, 0x85, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
    0x88, 0x18, 0x55, 0x55, 0x55, 0x55, 0x11, 0x11,
    0x55, 0x05, 0x06, 0x00, 0x00, 0x80, 0x00, 0x00, 
    0x22, 0x42, 0x5c, 0x55, 0x55, 0x75, 0x44, 0x44, 
    0x55, 0x05, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x88, 0x18, 0x71, 0x55, 0x55, 0x1d, 0x11, 0x11, 
    0x55, 0x05, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 
    0x22, 0x42, 0x44, 0x55, 0x55, 0x45, 0x44, 0x44,
    0x55, 0x05, 0x00, 0x06, 0x80, 0x00, 0x00, 0x00, 
    0x88, 0x18, 0x11, 0x59, 0x75, 0x11, 0x11, 0x11, 
    0x55, 0x05, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00,
    0x22, 0x42, 0x44, 0x64, 0x4d, 0x44, 0x44, 0x44, 
    0x55, 0x05, 0x00, 0x80, 0x06, 0x00, 0x00, 0x00, 
    0x88, 0x18, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, },


  {
    /* Chest Open */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x2b, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa8, 
    0xb7, 0x6a, 0x7d, 0x7d, 0xfd, 0xff, 0xab, 0xd6,
    0x2b, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xac, 
    0x37, 0xe2, 0xff, 0xff, 0xff, 0xff, 0x23, 0x96, 
    0x2b, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa8,
    0xa7, 0xc8, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xcc, 
    0x27, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a, 0x8c, 
    0x3d, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfc,
    0x3b, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xb9, 
    0x3d, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0x2b, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xbe,
    0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0x3b, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0x3b, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0xeb, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xbe, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0xeb, 0xee, 0xee, 0xee, 0xee, 0xee, 0xea, 0xbc,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0xdf, 
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x2b, 0xb8, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x23, 0xdc,
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0b, 0xbc, 
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xdc, 
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x03, 0xb8,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xf4, 
    0xab, 0xce, 0xee, 0xee, 0xee, 0xee, 0x03, 0xac, 
    0x3d, 0x66, 0xff, 0xff, 0xff, 0xff, 0x23, 0x96,
    0x3b, 0x80, 0xfe, 0xff, 0xff, 0xbf, 0x02, 0xa8, 
    0xbf, 0xc8, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xfc, 
    0x20, 0x40, 0xe8, 0xee, 0x6e, 0x00, 0x02, 0x84,
    0xb5, 0x6a, 0xfd, 0xff, 0x7f, 0x55, 0xab, 0xd6, 
    0x21, 0x00, 0xb0, 0xbb, 0x1b, 0x00, 0x02, 0x80, 
    0xb5, 0x6a, 0xf5, 0xff, 0x5f, 0x55, 0xab, 0xd6,
    0x20, 0x40, 0xe0, 0xcf, 0x4f, 0x00, 0x02, 0x84, 
    0xbf, 0xea, 0xff, 0x87, 0xcf, 0xff, 0xab, 0xfe, 
    0x2b, 0x80, 0xaa, 0x83, 0x83, 0xaa, 0x02, 0xa8,
    0xb5, 0x6a, 0xd5, 0x03, 0x44, 0x55, 0xab, 0xd6, 
    0x2a, 0xc0, 0xaa, 0xc2, 0xc3, 0xaa, 0x02, 0xac, 
    0xb5, 0x6a, 0xd5, 0x03, 0x40, 0x55, 0xab, 0xd6,
    0x2b, 0x80, 0xaa, 0xba, 0xbb, 0xaa, 0x02, 0xa8, 
    0xb5, 0x6a, 0x55, 0x55, 0x55, 0x55, 0xab, 0xd6, 
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, },

  {
    /* IronFloor_S */
      
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x7b, 0x7b, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
    0xbe, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x7b, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x73,
    0xbe, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xbe, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x7b, 0x7b, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
    0xbe, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },

  {
    /* Brick 0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80, 
    0x50, 0xd5, 0x51, 0xd5, 0x51, 0xd5, 0x55, 0xd5,
    0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 
    0x50, 0xd5, 0x51, 0xd5, 0x51, 0xd5, 0x55, 0xd5, 
    0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0,
    0xf8, 0xff, 0xf9, 0xff, 0xf9, 0xff, 0xfd, 0xff, 
    0xfc, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0xff, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc,
    0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5,
    0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
    0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 
    0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54,
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0x54, 0xd5, 0xfc, 
    0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0,
    0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 
    0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
    0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff,
    0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54,
    0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 
    0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 
    0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, },

  {
    /* SphereHalf Shadowed */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xee, 0xea, 0xaa, 0xaa, 0xee, 0xee, 0xfe, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff,
    0xff, 0xbb, 0xfb, 0xaa, 0xaa, 0xba, 0xbb, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xef, 0xee, 0xaa, 0xaa, 0xee, 0xee, 0xff,
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xbf, 0xfb, 0xaa, 0xaa, 0xba, 0xfb, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xee, 0xaa, 0xaa, 0xee, 0xfe, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xfb, 0xaa, 0xaa, 0xba, 0xff, 0xff,
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xaa, 0xaa, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
    0xff, 0x7f, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff,
    0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 
    0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0xff, 
    0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0xbf, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5,
    0xaf, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xab, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xab, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0xaf, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 
    0x5f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xf5,
    0xbb, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 
    0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 
    0xef, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee,
    0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xff, 
    0xbf, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xfb, 
    0xff, 0x7f, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xff,
    0xef, 0xef, 0x01, 0x00, 0x00, 0x00, 0xee, 0xee, 
    0xff, 0xff, 0x7f, 0x55, 0x55, 0xfd, 0xff, 0xff, 
    0xbf, 0xbb, 0xea, 0xaa, 0xaa, 0xbe, 0xbb, 0xfb, },

  {
    /* SphereLight_O */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xee, 0xea, 0xea, 0xaa, 0xee, 0xee, 0xfe, 
    0xff, 0xff, 0xff, 0x55, 0x55, 0xfd, 0xff, 0xff,
    0xff, 0xbb, 0xab, 0xeb, 0xaa, 0xab, 0xbb, 0xff, 
    0xff, 0xff, 0x57, 0xd5, 0x55, 0xd7, 0xff, 0xff, 
    0xff, 0xef, 0xab, 0x02, 0xab, 0xaa, 0xef, 0xff,
    0xff, 0x7f, 0x55, 0x55, 0x5d, 0x55, 0xfd, 0xff, 
    0xff, 0xbf, 0x02, 0x08, 0x90, 0xae, 0xfa, 0xff, 
    0xff, 0x5f, 0x55, 0x5d, 0xf5, 0x5f, 0xf5, 0xff,
    0xff, 0x2f, 0x02, 0x30, 0x20, 0xa8, 0xee, 0xff, 
    0xff, 0x57, 0x45, 0x54, 0x75, 0x55, 0xd7, 0xff, 
    0xff, 0x0b, 0x08, 0x88, 0x10, 0xa0, 0xaa, 0xff,
    0xff, 0x15, 0x11, 0x95, 0x57, 0x55, 0x55, 0xff, 
    0xff, 0x02, 0x20, 0x82, 0x15, 0x80, 0xab, 0xfe, 
    0xff, 0xe5, 0x40, 0x45, 0x5d, 0xd5, 0x55, 0xff,
    0xff, 0x1c, 0x81, 0x40, 0x31, 0x40, 0xaa, 0xfe, 
    0x7f, 0x17, 0x01, 0x50, 0xd1, 0xf5, 0x55, 0xfd, 
    0xff, 0x00, 0x02, 0x40, 0x01, 0x13, 0xab, 0xfa,
    0x5f, 0x05, 0x02, 0x60, 0x45, 0x5d, 0xf7, 0xf5, 
    0x3f, 0x00, 0xfc, 0x23, 0x01, 0x00, 0xbc, 0xeb, 
    0x5f, 0x01, 0x04, 0xfc, 0x11, 0x55, 0x55, 0xf7,
    0x2f, 0x00, 0x02, 0x40, 0x00, 0x00, 0xa8, 0xee, 
    0x57, 0x05, 0x01, 0x40, 0xc4, 0x55, 0x55, 0xdd, 
    0x0f, 0xc0, 0x00, 0x20, 0xb8, 0x00, 0xa0, 0xfa,
    0x57, 0x71, 0x00, 0x30, 0x97, 0x55, 0x75, 0xd5, 
    0x0b, 0x58, 0x00, 0xe0, 0x00, 0x01, 0xb8, 0xaa, 
    0x57, 0x65, 0x00, 0x74, 0x44, 0x55, 0x57, 0xd5,
    0x0b, 0x22, 0x00, 0x9c, 0x00, 0x81, 0xa1, 0xaa, 
    0xd7, 0x11, 0x11, 0x9b, 0x11, 0x75, 0x55, 0xd7, 
    0x4b, 0x10, 0xc0, 0x04, 0x01, 0x1a, 0xa0, 0xae,
    0x55, 0x55, 0x74, 0x44, 0x46, 0x57, 0x55, 0x5d, 
    0x0b, 0x08, 0x0c, 0x02, 0x04, 0x00, 0xa0, 0xbb, 
    0x55, 0x1d, 0x13, 0x11, 0x55, 0x55, 0xd5, 0x55,
    0x0a, 0x04, 0x82, 0x00, 0x08, 0x00, 0xb0, 0xaa, 
    0x55, 0x45, 0x45, 0x44, 0xf4, 0xff, 0x5f, 0x55, 
    0x2b, 0x00, 0x81, 0x00, 0x00, 0x03, 0xa8, 0xaa,
    0x57, 0x55, 0x91, 0x11, 0xd1, 0x55, 0x55, 0xd5, 
    0x2b, 0x00, 0x01, 0x01, 0x60, 0x00, 0xa8, 0xaa, 
    0x57, 0xd5, 0x45, 0x46, 0x5d, 0x55, 0x55, 0xd5,
    0xbb, 0x80, 0x00, 0x02, 0x06, 0x08, 0xa8, 0xaa, 
    0x7f, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0xfd, 
    0xef, 0x00, 0x00, 0x82, 0x00, 0x20, 0xaa, 0xee,
    0xff, 0x55, 0x55, 0x57, 0x55, 0x55, 0x55, 0xff, 
    0xbf, 0x03, 0x00, 0x41, 0x00, 0x80, 0xaa, 0xfb, 
    0xff, 0x5f, 0x55, 0x55, 0x55, 0x55, 0xf5, 0xff,
    0xef, 0x2e, 0x80, 0x00, 0x00, 0xa0, 0xee, 0xee, 
    0xff, 0xff, 0xdf, 0x55, 0x55, 0xf5, 0xff, 0xff, 
    0xbf, 0xbb, 0xea, 0x02, 0x80, 0xba, 0xbb, 0xfb, },
  
  {
    /* HexExtra Open */
    0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 
    0x01, 0x80, 0x06, 0x00, 0x00, 0xe0, 0x02, 0x00, 
    0x55, 0xd5, 0x5c, 0x55, 0x55, 0x5d, 0x57, 0x55,
    0x01, 0x40, 0x60, 0xb8, 0xfe, 0xaf, 0x06, 0x00, 
    0x55, 0x35, 0x51, 0xfd, 0xff, 0x5f, 0x5d, 0x55, 
    0x01, 0x20, 0xe8, 0xff, 0xff, 0xbf, 0x0a, 0x00,
    0x55, 0x55, 0xfd, 0xff, 0xff, 0x7f, 0x55, 0x55, 
    0x01, 0x08, 0xfe, 0xff, 0xff, 0xaf, 0x2a, 0x00, 
    0x55, 0x1d, 0xff, 0xff, 0xff, 0x57, 0x75, 0xd5,
    0x06, 0x04, 0xfe, 0xff, 0xff, 0xab, 0x6a, 0x60, 
    0x5d, 0x47, 0xff, 0xff, 0xff, 0x57, 0xd5, 0x5d, 
    0x60, 0x82, 0xff, 0xff, 0xff, 0xbf, 0xba, 0x06,
    0xd5, 0xd1, 0xff, 0xff, 0xff, 0xff, 0x77, 0x55, 
    0x80, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xaf, 0x02, 
    0xd5, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x57,
    0x40, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x06, 
    0x35, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0x5d, 
    0x20, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x0a,
    0x55, 0xd4, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x55, 
    0x08, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x2a, 
    0x9d, 0xf1, 0xff, 0xff, 0xff, 0xff, 0x5f, 0x77,
    0x64, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x6a, 
    0x1f, 0xfc, 0xfd, 0xff, 0xff, 0xff, 0x57, 0xd5, 
    0x06, 0xb8, 0xfe, 0xff, 0xff, 0xff, 0x03, 0xe0,
    0x01, 0x1c, 0xff, 0xff, 0xff, 0xff, 0x57, 0xd5, 
    0x02, 0x0a, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x80, 
    0x03, 0x01, 0xff, 0x7f, 0xff, 0xff, 0x57, 0xd5,
    0x84, 0x00, 0xfe, 0x3f, 0xfe, 0xeb, 0x0f, 0x40, 
    0x0d, 0x00, 0xff, 0x7f, 0xfd, 0xd5, 0x57, 0x75, 
    0x08, 0x80, 0xff, 0x3f, 0xaa, 0x87, 0x0e, 0x20,
    0x15, 0x00, 0xff, 0x7f, 0xf4, 0x57, 0x55, 0x55, 
    0x20, 0x80, 0xfa, 0x3f, 0x00, 0x02, 0x00, 0x08, 
    0x35, 0x00, 0xf0, 0x1f, 0x11, 0x55, 0x55, 0x5d,
    0x40, 0x00, 0xa0, 0x0f, 0x00, 0x04, 0x00, 0x04, 
    0xd5, 0x00, 0x40, 0x5d, 0x44, 0x54, 0x55, 0x57, 
    0x80, 0x00, 0x20, 0x08, 0x00, 0x08, 0x00, 0x02,
    0x55, 0x01, 0x20, 0x11, 0x11, 0x59, 0x55, 0x55, 
    0xc0, 0x02, 0x10, 0x00, 0x00, 0x10, 0x80, 0x06, 
    0x75, 0x03, 0x50, 0x44, 0x44, 0x54, 0xd5, 0x5d,
    0x0c, 0x04, 0x10, 0x00, 0x00, 0x10, 0x40, 0x60, 
    0x57, 0x0d, 0x18, 0x11, 0x11, 0x71, 0x75, 0xd5, 
    0x01, 0x08, 0x08, 0x00, 0x00, 0x20, 0x20, 0x00,
    0x55, 0x15, 0x44, 0x44, 0x44, 0x44, 0x55, 0x55, 
    0x01, 0x20, 0x04, 0x00, 0x00, 0x40, 0x08, 0x00, 
    0x55, 0x35, 0x14, 0x11, 0x11, 0x51, 0x5d, 0x55,
    0x01, 0x40, 0x02, 0x00, 0x00, 0x80, 0x04, 0x00, 
    0x55, 0xd5, 0x46, 0x44, 0x44, 0xc4, 0x57, 0x55, 
    0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, },

  {
    /* ChessFloor_S */
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55,
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 
    0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 
    0xaa, 0xaf, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00,
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff,
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, 
    0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xff, 0x0a, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0xaa, },

  {
    /* ChessSphere_O */
    0xff, 0x55, 0xd5, 0xff, 0xff, 0x55, 0x55, 0xff, 
    0xaa, 0x00, 0xf0, 0xea, 0xaa, 0x02, 0x00, 0xaa, 
    0xff, 0x55, 0xfd, 0x55, 0x55, 0x5d, 0x55, 0xff,
    0xaa, 0x00, 0xac, 0xeb, 0xaa, 0x2b, 0x00, 0xaa, 
    0xff, 0x55, 0x57, 0xd5, 0x55, 0x57, 0x55, 0xff, 
    0xaa, 0x00, 0xab, 0x02, 0xab, 0xaa, 0x03, 0xaa,
    0x55, 0xff, 0x55, 0x55, 0x5d, 0x55, 0xfd, 0x55, 
    0x00, 0xaa, 0x02, 0x08, 0x90, 0xae, 0xaa, 0x00, 
    0x55, 0x5f, 0x55, 0x5d, 0xf5, 0x5f, 0xf5, 0x55,
    0x00, 0x2a, 0x02, 0x30, 0x20, 0xa8, 0xae, 0x00, 
    0x55, 0x57, 0x45, 0x54, 0x75, 0x55, 0xd7, 0x55, 
    0x00, 0x0a, 0x08, 0x88, 0x10, 0xa0, 0xaa, 0x00,
    0x55, 0x15, 0x11, 0x95, 0x57, 0x55, 0x55, 0x55, 
    0x80, 0x02, 0x20, 0x82, 0x15, 0x80, 0xab, 0x02, 
    0xd5, 0xe5, 0x40, 0x45, 0x5d, 0xd5, 0x55, 0x57,
    0x80, 0x1c, 0x81, 0x40, 0x31, 0x40, 0xaa, 0x06, 
    0x55, 0x17, 0x01, 0x50, 0xd1, 0xf5, 0x55, 0x5d, 
    0x20, 0x00, 0x02, 0x40, 0x01, 0x13, 0xab, 0x1a,
    0x55, 0x05, 0x02, 0x60, 0x45, 0x5d, 0xf7, 0xf5, 
    0x2a, 0x00, 0xfc, 0x23, 0x01, 0x00, 0xbc, 0xab, 
    0x5f, 0x01, 0x04, 0xfc, 0x11, 0x55, 0x55, 0xf7,
    0x2a, 0x00, 0x02, 0x40, 0x00, 0x00, 0xa8, 0xae, 
    0x57, 0x05, 0x01, 0x40, 0xc4, 0x55, 0x55, 0xdd, 
    0x0e, 0xc0, 0x00, 0x20, 0xb8, 0x00, 0xa0, 0xfa,
    0x57, 0x71, 0x00, 0x30, 0x97, 0x55, 0x75, 0xd5, 
    0x0a, 0x58, 0x00, 0xe0, 0x00, 0x01, 0xb8, 0xaa, 
    0x57, 0x65, 0x00, 0x74, 0x44, 0x55, 0x57, 0xd5,
    0x0a, 0x22, 0x00, 0x9c, 0x00, 0x81, 0xa1, 0xaa, 
    0xd7, 0x11, 0x11, 0x9b, 0x11, 0x75, 0x55, 0xd7, 
    0x4a, 0x10, 0xc0, 0x04, 0x01, 0x1a, 0xa0, 0xae,
    0x55, 0x55, 0x74, 0x44, 0x46, 0x57, 0x55, 0x5d, 
    0x0a, 0x08, 0x0c, 0x02, 0x04, 0x00, 0xa0, 0xbb, 
    0x55, 0x1d, 0x13, 0x11, 0x55, 0x55, 0xd5, 0x55,
    0x0a, 0x04, 0x82, 0x00, 0x08, 0x00, 0xb0, 0xaa, 
    0x55, 0x45, 0x45, 0x44, 0xf4, 0xff, 0x5f, 0x55, 
    0x2a, 0x00, 0x81, 0x00, 0x00, 0x03, 0xa8, 0xaa,
    0x57, 0x55, 0x91, 0x11, 0xd1, 0x55, 0x55, 0xd5, 
    0x2c, 0x00, 0x01, 0x01, 0x60, 0x00, 0xa8, 0xaa, 
    0x55, 0xd5, 0x45, 0x46, 0x5d, 0x55, 0x55, 0xd5,
    0xb8, 0x80, 0x00, 0x02, 0x06, 0x08, 0xa8, 0x2a, 
    0x75, 0x55, 0x55, 0xd5, 0x55, 0x55, 0x55, 0x5d, 
    0xc0, 0x00, 0x00, 0x82, 0x00, 0x20, 0xaa, 0x02,
    0xff, 0x55, 0x55, 0x57, 0x55, 0x55, 0x55, 0xff, 
    0xaa, 0x06, 0x00, 0x41, 0x00, 0x80, 0xaa, 0xaa, 
    0xff, 0x5d, 0x55, 0x55, 0x55, 0x55, 0x75, 0xff,
    0xaa, 0x38, 0x80, 0x00, 0x00, 0xa0, 0x1e, 0xaa, 
    0xff, 0xf5, 0x5f, 0x55, 0x55, 0xf5, 0x57, 0xff, 
    0xaa, 0x80, 0xba, 0x02, 0x80, 0x1a, 0x00, 0xaa, },

  {
    /* LEgoFloor_S */
    0xff, 0xff, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xba, 0xae, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 
    0x57, 0xf5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xaa, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0,
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0xfd, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0xba, 0xbe, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 
    0xf7, 0xdf, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xae, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba,
    0xdf, 0xff, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 
    0xf7, 0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xf7, 0xff, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xba, 0xae, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac,
    0x57, 0xf5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0xaa, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0,
    0x57, 0xfd, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xba, 0xbe, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc, 
    0xf7, 0xff, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57,
    0xaa, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 
    0xdf, 0xff, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab,
    0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57,
    0xba, 0xae, 0x1a, 0xac, 0x1a, 0xac, 0x1a, 0xac, 
    0x57, 0xf5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0,
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xaa, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0x02, 0xa0, 
    0x57, 0xf5, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75,
    0xae, 0xba, 0x06, 0xb0, 0x06, 0xb0, 0x06, 0xb0, 
    0x57, 0xfd, 0x57, 0x75, 0x57, 0x75, 0x57, 0x75, 
    0xba, 0xbe, 0x1a, 0xbc, 0x1a, 0xbc, 0x1a, 0xbc,
    0xf5, 0xff, 0xf5, 0x57, 0xf5, 0x57, 0xf5, 0x57, 
    0xae, 0xba, 0xa6, 0xba, 0xa6, 0xba, 0xa6, 0xba, 
    0xdf, 0xff, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d,
    0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 0xea, 0xab, 
    0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, },

  {
    /* LEgoBlack_O */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xba, 0x93, 0x3b, 0xf3, 0xe7, 0x73, 0xe2, 0x73, 
    0x7e, 0xe7, 0x7f, 0xaf, 0xfa, 0x8f, 0xef, 0x2f,
    0x6e, 0xe9, 0xee, 0xee, 0xfb, 0xef, 0xce, 0x6f, 
    0xfe, 0xfe, 0xff, 0x9d, 0xfc, 0xf7, 0x3f, 0x1f, 
    0xba, 0xbb, 0xbb, 0xd3, 0xfd, 0xbb, 0xbb, 0x5e,
    0xfe, 0xff, 0xff, 0x8f, 0xfc, 0xfb, 0xff, 0x19, 
    0xee, 0xee, 0xee, 0xce, 0xf9, 0xed, 0xee, 0x46, 
    0xfe, 0xff, 0xff, 0x8f, 0xf8, 0xfe, 0xff, 0x0f,
    0xba, 0xbb, 0xbb, 0x9b, 0x65, 0xbb, 0xbb, 0x1b, 
    0xfe, 0xff, 0xff, 0x7f, 0x12, 0xff, 0xff, 0x7f, 
    0xee, 0xee, 0xee, 0xee, 0x68, 0xee, 0xee, 0x6e,
    0xfe, 0xff, 0xff, 0xff, 0x23, 0xff, 0xff, 0x7f, 
    0xba, 0xbb, 0xbb, 0xbb, 0x1b, 0xbb, 0xbb, 0x3b, 
    0xfe, 0xff, 0xff, 0xff, 0x87, 0xff, 0xff, 0x7f,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x6e, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 
    0xba, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x63,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2b, 
    0xe2, 0xee, 0xee, 0xee, 0x6e, 0xee, 0xee, 0x6a, 
    0xec, 0xff, 0xff, 0xff, 0xbf, 0xf9, 0xff, 0x1d,
    0x9c, 0xbb, 0xbb, 0xbb, 0xbb, 0xa7, 0xbb, 0x5c, 
    0xdc, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0x13, 
    0xb8, 0xee, 0xee, 0xee, 0xee, 0xcf, 0xee, 0x4e,
    0xd8, 0xff, 0xff, 0xff, 0xef, 0xcf, 0xff, 0x3f, 
    0xa4, 0xbb, 0xbb, 0xbb, 0xe3, 0x93, 0xbb, 0x3b, 
    0xe2, 0xff, 0xff, 0xff, 0x17, 0x2c, 0xff, 0x7f,
    0xea, 0xee, 0xee, 0xee, 0xe6, 0xef, 0xee, 0x6e, 
    0xe2, 0xff, 0xff, 0xff, 0xa7, 0xa3, 0xfc, 0x7f, 
    0xae, 0xbb, 0xbb, 0xbb, 0x13, 0xfc, 0xbb, 0x3b,
    0xea, 0xff, 0xff, 0xff, 0xab, 0xaa, 0xfa, 0x7f, 
    0xee, 0xee, 0xee, 0xee, 0xfa, 0xff, 0xe7, 0x6e, 
    0xe0, 0xff, 0xff, 0xff, 0x01, 0x00, 0xe0, 0x7f,
    0x9e, 0xbb, 0xbb, 0xbb, 0xfd, 0xff, 0x9f, 0x3b, 
    0xde, 0xff, 0xff, 0xff, 0xfe, 0xff, 0x7f, 0x7f, 
    0xbe, 0xee, 0xee, 0xee, 0xfe, 0xff, 0xff, 0x6c,
    0xbe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x73, 
    0x7e, 0xbb, 0xb9, 0xbb, 0xfe, 0xff, 0xff, 0x2f, 
    0x7e, 0xff, 0xe6, 0x7f, 0xff, 0xff, 0xff, 0x1f,
    0xfe, 0x6e, 0x9f, 0x6e, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xbe, 0x7f, 0x7e, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xd9, 0xff, 0x39, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xed, 0xff, 0xa7, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xf3, 0xff, 0x9f, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },

  {
    /* CityFree_S */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x23, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,
    0x89, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x23, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x89, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x32, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x55, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x98, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x55, 0x15, 0x11, 0x11, 0x11, 0x51, 0x15, 0x11, 
    0x32, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x55, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54,
    0x98, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x23, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x89, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x23, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x89, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x32, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x55, 0x54, 0x54, 0x55, 0x54, 0x54, 0x54,
    0x98, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x15, 0x11, 0x51, 0x15, 0x11, 0x11, 0x11, 
    0x32, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x55, 0x55, 0x54, 0x54, 0x55, 0x54, 0x54, 0x54, 
    0x98, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x23, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
    0x89, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x55, 0x55, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
    0x23, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x55, 0x55, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45,
    0x89, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x3a, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x55, 0x55, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x9a, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x15, 0x11, 0x11, 0x11, 0x51, 0x15, 0x51,
    0x3a, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x55, 0x55, 0x54, 0x54, 0x54, 0x54, 0x55, 0x54, 
    0x9a, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, },

  {
    /* LightHouse_O */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
    0xb1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x8a,
    0x55, 0x00, 0x00, 0x54, 0x15, 0x00, 0x00, 0xdd, 
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a, 
    0x55, 0x54, 0x55, 0x54, 0x15, 0x55, 0x15, 0xdd,
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a, 
    0x55, 0x54, 0x55, 0x54, 0x15, 0x55, 0x15, 0xdd, 
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a,
    0x55, 0x54, 0x55, 0x54, 0x15, 0x55, 0x15, 0xdd, 
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a, 
    0x55, 0x54, 0x55, 0x54, 0x15, 0x55, 0x15, 0xdd,
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a, 
    0x55, 0x54, 0x55, 0x54, 0x15, 0x55, 0x15, 0xdd, 
    0xb1, 0x00, 0x00, 0xaa, 0x2a, 0x00, 0x80, 0x8a,
    0x55, 0x00, 0x00, 0x54, 0x15, 0x00, 0x00, 0xdd, 
    0xb1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x8a, 
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0x81, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x80,
    0xd5, 0x54, 0xd5, 0x54, 0xd5, 0xff, 0xff, 0xd4, 
    0xc1, 0xff, 0xff, 0x00, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0x55, 0xaa, 0xaa, 0xd4,
    0xc1, 0xaa, 0xaa, 0x00, 0x40, 0x55, 0x95, 0x80, 
    0xff, 0xbb, 0xbb, 0xfc, 0x7f, 0xaa, 0xaa, 0xff, 
    0xc1, 0xee, 0xee, 0x80, 0x40, 0xff, 0xbf, 0x80,
    0xd5, 0xaa, 0xaa, 0xd4, 0x54, 0xaa, 0xaa, 0xd5, 
    0xc1, 0xaa, 0xaa, 0x80, 0x40, 0xff, 0xbf, 0x80, 
    0xd5, 0xbb, 0xbb, 0xd4, 0x54, 0xaa, 0xaa, 0xd5,
    0xc1, 0xee, 0xee, 0x80, 0x40, 0xff, 0xbf, 0x80, 
    0xd5, 0xaa, 0xbe, 0xd4, 0x54, 0xaa, 0xaa, 0xd5, 
    0xc1, 0xaa, 0xa2, 0x80, 0x40, 0xff, 0xbf, 0x80,
    0xff, 0xbb, 0xa3, 0xfc, 0x7f, 0xaa, 0xaa, 0xff, 
    0xc1, 0xee, 0xfe, 0x00, 0x40, 0x00, 0x80, 0x80, 
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0xff, 0xff, 0xd4,
    0xc1, 0xaa, 0xaa, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xd5, 0xbb, 0xbb, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xc1, 0xee, 0xee, 0x00, 0x80, 0x00, 0x80, 0x80,
    0xd5, 0xaa, 0xaa, 0x54, 0xd5, 0x54, 0xd5, 0xd4, 
    0xc1, 0xaa, 0xaa, 0x00, 0x80, 0x00, 0x80, 0x80, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },

  {
    /* DarkWay_S */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa,
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff,
    0xbf, 0xaa, 0x02, 0xa0, 0x02, 0xa0, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xaf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa0, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5, 
    0xab, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x53, 0xf5,
    0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0xa0, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xbf, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xff, 0xbf, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa,
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xff, 0xaf, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff,
    0xff, 0xab, 0x02, 0xa0, 0x02, 0xa0, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, },

  {
    /* Pumpkin_S */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xba, 0xaa, 0xba, 0xaa, 0xaa,
    0xff, 0xff, 0x53, 0xf5, 0x53, 0xf5, 0xff, 0xff, 
    0xaa, 0xaa, 0xaa, 0xda, 0xaa, 0xba, 0xaa, 0xaa, 
    0xff, 0xff, 0x53, 0x5d, 0xfb, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0x02, 0x04, 0xac, 0xea, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x57, 0xfd, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xeb, 0x01, 0xfc, 0xff, 0xff, 0xff,
    0xff, 0x5f, 0xff, 0x55, 0xfd, 0xf5, 0xbf, 0xfd, 
    0x6a, 0x2b, 0xfa, 0x00, 0x78, 0x81, 0x3f, 0xfe, 
    0x7f, 0x57, 0xf5, 0x55, 0x7d, 0xd5, 0x5f, 0xf4,
    0x8e, 0x8e, 0x78, 0x00, 0x08, 0x01, 0x0f, 0xec, 
    0x57, 0x57, 0x75, 0x55, 0x55, 0x55, 0x17, 0xf5, 
    0x3a, 0x22, 0x22, 0x00, 0x00, 0x01, 0x06, 0xfa,
    0x57, 0x57, 0x75, 0x55, 0x55, 0x55, 0x47, 0xe2, 
    0x9a, 0x8a, 0x28, 0x00, 0x00, 0x01, 0x02, 0xf2, 
    0x55, 0x55, 0x75, 0x55, 0x55, 0x55, 0x13, 0xdb,
    0x39, 0x26, 0x22, 0x00, 0x04, 0x01, 0x11, 0xb9, 
    0x6d, 0x5f, 0x75, 0x55, 0xdf, 0x55, 0x7d, 0xd5, 
    0xb9, 0xb4, 0x28, 0x00, 0x91, 0x80, 0x98, 0xbd,
    0xf9, 0xd5, 0x55, 0xd5, 0xd5, 0xd5, 0x75, 0xd7, 
    0x59, 0x84, 0x62, 0x40, 0xa0, 0x40, 0x24, 0xb2, 
    0x5d, 0xd4, 0xff, 0x75, 0xd5, 0xd5, 0x77, 0xd5,
    0x29, 0x44, 0xc0, 0x20, 0x80, 0xc0, 0xa8, 0xb8, 
    0x3b, 0xd5, 0xff, 0x55, 0xd5, 0xd5, 0x7f, 0xd5, 
    0x0a, 0x04, 0x20, 0x0a, 0x00, 0x39, 0x22, 0xe2,
    0x4f, 0x54, 0x75, 0x5f, 0x55, 0x57, 0x75, 0xd5, 
    0x16, 0x04, 0x20, 0x04, 0x00, 0x8a, 0xa8, 0xe8, 
    0x17, 0x55, 0x75, 0x55, 0x55, 0x57, 0x75, 0xf5,
    0x1a, 0x04, 0x20, 0x00, 0x00, 0x22, 0x26, 0xfa, 
    0x5f, 0x5c, 0x75, 0x55, 0x55, 0x57, 0x57, 0xfd, 
    0x3a, 0x08, 0x22, 0x38, 0xb0, 0xcb, 0x9c, 0xf8,
    0x3f, 0x59, 0x5d, 0xc7, 0x0d, 0x36, 0x5b, 0xfd, 
    0x6a, 0x08, 0xf1, 0x01, 0x63, 0xc8, 0x2c, 0xfe, 
    0xff, 0xd4, 0x42, 0x1c, 0x98, 0x31, 0x5f, 0xff,
    0xaa, 0x11, 0xc5, 0x63, 0x66, 0xce, 0x8c, 0xff, 
    0xff, 0x73, 0x3b, 0x9c, 0xd9, 0x71, 0xd5, 0xff, 
    0xaa, 0x2e, 0xc4, 0x63, 0x86, 0x2e, 0xf2, 0xff,
    0xff, 0x5f, 0x7d, 0xd5, 0xd5, 0x55, 0xfd, 0xff, 
    0xaa, 0xea, 0x00, 0x01, 0xc0, 0x88, 0xfe, 0xff, 
    0xff, 0xff, 0x57, 0x57, 0x55, 0xf5, 0xff, 0xff,
    0xaa, 0xaa, 0x1f, 0x04, 0x20, 0xfe, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x5b, 0xd5, 0xff, 0xff, 0xff, 
    0xaa, 0xaa, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, },

};



