/***********************************************************************
 *
 *	xwdtomatd.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/***********************************************************************
 *	include files
 **********************************************************************/

/*
 * standard io defs
 */
#include  <stdio.h>
/*
 * X library defines
 */
#include  <X11/Xlib.h>
/*
 * more X library type defs
 */
#include  <X11/Xmd.h>
/*
 * more client exerciser type defs
 */
#include  <xtm.h>
/*
 * definitions for the xwd format file
 */
#include  <X11/XWDFile.h>

/***********************************************************************
 *	external variables
 **********************************************************************/

extern FILE	*G_msg_file;
extern int	G_checksum_flag;
extern int	errno;

/***********************************************************************
 *	function declarations
 **********************************************************************/

void	readchk();
void	swaplong();
void	swapshort();
char	*malloc();

/***********************************************************************
 *	functions
 **********************************************************************/

/***********************************************************************
 *
 *	read_match_data_from_xwd
 *
 *	Reads the match data structure from an xwd format file.
 *	Much of this code is adapted from the xwud client source.
 */
void
read_match_data_from_xwd(xwd_fd, match_data_ptr, playback_info_ptr)
/*
 * file descriptor of the xwd format file
 */
int			xwd_fd;
/*
 * points to the structure containing the match information
 */
struct match_data	*match_data_ptr;
/*
 * points to the structure containing the playback information
 */
struct playback_info	*playback_info_ptr;
{
	/*
	 * holds the xwd header information
	 */
	XWDFileHeader	header;
	/*
	 * holds the size of the window name
	 */
	int		window_name_size;
	/*
	 * used as a flag for determining if the header information
	 * needs to be byte-swapped
	 */
	unsigned long	swaptest = 1;
	/*
	 * used to count through the color maps
	 */
	INT32		i;

	/*
	 * read in the header information
	 */
	readchk(xwd_fd,
		(char *) &header,
		sizeof(header),
		"error while reading xwd header from xwd file\n");
	/*
	 * byte-swap the header if needed
	 */
	if (*(char *) &swaptest)
	{
		swaplong((char *) &header, sizeof(header));
	}
	/*
	 * check to see if the xwd format file is in the proper format
	 */
	if (header.file_version != XWD_FILE_VERSION)
	{
		(void) fprintf(G_msg_file,
			       "xwd file format version mismatch\n");
		exit(1);
	}
	/*
	 * check to see if the header is too small
	 */
	if (header.header_size < sizeof(header))
	{
		(void) fprintf(G_msg_file, "xwd header size is too small\n");
		exit(1);
	}
	/*
	 * figure out the window name size
	 */
	window_name_size = header.header_size - sizeof(header);
	/*
	 * if the window name is too long, then error
	 */
	if (window_name_size > MAXPATH)
	{
		(void) fprintf(G_msg_file, "window name is too long\n");
		exit(1);
	}
	/*
	 * read in the window name
	 */
	readchk(xwd_fd,
		match_data_ptr->window_name,
		(unsigned int) window_name_size,
		"error while reading window name from xwd file\n");
	/*
	 * Load up the rest of the match data structure.  The screen number,
	 * x and y coordinates of the window the image data was recorded from,
	 * the match data type, the count of compressed match image data,
	 * and the file descriptor for the temp file containing the
	 * compressed match image data must be set by the calling routine
	 */
	match_data_ptr->window_width        = (int) header.window_width;
	match_data_ptr->window_height       = (int) header.window_height;
	match_data_ptr->window_border_width = (int) header.window_bdrwidth;
	match_data_ptr->width               = (int) header.pixmap_width;
	match_data_ptr->height              = (int) header.pixmap_height;
	match_data_ptr->depth               = (int) header.pixmap_depth;
	match_data_ptr->format              = (int) header.pixmap_format;
	match_data_ptr->xoffset             = (int) header.xoffset;
	match_data_ptr->byte_order          = (int) header.byte_order;
	match_data_ptr->bitmap_unit         = (int) header.bitmap_unit;
	match_data_ptr->bitmap_bit_order    = (int) header.bitmap_bit_order;
	match_data_ptr->bitmap_pad          = (int) header.bitmap_pad;
	match_data_ptr->bytes_per_line      = (int) header.bytes_per_line;
	match_data_ptr->bits_per_pixel      = (int) header.bits_per_pixel;
	match_data_ptr->visual_class        = (int) header.visual_class;
	match_data_ptr->red_mask            = (unsigned long) header.red_mask;
	match_data_ptr->green_mask          = (unsigned long) header.green_mask;
	match_data_ptr->blue_mask           = (unsigned long) header.blue_mask;
	match_data_ptr->bits_per_rgb        = (int) header.bits_per_rgb;
	match_data_ptr->colormap_entries    = (int) header.colormap_entries;
	match_data_ptr->ncolors             = (int) header.ncolors;
	/*
	 * The window_x and window_y values in the header structure are
	 * misnamed.  They actually contain the absolute coordinates of
	 * the image data.  They are normally used by xwud to create a
	 * window in the correct place on the screen that just fits
	 * the image data.  We have to compute the x and y offsets in 
	 * the window from the absolute coordinates.
	 */
	match_data_ptr->x = (int) header.window_x -
			    (match_data_ptr->window_x +
			     match_data_ptr->window_border_width);
	match_data_ptr->y = (int) header.window_y -
			    (match_data_ptr->window_y +
			     match_data_ptr->window_border_width);
	/*
	 * set the retry count
	 */
	match_data_ptr->retry = playback_info_ptr->retries;
	/*
	 * set the retry interval
	 */
	match_data_ptr->intv = playback_info_ptr->interval;
	/*
	 * if there are any color map entries, read them in
	 */
	if (match_data_ptr->ncolors > 0)
	{
		/*
		 * allocate the space needed to hold the color map entries
		 */
		if ((match_data_ptr->color_ptr =
		     (XColor *) malloc(sizeof(XColor) *
				       match_data_ptr->ncolors)) ==
		    (XColor *) 0)
		{
			(void) fprintf(G_msg_file,
				       "error %d while mallocing color map entries\n",
				       errno);
			exit(1);
		}
		/*
		 * read the color map entries in
		 */
		readchk(xwd_fd,
			(char *) match_data_ptr->color_ptr,
			(sizeof(XColor) * match_data_ptr->ncolors),
			"error while reading color map entries from xwd file\n");
		/*
		 * byte_swap the color map entries if needed
		 */
                if (*(char *) &swaptest)
                {
                        for (i = 0; i < match_data_ptr->ncolors; i++)
                        {
                                swaplong((char *) &(match_data_ptr->color_ptr[i].pixel),
                                         sizeof(long));
                                swapshort((char *) &(match_data_ptr->color_ptr[i].red),
                                          (3 * sizeof(short)));
                        }
                }
	}
	else
	{
		/*
		 * there are no color map entries
		 */
		match_data_ptr->color_ptr = (XColor *) 0;
	}
	/*
	 * if using checksums, read the checksum value in
	 */
	if (G_checksum_flag)
	{
		readchk(xwd_fd,
			(char *) &(match_data_ptr->checksum),
			sizeof(match_data_ptr->checksum),
			"error while reading match data checksum from xwd file\n");
	}
}
