/**********************************************************************
 *
 *	xtmrecord.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * constants for open
 */
#include <fcntl.h>
/*
 * contains NULL constant
 */
#include <stdio.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * X windows library
 */
#include <X11/Xlib.h>
/*
 * client exerciser constants
 */
#include <xtm.h>
/*
 * client exerciser defines
 */
#include <X11/extensions/xtestext1.h>

/**********************************************************************
 * external variables
 **********************************************************************/

extern int		XTestInputActionType;
extern int		errno;
extern char		version[];
extern int		moveX;
extern int		move16Y;

/**********************************************************************
 * variables
 **********************************************************************/

/*
 * ???
 */
int			G_motcnt = 0;
/*
 * ???
 */
int			G_jmpcnt = 0;
/*
 * buffer for saved input actions
 */
unsigned char		G_ia_buffer[INPUT_ACTION_BUFFER_SIZE];
/*
 * current index into buf
 */
int			G_ia_count;
/*
 * # of time input actions to skip
 */
int			G_timecnt;
/*
 * X server display pointer - initialized in MAIN
 */
Display			*G_disp_ptr;
/*
 * Buffer for screen matches
 */
unsigned char		*G_c_data_buffer;
/*
 * Buffer for screen matches
 */
unsigned char		*G_sb;
/*
 * Buffer for screen matches
 */
unsigned int		G_sb_size;
/*
 * invocation options
 */
int			G_debug_flag;
/*
 * device file pointers
 */
FILE			*G_msg_file;
/*
 * retries, intervals
 */
struct playback_info	G_playback_info;
/*
 * keycode corresponding to the "command" key
 */
KeyCode			G_command_key;
/*
 * keycode corresponding to the "toggle checksum mode" key
 */
KeyCode			G_checksum_key;
/*
 * keycode corresponding to the "match the window the mouse is in" key
 */
KeyCode			G_matchmouse_key;
/*
 * keycode corresponding to the "match screen" key
 */
KeyCode			G_matchscreen_key;
/*
 * keycode corresponding to the "match the top window" key
 */
KeyCode			G_matchtop_key;
/*
 * keycode corresponding to the "quit" key
 */
KeyCode			G_quit_key;
/*
 * keycode corresponding to the "resume" key
 */
KeyCode			G_resume_key;
/*
 * keycode corresponding to the "match a partial window" key
 */
KeyCode			G_matchpartial_key;
/*
 * keycode corresponding to the "accept partial window" key
 */
KeyCode			G_acceptpartial_key;
/*
 * keycode corresponding to the "reject partial window" key
 */
KeyCode			G_rejectpartial_key;
/*
 * name of the "command" key
 */
char			G_command_string[MAXPATH];
/*
 * name of the "toggle checksum mode" key
 */
char			G_checksum_string[MAXPATH];
/*
 * name of the "match the window the mouse is in" key
 */
char			G_matchmouse_string[MAXPATH];
/*
 * name of the "match screen" key
 */
char			G_matchscreen_string[MAXPATH];
/*
 * name of the "match the top window" key
 */
char			G_matchtop_string[MAXPATH];
/*
 * name of the "quit" key
 */
char			G_quit_string[MAXPATH];
/*
 * name of the "resume" key
 */
char			G_resume_string[MAXPATH];
/*
 * name of the "match a partial window" key
 */
char			G_matchpartial_string[MAXPATH];
/*
 * name of the "accept partial window" key
 */
char			G_acceptpartial_string[MAXPATH];
/*
 * name of the "reject partial window" key
 */
char			G_rejectpartial_string[MAXPATH];
/*
 * if true, then read all match data from the root window
 */
int			G_read_from_root_flag;
/*
 * if true then use checksums for matches
 */
int			G_checksum_flag;

/*
 * flag indicating an interactive COMMAND MODE operation
 */
  unsigned int            interaction_mode  = False;

/**********************************************************************
 * function definitions
 **********************************************************************/

int	XTestGetInput();
int	XTestStopInput();
KeyCode	XKeysymToKeycode();
KeySym	XStringToKeysym();
void	output_version_number();
int	getmouse();
int	gettop();
int	getroot();
void	chk_copy();
void	write_input_actions();
int     xerror();
void	wintotemp();
void	temptoint();
char    *malloc();
char	*strcpy();
void	usage();
long	atol();
int	init_getbox_params();
int	init_getbox();
Bool	get_box_posn();
int	get_rect_window();
int	box_key_interaction();
void	move_box();
Bool	jump_box();
Bool	flush_moves();
void	delay();
void	wrchk();
void	sigcatch();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	input.c
 *
 *	This function contains the main loop used to process input data.
 *	It is called in input mode.  Loop is terminated when the 'quit'
 *	key is pressed.
 */
static void
input(script_fd, script_name)
/*
 * file descriptor of internal format test script file
 */
int	script_fd;
/*
 * pointer to name of test script
 */
char	*script_name;
{
	/*
	 * code from input_functions
	 */
	int			quit;
	/*
	 * current input event
	 */
	XEvent			event;
	/*
	 * mode for client exerciser
	 */
	unsigned char		mode = RECORD_ACTIONS_MODE;
	/*
	 * ???
	 */
	XTestInputActionEvent	*action_event_ptr;

	/*
	 * catch signals
	 */
	sigcatch();
	/*
	 * output version information
	 */
	output_version_number(script_fd);
	/*
	 * begin saving input
	 * this function is defined in the X testing extension to Xlib
	 */
	XTestGetInput(G_disp_ptr, XTestPACKED_ACTIONS);

	(void) printf("\nTo enter command mode, press '%s'.  Then:\n\n",
		      G_command_string);
	(void) printf("    To match the window containing the mouse...press '%s'.\n",
		      G_matchmouse_string);
	(void) printf("    To match a partial window area.............press '%s'.\n",
		      G_matchpartial_string);
	(void) printf("    To match the top window....................press '%s'.\n",
		      G_matchtop_string);
	(void) printf("    To match the entire screen.................press '%s'.\n",
		      G_matchscreen_string);
	(void) printf("    To resume recording input actions..........press '%s'.\n",
		      G_resume_string);
	(void) printf("    To quit recording input actions............press '%s'.\n",
		      G_quit_string);
	(void) printf("    To toggle checksum mode....................press '%s'.\n",
		      G_checksum_string);
	(void) printf("\n");
	fflush(stdout);

	/*
	 * loop until quit key pressed in command mode
	 */
	for (quit = 0; quit < 1;)
	{
		XNextEvent(G_disp_ptr, &event);
		/*
		 * Since we don't request any events from the server,
		 * the only events we should get should be from the
		 * input synthesis extension.
		 */
		if (event.type == XTestInputActionType)
		{
			action_event_ptr = (XTestInputActionEvent *) &event;
			quit = check_pkt(script_fd,
					 script_name,
					 &(action_event_ptr->actions[0]),
					 &mode);
		}
		else
		{
			(void) fprintf(G_msg_file,
				       "got some other event, type=%x\n",
				       event.type);
		}
	}
	/*
	 * stop saving input
	 * this function is defined in the X testing extension to Xlib
	 */
	if (XTestStopInput(G_disp_ptr) == -1)
	{
		(void) fprintf(G_msg_file, "XTestStopInput failed\n");
		exit(1);
	}
	XSync(G_disp_ptr, 0);
	if (G_ia_count > 0)
	{
		write_input_actions(script_fd);
	}
	(void) printf("program terminated.\n");
}

/**********************************************************************
 *
 *	output_version_number
 *
 *	This function outputs the version number to a test script.
 */
static void
output_version_number(script_fd)
/*
 * file descriptor of internal format test script file
 */
int	script_fd;
{
	/*
	 * holds the version number temporarily
	 */
	int	temp;
	/*
	 * holds the version number string
	 */
	char	buf[WRITE_BUFFER_SIZE];

	/*
	 * put the version number into the correct type of variable
	 */
	temp =  VERSION_NUMBER;
	/*
	 * write the version number to a string
	 */
	(void) sprintf(buf, "v%d ", temp);
	/*
	 * write the string to the test script
	 */
	wrchk(script_fd, buf);
}

/**********************************************************************
 *
 *	check_pkt
 *
 *	This function processes the keys or other input data in the
 *	current event.  It buffers them up, and writes them to a file.
 */
static int
check_pkt(script_fd, script_name, input_action_buffer_start, mode)
/*
 * file descriptor of internal format test script file
 */
int	script_fd;
/*
 * pointer to name of test script
 */
char	*script_name;
/*
 * pointer to first input action in the event
 */
unsigned char		*input_action_buffer_start;
/*
 * current client exerciser mode
 */
unsigned char		*mode;
{
	/*
	 * type of input action
	 */   
	char		type;
	/*
	 * keycode of current key
	 */
	KeyCode		code;
	/*
	 * direction of key
	 */
	unsigned char	dir;
	/*
	 * pointer to current input action
	 */
	unsigned char	*iaptr;
	/*
	 * log key if 0
	 */
	int		key_ret = 0;
	/*
	 * terminate test if 1
	 */
	unsigned char	quit = 0;
	/*
	 * flag for loop
	 */
	int		pkt_done  = 0;
	/*
	 * ???
	 */
	XTestDelayInfo	dummyt;
	/*
	 * ???
	 */
	XTestMotionInfo	dummym;
	/*
	 * ???
	 */
	XTestKeyInfo	*fk;
	/*
	 * ???
	 */
	XTestMotionInfo	*fm;
	/*
	 * ???
	 */
	XTestJumpInfo	*fj;
	/*
	 * ???
	 */
	XTestDelayInfo	*ft;

        int     accepted;       /* transient flag showing interactive move*/

	dummyt.header = XTestPackDeviceID(XTestDELAY_DEVICE_ID);
	dummyt.pad1 = 0;
	dummyt.pad2 = 0;
	dummyt.delay_time = 2;

	dummym.header = XTestMOTION_ACTION;
	dummym.header |= XTestPackDeviceID(MOTION_DEVICE);
	dummym.motion_data = XTestPackXMotionValue(0) |
			     XTestPackYMotionValue(0);
	dummym.delay_time = 2;

	iaptr = input_action_buffer_start;
	/*
	 * process one event's worth of input actions
	 */
	while (!pkt_done && ((iaptr - input_action_buffer_start)
			     < XTestACTIONS_SIZE))
	{
		/*
		 * get type byte
		 */
		type = *iaptr & XTestACTION_TYPE_MASK;
		switch (type)
		{
		case XTestKEY_ACTION:
			fk = (XTestKeyInfo *) iaptr;
			code = (KeyCode) *(iaptr + 1);
			dir = *(iaptr) & XTestKEY_STATE_MASK;
			key_ret = chk_key(script_fd,
					  script_name,
					  code,
					  &pkt_done,
					  dir,
					  mode,
					  &quit);
			if (key_ret == 0)
			{
				chk_copy(script_fd, iaptr, sizeof(XTestKeyInfo));
			}
			else if ((key_ret == 2) && (fk->delay_time > 0))
			{
				dummyt.delay_time = fk->delay_time;
				chk_copy(script_fd,
					 &dummyt,
					 sizeof(XTestDelayInfo));
				chk_copy(script_fd,
				         &dummym,
					 sizeof(XTestMotionInfo));
			}
			iaptr += sizeof(XTestKeyInfo);
			break;

		case XTestJUMP_ACTION:

                        if (interaction_mode)
			{
                        	accepted = jump_box((XTestJumpInfo *) iaptr);
			}

                        if (!interaction_mode || !accepted)
                        {
                        	fj = (XTestJumpInfo *) iaptr;
                        	fj->pad1 = 0;
                        	chk_copy(script_fd,
					 iaptr,
					 sizeof(XTestJumpInfo));
                        	G_jmpcnt++;
                        }
			iaptr += sizeof(XTestJumpInfo);
			break;

		case XTestMOTION_ACTION:
                        if (interaction_mode)
                        {
			       /*
				* get the motion from the packet
				*/
				fm = (XTestMotionInfo *) iaptr;
				if (fm->header & XTestX_NEGATIVE)
				{
					moveX -= fm->motion_data & XTestX_MOTION_MASK;
				}
				else
				{
					moveX += fm->motion_data & XTestX_MOTION_MASK;
				}
				if (fm->header & XTestY_NEGATIVE)
				{
					move16Y -= fm->motion_data & XTestY_MOTION_MASK;
				}
				else
				{
					move16Y += fm->motion_data & XTestY_MOTION_MASK;
				}
			}
			else
			{
				chk_copy(script_fd,
					 iaptr,
					 sizeof(XTestMotionInfo));
				G_motcnt++;
			}
			iaptr += sizeof(XTestMotionInfo);
			break;

		default:
			type = XTestUnpackDeviceID(*iaptr);
			if (type == XTestDELAY_DEVICE_ID)
			{
				if (G_timecnt > 0)
				{
					G_timecnt--;
					iaptr += sizeof(XTestDelayInfo);
				}
				else
				{
					ft = (XTestDelayInfo *) iaptr;
					ft->pad1 = 0;
					ft->pad2 = 0;
					chk_copy(script_fd,
						 iaptr,
						 sizeof(XTestDelayInfo));
					iaptr += sizeof(XTestDelayInfo);
				}
			}
			else
			{
				if (G_debug_flag)
				{
					(void) fprintf(G_msg_file,
						       "type was %x\n",
						       type);
				}
				pkt_done++;
			}
			break;
		}
	}
	if (interaction_mode)
	{
		flush_moves();
	}
	return(quit);
}

/**********************************************************************
 *
 *	chk_key
 *
 *	This function checks for a key with special meaning.        
 */
static int
chk_key(script_fd, script_name, code, pkt_done, dir, mode, quit)
/*
 * file descriptor of internal format test script file
 */
int		script_fd;
/*
 * pointer to name of test script
 */
char		*script_name;
/*
 * current keycode
 */
KeyCode		code;
/*
 * ???
 */
int		*pkt_done;
/*
 * direction of key
 */
int		dir;
/*
 * RECORD_ACTIONS_MODE or COMMAND_MODE
 */
unsigned char	*mode;
/*
 * quit if true
 */
unsigned char	*quit;
{
	/*
	 * ???
	 */
	int			key_ret = 0;
	/*
	 * ???
	 */
	struct match_data	p;
	/*
	 * ???
	 */
	static Window			subw, result_subw;
	XRectangle		rect;
	int			computed_window_x;
	int			computed_window_y;

	if (G_playback_info.interval == -1)
	{
		p.intv = DEFAULT_INTERVAL;
	}
	else
	{
		p.intv = G_playback_info.interval;
	}
	if (G_playback_info.retries == -1)
	{
		p.retry = DEFAULT_RETRY;
	}
	else
	{
		p.retry = G_playback_info.retries;
	}
	if (*mode == COMMAND_MODE)
	{
		key_ret = 1;
	}
/*
 *	Interaction test should precede the other COMMAND_MODE checks.
 */
        if (interaction_mode)
        {
                if (*mode == COMMAND_MODE)
                {
                    interaction_mode = box_key_interaction(code, dir);
                    if (!interaction_mode)
                    {
                       /*
                        * the interaction is now completed.
                        * if a rectangle was selected, get its final position.
                        * (restores cursor, and warps it back to starting pt)
                        */
                        if (get_box_posn(&p.x, &p.y, &p.width, &p.height))
                        {
                          /*
                           * the appropriate window is located
                           */
                           rect.x = p.x;
                           rect.y = p.y;
                           rect.width = p.width;
                           rect.height = p.height;
			   /*
			    * for starting root window, 
			    *  know that border width is zero.
			    */
                           computed_window_x = 0;
                           computed_window_y = 0;
			   /*
			    * subw is set further down before this code is
			    * able to be called
			    */
                           if (get_rect_window( subw,
						&result_subw,
						&rect,
						&computed_window_x,
						&computed_window_y)
				== GoodCoverage)
                           {
                               /*
                                * the match data is read into a temp file
                                */
                                (void) printf("partial window match starting...");
                                fflush(stdout);
				p.x = rect.x - computed_window_x;
				p.y = rect.y - computed_window_y;
                                wintotemp(result_subw, &p);
                                p.type = (INT8) 'p';
                               /*
                                * write the match data out to the test script
                                * and remove the temp file
                                */
                                temptoint(script_fd, &p);
                                (void) printf("partial window match complete\n");
                                fflush(stdout);
                           }
                           else /* return to interactive mode */
                           {
				XBell(G_disp_ptr, 0);
				(void) printf("partial window rectangle overlaps more than one window region.\n");
				(void) printf(" Reposition rectangle or cancel partial window specification.\n");
				fflush(stdout);
			        /*
			         * need a delay because init_getbox()
			         * promptly grabs the server, so without it
			         * the message won't appear till later.
			         */
			        delay(1000);         /* 1 sec */
                                interaction_mode = init_getbox(subw,
                                                      rect.x, rect.y,
                                                      rect.width, rect.height);
                           }
                        }
                        else
                           (void) printf("no match selected\n");
                    }
                }
	}
	else if (code == G_matchmouse_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			if (G_ia_count > 0)
			{
				write_input_actions(script_fd);
			}
			G_timecnt++;
			/*
			 * We want to match the whole window, so set the
			 * x and y offsets of the match area inside the 
			 * window to 0.  This may get modified if the 
			 * window is clipped by its parent window or the
			 * root window.
			 */
			p.x = 0;
			p.y = 0;
			if (getmouse(&p, &subw))
			{
				(void) printf("mouse match starting...");
				fflush(stdout);
				/*
				 * this reads the match data into a temp file
				 */
				wintotemp(subw, &p);
				p.type = (INT8) 'm';
				/*
				 * this writes the match data out to the test
				 * script and removes the temp file
				 */
				temptoint(script_fd, &p);
				(void) printf("mouse match complete\n");
			}
			else
			{
				(void) printf("could not find the mouse window\n");
			}
			fflush(stdout);
		}
		else
		{
			;
		}
	}
	else if (code == G_matchtop_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			if (G_ia_count > 0)
			{
				write_input_actions(script_fd);
			}
			G_timecnt++;
			/*
			 * We want to match the whole window, so set the
			 * x and y offsets of the match area inside the 
			 * window to 0.  This may get modified if the 
			 * window is clipped by its parent window or the
			 * root window.
			 */
			p.x = 0;
			p.y = 0;
			if (gettop(&p, &subw))
			{
				(void) printf("top match starting...");
				fflush(stdout);
				/*
				 * this reads the match data into a temp file
				 */
				wintotemp(subw, &p);
				p.type = (INT8) 't';
				/*
				 * this writes the match data out to the test
				 * script and removes the temp file
				 */
				temptoint(script_fd, &p);
				(void) printf("top match complete\n");
			}
			else
			{
				(void) printf("could not find a top window\n");
			}
			fflush(stdout);
		}
		else
		{
			;
		}
	}
	else if (code == G_matchscreen_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			if (G_ia_count > 0)
			{
				write_input_actions(script_fd);
			}
			G_timecnt++;
			/*
			 * We want to match the whole screen, so set the
			 * x and y offsets of the match area inside the 
			 * root window to 0.
			 */
			p.x = 0;
			p.y = 0;
			if (getroot(&p, &subw))
			{
				(void) printf("screen match starting...");
				fflush(stdout);
				/*
				 * this reads the match data into a temp file
				 */
				wintotemp(subw, &p);
				p.type = (INT8) 's';
				/*
				 * this writes the match data out to the test
				 * script and removes the temp file
				 */
				temptoint(script_fd, &p);
				(void) printf("screen match complete\n");
			}
			else
			{
				(void) printf("could not find the root window\n");
			}
			fflush(stdout);
		}
		else
		{
			;
		}
	}
        else if (code == G_matchpartial_key)
        {
                if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
                {
                   if (G_ia_count > 0)
                   {
                        write_input_actions(script_fd);
                   }
                   G_timecnt++;
                  /*
                   * We want to match only part of the region within the
                   * window containing the mouse.  init_getbox begins
                   * interactive selection of the appropriate region.
                   */
                   p.x = 0;
                   p.y = 0;
		   if (!getroot(&p, &subw))
		   {
		   	(void) fprintf(G_msg_file,
		   		       "could not find the root window\n");
		   	exit(1);
		   }
		  (void) printf("specify partial window\n");
		  /*
		   * need a delay because init_getbox()
		   * promptly grabs the server, so without it
		   * the message won't appear till later.
		   */
		  delay(1000);         /* 1 sec */
                  /*
                   * initial 'box' params set to 0, default will be used.
                   */
                   interaction_mode = init_getbox( subw, 0, 0, 0, 0 );
                  /*
                   * The actual match is performed at the beginning
                   * of this "code-test" loop.
                   */
                }
                else
                {
                    ;
                }
	}
	else if (code == G_resume_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			*mode = RECORD_ACTIONS_MODE;
                        printf ("exit command mode\n");
                        fflush(stdout);
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			if (XTestStopInput(G_disp_ptr) == -1)
			{
				(void) fprintf(G_msg_file,
					       "XTestStopInput failed\n");
				exit(1);
			}
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			XTestGetInput(G_disp_ptr, XTestPACKED_ACTIONS);
			XSync(G_disp_ptr, 0);
		}
		else
		{
			;
		}
	}
	else if (code == G_checksum_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			if (G_ia_count > 0)
			{
				write_input_actions(script_fd);
			}
			/*
			 * toggle the checksum mode flag
			 */
			if (G_checksum_flag)
			{
				G_checksum_flag = 0;
				wrchk(script_fd, "Tcd");
				(void) printf("checksum mode off\n");
				fflush(stdout);
			}
			else
			{
				G_checksum_flag = 1;
				wrchk(script_fd, "Tce");
				(void) printf("checksum mode on\n");
				fflush(stdout);
			}
		}
		else
		{
			;
		}
	}
	else if (code == G_quit_key)
	{
		if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			*pkt_done = 1;
			*quit = 1;
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			if (XTestStopInput(G_disp_ptr) == -1)
			{
				(void) fprintf(G_msg_file,
					       "XTestStopInput failed\n");
				exit(1);
			}
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			XTestGetInput(G_disp_ptr, XTestPACKED_ACTIONS);
			XSync(G_disp_ptr, 0);
		}
		else
		{
			;
		}
	}
	else if (code == G_command_key)
	{
		if ((dir == XTestKEY_DOWN) && (*mode == RECORD_ACTIONS_MODE))
		{
			key_ret = 2;
		}
		else if ((dir == XTestKEY_UP) && (*mode == RECORD_ACTIONS_MODE))
		{
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			if (XTestStopInput(G_disp_ptr) == -1)
			{
				(void) fprintf(G_msg_file,
					       "XTestStopInput failed\n");
				exit(1);
			}
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			XTestGetInput(G_disp_ptr, XTestEXCLUSIVE);
			XSync(G_disp_ptr, 0);
			if (G_ia_count > 0)
			{
				write_input_actions(script_fd);
			}
			/*
			 * ensure data written
			 */
			if (close(script_fd) == -1)
			{
				(void) fprintf(G_msg_file,
					       "error %d while closing test script file\n",
					       errno);
			}
			script_fd = chkopen(script_name,
					    "Cannot open test script file '",
					    (O_RDWR | O_APPEND));
			*mode = COMMAND_MODE;
                        printf ("enter command mode\n");
                        fflush(stdout);
			key_ret = 1;
		}
		else if ((dir == XTestKEY_DOWN) && (*mode == COMMAND_MODE))
		{
			key_ret = 0;
		}
		else if ((dir == XTestKEY_UP) && (*mode == COMMAND_MODE))
		{
			*mode = RECORD_ACTIONS_MODE;
                        printf("exit command mode\n");
                        fflush(stdout);
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			if (XTestStopInput(G_disp_ptr) == -1)
			{
				(void) fprintf(G_msg_file,
					       "XTestStopInput failed\n");
				exit(1);
			}
			/*
			 * this function is defined in the X testing extension
			 * to Xlib
			 */
			XTestGetInput(G_disp_ptr, XTestPACKED_ACTIONS);
			XSync(G_disp_ptr, 0);
			key_ret = 0;
		}
	}
	else if (*mode == COMMAND_MODE)
	{
		/*
		 * in command mode but didn't recognize the key, so beep
		 */
		XBell(G_disp_ptr, 0);
	}
	return (key_ret);
}

/**********************************************************************
 *
 *	usage
 *
 *	Gives a usage message.
 *
 */
static void
usage()
{
	(void) printf("\nusage:  xtmrecord <filename>%s\n", SCRIPT_ENDING);
	/*
	 * skip over the first 4 characters of the version string
	 */
	(void) printf("\n%s\n", &(version[4]));
}

/**********************************************************************
 *
 *	xtmrecord_parse_options
 *
 *	parses the command line parameters and sets the debug flag
 *      (-D) is the only option allowed here.
 *
 */
static int
xtmrecord_parse_options(argc, argv, script_name)
/*
 * argument count
 */
register int	argc;
/*
 * argument vector pointer
 */
register char	*argv[];
/*
 * RETURN parameter for actual test script file name
 */
char 		*script_name;
{
	char	temp[MAXPATH];
	int	namePos;
	int	returnVal;

	/*
	 * Initialize G_debug_flag to False
	 */
	returnVal = False;
	(void) strcpy(temp, "");

	switch (argc) {
	case 1:
		/*
		 * No parameters given - so give help
		 */
		usage();
		exit(1);
		break;

	case 2:
		/*
		 * file name only given
		 */
		namePos = 1;
		break;

	case 3:
		/*
		 * debug flag and file name given
		 */
		if (strcmp(argv[1], "-D") == 0)
		{
			returnVal = 1;
			namePos = 2;
		}
		else
		{
			usage();
			exit(1);
		}
		break;

	default:
		/*
		 * too many parameters, so give help
		 */
		usage();
		exit(1);
		break;
	}
	/*
	 * String length indicates that SCRIPT_ENDING must be added
	 */
	if (strlen(argv[namePos]) <= ENDING_LENGTH) 
	{
		usage();
		(void) printf("\nNOTE: '%s' filename extension is required\n",
			      SCRIPT_ENDING);
		exit(1);
	}
	/*
	 * Tricky, check the last ENDING_LENGTH chars in the string
	 */
	else if (strcmp(&(argv[namePos][strlen(argv[namePos]) - ENDING_LENGTH]),
			SCRIPT_ENDING) != 0)
	{
		usage();
		(void) printf("\nNOTE: '%s' filename extension is required\n",
			      SCRIPT_ENDING);
		exit(1);
	}
	/*
	 * String must already end in SCRIPT_ENDING
	 */
	else  
	{
		(void) strcpy(temp, argv[namePos]);
	}
	(void) strcpy(script_name, temp);
	return(returnVal);
}



/**********************************************************************
 *
 *	xtmrecord_global_initialize
 *
 *	Initialization routine for all global vars.
 *
 */
static void
xtmrecord_global_initialize(argv)
/*
 * argument vector pointer
 */
register char *argv[];
{
	/*
	 * ???
	 */
	char			*bufsize;
	/*
	 * ???
	 */
	char			*interval;
	/*
	 * ???
	 */
	char			*retries;
	/*
	 * points to the string returned by a XGetDefaults call
	 */
	char			*cmd;
	/*
	 * this holds the screen buffer size for error checking
	 */
	int			temp_scrnbuf;

	/*
	 * Set the global message file to stderr
	 */
	G_msg_file = stderr;
	/*
	 * open the display
	 */
	if ((G_disp_ptr = XOpenDisplay((char *) 0)) == (Display *) 0)
	{
		(void) fprintf(G_msg_file,
			       "%s: Could not open Display %s\n",
			       argv[0],
			       XDisplayName((char *) 0));
		exit(1);
	}

	if ((bufsize = XGetDefault(G_disp_ptr,
				   argv[0],
				   "MatchBufferSize")) != (char *) 0)
	{
		temp_scrnbuf = atoi(bufsize);
		/*
		 * the buffer size must be divisible by 8
		 */
		if ((temp_scrnbuf % 8) != 0)
		{
			(void) fprintf(G_msg_file,
				       "%s: The match buffer size must be divisible by 8\n",
				       argv[0]);
			exit(1);
		}
		/*
		 * twice the buffer size must fit in an unsigned int
		 */
		if (temp_scrnbuf > ((unsigned int) UNSIGNED_INT_MAX / 2))
		{
			(void) fprintf(G_msg_file,
				       "%s: The match buffer size may not be larger than %d\n",
				       argv[0],
				       ((unsigned int) UNSIGNED_INT_MAX / 2));
			exit(1);
		}
		/*
		 * the value has passed the tests, so use it
		 */
		G_sb_size = temp_scrnbuf;
	}
	else
	{
		G_sb_size = DEFAULT_SCREEN_BUFFER_SIZE;
	}

	if ((G_c_data_buffer = (unsigned char *) malloc(G_sb_size * 2))
	    == (unsigned char *) 0)
	{
		(void) fprintf(G_msg_file,
			       "Unable to malloc space for match buffer.\n");
		exit(1);
	}
	if ((G_sb = (unsigned char *) malloc(G_sb_size)) == (unsigned char *) 0)
	{
		(void) fprintf(G_msg_file,
			       "Unable to malloc space for match buffer.\n");
		exit(1);
	}

	if ((interval = XGetDefault(G_disp_ptr, argv[0], "RetryInterval"))
	    != (char *) 0)
	{
		G_playback_info.interval = atol(interval);
	}
	else
	{
		G_playback_info.interval = -1;
	}

	if ((retries = XGetDefault(G_disp_ptr, argv[0], "MatchRetries"))
	    != (char *) 0)
	{
		G_playback_info.retries = atol(retries);
	}
	else
	{
		G_playback_info.retries = -1;
	}
	/*
	 * initialize G_command_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "CommandKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_command_string, cmd);
        }
        else
        {
		(void) strcpy(G_command_string, COMMAND_KEY_STRING);
        }
	G_command_key = XKeysymToKeycode(G_disp_ptr,
					 XStringToKeysym(G_command_string));
	/*
	 * initialize G_matchmouse_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "MatchMouseKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_matchmouse_string, cmd);
        }
        else
        {
		(void) strcpy(G_matchmouse_string, MATCHMOUSE_KEY_STRING);
        }
	G_matchmouse_key = XKeysymToKeycode(G_disp_ptr,
					    XStringToKeysym(G_matchmouse_string));
	/*
	 * initialize G_matchscreen_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "MatchScreenKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_matchscreen_string, cmd);
        }
        else
        {
		(void) strcpy(G_matchscreen_string, MATCHSCREEN_KEY_STRING);
        }
	G_matchscreen_key = XKeysymToKeycode(G_disp_ptr,
					     XStringToKeysym(G_matchscreen_string));
	/*
	 * initialize G_matchtop_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "MatchTopKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_matchtop_string, cmd);
        }
        else
        {
		(void) strcpy(G_matchtop_string, MATCHTOP_KEY_STRING);
        }
	G_matchtop_key = XKeysymToKeycode(G_disp_ptr,
					  XStringToKeysym(G_matchtop_string));
	/*
	 * initialize G_quit_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "QuitKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_quit_string, cmd);
        }
        else
        {
		(void) strcpy(G_quit_string, QUIT_KEY_STRING);
        }
	G_quit_key = XKeysymToKeycode(G_disp_ptr,
				      XStringToKeysym(G_quit_string));
	/*
	 * initialize G_resume_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "ResumeKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_resume_string, cmd);
        }
        else
        {
		(void) strcpy(G_resume_string, RESUME_KEY_STRING);
        }
	G_resume_key = XKeysymToKeycode(G_disp_ptr,
					XStringToKeysym(G_resume_string));
	/*
	 * initialize G_checksum_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "ChecksumKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_checksum_string, cmd);
        }
        else
        {
		(void) strcpy(G_checksum_string, CHECKSUM_KEY_STRING);
        }
	G_checksum_key = XKeysymToKeycode(G_disp_ptr,
					  XStringToKeysym(G_checksum_string));
	/*
	 * initialize G_matchpartial_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "MatchPartialKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_matchpartial_string, cmd);
        }
        else
        {
		(void) strcpy(G_matchpartial_string, MATCHPARTIAL_KEY_STRING);
        }
	G_matchpartial_key = XKeysymToKeycode(G_disp_ptr,
					      XStringToKeysym(G_matchpartial_string));
	/*
	 * initialize G_acceptpartial_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "AcceptPartialKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_acceptpartial_string, cmd);
        }
        else
        {
		(void) strcpy(G_acceptpartial_string, ACCEPTPARTIAL_KEY_STRING);
        }
	G_acceptpartial_key = XKeysymToKeycode(G_disp_ptr,
					       XStringToKeysym(G_acceptpartial_string));
	/*
	 * initialize G_rejectpartial_key
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "RejectPartialKey"))
	    != (char *) 0)
        {
		(void) strcpy(G_rejectpartial_string, cmd);
        }
        else
        {
		(void) strcpy(G_rejectpartial_string, REJECTPARTIAL_KEY_STRING);
        }
	G_rejectpartial_key = XKeysymToKeycode(G_disp_ptr,
					       XStringToKeysym(G_rejectpartial_string));
	/*
	 * get the read_from_root flag setting, if any, from the .Xdefaults file
	 */
        if ((cmd = XGetDefault(G_disp_ptr, argv[0], "ReadFromRoot"))
	    != (char *) 0)
        {
		if (strcmp(cmd, "yes") == 0)
		{
			G_read_from_root_flag = 1;
		}
		else
		{
			G_read_from_root_flag = 0;
		}
        }
        else
        {
		G_read_from_root_flag = 0;
        }
	/*
	 * set the checksum flag to off (don't use checksums)
	 */
	G_checksum_flag = 0;
	/*
	 * initialize "getbox" parameters
	 */
	init_getbox_params();
}

/**********************************************************************
 *
 *	main
 *
 *	X-based test execution monitor.  Requires server extension on
 *	each machine upon which it is implemented.
 *
 *	Its purpose is to capture the input actions entered in the course of
 *	a test, and the results from the screen, so that the test may be
 *	repeated automatically.
 *
 *	Any parameter beginning with "-" is assumed to be a flag string.
 *	The first parameter after the flags is assumed to be a filename.
 */
int
main(argc, argv) 
/*
 * argument count
 */
register int	argc;
/*
 * argument vector pointer
 */
register char	*argv[];
{
	/*
	 * this is ignored
	 */
	unsigned long	max_input_actions;
	/*
	 * file descriptor of the test script file
	 */
	int		script_fd;
	/*
	 * holds the name of the test script file
	 */
	char		script_name[MAXPATH];

	/*
	 * Initialize the zillion global variables
	 */
	xtmrecord_global_initialize(argv);
	/*
	 * Set the Xerror Handler ????
	 */
	XSetErrorHandler(xerror);
	/*
	 * Check to see if the extension exists
	 */
	if (XTestQueryInputSize(G_disp_ptr, &max_input_actions) != 0)
	{
		(void) fprintf(G_msg_file,
			       "Unable to query input action size.\n");
		(void) fprintf(G_msg_file,
			       "Does the server have the %s extension installed?\n",
		               XTestEXTENSION_NAME);
		exit(1);
	}
	/*
	 * parse the command line and set the one flag - debug
	 */
	G_debug_flag = xtmrecord_parse_options(argc, argv, script_name);
	/*
	 * Open the test script file and get the file descriptor
	 */
	script_fd = makef(script_name);
	/*
	 * Print some details if debugging is on
	 */
	if (G_debug_flag)
	{
		(void) fprintf(G_msg_file,
			       "test script is %s\n",
			       script_name);
		(void) fprintf(G_msg_file,
			       "retries is %ld\n",
			       G_playback_info.retries);
		(void) fprintf(G_msg_file,
			       "interval is %ld\n",
			       G_playback_info.interval);
	}
	/*
	 * invoke input mode routine
	 */
	input(script_fd, script_name);
	/*
	 * close the test script file
	 */
	if (close(script_fd) == -1)
	{
		(void) fprintf(G_msg_file,
			       "error %d while closing test script file\n",
			       errno);
	}
	return(0);
}
