.TH XTMEXECUTE 1
.ad b
.SH NAME
xtmexecute \- test script execution (playback) tool
.SH SYNOPSIS
.B xtmexecute
[\fB-d\fR] [\fB-u\fR|\fB-c\fR] [\fB-t\fR [\fB+\fR|\fB-\fR|\fB/\fR|\fB*\fR] \fIfactor\fR] \fIfilename\fR
.br
.SH DESCRIPTION
.I Xtmexecute
plays back one or more test scripts created by
.I xtmrecord(1)
or by
.I xtmconvert(1).
The test scripts must contain a record of which keys and mouse buttons were
pressed and released, where the mouse was moved to,
and what the time delays were before each action.
The test scripts may also contain requests for verification of image data
from the display.
.SS File Name Syntax
If the
.B \-d
option is used, then
.I filename
must be the name of a directory.
Otherwise 
.I filename
must end in ".scr".
Thus:
.PP
.RS
xtmexecute -d testdir
.RE
.PP
will play back all of the test scripts in
.I testdir
and any directories below
.I testdir,
and
.PP
.RS
xtmexecute testscript.scr
.RE
.PP
will play back a test script
.I testscript.scr.
If no file name or an incorrect file name is given,
.I xtmexecute
will display the correct invocation syntax 
and terminate with a non-zero exit status but without creating
an error file.
.SS Running Xtmexecute
.I Xtmexecute
may be run in an X terminal emulator window or on a terminal.
If you run
.I xtmexecute
on a terminal, make sure that the
.SM
.B DISPLAY
environment variable is set to the name of the desired X server.
.PP
.I Xtmexecute
requires that the X server support the 
.I Input Synthesis
extension.  This extension supplies the additional capabilities needed to play
back a test script.
.PP
.I Xtmexecute
will communicate with the X server to start playing back
one or more test scripts as soon as it is invoked.
Several options modify how the test scripts are played back:  
.TP
.B \-d
This option allows
.I xtmexecute
to be used to run multiple test scripts.
It causes 
.I xtmexecute
to play back all of the test scripts in
.I filename
(which must be the name of a directory)
followed by playing back any test scripts in directories below
.I filename.
.TP
.B \-u
This option allows a test script to be updated
if the expected display image data changes.
When this option is used
.I xtmexecute
plays back a test script normally
except that instead of verifying the image data,
.I xtmexecute
puts information about the current image data
into the test script for later use.
.TP
.B -c
This option causes
.I xtmexecute
to continue to play back a test script in spite of any image data verification
failures.
When this option is used, an image data verification failure will cause
.I xtmexecute
to leave an error file, but
.I xtmexecute
will not terminate with a non-zero exit status because
of the failure.
.IP
This option is mostly used when playing back multiple test scripts, so that an 
image data verification failure in one test script will not stop the other
test scripts from being played back.
.TP
.B -t
This option allows the user to modify the time delay associated with each
action in the test scripts.
The syntax for this option is the same as that of the
.I ActionTiming .Xdefaults
variable.
Since many command interpreters use the
.B *
as a pattern-matching character, you may want to use the
.I ActionTiming .Xdefaults
variable instead of this option.
.PP
.I Xtmexecute
will play back the actions in the test scripts
in the order that the test scripts specify.
.I Xtmexecute
will attempt to play back the actions with the same time delays as the
test scripts specify.
The time delays may be longer than the test scripts specify due to delays in
communication between
.I xtmexecute
and the X server and/or delays in the X server.
.PP
All test scripts contain a version number.
.I Xtmexecute
checks the version number when a test script is played back to help
deal with future changes to the test script format.
If a test script has a version number that 
.I xtmexecute
does not know how to play back,
.I xtmexecute
will terminate with a non-zero exit status and leave an error file.
.PP
If a request for verification of image data from the display is in a
test script, the corresponding portion of the display is read, and the 
information stored in the test script is used to decide if the image data has
changed.
.PP
If the image data has not changed,
.I xtmexecute
will continue to play back the test script.
.sp
.PP
If the image data has changed and checksum mode is off,
.I xtmexecute
will terminate with a non-zero exit status and leave an error file,
a file containing the expected image data
and a file containing the actual image data.
.PP
If the image data has changed and checksum mode is on,
.I
xtmexecute
will terminate with a non-zero exit status and leave only an error file,
since it does not have enough information in the test script 
to leave the expected and actual image data files.
.SS Files Created by Xtmexecute
.PP
Messages about the progress of
.I xtmexecute
in playing back test scripts are recorded in log files.
There is one log file for each test script.
The log file's name is created by replacing the ".scr" at the end of the
name of the test script with ".log".
.PP
If 
.I xtmexecute
terminates normally, no error file will be created and
.I xtmexecute
will have an exit status of zero.
.PP
If 
.I xtmexecute
terminates with an error
.I xtmexecute
will have a non-zero exit status
and an (empty) error file will be created.
The error file is created to allow easy programmatic identification of which
test scripts failed when playing back more than one test script at a time.
The error file's name is created by replacing the ".scr" at the end of the
name of the test script with ".err".
.PP
If an image data verification fails and checksum mode is off,
the expected and actual image data will be placed in
.I xwd(1)
format in expected and actual data files.
The expected and actual data file names are created by replacing the ".scr"
at the end of the name of the test script with ".e\fBnn\fR" and ".a\fBnn\fR",
respectively.
The
.B nn
in the expected and actual data file names will be replaced by a number
corresponding to the image data verification request in the test script.
The number will be 01 for the first request in the test script,
02 for the second request,
and so forth up to 99 (the maximum number of requests in one test script).
.PP
When
.I xtmexecute
is playing back a test script in update mode (using the
.B -u
option), it creates a new test script.  The new test script's name is created
by replacing the ".scr" at the end of the name of the test script with ".new".
If there is no error during the update of the test script, the new test
script's name is changed to the original name, and the old test script is
removed.  If an error occurs during the update, the new test script is not
renamed.
.sp
.SS .Xdefaults Variable Usage
.I Xtmexecute
recognizes the following
.I .Xdefaults
variables (shown with their default values):
.PP
.RS
xtmexecute.ActionTiming:      +0
.RE
.RS
xtmexecute.MatchRetries:
.RE
.RS
xtmexecute.RetryInterval:
.RE
.RS
xtmexecute.MatchBufferSize:   32760
.RE
.RS
xtmexecute.ReadFromRoot:      no
.RE
.RS
xtmexecute.CompareColorMap:   yes
.RE
.PP
The
.I ActionTiming
variable modifies the time delay for playing back each action in the
test scripts.
The range of time delays possible using this option is 0 to 65535 milliseconds
(approximately one minute).
.PP
The type of time delay modification depends on the arithmetic operator
preceeding the number:
.TP
.B +
Add the (32-bit integer) number (in milliseconds) to each time delay
in the test scripts.
.TP
.B -
Subtract the (32-bit integer) number (in milliseconds) from each time delay
in the test scripts.
.TP
.B *
Multiply the (floating point) number times each time delay in the test scripts.
.TP
.B /
Divide the (floating point) number into each time delay in the test scripts.
.PP
If no arithmetic operator preceeds the number, then the (32-bit integer) number
will be used as the minimum time delay (in milliseconds) for each time delay
in the test scripts.
.PP
The
.I MatchRetries
variable controls the number of times a failing image data comparison
will be retried when the test script is played back.
It has a range of 0 to 32767 retries.
If the variable is not in the
.I .Xdefaults
file the test script will be retried the number of times that is stored
in the test script.
.PP
The
.I RetryInterval
variable controls the interval in milliseconds between each retry when the
test script is played back.
It has a range of 0 to 2,147,483,647 milliseconds (approximately 25 days).
If the variable is not in the
.I .Xdefaults
file the delay between retries will be the amount of time that is stored
in the test script.
.sp
.PP
The
.I MatchBufferSize
variable controls the size in bytes of the buffer that is used to hold
the data read from the display.
It does not limit the amount of data that can be read from the display,
but only determines how much of the data can be read at one time.
.PP
The value of this variable must be divisible by 8 and at least large enough to
hold one line of pixels the width of the X server's display.
Larger than default values of this variable may increase the performance
of display reads on machines with large amounts of memory.
It has a range of 0 to one-half the maximum value an unsigned integer can hold.
.PP
The
.I ReadFromRoot
variable controls whether or not to read all of the information
for image data verifications in a test script from the root window 
instead of from the window that would normally be used.
.PP
If a test script was recorded by
.I xtmrecord(1)
with
.I ReadFromRoot
set to "\fByes\fR", make sure that it is set to "\fByes\fR" for 
.I xtmexecute
as well.
.PP
The
.I CompareColorMap
variable controls whether to compare the color map or not as part of image data
verification.
During image data verification
.I xtmexecute
compares all of the colors in the color map with color map information
stored in the test script.
If this variable is set to "\fByes\fR", any differences are considered an error.
If it is set to "\fBno\fR", any differences cause a warning instead of
an error.
.PP
Setting this variable to "\fByes\fR" may be considered too strict.
For example, a test script may not even use a given color, but all image data
verifications in the test script may fail because the unused color map entry
changed between the time that the verification information was stored
in the test script and the time that the test script was executed.
.PP
If this variable is set to "\fBno\fR" and the color map entry numbers
(sometimes called "pixel" numbers)
stored in the test script and read from the display are the same,
then a test script will not fail even if the colors
associated with the color map entry numbers have changed.
.SH SEE ALSO
xtmrecord(1), xtmconvert(1), xwd(1).
.SH COPYRIGHT
.PP
Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
.sp
.PP
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology
.PP
Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.
.PP
This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.
