/**********************************************************************
 *
 *	wintotemp.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * pointer to the display
 */
extern Display		*G_disp_ptr;
/*
 * size of the buffer for screen matches
 */
extern unsigned int	G_sb_size;
/*
 * undocumented debug invocation option flag
 */
extern int           	G_debug_flag;
/*
 * pointer to diagnostic/error message file
 */
extern FILE		*G_msg_file;
/*
 * "read from root" flag
 */
extern int		G_read_from_root_flag;
/*
 * if true, use checksums for match data
 */
extern int		G_checksum_flag;

extern int		errno;

/**********************************************************************
 * function declarationss
 **********************************************************************/

void	gettmp();
char	*malloc();
XImage	*XGetImage();
void	clear_pad_bits();
void	compute_checksum();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	wintotemp
 *
 *	This function reads the area of the screen to be matched into
 *	a temporary file.
 *
 *	This functions expects that the screen number, x, y, width, and
 *	height of the desired area of the specified window be set in the
 *	specified match_data structure.  It will store other information
 *	about the match data in the specified match_data structure.
 */
void
wintotemp(subw, p)
/*
 * this specifies the id of the window to read data from
 */
Window			subw;
/*
 * this points to the match data structure
 */
struct match_data	*p;
{
	/*
	 * holds the height of the partial image to be read
	 */
	int			theight;
	/*
	 * holds the starting x coordinate of the partial image to be read
	 */
	int			hndx;
	/*
	 * holds the total count of compressed image bytes
	 */
	INT32			cnt = 0;
	/*
	 * holds the count of compressed image bytes for a partial image
	 */
	int			tcnt = 0;
	/*
	 * holds the size (in bytes) of the whole image
	 */
	unsigned long		size = 0;
	/*
	 * holds the size (in bytes) of a partial image
	 */
	unsigned int		tsize = 0;
	/*
	 * points to an image
	 */
	XImage			*tmp_image_ptr;
	/*
	 * holds the plane mask used when reading the image
	 */
	unsigned long		plane_mask;
	/*
	 * used a a general purpose loop counter
	 */
	int			i;
	/*
	 * holds the information about subw
	 * (the window containing the match data)
	 */
	XWindowAttributes	win_info;
	/*
	 * points to the window name
	 */
	char			*win_name;
	/*
	 * holds the temporary file name
	 */
	char			temp_file_name[MAXPATH];
	/*
	 * holds the x coordinate of the match data
	 */
	int			image_x;
	/*
	 * holds the y coordinate of the match data
	 */
	int			image_y;
	/*
	 * holds the id of the window to read the image data from
	 */
	Window			image_window;
	/*
	 * holds the id of the child window from the XTranslateCoordinates
	 * call (ignored)
	 */
	Window			child_window;

/*
	XGrabServer(G_disp_ptr);
*/
	/*
	 * if we are supposed to read all image data from the root window,
	 * convert the coordinates of the passed-in window to the
	 * corresponding coordinates in the root window
	 */
	if (G_read_from_root_flag)
	{
		/*
		 * read the image from the root window
		 */
		image_window = RootWindow(G_disp_ptr, p->screen_number);
		/*
		 * translate the x and y coordinates to the root window
		 */
		if (XTranslateCoordinates(G_disp_ptr,
					  subw,
					  image_window,
					  p->x,
					  p->y,
					  &image_x,
					  &image_y,
					  &child_window) == False)
		{
			(void) fprintf(G_msg_file,
				       "XTranslateCoordinates failed\n");
			exit(1);
		}
		/*
		 * remember the converted x and y coordinates
		 */
		p->x = image_x;
		p->y = image_y;
	}
	else
	{
		/*
		 * read the image from the specified window
		 */
		image_window = subw;
		image_x = p->x;
		image_y = p->y;
	}
	/*
	 * initialize the checksum
	 */
	p->checksum = 0;
	/*
	 * find out information about the window so that is can
	 * be stored with the match data and used/compared later
	 */
	if(!XGetWindowAttributes(G_disp_ptr, image_window, &win_info))
	{
		(void) fprintf(G_msg_file,
			       "XGetWindowAttributes failed\n");
		exit(1);
	}
	p->window_width		  = win_info.width;
	p->window_height	  = win_info.height;
	p->window_border_width    = win_info.border_width;
	/*
	 * translate the window_x and window_y coordinates to root-relative
	 * coordinates by getting the coordinates of the orgin inside the
	 * window and subtracting the border width
	 */
	if (XTranslateCoordinates(G_disp_ptr,
				  image_window,
				  RootWindow(G_disp_ptr, p->screen_number),
				  0,
				  0,
				  &(p->window_x),
				  &(p->window_y),
				  &child_window) == False)
	{
		(void) fprintf(G_msg_file,
			       "XTranslateCoordinates failed\n");
		exit(1);
	}
	p->window_x -= p->window_border_width;
	p->window_y -= p->window_border_width;
	/*
	 * get the window name if it has one
	 */
	(void) XFetchName(G_disp_ptr, image_window, &win_name);
	if (!win_name || !win_name[0])
	{
		/*
		 * if the window did not have a name or the window
		 * name was a null string, use a default name instead
		 */
		(void) strcpy(p->window_name, DEFAULT_WINDOW_NAME);
	}
	else
	{
		/*
		 * save the window name 
		 */
		(void) strcpy(p->window_name, win_name);
	}
	/*
	 * free the space allocated for the window name
	 */
	XFree((caddr_t) win_name);
	/*
	 * all images read by this routine are kept in Z format
	 */
	p->format		  = ZPixmap;
	p->visual_class		  = win_info.visual->class;
	p->red_mask		  = win_info.visual->red_mask;
	p->green_mask		  = win_info.visual->green_mask;
	p->blue_mask		  = win_info.visual->blue_mask;
	p->bits_per_rgb		  = win_info.visual->bits_per_rgb;
	p->colormap_entries	  = win_info.visual->map_entries;
	/*
	 * get the colors from the colormap
	 */
	p->ncolors = Get_XColors(&win_info, &(p->color_ptr));
	/*
	 * get an image of height 1 so that I can find out
	 * the number of bytes per line in the window
	 * (I can't figure out any other way to get that info)
	 */
	tmp_image_ptr = XGetImage(G_disp_ptr,
				  image_window,
				  image_x,
				  image_y,
				  (unsigned int) p->width,
				  1,
				  AllPlanes,
				  ZPixmap);
	if (tmp_image_ptr == (XImage *) 0)
	{
		(void) fprintf(G_msg_file, "XGetImage failed\n");
		exit(1);
	}
	/*
	 * save the information about the image so that it can be
	 * stored with the match data and used later to re-create the image
	 */
	p->depth            = tmp_image_ptr->depth;
	p->xoffset          = tmp_image_ptr->xoffset;
	p->byte_order       = tmp_image_ptr->byte_order;
	p->bitmap_unit      = tmp_image_ptr->bitmap_unit;
	p->bitmap_bit_order = tmp_image_ptr->bitmap_bit_order;
	p->bitmap_pad       = tmp_image_ptr->bitmap_pad;
	p->bytes_per_line   = tmp_image_ptr->bytes_per_line;
	p->bits_per_pixel   = tmp_image_ptr->bits_per_pixel;
	/*
	 * compute the plane mask to use to ensure that any bits 
	 * in the match data that are not used for pixels are set to 0
	 */
	plane_mask = 0;
	for (i = 0; i < tmp_image_ptr->depth; i++)
	{
		plane_mask <<= 1;
		plane_mask |= 1;
	}
	/*
	 * free the image
	 */
	XDestroyImage(tmp_image_ptr);
	/*
	 * if we are not doing checksums create a temp file for the match data
	 */
	if (!G_checksum_flag)
	{
		/*
		 * create a temporary file to hold the match data
		 */
		gettmp(&(p->tfd), temp_file_name);
		/*
		 * unlink the temporary file so that if the program stops
		 * unexpectedly the file will not be left laying around
		 */
		if (unlink(temp_file_name) != 0)
		{
			(void) fprintf(G_msg_file,
				       "error %d while unlinking the match data temp file\n",
				       errno);
		}
	}
	/*
	 * figure out if the area data will fit into the buffer
	 */
	size = p->bytes_per_line * p->height;
	/*
	 * If the area data will fit, read the entire window.  If they won't
	 * fit, compute the number of horizontal lines of pixels of the area
	 * data that will fit.
	 */
	theight = (size < G_sb_size) ? p->height :
				       (G_sb_size / p->bytes_per_line);
	/*
	 * figure out the actual size of the area data to be read
	 */
	tsize = p->bytes_per_line * (theight);
	if (G_debug_flag)
	{
		(void) fprintf(G_msg_file,
			       "match: image_window = %lx size=%d x=%d y=%d w=%d h=%d theight=%d.\n",
			       image_window,
			       size,
			       image_x,
			       image_y,
			       p->width,
			       p->height,
			       theight);
	}

	for (hndx = image_y; hndx < (image_y + p->height);)
	{
		if (G_debug_flag)
		{
			(void) fprintf(G_msg_file,
				       "match: image_window %lx image_x=%d hndx=%d p->w=%d theight=%d.\n",
				       image_window,
				       image_x,
				       hndx,
				       p->width,
				       theight);
		}
		tmp_image_ptr = XGetImage(G_disp_ptr,
					  image_window,
					  image_x,
					  hndx,
					  (unsigned int) p->width,
					  (unsigned int) theight,
					  plane_mask,
					  ZPixmap);
		if (tmp_image_ptr == (XImage *) 0)
		{
			(void) fprintf(G_msg_file, "XGetImage failed\n");
			exit(1);
		}
		/*
		 * clear any pad bits in the image data to a known value
		 * so comparisons will work even if the pad bits change
		 */
		clear_pad_bits((unsigned char *) tmp_image_ptr->data,
			       theight,
			       p);
		if (G_checksum_flag)
		{
			/*
			 * compute the checksum for the match data
			 */
			compute_checksum(&(p->checksum),
					 (unsigned char *) (tmp_image_ptr->data),
					 tsize);
		}
		else
		{
			/*
			 * compress the match data and
			 * write it out to the temporary file
			 */
			tcnt = compress(tmp_image_ptr->data, tsize, p->tfd);
			/*
			 * update the byte count (for the compressed image)
			 */
			cnt += tcnt;
		}
		/*
		 * free the image structure created by XGetImage
		 */
		XDestroyImage(tmp_image_ptr);
		/*
		 * update the height parameter
		 */
		hndx += theight;
		/*
		 * handle the height for the last piece of the match data
		 */
		if (hndx + theight > image_y + p->height)
		{
			theight = image_y + p->height - hndx;
			tsize = p->bytes_per_line * (theight);
		}

	}
/*
	XUngrabServer(G_disp_ptr);
*/
	if (G_debug_flag)
	{
		if (G_checksum_flag)
		{
			(void) fprintf(G_msg_file,
				       "match: checksum is %lu.\n",
				       p->checksum);
		}
		else
		{
			(void) fprintf(G_msg_file,
				       "match: compressed size is %d.\n",
				       cnt);
		}
	}
	/*
	 * set the count parameter for later reference
	 */
	p->cnt = cnt;
	return;
}

/**********************************************************************
 *
 *	Get_XColors
 *
 *	This function was taken (almost unchanged) from the source for xwd.
 *	It reads the colormap information for the window.  It returns
 *	the number of colors read.
 */
static int
Get_XColors(win_info, colors)
/*
 * points to the window information
 */
XWindowAttributes	*win_info;
/*
 * points to a pointer that will keep track of the colors
 */
XColor			**colors;
{
	int	i;
	int	ncolors;

	if (!win_info->colormap)
	{
		return(0);
	}
	if ((win_info->visual->class == TrueColor) ||
	    (win_info->visual->class == DirectColor))
	{
		/*
		 * the xwd code had this comment in it:
		 * XXX punt for now
		 */
		return(0);
	}
	ncolors = win_info->visual->map_entries;
	if ((*colors = (XColor *) malloc(sizeof(XColor) * ncolors)) ==
	    (XColor *) 0)
	{
		(void) fprintf(G_msg_file, "Out of memory in Get_XColors\n");
		exit(1);
	}
	for (i = 0; i < ncolors; i++)
	{
		(*colors)[i].pixel = i;
	}
	XQueryColors(G_disp_ptr, win_info->colormap, *colors, ncolors);
	/*
	 * this was added to make sure that the pad bytes are always set to
	 * the same value since it appears that XQueryColors doesn't do this
	 */
	for (i = 0; i < ncolors; i++)
	{
		(*colors)[i].pad = 0;
	}
	return(ncolors);
}
