/**********************************************************************
 *
 *	matdtoint.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * function definitions
 **********************************************************************/

void	wrchk2();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	write_match_data_to_internal
 *
 *	Writes out most of the data in the match data structure to an
 *	internal format file.
 */
void
write_match_data_to_internal(internal_format_fd, match_data_ptr)
/*
 * file descriptor of the file (assumed to be in internal format)
 * where the match data is to be written
 */
int			internal_format_fd;
/*
 * this points to the structure that describes the match data
 */
struct match_data	*match_data_ptr;
{
	/*
	 * points to a color map structure
	 */
	XColor	*color_ptr;
	/*
	 * keeps track of the number of color map structures
	 */
	INT32	i;
	/*
	 * holds the length of the window name
	 */
	int	window_name_length;

	/*
	 * The 'm' is a flag to indicate that a match follows.
	 */
	wrchk2(internal_format_fd,
	       "m",
	       sizeof(char),
	       "Error while writing match flag\n");
	/*
	 * write out the match type
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->type),
	       sizeof(match_data_ptr->type),
	       "Error while writing match type\n");
	/*
	 * write out the match retry count
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->retry),
	       sizeof(match_data_ptr->retry),
	       "Error while writing match retry count\n");
	/*
	 * write out the match retry interval
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->intv),
	       sizeof(match_data_ptr->intv),
	       "Error while writing match retry interval\n");
	/*
	 * write out the count of the compressed match image data bytes
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->cnt),
	       sizeof(match_data_ptr->cnt),
	       "Error while writing match cnt\n");
	/*
	 * write out the checksum
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->checksum),
	       sizeof(match_data_ptr->checksum),
	       "Error while writing match checksum\n");
	/*
	 * write out the match screen number
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->screen_number),
	       sizeof(match_data_ptr->screen_number),
	       "Error while writing match screen number\n");
	/*
	 * write out the match window x coordinate
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->window_x),
	       sizeof(match_data_ptr->window_x),
	       "Error while writing match window x coordinate\n");
	/*
	 * write out the match window y coordinate
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->window_y),
	       sizeof(match_data_ptr->window_y),
	       "Error while writing match window y coordinate\n");
	/*
	 * write out the match window width
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->window_width),
	       sizeof(match_data_ptr->window_width),
	       "Error while writing match window width\n");
	/*
	 * write out the match window height
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->window_height),
	       sizeof(match_data_ptr->window_height),
	       "Error while writing match window height\n");
	/*
	 * write out the match window border width
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->window_border_width),
	       sizeof(match_data_ptr->window_border_width),
	       "Error while writing match window border width\n");
	/*
	 * write out the match window name length (including
	 * the null character)
	 */
	window_name_length = (strlen(match_data_ptr->window_name) + 1) *
			     sizeof(char);
	wrchk2(internal_format_fd,
	       (char *) &(window_name_length),
	       sizeof(window_name_length),
	       "Error while writing match window name length\n");
	/*
	 * write out the match window name (including the null
	 * character at the end)
	 */
	wrchk2(internal_format_fd,
	       match_data_ptr->window_name,
	       (unsigned int) window_name_length,
	       "Error while writing match window name\n");
	/*
	 * write out the match data x coordinate
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->x),
	       sizeof(match_data_ptr->x),
	       "Error while writing match data x coordinate\n");
	/*
	 * write out the match data y coordinate
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->y),
	       sizeof(match_data_ptr->y),
	       "Error while writing match data y coordinate\n");
	/*
	 * write out the match data width
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->width),
	       sizeof(match_data_ptr->width),
	       "Error while writing match data width\n");
	/*
	 * write out the match data height
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->height),
	       sizeof(match_data_ptr->height),
	       "Error while writing match data height\n");
	/*
	 * write out the match data depth
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->depth),
	       sizeof(match_data_ptr->depth),
	       "Error while writing match data depth\n");
	/*
	 * write out the match data format
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->format),
	       sizeof(match_data_ptr->format),
	       "Error while writing match data format\n");
	/*
	 * write out the match data xoffset
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->xoffset),
	       sizeof(match_data_ptr->xoffset),
	       "Error while writing match data xoffset\n");
	/*
	 * write out the match data byte order
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->byte_order),
	       sizeof(match_data_ptr->byte_order),
	       "Error while writing match data byte order\n");
	/*
	 * write out the match data bitmap unit
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bitmap_unit),
	       sizeof(match_data_ptr->bitmap_unit),
	       "Error while writing match data bitmap unit\n");
	/*
	 * write out the match data bitmap bit order
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bitmap_bit_order),
	       sizeof(match_data_ptr->bitmap_bit_order),
	       "Error while writing match data bitmap bit order\n");
	/*
	 * write out the match data bitmap pad
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bitmap_pad),
	       sizeof(match_data_ptr->bitmap_pad),
	       "Error while writing match data bitmap pad\n");
	/*
	 * write out the match data bytes per line
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bytes_per_line),
	       sizeof(match_data_ptr->bytes_per_line),
	       "Error while writing match data bytes per line\n");
	/*
	 * write out the match data bits per pixel
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bits_per_pixel),
	       sizeof(match_data_ptr->bits_per_pixel),
	       "Error while writing match data bits per pixel\n");
	/*
	 * write out the match data visual class
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->visual_class),
	       sizeof(match_data_ptr->visual_class),
	       "Error while writing match data visual class\n");
	/*
	 * write out the match data red mask
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->red_mask),
	       sizeof(match_data_ptr->red_mask),
	       "Error while writing match data red mask\n");
	/*
	 * write out the match data green mask
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->green_mask),
	       sizeof(match_data_ptr->green_mask),
	       "Error while writing match data green mask\n");
	/*
	 * write out the match data blue mask
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->blue_mask),
	       sizeof(match_data_ptr->blue_mask),
	       "Error while writing match data blue mask\n");
	/*
	 * write out the match data bits per rgb
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->bits_per_rgb),
	       sizeof(match_data_ptr->bits_per_rgb),
	       "Error while writing match data bits per rgb\n");
	/*
	 * write out the match data colormap entries
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->colormap_entries),
	       sizeof(match_data_ptr->colormap_entries),
	       "Error while writing match data colormap entries\n");
	/*
	 * write out the match data color structure count
	 */
	wrchk2(internal_format_fd,
	       (char *) &(match_data_ptr->ncolors),
	       sizeof(match_data_ptr->ncolors),
	       "Error while writing match data color structure count\n");
	/*
	 * write out the color map entries
	 */
	for (i = 0, color_ptr = match_data_ptr->color_ptr;
	     i < match_data_ptr->ncolors;
	     i++, color_ptr++)
	{
		/*
		 * write out the color map pixel value
		 */
		wrchk2(internal_format_fd,
		       (char *) &(color_ptr->pixel),
		       sizeof(color_ptr->pixel),
		       "Error while writing color map pixel value\n");
		/*
		 * write out the color map red value
		 */
		wrchk2(internal_format_fd,
		       (char *) &(color_ptr->red),
		       sizeof(color_ptr->red),
		       "Error while writing color map red value\n");
		/*
		 * write out the color map green value
		 */
		wrchk2(internal_format_fd,
		       (char *) &(color_ptr->green),
		       sizeof(color_ptr->green),
		       "Error while writing color map green value\n");
		/*
		 * write out the color map blue value
		 */
		wrchk2(internal_format_fd,
		       (char *) &(color_ptr->blue),
		       sizeof(color_ptr->blue),
		       "Error while writing color map blue value\n");
		/*
		 * write out the color map flags value
		 */
		wrchk2(internal_format_fd,
		       (char *) &(color_ptr->flags),
		       sizeof(color_ptr->flags),
		       "Error while writing color map flags value\n");
	}
}
