/**********************************************************************
 *
 *	makef.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * device file pointers 
 */
extern FILE	*G_msg_file;
extern int	errno;

/**********************************************************************
 *
 *      makef
 *
 *      File creation routine.  It returns a file descriptor to its caller.
 */
int
makef(name)
/*
 * ptr to desired file name
 */
char   *name;
{
        /*
         * file descriptor
         */
        int    ofd;

        /*
         * create the file
         */
        ofd = creat(name, FILE_CREATION_MODE);
        /*
         * if creat failed
         */
        if (ofd < 0)
        {
                /*
                 * write message and exit
                 */
                (void) fprintf(G_msg_file,
			       "Unable to create file '%s'.\n",
			       name);
		(void) fprintf(G_msg_file, "errno was %d\n", errno);
		exit(1);
        }
        /*
         * return the file descriptor
         */
        return(ofd);
}
