/***********************************************************************
 *
 *	inttosum.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/***********************************************************************
 *	include files
 **********************************************************************/

/*
 * standard io defs
 */
#include  <stdio.h>
/*
 * X library defines
 */
#include  <X11/Xlib.h>
/*
 * more X library type defs
 */
#include  <X11/Xmd.h>
/*
 * more client exerciser type defs
 */
#include  <xtm.h>

/***********************************************************************
 *	external variables
 **********************************************************************/

extern FILE	*G_msg_file;
extern int	G_checksum_flag;
extern int	errno;

/***********************************************************************
 *	function declarations
 **********************************************************************/

void	read_match_data_from_internal();
void	write_match_data_to_xwd();
long	lseek();

/***********************************************************************
 *	functions
 **********************************************************************/

/***********************************************************************
 *
 *	inttosum
 *
 *	This routine translates match data from internal format
 *	to summary format.
 */
void
inttosum(from_fd, to_fptr, xwd_file_name, stripflag)
/*
 * file descriptor of the internal format file to read from
 */
int	from_fd;
/*
 * file pointer of the summary format file to write to
 */
FILE	*to_fptr;
/*
 * points to the name of the xwd file
 */
char	*xwd_file_name;
/*
 * if non-zero then leave out any image data
 */
int	stripflag;
{
	/*
	 * holds the match information temporarily
	 */
	struct match_data	match_data;
	/*
	 * holds the file descriptor of the xwd format file
	 */
	int			xwd_fd;

	/*
	 * read the match data information into the match data structure
	 */
	read_match_data_from_internal(from_fd, &match_data);
	/*
	 * if the strip flag is true or not using checksums and
	 *	    there is no image data
	 *     then just write out the match type and skip over
	 *     any image data in the internal format file
	 * else create an xwd format file for the match data and
	 *     write out the match type and name.
	 */
	if (stripflag || (!G_checksum_flag && (match_data.cnt == 0)))
	{
		/*
		 * write out the match type
		 */
		switch (match_data.type) 
		{
		case 'm':
			(void) fprintf(to_fptr, "<MATCH MOUSE>\n");
			break; 
		case 'p':
			(void) fprintf(to_fptr, "<MATCH PARTIAL>\n");
			break; 
		case 's':
			(void) fprintf(to_fptr, "<MATCH SCREEN>\n");
			break; 
		case 't':
			(void) fprintf(to_fptr, "<MATCH TOP>\n");
			break; 
		default:
			/*
			 * should never get here, but for consistancy.
			 */
			(void) fprintf(G_msg_file,
				       "match type error - unknown type %d\n",
				       match_data.type);
			exit(1); 
		}
                /*
                 * skip over the image data in the internal format file
                 */
                if (lseek(from_fd, (long) match_data.cnt, 1) == -1)
                {
                        (void) fprintf(G_msg_file,
                                       "error %d while seeking in internal format file\n",
                                       errno);
                        exit(1);
                }
	}
	else
	{
		/*
		 * create the xwd format file
		 */
		xwd_fd = makef(xwd_file_name);
		/*
		 * write the match data to the xwd format file
		 */
		write_match_data_to_xwd(xwd_fd, from_fd, &match_data);
		/*
		 * close the xwd format file
		 */
		if (close(xwd_fd) == -1)
		{
			(void) fprintf(G_msg_file,
				       "error %d while closing xwd format file\n",
				       errno);
			exit(1);
		}
		/*
		 * Write the match type and xwd format file name to the
		 * sumamry format file.  The xwd format file holds all of
		 * the information about the match data that we need except
		 * for the screen number and the x and y coordinates of the
		 * window that the match data was read from.  Those three
		 * pieces of information also have to be written out to the
		 * summary file.
		 */
		switch (match_data.type) 
		{
		case 'm':
			(void) fprintf(to_fptr,
				       "<MATCH MOUSE %s %d %d %d>\n",
				       xwd_file_name,
				       match_data.screen_number,
				       match_data.window_x,
				       match_data.window_y);
			break; 
		case 'p':
			(void) fprintf(to_fptr,
				       "<MATCH PARTIAL %s %d %d %d>\n",
				       xwd_file_name,
				       match_data.screen_number,
				       match_data.window_x,
				       match_data.window_y);
			break; 
		case 's':
			(void) fprintf(to_fptr,
				       "<MATCH SCREEN %s %d %d %d>\n",
				       xwd_file_name,
				       match_data.screen_number,
				       match_data.window_x,
				       match_data.window_y);
			break; 
		case 't':
			(void) fprintf(to_fptr,
				       "<MATCH TOP %s %d %d %d>\n",
				       xwd_file_name,
				       match_data.screen_number,
				       match_data.window_x,
				       match_data.window_y);
			break; 
		default:
			/*
			 * should never get here, but for consistancy.
			 */
			(void) fprintf(G_msg_file,
				       "match type error - unknown type %d\n",
				       match_data.type);
			exit(1); 
		}
	}
	/*
	 * free the color map structure memory, if any
	 */
	if ((match_data.ncolors > 0) &&
	    (match_data.color_ptr != (XColor *) 0))
	{
		free((char *) (match_data.color_ptr));
	}
}
