/**********************************************************************
 *
 *	getmouse.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * device file pointers 
 */
extern FILE		*G_msg_file;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	findmouse();
void	findchildren();
void	clipwin();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	getmouse
 *
 *	Match the window containing the mouse.
 */
int
getmouse(p, mouse_window_ptr)
/*
 * ???
 */
struct match_data	*p;
/*
 * window returned.
 */
Window			*mouse_window_ptr;
{
	/*
	 * ???
	 */
	int			i;
	/*
	 * subwindow where mouse is
	 */
	Window			subw;
	/*
	 * number of children
	 */
	unsigned int		nchildren;
	/*
	 * ???
	 */
	XWindowAttributes	*info;
	/*
	 * ???
	 */
	Window			*ids;

	p->screen_number = get_current_screen();
	findmouse(p->screen_number, &subw);
	findchildren(p->screen_number, &nchildren, &ids, &info);

	for (i = 0; i < nchildren; i++, info++, ids++)
	{
		if (subw == *ids)
		{
			if (info->map_state != IsViewable)
			{
				(void) fprintf(G_msg_file,
					       "The window containing the mouse is not viewable.\n");
				/*
				 * assign a window to the return parameter,
				 * but indicate failure to find good window
				 */
				*mouse_window_ptr = subw;
				return(0);
			}
			p->width = info->width;
			p->height = info->height;
			clipwin(subw, info, p);
			ids -= i;
			info -= i;
			free((char *) ids);
			free((char *) info);
			break;
		}
	}
	if (i < nchildren)
	{
		/*
		 *  window found. set return value. return success.
		 */
		*mouse_window_ptr = subw;
		return(1);
	}
	else
	{
		/*
		 * fell out of the loop without success.
		 * assign a window to the return parameter,
		 * but indicate failure to find good window
		 */
		*mouse_window_ptr = subw;
		return(0);
	}
}
