/**********************************************************************
 *
 *	getint.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/extensions/xtestext1.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * device file pointers 
 */
extern FILE		*G_msg_file;

/**********************************************************************
 * function definitons
 **********************************************************************/

void	readchk();

/**********************************************************************
 * functions
 **********************************************************************/

/***********************************************************************
 *
 *      getint
 *
 *      This routine retrieves a string of digits from a file and converts
 *      them to an integer.  It assumes that the file is positioned at the
 *      beginning of the string, and that the string is blank-terminated.
 */
int
getint(filedesc)
/*
 * argument filedesc - file descriptor
 */
int    filedesc;
{
	/*
	 * loop counter
	 */
        int	i;
	/*
	 * file character buffer
	 */
        char	int_str[MAX_INTEGER_CHARS];

	/*
	 * read in characters until a blank or too many chars
	 */
        for (i = 0; i < MAX_INTEGER_CHARS; i++)
        {
                readchk(filedesc, &(int_str[i]), 1, "read error in getint\n");
                if (int_str[i] == ' ')
		{
                        return(atoi(int_str));
		}
        }
	/*
	 * If I get here an error must have occured
	 */
	fprintf(G_msg_file,
		"too many characters in getint\n");
	exit(1);
}
