/**********************************************************************
 *
 *	getcurscr.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * invocation options
 */
extern int		G_debug_flag;
/*
 * device file pointers 
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * function declarationss
 **********************************************************************/

Bool	XQueryPointer();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	get_current_screen
 *
 *	This function determines which screen the mouse is in.
 */
int
get_current_screen()
{
	/*
	 * status returned from request
	 */
	Status		ret;
	/*
	 * x-coordinate of mouse (ignored)
	 */
	int		x;
	/*
	 * y-coordinate of mouse (ignored)
	 */
	int		y;
	/*
	 * holds root window id (ignored)
	 */
	Window		root_id;
	/*
	 * holds root window id (ignored)
	 */
	Window		window_return;
	/*
	 * holds root window x coord (ignored)
	 */
	int		root_x;
	/*
	 * holds root window y coord (ignored)
	 */
	int		root_y;
	/*
	 * holds modifier state (ignored)
	 */
	unsigned int	mask_return;
	/*
	 * used to loop through the possible screen numbers
	 */
	int		i;

	/*
	 * if there is only one screen, return 0 without wasting time
	 * checking
	 */
	if (ScreenCount(G_disp_ptr) == 1)
	{
		return(0);
	}
	/*
	 * There is more than one screen to check.  Loop through
	 * all of the screens until the XQueryPointer call returns
	 * successfully.
	 */
	for (i = 0; i < ScreenCount(G_disp_ptr); i++)
	{
		if (XQueryPointer(G_disp_ptr,
				  RootWindow(G_disp_ptr, i),
				  &root_id,
				  &window_return,
				  &root_x,
				  &root_y,
				  &x,
				  &y,
				  &mask_return) == True)
		{
			/*
			 * if the mouse (pointer) is on this screen, then
			 * get out of the loop
			 */
			break;
		}
	}
	/*
	 * if we looped through all of the screens without finding the mouse,
	 * then error
	 */
	if (i >= ScreenCount(G_disp_ptr))
	{
		(void) fprintf(G_msg_file,
			       "get_current_screen: the pointer could not be found in any screen.\n");
		exit(1);
	}
	/*
	 * return the screen number the mouse was found in
	 */
	return(i);
}
