/**********************************************************************
 *
 *	findchild.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * invocation options
 */
extern int		G_debug_flag;
/*
 * device file pointers 
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * function definitions
 **********************************************************************/

/*
 * ???
 */
Status	XQueryTree();
/*
 * ???
 */
char	*malloc();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	findchildren
 *
 *	This function finds all subwindows of the root window.
 */
void
findchildren(screen_number, nchildren, ids, info)
/*
 * number of the screen to use
 */
int			screen_number;
/*
 * number of children
 */
unsigned int		*nchildren;
/*
 * ???
 */
Window			**ids;
/*
 * ???
 */
XWindowAttributes	**info;
{
	/*
	 * status returned from request
	 */
	Status	ret;
	/*
	 * loop counter
	 */
	int	i;
	/*
	 * parent of queried window
	 */
	Window	parent_return;
	/*
	 * pointer to list of children
	 */
	Window	*children;
	/*
	 * pointer to list of children
	 */
	Window	*children_list;
	/*
	 * root of queried window
	 */
	Window	root_return;

	/*
	 * query the root window to get a list of its children
	 */
	ret = XQueryTree(G_disp_ptr,
			 RootWindow(G_disp_ptr, screen_number),
			 &root_return,
			 &parent_return,
			 &children,
			 nchildren);
	if (ret == 0)
	{
		(void) fprintf(G_msg_file, "XQueryTree failed.\n");
		exit (1);
	}
	/*
	 * save a pointer to the list of children so it can be freed later
	 */
	children_list = children;
	/*
	 * query each child to determine its location and id
	 */
	if ((*ids = (Window *) malloc(*nchildren * sizeof(Window))) ==
	    (Window *) 0)
	{
		(void) fprintf(G_msg_file,
			       "out of memory in findchildren\n");
		exit(1);
	}
	if ((*info = (XWindowAttributes *) malloc(*nchildren *
						  sizeof(XWindowAttributes))) ==
	    (XWindowAttributes *) 0)
	{
		(void) fprintf(G_msg_file,
			       "out of memory in findchildren\n");
		exit(1);
	}
	for (i = 0; i < *nchildren; i++, (*ids)++, (*info)++)
	{
		**ids = *children;
		ret = XGetWindowAttributes(G_disp_ptr, *children++, *info);
		if (ret == 0)
		{
			(void) fprintf(G_msg_file,
				       "XGetWindowAttributes failed.\n");
			exit (1);
		}
		if (G_debug_flag)
		{
			(void) fprintf(G_msg_file,
				       "Window %d: id %lx width=%d height=%d x-org=%d y-org=%d\n",
			               i,
			               *(children-1),
			               (*info)->width,
			               (*info)->height,
			               (*info)->x,
			               (*info)->y);
		}
	}
	*ids -= *nchildren;
	*info -= *nchildren;
	/*
	 * free the list of children for the window
	 *
	 * where are the ids and info structures malloc'ed above freed??????
	 */
	XFree((char *) children_list);
}
