/**********************************************************************
 *
 *	copymatd.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * variables
 **********************************************************************/

extern int		errno;
/*
 * Buffer for screen matches
 */
extern unsigned char	*G_sb;
/*
 * Buffer for screen matches
 */
extern unsigned int	G_sb_size;
/*
 * pointer to diagnostic/error message file
 */
extern FILE		*G_msg_file;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	readchk();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	copy_match_data
 *
 *	Copies match data from one file to another.
 */
void
copy_match_data(from_fd, to_fd, count)
/*
 * holds the "from" file descriptor
 */
int	from_fd;
/*
 * holds the "to" file descriptor
 */
int	to_fd;
/*
 * holds the number of bytes to copy
 */
INT32	count;
{
	/*
	 * holds the number of bytes to read at one time
	 */
	unsigned int	read_count;
	/*
	 * holds the current count
	 */
	INT32	current_count = 0;

	/*
	 * copy the match data from the "from" file to the "to" file
	 * using the screen match data buffer.
	 */
	while (current_count < count)
	{
		/*
		 * figure out how many bytes to read at one time
		 */
		read_count = (count - current_count) < G_sb_size ?
			     (count - current_count) :
			     G_sb_size;
		/*
		 * read the data from the "from" file
		 */
		readchk(from_fd,
			(char *) G_sb,
			read_count,
			"error while reading match data from file\n");
		/*
		 * write the data to the "to" file
		 */
		wrchk2(to_fd,
		       (char *) G_sb,
		       read_count,
		       "error while writing match data to file\n");
		/*
		 * add the number of bytes copied to the current count
		 */
		current_count += read_count;
	}
}
