/**********************************************************************
 *
 *	clipwin.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * ???
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * function definitions
 **********************************************************************/

/*
 * ???
 */
int	XTranslateCoordinates();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	clipwin
 *
 *	This function adjusts the match area so that no attempt is made
 *	to read an area that is clipped by the match window (the window
 *	the match area is in) or not on the screen.  It is passed the
 *	information returned for the match window by XGetWindowAttributes.
 *
 *	It is up to the calling routine to set the match area x and y
 *	coordinates (p->x and p->y).  The calling routine must also
 *	set the match area width and height, (p->width and p->height)
 *	and the screen containing the match area (p->screen_number).
 *
 *	The match area x and y coordinates are relative to the match
 *	window.
 */
void
clipwin(win, winp, p)
/*
 * ???
 */
Window			win;
/*
 * ???
 */
XWindowAttributes	*winp;
/*
 * ???
 */
struct match_data	*p;
{
	/*
	 * holds the absolute (root-relative) x coordinate of the match area
	 */
	int	abs_x;
	/*
	 * holds the absolute (root-relative) y coordinate of the match area
	 */
	int	abs_y;
	/*
	 * holds the child window returned by XTranslateCoordinates (ignored)
	 */
	Window	child_return;
	/*
	 * holds the status returned by XTranslateCoordinates
	 */
	int	status;

	/*
	 * set p->window_x to the x origin of the match window relative to its
	 * parent window
	 */
	p->window_x = winp->x;
	/*
	 * set p->window_y to the y origin of the match window relative to its
	 * parent window
	 */
	p->window_y = winp->y;
	/*
	 * clip the match area to fit in the match window
	 */
	if ((p->x + p->width) > winp->width)
	{
		p->width = winp->width - p->x;
	}
	if ((p->y + p->height) > winp->height)
	{
		p->height = winp->height - p->y;
	}
	if (p->x < 0)
	{
		p->width -= abs(p->x);
		p->x = 0;
	}
	if (p->y < 0)
	{
		p->height -= abs(p->y);
		p->y = 0;
	}
	/*
	 * compute the absolute (root-relative) x and y coordinates of the
	 * match area
	 */
	status = XTranslateCoordinates(G_disp_ptr,
				       win,
				       RootWindow(G_disp_ptr, p->screen_number),
				       p->x,
				       p->y,
				       &abs_x,
				       &abs_y,
				       &child_return);
	if (status == 0)
	{
		(void) fprintf(G_msg_file,
			       "clipwin: window is on a different screen.\n");
		exit(1);
	}
	/*
	 * clip the match area to fit in the root window of the current screen
	 */
	if ((abs_x + p->width) > DisplayWidth(G_disp_ptr, p->screen_number))
	{
		p->width = DisplayWidth(G_disp_ptr, p->screen_number) - abs_x;
	}
	if ((abs_y + p->height) > DisplayHeight(G_disp_ptr, p->screen_number))
	{
		p->height = DisplayHeight(G_disp_ptr, p->screen_number) - abs_y;
	}
	if (abs_x < 0)
	{
		p->x += abs(abs_x);
		p->width -= abs(abs_x);
	}
	if (abs_y < 0)
	{
		p->y += abs(abs_y);
		p->height -= abs(abs_y);
	}
}
