/**********************************************************************
 *
 *	chk_copy.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include <stdio.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * X windows library
 */
#include <X11/Xlib.h>
/*
 * client exerciser constants
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * buffer for saved input actions
 */
extern unsigned char	G_ia_buffer[];
/*
 * current index into buf
 */
extern int		G_ia_count;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	write_input_actions();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	chk_copy
 *
 *	This function copies the information to the input action buffer. 
 *	If the information will not fit in the input action buffer,
 *	the input action buffer is written out to the test script file,
 *	and the information is then put into the input action buffer.
 */
void
chk_copy(sfd, from, size)
/*
 * test script file descriptor
 */
int		sfd;
/*
 * address of bytes to put in the input action buffer
 */
unsigned char	*from;
/*
 * the number of bytes to copy
 */
int		size;
{
	int	i;

	/*
	 * if adding the new data would exceed the size of the input action
	 * buffer, write the input actions out to the test script file
	 */
	if (G_ia_count + size >= INPUT_ACTION_BUFFER_SIZE)
	{
		/*
		 * write out the data
		 */
		write_input_actions(sfd);
	}
	/*
	 * copy the information to input action buffer
	 */
	for (i = 0; i < size; i++)
	{
		G_ia_buffer[G_ia_count + i] = *(from + i);
	}
	G_ia_count += size;
}
