/**********************************************************************
 *
 *	checksum.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

#include  <stdio.h>
#include  <X11/Xmd.h>

/**********************************************************************
 * external variables
 **********************************************************************/

extern int	G_debug_flag;
extern FILE	*G_msg_file;

/**********************************************************************
 * functions
 **********************************************************************/

/*
 *	This routine has been adapted from the following routine (believed
 *	to be in the public domain):
 *
 *	C H K 3  --  Compute a type-3 Kermit block check. 
 *
 *	Calculate the 16-bit CRC of a null-terminated string using a
 *	byte-oriented tableless algorithm invented by Andy Lowry (Columbia
 *	University).  The magic number 010201 is derived from the CRC-CCITT
 *	polynomial x^16+x^12+x^5+1.  Note - this function could be adapted
 *	for strings containing imbedded 0's by including a length argument.
 *	Another note - Replacing this function by a table lookup version
 *	might speed things up.
 *
 *	chk3(s) char *s; {
 *	    unsigned int c, q;
 *	    LONG crc = 0;
 *	
 *	    while ((c = *s++) != '\0') {
 *		if (parity) c &= 0177;		Strip any parity
 *		q = (crc ^ c) & 017;		Low-order nibble
 *		crc = (crc >> 4) ^ (q * 010201);
 *		q = (crc ^ (c >> 4)) & 017;	High order nibble
 *		crc = (crc >> 4) ^ (q * 010201);
 *	    }
 *	    return(crc);
 *	}
 */
void
compute_checksum(checksum_ptr, buffer_ptr, count)
CARD32		*checksum_ptr;
unsigned char	*buffer_ptr;
unsigned int	count;
{
	unsigned int	i;
	unsigned int  	c, q;

	if (G_debug_flag)
	{
		(void) fprintf(G_msg_file,
			       "compute_checksum: starting checksum = %lu\n",
			       *checksum_ptr);
		(void) fprintf(G_msg_file,
			       "compute_checksum: count = %u\n",
			       count);
	}
	for (i = 0; i < count; i++)
	{
		c = buffer_ptr[i];
		/*
		 * Low-order nibble
		 */
		q = (*checksum_ptr ^ c) & 017;
		*checksum_ptr = (*checksum_ptr >> 4) ^ (q * 010201);
		/*
		 * High order nibble
		 */
		q = (*checksum_ptr ^ (c >> 4)) & 017;
		*checksum_ptr = (*checksum_ptr >> 4) ^ (q * 010201);
	}
	if (G_debug_flag)
	{
		(void) fprintf(G_msg_file,
			       "compute_checksum: ending checksum = %lu\n",
			       *checksum_ptr);
	}
}

