#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "color.h"



extern struct col_rec BaseColors[];
extern int	BaseCells, BaseCount;
extern int	OrigNpts, OrigNpolys;
extern int	Npts, Npolys;
extern int	*OrigPolys, *AllPolys, *iptr;
extern float	*OrigPts, *AllPts, *fptr;
extern float	*OrigProbs, *AllProbs;
extern int	*OrigPixels, *AllPixels;
extern int	LowMem;


/*
 * Write a wireframe description to a file
 */
void
writeframe(file)
	char *file;
{
	int i;
	FILE *fp;
	int *iptr1, *iptr2;
	float *fptr1, *fptr2;

	if ((file == NULL)||(*file == '\0'))
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(file, "w");
		if (fp == NULL)
		{
			fprintf(stderr, "cannot open file (%s) for writing\n",
				file);
		}
	}
	if (fp != NULL)
	{
		fprintf(fp, "%d\n", Npts);
		fprintf(fp, "%d\n", Npolys);
		fptr = AllPts;
		for (i=0; i<Npts; i++)
		{
			fprintf(fp, "%f ", *fptr++);
			fprintf(fp, "%f ", *fptr++);
			fprintf(fp, "%f\n", *fptr++);
		}
		fptr = AllProbs;
		iptr1 = AllPixels;
		iptr = AllPolys;
		for (i=0; i<Npolys; i++)
		{
			fprintf(fp, "%d ", *iptr++);
			fprintf(fp, "%d ", *iptr++);
			fprintf(fp, "%d ", *iptr++);
			if (*iptr1 != -1)
			{
				fprintf(fp, "P%d ", *iptr1);
			}
			if (*fptr != 1.0)
			{
				fprintf(fp, "O%f ", *fptr);
			}
			fprintf(fp, "\n");
			iptr1++;
			if (!LowMem)
			{
				fptr++;
			}
		}
		if (BaseCells != 0)
		{
			fprintf(fp, "Colormap %d\n", BaseCells);
			fprintf(fp, "red green blue\n", BaseCells);
			for (i=0; i<BaseCount; i++)
			{
				fprintf(fp, "%d %d %d\n",
					BaseColors[i].red,
					BaseColors[i].green,
					BaseColors[i].blue);
			}
		}
	}
	fclose(fp);
}


void
DoWrite(w, client_data, call_data)
        Widget w;
        caddr_t client_data, call_data;
{
	XmFileSelectionBoxCallbackStruct *dp;
	char *file;

	dp = (XmFileSelectionBoxCallbackStruct *)call_data;
	XmStringGetLtoR(dp->value, XmSTRING_DEFAULT_CHARSET, &file);
	writeframe(file);
}

