#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <Xm/List.h>
#include "edit.h"

#define	DEF_BLACK	BlackPixel(dsp, DefaultScreen(dsp))
#define	DEF_WHITE	WhitePixel(dsp, DefaultScreen(dsp))
#define MSTR(str)	XmStringCreateSimple((str))

#define _ABS(x)         ((x) < 0 ? -(x) : (x))
#define	MARKWIDTH	6
#define	SPACING		2

#define	RIGHT		0
#define	LEFT		1
#define	UP		2
#define	DOWN		3
#define	FORWARD		4
#define	BACK		5

extern int Npts, Npolys;
extern float *AllPts;
extern int *AllPolys;
extern int *AllPixels;
extern float *AllProbs;
extern XtAppContext app;
extern Display *dsp;
extern Window Dwindow;
extern GC invGC;
extern GC DrawGC;
extern float view_dist;
extern float distance;
extern unsigned int Width, Height;
extern Bool Perspective;
extern Bool EditMode;
extern Widget listlist;


void DrawLines();
void NewPoly();
int CheckPoly();
int NewPoint();


struct pt_rec {
	int indx;
	int indx2;
	int count;
	struct pt_rec *next;
};

struct pt_rec *pt_list = NULL;
struct pt_rec *Tlist = NULL;

XtIntervalId ArrowTimer = 0;
unsigned long initial_delay = 500;
unsigned long repeat_delay = 10;

int LPos = 1;
int EditType = SELECT;
static int EditCnt;
static int Edit1, Edit2, Edit3;



/*
 * Highlight point number passed in indx by drawing a mode-inverse
 * box on it
 */
void
ShowVertex(indx)
	int indx;
{
	int xscale, yscale, xoffset, yoffset;
	float xp1, yp1;
	float xu1, yu1, zu1;
	float *pptr;
	int px, py;

	xscale = xoffset = (Width) / 2;
	yscale = yoffset = (Height) / 2;

	pptr = (float *)(AllPts + (indx * 3));

	/*
	 * 3D to 2D transform
	 */
	xu1 = *pptr;
	yu1 = *(pptr + 1);
	zu1 = *(pptr + 2) - distance;
	if (Perspective == True)
	{
		xp1 = (xu1 * view_dist) / (view_dist - zu1);
		yp1 = (yu1 * view_dist) / (view_dist - zu1);
	}
	else
	{
		xp1 = (xu1 * view_dist) / (view_dist + distance);
		yp1 = (yu1 * view_dist) / (view_dist + distance);
	}
	px = (int)(xp1 * xscale) + xoffset;
	py = yoffset - (int)(yp1 * yscale);

	XFillRectangle(dsp, Dwindow, invGC,
		(px - (MARKWIDTH / 2)),
		(py - (MARKWIDTH / 2)),
		MARKWIDTH, MARKWIDTH);
}


/*
 * Toggle highlighting for all the selected verticies
 */
void
ShowAllVertices()
{
	struct pt_rec *ptr;

	ptr = pt_list;
	while (ptr != NULL)
	{
		ShowVertex(ptr->indx);
		ptr = ptr->next;
	}
}


void
free_pt_list()
{
	struct pt_rec *ptptr;
	struct pt_rec *tptr;
	Arg arg[10];
	Cardinal argcnt;

	ptptr = pt_list;
	while (ptptr != NULL)
	{
		tptr = ptptr;
		ptptr = ptptr->next;
		ShowVertex(tptr->indx);
		XtFree(tptr);
	}
	pt_list = NULL;
	XmListDeleteAllItems(listlist);
	LPos = 1;
	argcnt = 0;
	XtSetArg(arg[argcnt], XmNvisibleItemCount, LPos); argcnt++;
	XtSetValues(listlist, arg, argcnt);
}


/*
 * Add point number indx to the list of selected points, and then
 * highlight it.
 * If the point is already in the list, remove it, and unhighlight it.
 */
int
add_pt_list(indx)
	int indx;
{
	struct pt_rec pthead;
	struct pt_rec *ptptr;
	float *pptr;
	float x, y, z;
	char lab[100];
	int found;
	Arg arg[10];
	Cardinal argcnt;

	pptr = (float *)(AllPts + (indx * 3));
	x = *pptr;
	y = *(pptr + 1);
	z = *(pptr + 2);
	sprintf(lab, "% 1.3e  % 1.3e  % 1.3e", x, y, z);

	found = 0;
	if (pt_list == NULL)
	{
		pt_list = (struct pt_rec *)XtMalloc(sizeof(struct pt_rec));
		pt_list->indx = indx;
		pt_list->next = NULL;
		pt_list->count = LPos;
		XmListAddItem(listlist, MSTR(lab), LPos);
		argcnt = 0;
		XtSetArg(arg[argcnt], XmNvisibleItemCount, LPos); argcnt++;
		XtSetValues(listlist, arg, argcnt);
		LPos++;
	}
	else
	{

		pthead.next = pt_list;
		ptptr = &pthead;
		while (ptptr->next != NULL)
		{
			if (ptptr->next->indx == indx)
			{
				struct pt_rec *tptr;

				tptr = ptptr->next->next;
				while(tptr != NULL)
				{
					tptr->count = tptr->count - 1;
					tptr = tptr->next;
				}
				tptr = ptptr->next;
				ptptr->next = ptptr->next->next;
				XmListDeletePos(listlist, tptr->count);
				LPos--;
				if (LPos > 1)
				{
					argcnt = 0;
					XtSetArg(arg[argcnt],
						XmNvisibleItemCount,
						(LPos - 1));
					argcnt++;
					XtSetValues(listlist, arg, argcnt);
				}
				XtFree(tptr);
				found = 1;
				break;
			}
			ptptr = ptptr->next;
		}
		if (!found)
		{
			ptptr->next = (struct pt_rec *)
				XtMalloc(sizeof(struct pt_rec));
			ptptr->next->indx = indx;
			ptptr->next->next = NULL;
			ptptr->next->count = LPos;
			XmListAddItem(listlist, MSTR(lab), LPos);
			argcnt = 0;
			XtSetArg(arg[argcnt], XmNvisibleItemCount, LPos);
			argcnt++;
			XtSetValues(listlist, arg, argcnt);
			LPos++;
		}
		pt_list = pthead.next;
	}
	ShowVertex(indx);
	return(found);
}


void
FreeLines()
{
	struct pt_rec *tptr;

	while (Tlist != NULL)
	{
		tptr = Tlist;
		Tlist = Tlist->next;
		XtFree(tptr);
	}
	Tlist = NULL;
}


struct pt_rec *
AddLine(tptr, indx, indx2, delete)
	struct pt_rec *tptr;
	int indx;
	int indx2;
	int delete;
{
	struct pt_rec *ptptr;

	if (tptr == NULL)
	{
		tptr = (struct pt_rec *)XtMalloc(sizeof(struct pt_rec));
		tptr->indx = indx;
		tptr->indx2 = indx2;
		tptr->count = 1;
		tptr->next = NULL;
		DrawLines(tptr, 0);
	}
	else
	{
		int found = 0;
		struct pt_rec *prev;

		ptptr = tptr;
		while (ptptr != NULL)
		{
			if (((ptptr->indx == indx)&&(ptptr->indx2 == indx2))||
			    ((ptptr->indx == indx2)&&(ptptr->indx2 == indx)))
			{
				if (delete)
				{
					ptptr->count = ptptr->count - 1;
					if (ptptr->count == 0)
					{
						if (ptptr == tptr)
						{
							tptr = tptr->next;
							ptptr->next = NULL;
							DrawLines(ptptr, 1);
							XtFree(ptptr);
						}
						else
						{
						       prev->next = ptptr->next;
						       ptptr->next = NULL;
						       DrawLines(ptptr, 1);
						       XtFree(ptptr);
						}
					}
					found = 1;
					break;
				}
				else
				{
					ptptr->count = ptptr->count + 1;
					found = 1;
					break;
				}
			}
			prev = ptptr;
			ptptr = ptptr->next;
		}
		if (!found)
		{
			ptptr = (struct pt_rec *)
				XtMalloc(sizeof(struct pt_rec));
			ptptr->indx = indx;
			ptptr->indx2 = indx2;
			ptptr->count = 1;
			ptptr->next = NULL;
			DrawLines(ptptr, 0);
			ptptr->next = tptr;
			tptr = ptptr;
		}
	}
	return(tptr);
}


struct pt_rec *
FindLines(tptr, indx, delete)
	struct pt_rec *tptr;
	int indx;
	int delete;
{
	int i;
	struct pt_rec *newptr;
	int *pptr;
	int p1, p2, p3;

	XSetForeground(dsp, DrawGC, DEF_BLACK);

	pptr = AllPolys;
	for (i=0; i<Npolys; i++)
	{
		p1 = *pptr++;
		p2 = *pptr++;
		p3 = *pptr++;
		if (p1 == indx)
		{
			tptr = AddLine(tptr, p1, p2, delete);
			tptr = AddLine(tptr, p1, p3, delete);
		}
		else if (p2 == indx)
		{
			tptr = AddLine(tptr, p2, p1, delete);
			tptr = AddLine(tptr, p2, p3, delete);
		}
		else if (p3 == indx)
		{
			tptr = AddLine(tptr, p3, p1, delete);
			tptr = AddLine(tptr, p3, p2, delete);
		}
	}

	XSetForeground(dsp, DrawGC, DEF_WHITE);

	return(tptr);
}


void
DrawLines(tptr, xor)
	struct pt_rec *tptr;
	int xor;
{
	float *fptr;
	int draw;
	int xscale, yscale, xoffset, yoffset;
	float xp1, yp1, xp2, yp2;
        float xu1, xu2, yu1, yu2, zu1, zu2;
	int x1, x2, y1, y2;

	/*
	 * scale points so distance on 1.0 equals 1/2 window size
	 */
	xscale = xoffset = (Width) / 2;
	yscale = yoffset = (Height) / 2;
	while (tptr != NULL)
	{
		draw = 1;
		fptr = (float *)(AllPts + (tptr->indx * 3));
		xu1 = *fptr;
		yu1 = *(fptr + 1);
		zu1 = *(fptr + 2) - distance;
		fptr = (float *)(AllPts + (tptr->indx2 * 3));
		xu2 = *fptr;
		yu2 = *(fptr + 1);
		zu2 = *(fptr + 2) - distance;

		/*
		 * clip triangles that are partially behind your "eye"
		 */
		if ((zu1 >= view_dist)||(zu2 >= view_dist))
		{
			draw = 0;
		}

		if (Perspective == True)
		{
			xp1 = (xu1 * view_dist) / (view_dist - zu1);
			yp1 = (yu1 * view_dist) / (view_dist - zu1);
			xp2 = (xu2 * view_dist) / (view_dist - zu2);
			yp2 = (yu2 * view_dist) / (view_dist - zu2);
		}
		else
		{
			xp1 = (xu1 * view_dist) / (view_dist + distance);
			yp1 = (yu1 * view_dist) / (view_dist + distance);
			xp2 = (xu2 * view_dist) / (view_dist + distance);
			yp2 = (yu2 * view_dist) / (view_dist + distance);
		}

		/*
		 * scale x coordinates to window space
		 */
		x1 = (int)(xp1 * xscale) + xoffset;
		x2 = (int)(xp2 * xscale) + xoffset;

		/*
		 * scale y coordinates to window space
		 */
		y1 = yoffset - (int)(yp1 * yscale);
		y2 = yoffset - (int)(yp2 * yscale);

		if (draw)
		{
			if (xor)
			{
				XDrawLine(dsp, Dwindow, invGC, x1, y1, x2, y2);
			}
			else
			{
				XDrawLine(dsp, Dwindow, DrawGC, x1, y1, x2, y2);
			}
		}

		tptr = tptr->next;
	}
}


/*
 * Search through all the points and find the one closest to the
 * passed x, y window position.
 * For points that map to the exact same x, y window position, take
 * the one with the greatest z coordinate.
 */
int
SelectPoint(x, y)
	int x, y;
{
	int i, indx;
	int xscale, yscale, xoffset, yoffset;
	float xp1, yp1;
	float xu1, yu1, zu1;
	float *pptr;
	int px, py;
	int dist, Tdist;
	float zdist;

	/*
	 * scale points so distance on 1.0 equals 1/2 window size
	 */
	xscale = xoffset = (Width) / 2;
	yscale = yoffset = (Height) / 2;

	pptr = AllPts;

	indx = 0;
	xu1 = *pptr;
	yu1 = *(pptr + 1);
	zu1 = *(pptr + 2) - distance;
	zdist = zu1;
	if (Perspective == True)
	{
		xp1 = (xu1 * view_dist) / (view_dist - zu1);
		yp1 = (yu1 * view_dist) / (view_dist - zu1);
	}
	else
	{
		xp1 = (xu1 * view_dist) / (view_dist + distance);
		yp1 = (yu1 * view_dist) / (view_dist + distance);
	}
	px = (int)(xp1 * xscale) + xoffset;
	py = yoffset - (int)(yp1 * yscale);
	dist = ((px - x) * (px - x)) + ((py - y) * (py - y));

	for (i=0; i<Npts; i++)
	{
		/*
		 * get the x, y, z coordinates of the vertex
		 */
		xu1 = *pptr;
		yu1 = *(pptr + 1);
		zu1 = *(pptr + 2) - distance;
	
		/*
		 * convert to x, y coordinates based on perpective projection
		 */
		if (Perspective == True)
		{
			xp1 = (xu1 * view_dist) / (view_dist - zu1);
			yp1 = (yu1 * view_dist) / (view_dist - zu1);
		}
		else
		{
			xp1 = (xu1 * view_dist) / (view_dist + distance);
			yp1 = (yu1 * view_dist) / (view_dist + distance);
		}

		/*
		 * scale x, y coordinates to window space
		 */
		px = (int)(xp1 * xscale) + xoffset;
		py = yoffset - (int)(yp1 * yscale);

		Tdist = ((px - x) * (px - x)) + ((py - y) * (py - y));
		if ((Tdist < dist) || ((Tdist == dist)&&(zu1 > zdist)))
		{
			dist = Tdist;
			zdist = zu1;
			indx = i;
		}

		/*
		 * get the next vertex in the list
		 */
		pptr += 3;
	}

	return(indx);
}


/*
 * We got a button press event.  If we are in EditMode, and it
 * was button1.  Toggle the select status of the nearest point.
 */
void
SelectCall(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int indx;
	int delete;
	XmDrawingAreaCallbackStruct *sp =
		(XmDrawingAreaCallbackStruct *)call_data;

	if ((sp->event->type == ButtonPress)&&(EditMode == True))
	{
		XButtonPressedEvent *bp = (XButtonPressedEvent *)sp->event;

		if ((bp->button == Button1)&&(EditType == SELECT))
		{ 
			indx = SelectPoint(bp->x, bp->y);
			delete = add_pt_list(indx);
			ShowAllVertices();
			DrawLines(Tlist, 1);
			Tlist = FindLines(Tlist, indx, delete);
			DrawLines(Tlist, 1);
			ShowAllVertices();
		}
		else if ((bp->button == Button1)&&(EditType == ADD))
		{ 
			if (EditCnt == 0)
			{
				indx = NewPoint(bp->x, bp->y);
				Edit1 = indx;
				delete = add_pt_list(indx);
				EditCnt++;
			}
			else if (EditCnt == 1)
			{
				indx = NewPoint(bp->x, bp->y);
				Edit2 = indx;
				delete = add_pt_list(indx);
				ShowAllVertices();
				XSetForeground(dsp, DrawGC, DEF_WHITE);
				Tlist = AddLine(Tlist, Edit2, Edit1, delete);
				Tlist = AddLine(Tlist, Edit1, Edit2, delete);
				ShowAllVertices();
				EditCnt++;
			}
			else if (EditCnt == 2)
			{
				indx = NewPoint(bp->x, bp->y);
				Edit3 = indx;
				delete = add_pt_list(indx);
				ShowAllVertices();
				XSetForeground(dsp, DrawGC, DEF_WHITE);
				Tlist = AddLine(Tlist, Edit2, Edit3, delete);
				Tlist = AddLine(Tlist, Edit1, Edit3, delete);
				Tlist = AddLine(Tlist, Edit3, Edit2, delete);
				Tlist = AddLine(Tlist, Edit3, Edit1, delete);
				ShowAllVertices();
				NewPoly(Edit1, Edit2, Edit3);
				EditCnt = 0;
			}
		}
		else if ((bp->button == Button1)&&(EditType == LINK))
		{ 
			if (EditCnt == 0)
			{
				indx = SelectPoint(bp->x, bp->y);
				delete = add_pt_list(indx);
				ShowAllVertices();
				DrawLines(Tlist, 1);
				Tlist = FindLines(Tlist, indx, delete);
				DrawLines(Tlist, 1);
				ShowAllVertices();
				if (!delete)
				{
					Edit1 = indx;
					EditCnt++;
				}
			}
			else if (EditCnt == 1)
			{
				indx = SelectPoint(bp->x, bp->y);
				delete = add_pt_list(indx);
				ShowAllVertices();
				DrawLines(Tlist, 1);
				Tlist = FindLines(Tlist, indx, delete);
				DrawLines(Tlist, 1);
				if (!delete)
				{
					Edit2 = indx;
					XSetForeground(dsp, DrawGC, DEF_WHITE);
					Tlist = AddLine(Tlist, Edit2, Edit1,
						delete);
					Tlist = AddLine(Tlist, Edit1, Edit2,
						delete);
					EditCnt++;
				}
				ShowAllVertices();
			}
			else if (EditCnt == 2)
			{
				indx = SelectPoint(bp->x, bp->y);
				delete = add_pt_list(indx);
				ShowAllVertices();
				DrawLines(Tlist, 1);
				Tlist = FindLines(Tlist, indx, delete);
				DrawLines(Tlist, 1);
				if (!delete)
				{
					Edit3 = indx;
					XSetForeground(dsp, DrawGC, DEF_WHITE);
					Tlist = AddLine(Tlist, Edit2, Edit3,
						delete);
					Tlist = AddLine(Tlist, Edit1, Edit3,
						delete);
					Tlist = AddLine(Tlist, Edit3, Edit2,
						delete);
					Tlist = AddLine(Tlist, Edit3, Edit1,
						delete);
				}
				ShowAllVertices();
				if (!delete)
				{
					indx = CheckPoly(Edit1, Edit2, Edit3);
					if (indx == -1)
					{
						NewPoly(Edit1, Edit2, Edit3);
					}
					else
					{
						Tlist = AddLine(Tlist,
							Edit2, Edit1, 1);
						Tlist = AddLine(Tlist,
							Edit1, Edit2, 1);
						Tlist = AddLine(Tlist,
							Edit2, Edit3, 1);
						Tlist = AddLine(Tlist,
							Edit1, Edit3, 1);
						Tlist = AddLine(Tlist,
							Edit3, Edit2, 1);
						Tlist = AddLine(Tlist,
							Edit3, Edit1, 1);
					}
					EditCnt = 0;
				}
			}
		}
	}
}


/*
 * Move all the selected points one movement unit in the
 * passed direction
 */
void
MovePts(dir)
	int dir;
{
	int i;
	int xscale, yscale;
	float x, y, z;
	float dx, dy, dz;
	float *fptr;
	struct pt_rec *ptr;
	char lab[100];
	XmString *Mlabs;
	XmString *Mptr;

	if (LPos > 1)
	{
		Mlabs = (XmString *)XtMalloc((LPos - 1) * sizeof(XmString));
	}

	xscale = (Width) / 2;
	yscale = (Height) / 2;

	ShowAllVertices();
	DrawLines(Tlist, 1);

	Mptr = Mlabs;
	ptr = pt_list;
	while (ptr != NULL)
	{
		fptr = (float *)(AllPts + (ptr->indx * 3));
		x = *fptr;
		y = *(fptr + 1);
		z = *(fptr + 2) - distance;
		dx = 0.0;
		dy = 0.0;
		dz = 0.0;

	switch (dir)
	{
		case RIGHT:
			if (Perspective == True)
			{
				dx = ((view_dist - z) / xscale / view_dist);
			}
			else
			{
				dx = ((view_dist - distance) / xscale / view_dist);
			}
			break;
		case LEFT:
			if (Perspective == True)
			{
				dx = -1 * ((view_dist - z) / xscale / view_dist);
			}
			else
			{
				dx = -1 * ((view_dist - distance) / xscale / view_dist);
			}
			break;
		case UP:
			if (Perspective == True)
			{
				dy = ((view_dist - z) / yscale / view_dist);
			}
			else
			{
				dy = ((view_dist - distance) / yscale / view_dist);
			}
			break;
		case DOWN:
			if (Perspective == True)
			{
				dy = -1 * ((view_dist - z) / yscale / view_dist);
			}
			else
			{
				dy = -1 * ((view_dist - distance) / yscale / view_dist);
			}
			break;
		case FORWARD:
			dz = -0.1;
			break;
		case BACK:
			dz = 0.1;
			break;
	}

		x += dx;
		y += dy;
		z += dz;
		*fptr = x;
		*(fptr + 1) = y;
		*(fptr + 2) = z + distance;

		sprintf(lab, "% 1.3e  % 1.3e  % 1.3e", x, y, (z + distance));
		*Mptr = MSTR(lab);
		Mptr++;

		ptr = ptr->next;
	}

	if (LPos > 1)
	{
		XmListReplaceItemsPos(listlist, Mlabs, (LPos - 1), 1);
		Mptr = Mlabs;
		for (i=0; i<(LPos - 1); i++)
		{
			XmStringFree(*Mptr);
			Mptr++;
		}
		XtFree((char *)Mlabs);
	}

	DrawLines(Tlist, 1);
	ShowAllVertices();
}


/*
 * This timer is used to allow held down mouse buttons to cause
 * repeated movement.
 */
void
TimerEvent (client_data, id)
	caddr_t client_data;
	XtIntervalId *id;
{
	int dir = (int)client_data;

	MovePts(dir);
	ArrowTimer = XtAppAddTimeOut (app,
		(unsigned long) repeat_delay,
		(XtTimerCallbackProc) TimerEvent, client_data);
}


/*
 * An arrow button to move selected points was pushed
 */
void
ArrowPushed(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int dir = (int)client_data;

	MovePts(dir);
	ArrowTimer = XtAppAddTimeOut (app,
		(unsigned long) initial_delay,
		(XtTimerCallbackProc) TimerEvent, client_data);
}


/*
 * An arrow button to move selected points was released
 */
void
ArrowReleased(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	XtRemoveTimeOut (ArrowTimer);
}


/*
 * Delete all the selected points, and remove all triangles that use them.
 */
void
DeleteCall(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	struct pt_rec *ptr;
	float *pptr;
	float *fptr;
	float *fptr1;
	float *fptr2;
	int *iptr;
	int *iptr1;
	int *iptr2;
	int *iptr3;
	int i, pcnt, tcnt, deleted;

	if (pt_list == NULL)
	{
		return;
	}

	/*
	 * count the selected points
	 */
	pcnt = 0;
	ptr = pt_list;
	while (ptr != NULL)
	{
		pcnt++;
		ptr = ptr->next;
	}

	/*
	 * Make a new point array
	 */
	pptr = (float *)XtMalloc((Npts - pcnt) * 3 * sizeof(float));
	fptr1 = AllPts;
	fptr2 = pptr;
	for (i=0; i<Npts; i++)
	{
		deleted = 0;
		ptr = pt_list;
		while (ptr != NULL)
		{
			if (ptr->indx == i)
			{
				deleted = 1;
				break;
			}
			ptr = ptr->next;
		}
		if (deleted)
		{
			fptr1++;
			fptr1++;
			fptr1++;
		}
		else
		{
			*fptr2++ = *fptr1++;
			*fptr2++ = *fptr1++;
			*fptr2++ = *fptr1++;
		}
	}

	/*
	 * mark and count all the deleted triangles that used these deleted
	 * points.
	 */
	tcnt = 0;
	iptr1 = AllPolys;
	for (i=0; i<Npolys; i++)
	{
		int i1, i2, i3;

		i1 = *iptr1;
		i2 = *(iptr1 + 1);
		i3 = *(iptr1 + 2);

		deleted = 0;
		ptr = pt_list;
		while (ptr != NULL)
		{
			if ((ptr->indx == i1)||
			    (ptr->indx == i2)||
			    (ptr->indx == i3))
			{
				deleted = 1;
				break;
			}
			ptr = ptr->next;
		}
		if (deleted)
		{
			tcnt++;
			*iptr1++ = -1;
			*iptr1++ = -1;
			*iptr1++ = -1;
		}
		else
		{
			iptr1++;
			iptr1++;
			iptr1++;
		}
	}

	/*
	 * Copy a new probability array
	 */
	fptr = (float *)XtMalloc((Npolys - tcnt) * sizeof(float));
	iptr1 = AllPolys;
	fptr1 = AllProbs;
	fptr2 = fptr;
	for (i=0; i<Npolys; i++)
	{
		if (*iptr1 == -1)
		{
			fptr1++;
		}
		else
		{
			*fptr2++ = *fptr1++;
		}
		iptr1++;
		iptr1++;
		iptr1++;
	}
	XtFree((char *)AllProbs);
	AllProbs = fptr;

	/*
	 * Copy a new pixel array
	 */
	iptr = (int *)XtMalloc((Npolys - tcnt) * sizeof(int));
	iptr3 = AllPolys;
	iptr1 = AllPixels;
	iptr2 = iptr;
	for (i=0; i<Npolys; i++)
	{
		if (*iptr3 == -1)
		{
			iptr1++;
		}
		else
		{
			*iptr2++ = *iptr1++;
		}
		iptr3++;
		iptr3++;
		iptr3++;
	}
	XtFree((char *)AllPixels);
	AllPixels = iptr;

	/*
	 * Copy a new triangle list, updating vertex number to match the new
	 * point list
	 */
	iptr = (int *)XtMalloc((Npolys - tcnt) * 3 * sizeof(int));
	iptr1 = AllPolys;
	iptr2 = iptr;
	for (i=0; i<Npolys; i++)
	{
		int i1, i2, i3, d1, d2, d3;

		if (*iptr1 == -1)
		{
			iptr1++;
			iptr1++;
			iptr1++;
		}
		else
		{
			d1 = 0;
			d2 = 0;
			d3 = 0;
			i1 = *iptr1;
			i2 = *(iptr1 + 1);
			i3 = *(iptr1 + 2);

			ptr = pt_list;
			while (ptr != NULL)
			{
				if (i1 > ptr->indx)
				{
					d1++;
				}
				if (i2 > ptr->indx)
				{
					d2++;
				}
				if (i3 > ptr->indx)
				{
					d3++;
				}
				ptr = ptr->next;
			}

			*iptr2++ = (*iptr1 - d1);
			iptr1++;
			*iptr2++ = (*iptr1 - d2);
			iptr1++;
			*iptr2++ = (*iptr1 - d3);
			iptr1++;
		}
	}

	DrawLines(Tlist, 1);
	FreeLines();
	free_pt_list();

	XtFree((char *)AllPts);
	AllPts = pptr;
	Npts = Npts - pcnt;
	XtFree((char *)AllPolys);
	AllPolys = iptr;
	Npolys = Npolys - tcnt;
}


/*
 * Set the editing type to link.  We are link three points to make a new
 * triangle to add to the poly list.
 */
void
SetLink(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (EditMode == True)
	{
		if (EditType == LINK)
		{
			EditType = SELECT;
		}
		else
		{
			EditType = LINK;
		}
		EditCnt = 0;
	}
}


/*
 * Set the editing type to add.  We are adding three points to make a new
 * triangle to add to the poly list.
 */
void
SetAdd(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (EditMode == True)
	{
		if (EditType == ADD)
		{
			EditType = SELECT;
		}
		else
		{
			EditType = ADD;
		}
		EditCnt = 0;
	}
}


/*
 * Takes the passed x.y window coordinates, and make a new point at
 * distance 0 from the observer, and add it to the end of the point list.
 */
int
NewPoint(x, y)
	int x, y;
{
	float fx, fy, fz;
	int xscale, yscale, xoffset, yoffset;
	float *fptr;
	float *fptr1;
	float *fptr2;
	int i;

	/*
	 * Turn window space into object space.
	 */
	xscale = xoffset = (Width) / 2;
	yscale = yoffset = (Height) / 2;
	fx = (float)(x - xoffset) / xscale;
	fy = (float)(yoffset - y) / yscale;
	fz = -distance;
	if (Perspective == True)
	{
		fx = fx * (view_dist - fz) / view_dist;
		fy = fy * (view_dist - fz) / view_dist;
	}
	else
	{
		fx = fx * (view_dist + distance) / view_dist;
		fy = fy * (view_dist + distance) / view_dist;
	}

	/*
	 * Malloc space for a 1 larger point array, and copy it in.
	 */
	fptr = (float *)XtMalloc((Npts + 1) * 3 * sizeof(float));
	fptr1 = AllPts;
	fptr2 = fptr;
	for (i=0; i<Npts; i++)
	{
		*fptr2++ = *fptr1++;
		*fptr2++ = *fptr1++;
		*fptr2++ = *fptr1++;
	}
	*fptr2++ = fx;
	*fptr2++ = fy;
	*fptr2++ = fz + distance;
	XtFree((char *)AllPts);
	AllPts = fptr;
	Npts++;
	return((Npts - 1));
}


/*
 * Look through the polygon aray for this triangle.  If it is there, return
 * its index, otherwise return -1
 */
int
CheckPoly(v1, v2, v3)
	int v1, v2, v3;
{
	int i;
	int p1, p2, p3;
	int *iptr;

	iptr = AllPolys;
	for (i=0; i<Npolys; i++)
	{
		p1 = *iptr++;
		p2 = *iptr++;
		p3 = *iptr++;
		if (((v1 == p1)&&(v2 == p2)&&(v3 == p3))||
		    ((v1 == p2)&&(v2 == p3)&&(v3 == p1))||
		    ((v1 == p3)&&(v2 == p1)&&(v3 == p2)))
		{
			return(i);
		}
	}
	return(-1);
}


/*
 * Add the triangle made up of the verticies passed to the polygon array.
 * Also give it default values in the Pixel and probability arrays.
 */
void
NewPoly(v1, v2, v3)
	int v1, v2, v3;
{
	int i;
	int *iptr;
	int *iptr1;
	int *iptr2;
	float *fptr;
	float *fptr1;
	float *fptr2;

	/*
	 * malloc space for a one larger polygon array, and add the new
	 * triangle to the end
	 */
	iptr = (int *)XtMalloc((Npolys + 1) * 3 * sizeof(int));
	iptr1 = AllPolys;
	iptr2 = iptr;
	for (i=0; i<Npolys; i++)
	{
		*iptr2++ = *iptr1++;
		*iptr2++ = *iptr1++;
		*iptr2++ = *iptr1++;
	}
	*iptr2++ = v1;
	*iptr2++ = v2;
	*iptr2++ = v3;
	XtFree((char *)AllPolys);
	AllPolys = iptr;

	/*
	 * malloc space for a one larger pixel array, and add 
	 * -1 to the end
	 */
	iptr = (int *)XtMalloc((Npolys + 1) * 3 * sizeof(int));
	iptr1 = AllPixels;
	iptr2 = iptr;
	for (i=0; i<Npolys; i++)
	{
		*iptr2++ = *iptr1++;
	}
	*iptr2++ = -1;
	XtFree((char *)AllPixels);
	AllPixels = iptr;

	/*
	 * malloc space for a one larger probability array, and add 
	 * 1.0 to the end
	 */
	fptr = (float *)XtMalloc((Npolys + 1) * 3 * sizeof(float));
	fptr1 = AllProbs;
	fptr2 = fptr;
	for (i=0; i<Npolys; i++)
	{
		*fptr2++ = *fptr1++;
	}
	*fptr2++ = 1.0;
	XtFree((char *)AllProbs);
	AllProbs = fptr;

	Npolys++;
}

