#include <stdio.h>
#include <X11/Intrinsic.h>
#include <math.h>
#include <values.h>

#define _ABS(x)         ((x) < 0 ? -(x) : (x))


extern void AddList();
extern double S3Noise();


extern float view_dist;
extern float distance;
extern Bool EditMode;
extern int Npts;
extern double Total_Rot[3][3];

void UnRotate();


/*
 * Copy the first count points from array v1 to array v2.
 */
Duplicate(v1, v2, count)
	float *v1, *v2;
	int count;
{
	int i;

	for(i=0; i<count; i++)
	{
		*v2++ = *v1++;
		*v2++ = *v1++;
		*v2++ = *v1++;
	}
}


/*
 * Rotate the first vcount points in the v array by theta degrees around
 * the X-axis.  Also multiply the rotation into the cumulative rotation 
 * array.
 */
void
rotatex(v, vcount, theta)
	float *v;
	int vcount;
	int theta;
{
	int i;
	float s, c, x, y, z;
	float *fptr;
	double new[3][3];

	c = (float)cos((double)((M_PI * theta) / 180.0)); 
	s = (float)sin((double)((M_PI * theta) / 180.0)); 
	for (i=0; i<3; i++)
	{
		new[i][0] = Total_Rot[i][0];
		new[i][1] = (Total_Rot[i][1] * c) - (Total_Rot[i][2] * s);
		new[i][2] = (Total_Rot[i][1] * s) + (Total_Rot[i][2] * c);
	}
	for (i=0; i<3; i++)
	{
		Total_Rot[0][i] = new[0][i];
		Total_Rot[1][i] = new[1][i];
		Total_Rot[2][i] = new[2][i];
	}
	for (i=0; i<vcount; i++)
	{
		fptr = (float *)(v + (i * 3));
		y = *(fptr + 1);
		z = *(fptr + 2);
		*(fptr + 1) = (y * c) - (z * s);
		*(fptr + 2) = (y * s) + (z * c);
	}
}


/*
 * Rotate the first vcount points in the v array by theta degrees around
 * the Y-axis.  Also multiply the rotation into the cumulative rotation 
 * array.
 */
void
rotatey(v, vcount, theta)
	float *v;
	int vcount;
	int theta;
{
	int i;
	float c, s, x, y, z;
	float *fptr;
	double new[3][3];

	c = (float)cos((double)((M_PI * theta) / 180.0)); 
	s = (float)sin((double)((M_PI * theta) / 180.0)); 
	for (i=0; i<3; i++)
	{
		new[i][0] = (Total_Rot[i][0] * c) - (Total_Rot[i][2] * s);
		new[i][1] = Total_Rot[i][1];
		new[i][2] = (Total_Rot[i][0] * s) + (Total_Rot[i][2] * c);
	}
	for (i=0; i<3; i++)
	{
		Total_Rot[0][i] = new[0][i];
		Total_Rot[1][i] = new[1][i];
		Total_Rot[2][i] = new[2][i];
	}
	for (i=0; i<vcount; i++)
	{
		fptr = (float *)(v + (i * 3));
		x = *fptr;
		z = *(fptr + 2);
		*fptr = (x * c) - (z * s);
		*(fptr + 2) = (x * s) + (z * c);
	}
}


/*
 * Rotate the first vcount points in the v array by theta degrees around
 * the Z-axis.  Also multiply the rotation into the cumulative rotation 
 * array.
 */
void
rotatez(v, vcount, theta)
	float *v;
	int vcount;
	int theta;
{
	int i;
	float c, s, x, y, z;
	float *fptr;
	double new[3][3];

	c = (float)cos((double)((M_PI * theta) / 180.0)); 
	s = (float)sin((double)((M_PI * theta) / 180.0)); 
	for (i=0; i<3; i++)
	{
		new[i][0] = (Total_Rot[i][0] * c) - (Total_Rot[i][1] * s);
		new[i][1] = (Total_Rot[i][0] * s) + (Total_Rot[i][1] * c);
		new[i][2] = Total_Rot[i][2];
	}
	for (i=0; i<3; i++)
	{
		Total_Rot[0][i] = new[0][i];
		Total_Rot[1][i] = new[1][i];
		Total_Rot[2][i] = new[2][i];
	}
	for (i=0; i<vcount; i++)
	{
		fptr = (float *)(v + (i * 3));
		x = *fptr;
		y = *(fptr + 1);
		*fptr = (x * c) - (y * s);
		*(fptr + 1) = (x * s) + (y * c);
	}
}


/*
 * A silly function that is part of the Eroded surface code I tried to add
 * which didn't work.  It remains in case I ever want to try again.
 */
double FFunc(x)
	double x;
{
	double ret;

	if (x < 0.0)
	{
		ret = 0.0;
	}
	else if (x > 0.8)
	{
		ret = 1.0;
	}
	else
	{
		ret = x / 0.8;
	}
	return(ret);
}


/*
 * Finds cosine of angle between light and surface normal for each
 * polygon.  It eliminates back facing polygons unless EditMode is active.
 *
 * Note:  This function contain unindented, nad partially commented out
 *        code that all has to do with trying to do eroded surfaces.
 *        Just ignore it.  Right now erode is always passed in as 0.
 */
MakeVisList(tr, vertex, count, erode, dist)
	int *tr;
	float *vertex;
	int count;
	int erode;
	float dist;
{
	int i;
	int *iptr;
	float *pa, *pb, *pc;
	float x1, x2, x3, y1, y2, y3, z1, z2, z3;
	float xc, yc, zc;
float l_xc, l_yc, l_zc, l_noise;
	float eyex, eyey, eyez;
	float A, B, C, D;
	float dist_pt_to_plane;
	float dist_pt_to_center;
	float cosine_theta;
	float temp;

l_xc = l_yc = l_zc = l_noise = 0.0;
	eyex = 0.0;
	eyey = 0.0;
	eyez = view_dist;
	for (i=0; i<count; i++)
	{
		iptr = (int *)(tr + (i * 3));
		pa = (float *)(vertex + (*iptr * 3));
		pb = (float *)(vertex + (*(iptr + 1) * 3));
		pc = (float *)(vertex + (*(iptr + 2) * 3));

		x1 = *pa;
		y1 = *(pa + 1);
		z1 = *(pa + 2) - dist;
		x2 = *pb;
		y2 = *(pb + 1);
		z2 = *(pb + 2) - dist;
		x3 = *pc;
		y3 = *(pc + 1);
		z3 = *(pc + 2) - dist;

		xc = (x1 + x2 + x3) / 3;
		yc = (y1 + y2 + y3) / 3;
		zc = (z1 + z2 + z3) / 3;

		A = y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2);
		B = x1 * (z3 - z2) + x2 * (z1 - z3) + x3 * (z2 - z1);
		C = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
		D = x1 * ((z2 * y3) - (z3 * y2))
			+ x2 * ((y1 * z3) - (y3 * z1))
			+ x3 * ((z1 * y2) - (z2 * y1));

		temp = sqrt(((double)A * A) + ((double)B * B) +
			((double)C * C));
		if (temp == 0.0)
		{
			temp = 1.0;
/*
printf("temp was 0 for index=%d\n", i);
*/
		}
		dist_pt_to_plane = ((A * eyex) + (B * eyey) + (C * eyez) + D) /
			temp;
		dist_pt_to_center = sqrt((double)(xc - eyex) * (xc - eyex) +
			(double)(yc - eyey) * (yc - eyey) +
			(double)(zc - eyez) * (zc - eyez));
		if (dist_pt_to_center == 0.0)
		{
			dist_pt_to_center = 1.0;
/*
printf("distance was 0 for index=%d\n", i);
*/
		}
		if (erode == 1)
		{
			int loop;
			double nret, siz, mag;
			double xf, yf, zf;
			float x, y, z;

			siz = 1.0;
			mag = 0.0;

			x = xc;
			y = yc;
			z = zc + distance;
			UnRotate(&x, &y, &z);
			z = z - distance;
/*
			xf = (double)(x + 1.8) * 10.0 / 2.0;
			yf = (double)(y + 1.8) * 10.0 / 2.0;
			zf = (double)(z + distance + 1.8) * 10.0 / 2.0;
*/
			xf = (double)(x + 1.8) * 25.0 / 2.0;
			yf = (double)(y + 1.8) * 25.0 / 2.0;
			zf = (double)(z + distance + 1.8) * 25.0 / 2.0;
			for (loop=0; loop<6; loop++)
			{
				nret = S3Noise(siz * xf, siz * yf, siz * zf);
/*
				nret = _ABS((double)(0.5 - nret));
*/
				nret = _ABS((double)(0.5 - nret));
				mag = mag + (nret / siz);
				siz *= 2;
			}
			dist_pt_to_center = dist_pt_to_center *
				(1.0 + (mag * mag * mag * 1.0));
		}
		else if (erode == 2)
		{
			double xf, yf, zf;
			double dx, dy, dz;
			double nret, dnret, dn;
			float x, y, z;

			x = xc;
			y = yc;
			z = zc + distance;
			UnRotate(&x, &y, &z);
			z = z - distance;

			xf = (double)(x + 2.0) * 5;
			yf = (double)(y + 2.0) * 5;
			zf = (double)(z + 2.0 + distance) * 5;
			nret = S3Noise(xf, yf, zf);
/*
			dn = l_noise - nret * 100;
			dn = (double)((int)(dn * 1e7)) / 1e7;
			dx = l_xc - x;
			dy = l_yc - y;
			dz = l_zc - (z + distance);
			xf = (double)(dx) * 10;
			yf = (double)(dy) * 10;
			zf = (double)(dz) * 10;
			xf = (double)((int)(xf * 1e7)) / 1e7;
			if (xf == 0) xf = 1e-7;
			yf = (double)((int)(yf * 1e7)) / 1e7;
			if (yf == 0) yf = 1e-7;
			zf = (double)((int)(zf * 1e7)) / 1e7;
			if (zf == 0) zf = 1e-7;
			dnret = S3Noise(dn / xf, dn / yf, dn / zf);
*/
dnret = FFunc(nret);
			dist_pt_to_plane = dist_pt_to_plane *
				dnret * dnret * dnret;
/*
			l_noise = nret;
			l_xc = x;
			l_yc = y;
			l_zc = z + distance;
*/
		}
		cosine_theta = dist_pt_to_plane / dist_pt_to_center;
		cosine_theta = -1.0 * cosine_theta;
/*
printf("cos(theta)=%f for index=%d\n(%f,%f,%f)\n(%f,%f,%f)\n(%f,%f,%f)\n", cosine_theta, i, x1, y1, z1, x2, y2, z2, x3, y3, z3);
*/

		if ((cosine_theta >= 0.0)&&(zc < 4.0))
		{
			AddList(i, dist, cosine_theta);
		}
		else if ((zc < 4.0)&&(EditMode == True))
		{
			AddList(i, dist, cosine_theta);
		}
	}
}


/*
 * Do rotations of the points one at a time, in sequence.  X, Y, Z.
 */
void
Rotate(v, vcount, dx, dy, dz)
	float *v;
	int vcount, dx, dy, dz;
{
	if (dx != 0)
	{
		rotatex(v, vcount, dx);
	}
	if (dy != 0)
	{
		rotatey(v, vcount, dy);
	}
	if (dz != 0)
	{
		rotatez(v, vcount, dz);
	}
}


/*
 * Multiply a rotated point by the Transpose of the cumulative Rotation Matrix
 * to get the point in unrotated space.
 */
void
UnRotate(x, y, z)
	float *x, *y, *z;
{
	float nx, ny, nz;

	nx = (float)((Total_Rot[0][0] * *x) +
		 (Total_Rot[0][1] * *y) +
		 (Total_Rot[0][2] * *z));
	ny = (float)((Total_Rot[1][0] * *x) +
		 (Total_Rot[1][1] * *y) +
		 (Total_Rot[1][2] * *z));
	nz = (float)((Total_Rot[2][0] * *x) +
		 (Total_Rot[2][1] * *y) +
		 (Total_Rot[2][2] * *z));
	*x = nx;
	*y = ny;
	*z = nz;
}

