#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <Xm/FileSB.h>
#include <X11/StringDefs.h>
#include "color.h"

#define	DEF_BLACK	BlackPixel(dsp, DefaultScreen(dsp))
#define	DEF_WHITE	WhitePixel(dsp, DefaultScreen(dsp))

extern void doTriangles();
extern void ShadeMarble();
extern void ShadeWood();
extern void ShadeFire();
extern void ShadeGranite();
extern void replaceText();
extern void InitLattice();
extern void Detail();
extern void DetailZero();
extern void DoRead();
extern void DoWrite();

extern Display *dsp;
extern Window Dwindow;
extern unsigned int Width, Height;
extern XColor color[];
extern int NumCells;
extern int BaseCells;
extern Colormap Cmap;
extern float distance;
extern int ShadeType;
extern Bool Nomap;
extern Bool Mapped;
extern Widget drawingcore;
extern Widget top, filebox;
extern Widget wirecommand, shadecommand, firecommand;
extern Widget granitecommand, marblecommand, woodcommand;
extern Widget basecommand, bshadecommand;
extern Widget xscrollbar, yscrollbar, zscrollbar;
extern int Iter;
extern int Changes;
extern struct col_rec Colors[];
extern struct col_rec BaseColors[];

int save_xt = 0;
int save_yt = 0;
int save_zt = 0;
int save_iter = 0;

void DoCancel();

static XtCallbackRec Canceled[] = {
	{  (XtCallbackProc)DoCancel, NULL  },
	{  NULL, NULL  }
};

static XtCallbackRec Reading[] = {
	{  (XtCallbackProc)DoRead, NULL  },
	{  NULL, NULL  }
};

static XtCallbackRec Writing[] = {
	{  (XtCallbackProc)DoWrite, NULL  },
	{  NULL, NULL  }
};




/*
 * A New Shading Model has been selected from the shading menu.  Unmark
 * the old shading button, and mark the new button as selected.
 */
void
Shade(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	char buf[128];
	int i;

	/*
	 * Unmark old shading button.
	 */
	switch (ShadeType)
	{
		case 0:
			sprintf(buf, " Wire");
			replaceText(wirecommand, buf);
			break;
		case 1:
			sprintf(buf, " Shade");
			replaceText(shadecommand, buf);
			break;
		case 2:
			sprintf(buf, " Fire");
			replaceText(firecommand, buf);
			break;
		case 3:
			sprintf(buf, " Granite");
			replaceText(granitecommand, buf);
			break;
		case 4:
			sprintf(buf, " Marble");
			replaceText(marblecommand, buf);
			break;
		case 5:
			sprintf(buf, " Wood");
			replaceText(woodcommand, buf);
			break;
		case 6:
			sprintf(buf, " BaseColors");
			replaceText(basecommand, buf);
			break;
		case 7:
			sprintf(buf, " BaseShade");
			replaceText(bshadecommand, buf);
			break;
	}
	ShadeType = (int)client_data;
	/*
	 * Mark the new button.  Also set up the colormap for the selected
	 * shading model.
	 */
	switch (ShadeType)
	{
		case 0:
			/*
			 * When drawing a Wireframe, set the colormap entries
			 * to make sure you have contrast to see the wires.
			 */
			sprintf(buf, "*Wire");
			replaceText(wirecommand, buf);
			color[0].red = 0;
			color[0].green = 0;
			color[0].blue = 0;
			color[0].flags = DoRed|DoGreen|DoBlue;
			color[0].pixel = DEF_BLACK;
			color[1].red = 65535;
			color[1].green = 65535;
			color[1].blue = 65535;
			color[1].flags = DoRed|DoGreen|DoBlue;
			color[1].pixel = DEF_WHITE;
			if (Nomap == False)
			{
				XStoreColors(dsp, Cmap, color, 2);
			}
			break;
		case 1:
			/*
			 * Set up a gray scale for basic shading.
			 */
			sprintf(buf, "*Shade");
			replaceText(shadecommand, buf);
			for (i=0; i<NumCells; i++)
			{
				Colors[i].red = i;
				Colors[i].green = i;
				Colors[i].blue = i;

				color[i].red = i * 65536 / NumCells;
				color[i].green = i * 65536 / NumCells;
				color[i].blue = i * 65536 / NumCells;
				color[i].flags = DoRed|DoGreen|DoBlue;
				if (Nomap == True)
				{
					XAllocColor(dsp, Cmap, &color[i]);
				}
				color[i].pixel = i;
			}
			if (Nomap == False)
			{
				XStoreColors(dsp, Cmap, color, NumCells);
			}
			break;
		case 2:
			sprintf(buf, "*Fire");
			replaceText(firecommand, buf);
			ShadeFire();
			break;
		case 3:
			sprintf(buf, "*Granite");
			replaceText(granitecommand, buf);
			ShadeGranite();
			break;
		case 4:
			sprintf(buf, "*Marble");
			replaceText(marblecommand, buf);
			ShadeMarble();
			break;
		case 5:
			sprintf(buf, "*Wood");
			replaceText(woodcommand, buf);
			ShadeWood();
			break;
		case 6:
			/*
			 * Convert the read in colormap to have the same format
			 * as the current display visual, and set it.
			 */
			sprintf(buf, "*BaseColor");
			replaceText(basecommand, buf);
			for (i=0; i<NumCells; i++)
			{
				if (i >= BaseCells)
				{
					Colors[i].red = 0;
					Colors[i].green = 0;
					Colors[i].blue = 0;

					color[i].red = Colors[i].red *
						65536 / NumCells;
					color[i].green = Colors[i].green *
						65536 / NumCells;
					color[i].blue = Colors[i].blue *
						65536 / NumCells;
				}
				else
				{
					Colors[i].red = BaseColors[i].red *
						(NumCells - 1)/(BaseCells - 1);
					Colors[i].green = BaseColors[i].green *
						(NumCells - 1)/(BaseCells - 1);
					Colors[i].blue = BaseColors[i].blue *
						(NumCells - 1)/(BaseCells - 1);

					color[i].red = BaseColors[i].red *
						65536 / BaseCells;
					color[i].green = BaseColors[i].green *
						65536 / BaseCells;
					color[i].blue = BaseColors[i].blue *
						65536 / BaseCells;
				}
				color[i].flags = DoRed|DoGreen|DoBlue;
				if (Nomap == True)
				{
					XAllocColor(dsp, Cmap, &color[i]);
				}
				color[i].pixel = i;
			}
			if (Nomap == False)
			{
				XStoreColors(dsp, Cmap, color, NumCells);
			}
			break;
		case 7:
			/*
			 * Convert the read in colormap to have the same format
			 * as the current display visual, and set it.
			 */
			sprintf(buf, "*BaseShade");
			replaceText(bshadecommand, buf);
			for (i=0; i<NumCells; i++)
			{
				if (i >= BaseCells)
				{
					Colors[i].red = 0;
					Colors[i].green = 0;
					Colors[i].blue = 0;

					color[i].red = Colors[i].red *
						65536 / NumCells;
					color[i].green = Colors[i].green *
						65536 / NumCells;
					color[i].blue = Colors[i].blue *
						65536 / NumCells;
				}
				else
				{
					Colors[i].red = BaseColors[i].red *
						(NumCells - 1)/(BaseCells - 1);
					Colors[i].green = BaseColors[i].green *
						(NumCells - 1)/(BaseCells - 1);
					Colors[i].blue = BaseColors[i].blue *
						(NumCells - 1)/(BaseCells - 1);

					color[i].red = BaseColors[i].red *
						65536 / BaseCells;
					color[i].green = BaseColors[i].green *
						65536 / BaseCells;
					color[i].blue = BaseColors[i].blue *
						65536 / BaseCells;
				}
				color[i].flags = DoRed|DoGreen|DoBlue;
				if (Nomap == True)
				{
					XAllocColor(dsp, Cmap, &color[i]);
				}
				color[i].pixel = i;
			}
			if (Nomap == False)
			{
				XStoreColors(dsp, Cmap, color, NumCells);
			}
			break;
	}
	/*
	 * Force a redraw of the image.
	 */
	doTriangles(0, 0, 0, distance);
}


/*
 * Select a new set of random numbers for the noise function,
 * and force a redraw of the image.
 */
void
Lattice(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	InitLattice();
	doTriangles(0, 0, 0, distance);
}


/*
 * Toggle on and off the mapping of the drawing window by managing
 * and unmanaging it.
 * When popping the window down, save the iteration and rotation values
 * in case they are changed before we pop it back up again.
 */
void
Show(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int xt, yt, zt;
	int junk1, junk2, junk3;

	if (!XtIsManaged(drawingcore))
	{
		XtManageChild(drawingcore);
		Dwindow = XtWindow(drawingcore);
	}
	else
	{
		XtUnmanageChild(drawingcore);

		XmScrollBarGetValues(xscrollbar, &xt, &junk1, &junk2, &junk3);
		save_xt = -xt;
		XmScrollBarGetValues(yscrollbar, &yt, &junk1, &junk2, &junk3);
		save_yt = yt;
		XmScrollBarGetValues(zscrollbar, &zt, &junk1, &junk2, &junk3);
		save_zt = -zt;
		save_iter = Iter;

		Mapped = False;
	}
}


/*
 * If we map the drawing window, there may be some saved changes
 * to do
 */
void
Mapping(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (Mapped == False)
	{
		if (Changes)
		{
			if (Iter == 0)
			{
				DetailZero(w, client_data, call_data);
			}
			else
			{
				Detail(w, (caddr_t)Iter, call_data);
			}
			Changes = 0;
		}
		else
		{
			doTriangles(0, 0, 0, distance);
		}
		Mapped = True;
	}
}


/*
 * Drawing window has been resized.  Set the global Width and Height variables
 * and force a redraw.
 */
void
Size(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	Window tmpwin;
	int x, y;
	unsigned int bw, d;

	XGetGeometry(dsp, Dwindow, &tmpwin, &x, &y, &Width, &Height, &bw, &d);
	doTriangles(0, 0, 0, distance);
}


/*
 * Always make Cancel button pop down file selection box, no matter what
 * the autoUnmanage resource says.
 */
void
DoCancel(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (XtIsManaged(filebox))
	{
		XtUnmanageChild(filebox);
	}
}


/*
 * Read menu item selected.  Pop up a file selection box to select a file.
 */
void
Read(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int x, y;
	Window child;
	Arg arg[10];
	Cardinal argcnt;

	if (!XtIsManaged(filebox))
	{
		XTranslateCoordinates(dsp, XtWindow(top),
			XDefaultRootWindow(dsp), 0, 0, &x, &y, &child);
		argcnt = 0;
		XtSetArg(arg[argcnt], XmNx, x); argcnt++;
		XtSetArg(arg[argcnt], XmNy, y); argcnt++;
		XtSetArg(arg[argcnt], XmNokCallback, Reading); argcnt++;
		XtSetArg(arg[argcnt], XmNcancelCallback, Canceled); argcnt++;
		XtSetValues(filebox, arg, argcnt);
		XtManageChild(filebox);
	}
}


/*
 * Write menu item selected.  Pop up a file selection box to select a file.
 */
void
Write(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	int x, y;
	Window child;
	Arg arg[10];
	Cardinal argcnt;

	if (!XtIsManaged(filebox))
	{
		XTranslateCoordinates(dsp, XtWindow(top),
			XDefaultRootWindow(dsp), 0, 0, &x, &y, &child);
		argcnt = 0;
		XtSetArg(arg[argcnt], XmNx, x); argcnt++;
		XtSetArg(arg[argcnt], XmNy, y); argcnt++;
		XtSetArg(arg[argcnt], XmNokCallback, Writing); argcnt++;
		XtSetArg(arg[argcnt], XmNcancelCallback, Canceled); argcnt++;
		XtSetValues(filebox, arg, argcnt);
		XtManageChild(filebox);
	}
}

