#include <stdio.h>


int	OrigNpts, OrigNpolys;
float minx, maxx;
float miny, maxy;
float minz, maxz;



/*
 * Scan a wireframe description from a file
 */
void
lookframe(file)
	char *file;
{
	int i;
	FILE *fp;
	float ftmp;

	minx = 1000000.0;
	miny = 1000000.0;
	minz = 1000000.0;
	maxx = -1000000.0;
	maxy = -1000000.0;
	maxz = -1000000.0;

	/*
	 * Open the filename passed for read.  If cannot read or filename is
	 * invalid, then report error.
	 */
	if ((file == NULL)||(*file == '\0'))
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(file, "r");
		if (fp == NULL)
		{
			fprintf(stderr, "cannot open file (%s) for reading\n",
				file);
		}
	}

	/*
	 * read the number of points and polygons in the object
	 */
	fscanf(fp, "%d\n", &OrigNpts);
	fscanf(fp, "%d\n", &OrigNpolys);

	/*
	 * read in all the point data.
	 */
	for (i=0; i<OrigNpts; i++)
	{
		fscanf(fp, "%f ", &ftmp);
		if (ftmp > maxx)
			maxx = ftmp;
		if (ftmp < minx)
			minx = ftmp;
		fscanf(fp, "%f ", &ftmp);
		if (ftmp > maxy)
			maxy = ftmp;
		if (ftmp < miny)
			miny = ftmp;
		fscanf(fp, "%f ", &ftmp);
		if (ftmp > maxz)
			maxz = ftmp;
		if (ftmp < minz)
			minz = ftmp;
	}
	fclose(fp);
}


/*
 * Scale a wireframe description from a file
 */
void
scaleframe(file)
	char *file;
{
	int i;
	FILE *fp;
	char c;
	float ftmp;
	int itmp1, itmp2, itmp3;

	/*
	 * Open the filename passed for read.  If cannot read or filename is
	 * invalid, then report error.
	 */
	if ((file == NULL)||(*file == '\0'))
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(file, "r");
		if (fp == NULL)
		{
			fprintf(stderr, "cannot open file (%s) for reading\n",
				file);
		}
	}

	/*
	 * read and write the number of points and polygons in the object
	 */
	fscanf(fp, "%d\n", &OrigNpts);
	fscanf(fp, "%d\n", &OrigNpolys);
	printf("%d\n", OrigNpts);
	printf("%d\n", (OrigNpolys * 2));

	/*
	 * read scale and write all the point data.
	 */
	for (i=0; i<OrigNpts; i++)
	{
		fscanf(fp, "%f ", &ftmp);
		ftmp = (ftmp - minx) * 2.0 / (maxx - minx);
		ftmp = ftmp - 1.0;
		printf("%f ", ftmp);
		fscanf(fp, "%f ", &ftmp);
		ftmp = (ftmp - miny) * 2.0 / (maxy - miny);
		ftmp = ftmp - 1.0;
		printf("%f ", ftmp);
		fscanf(fp, "%f ", &ftmp);
		ftmp = (ftmp - minz) * 2.0 / (maxz - minz);
		ftmp = ftmp - 1.0;
		printf("%f\n", ftmp);
	}

	/*
	 * read subtract 1 and write polygon vertices
	 */
	for (i=0; i<OrigNpolys; i++)
	{
		fscanf(fp, "%d ", &itmp1);
		fscanf(fp, "%d ", &itmp2);
		fscanf(fp, "%d ", &itmp3);
		printf("%d %d %d\n", (itmp1 - 1), (itmp2 - 1), (itmp3 - 1));
		printf("%d %d %d\n", (itmp1 - 1), (itmp3 - 1), (itmp2 - 1));
	}

	fclose(fp);
}


void
main(argc, argv)
    int argc;
    char **argv;
{
	lookframe(argv[1]);
	scaleframe(argv[1]);
}

