/*
 * $XConsortium: main.c,v 1.44 91/02/13 11:32:55 rws Exp $
 */
#ifdef SVR4
#define _POSIX_SOURCE
#endif

#include "def.h"
#ifdef hpux
#define sigvec sigvector
#endif /* hpux */

#include <signal.h>


#ifdef DEBUG
int	_debugmask;
#endif

char *ProgramName;

char	*directives[] = {
	"if",
	"ifdef",
	"ifndef",
	"else",
	"endif",
	"define",
	"undef",
	"include",
	"line",
	"pragma",
	"error",
	"ident",
	"sccs",
	"elif",
	"eject",
	NULL
};

#define MAKEDEPEND
#include "imakemdep.h"	/* from config sources */
#undef MAKEDEPEND

struct symtab	deflist[ MAXDEFINES ];
struct	inclist inclist[ MAXFILES ],
		*inclistp = inclist;

char	*filelist[ MAXFILES ];
char	*includedirs[ MAXDIRS ];
char	*notdotdot[ MAXDIRS ];
#ifdef vms
char	*objfile = ".obj";
#else
char	*objfile = ".o";
#endif
char	*startat = "# Source file dependencies - do not delete this line ";
#if !defined(vms)
int	width = 78;
#else
int	width = 72;
#endif
boolean	printed = FALSE;
boolean	verbose = FALSE;
boolean	show_where_not = FALSE;
boolean	show_unknown = FALSE;
#if defined(vms)
boolean sawF          = FALSE;
char    **FstartedAt  = NULL;
char	**FfinishedAt = NULL;
#endif

static
#ifdef SIGNALRETURNSINT
int
#else
void
#endif
catch (sig)
    int sig;
{
	fflush (stdout);
	fatal ("got signal %d\n", sig);
}

#ifndef USG
#ifndef _POSIX_SOURCE
#define sigaction sigvec
#define sa_handler sv_handler
#define sa_mask sv_mask
#ifdef vms
#define sa_flags sv_onstack
#else
#define sa_flags sv_flags
#endif /*VMS*/
#endif /*_POSIX_SOURCE*/
struct sigaction sig_act;
#endif /* USG */

main(argc, argv)
	int	argc;
	char	**argv;
{
	register struct symtab	*symp = deflist;
	register char	**fp = filelist;
	register char	**incp = includedirs;
	register char	*p;
	register struct inclist	*ip;
	char	*makefile = NULL;
	struct filepointer	*filecontent;
	struct symtab *psymp = predefs;
	char *endmarker = NULL;

#if !defined(vms)
	ProgramName = argv[0];
#else
	p = strrchr(argv[0], ']');
	if (*p != '\0') {
		p++;
		ProgramName = p;
	}
	else {
		p = strrchr(argv[0], ':');
		if (*p != '\0') {
			p++;
			ProgramName = p;
		}
		else
			ProgramName = argv[0];
	}
	p = strrchr(ProgramName, '.');
	if (*p != '\0')
		*p = '\0';
#endif

	while (psymp->s_name)
	    *symp++ = *psymp++;
	for(argc--, argv++; argc; argc--, argv++) {
	    	/* if looking for endmarker then check before parsing */
		if (endmarker && strcmp (endmarker, *argv) == 0) {
		    endmarker = NULL;
		    continue;
		}
		if (**argv != '-') {
			*fp++ = argv[0];
			continue;
		}
		switch(argv[0][1]) {
		case '-':
			endmarker = &argv[0][2];
			if (endmarker[0] == '\0') endmarker = "--";
			break;
		case 'D':
		case 'd':
			symp->s_name = argv[0]+2;
			if (*symp->s_name == '\0') {
				symp->s_name = *(++argv);
				argc--;
			}
			for (p=symp->s_name; *p ; p++)
				if (*p == '=') {
					*p++ = '\0';
					break;
				}
			symp->s_value = p;
			symp++;
			break;
		case 'I':
		case 'i':
			if (incp >= includedirs + MAXDIRS)
			    fatal("Too many -I flags.\n");
			*incp++ = argv[0]+2;
			if (**(incp-1) == '\0') {
				*(incp-1) = *(++argv);
				argc--;
			}
			break;
		/* do not use if endmarker processing */
		case 'w':
			if (endmarker) break;
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
				width = atoi(argv[0]);
			} else
				width = atoi(argv[0]+2);
			break;
		case 'o':
			if (endmarker) break;
			if (argv[0][2] == '\0') {
				argv++;
				argc--;
				objfile = argv[0];
			} else
				objfile = argv[0]+2;
			break;
		case 'v':
			if (endmarker) break;
			verbose = TRUE;
#ifdef DEBUG
			if (argv[0][2])
				_debugmask = atoi(argv[0]+2);
#endif
			break;
		case 's':
			if (endmarker) break;
			startat = argv[0]+2;
			if (*startat == '\0') {
				startat = *(++argv);
				argc--;
			}
			if (*startat != '#')
				fatal("-s flag's value should start %s\n",
					"with '#'.");
			break;
		case 'f':
			if (endmarker) break;
			makefile = argv[0]+2;
			if (*makefile == '\0') {
				makefile = *(++argv);
				argc--;
			}
			break;
		
#if defined(vms)
		case 'F' :
			{
				FILE	*input_file;
				char	buffer[100];
				char	*extra_filename;
				char	*rc;
				int	len;
				char	*ptr;

				if (endmarker)
					break;
				if (sawF) {
					fatal("Too many -F flags.\n");
				}
				else
					sawF = TRUE;
				extra_filename = argv[0]+2;
				if (*extra_filename == '\0') {
					extra_filename = *(++argv);
					argc--;
				}
				input_file = fopen(extra_filename, "r");
				if (input_file != NULL) {
					rc = fgets(buffer, 100, input_file);
					while (rc != NULL) {
						len = strlen(buffer);
						len--;
						if (buffer[len] == '\n') {
							buffer[len] = '\0';
							len--;
						}
						ptr = malloc(len+1);
						strcpy(ptr, buffer);
						if (FstartedAt == NULL) {
							FstartedAt = fp;
						}
						FfinishedAt = fp;
						*fp++ = ptr;
						rc = fgets(buffer, 100, input_file);
					}
				}
			}
			break;
#endif
		/* Ignore -O, -g so we can just pass ${CFLAGS} to
		   makedepend
		 */
		case 'O':
		case 'g':
			break;
		/* Do not include files not found.  VERY bad unless
		    desired for _elimination_ of certain includes
		 */
		case 'u':
			show_unknown = TRUE;
			break;
		default:
			if (endmarker) break;
	/*		fatal("unknown opt = %s\n", argv[0]); */
			warning("ignoring option %s\n", argv[0]);
		}
	}
#ifdef __GNUC__
	if (incp >= includedirs + MAXDIRS)
	    fatal("Too many -I flags.\n");
	*incp++ = "/usr/local/lib/gcc-include";
#endif

#ifdef vms
	if (incp >= includedirs + MAXDIRS)
	    fatal("Too many -I flags.\n");
	*incp++ = "SYS$LIBRARY:";

	if (incp >= includedirs + MAXDIRS)
	    fatal("Too many -I flags.\n");
	*incp++ = "DECW$INCLUDE:";
#endif

#ifdef CRAY
	if (incp >= includedirs + MAXDIRS)
	    fatal("Too many -I flags.\n");
	*incp++ = "/usr/include/stdc";
#endif

	redirect(startat, makefile);

	/*
	 * catch signals.
	 */
#ifdef USG
/*  should really reset SIGINT to SIG_IGN if it was.  */
	signal (SIGHUP, catch);
	signal (SIGINT, catch);
	signal (SIGQUIT, catch);
	signal (SIGILL, catch);
	signal (SIGBUS, catch);
	signal (SIGSEGV, catch);
	signal (SIGSYS, catch);
#else
	sig_act.sa_handler = catch;
#ifdef _POSIX_SOURCE
	sigemptyset(&sig_act.sa_mask);
	sigaddset(&sig_act.sa_mask, SIGINT);
	sigaddset(&sig_act.sa_mask, SIGQUIT);
	sigaddset(&sig_act.sa_mask, SIGBUS);
	sigaddset(&sig_act.sa_mask, SIGILL);
	sigaddset(&sig_act.sa_mask, SIGSEGV);
	sigaddset(&sig_act.sa_mask, SIGHUP);
	sigaddset(&sig_act.sa_mask, SIGPIPE);
	sigaddset(&sig_act.sa_mask, SIGSYS);
#else
	sig_act.sa_mask = ((1<<(SIGINT -1))
			   |(1<<(SIGQUIT-1))
			   |(1<<(SIGBUS-1))
			   |(1<<(SIGILL-1))
			   |(1<<(SIGSEGV-1))
			   |(1<<(SIGHUP-1))
			   |(1<<(SIGPIPE-1))
			   |(1<<(SIGSYS-1)));
#endif
	sig_act.sa_flags = 0;
	sigaction(SIGHUP, &sig_act, (struct sigaction *)0);
	sigaction(SIGINT, &sig_act, (struct sigaction *)0);
	sigaction(SIGQUIT, &sig_act, (struct sigaction *)0);
	sigaction(SIGILL, &sig_act, (struct sigaction *)0);
	sigaction(SIGBUS, &sig_act, (struct sigaction *)0);
	sigaction(SIGSEGV, &sig_act, (struct sigaction *)0);
	sigaction(SIGSYS, &sig_act, (struct sigaction *)0);
#endif

	/*
	 * now peruse through the list of files.
	 */
	for(fp=filelist; *fp; fp++) {
		filecontent = getfile(*fp);
		ip = newinclude(*fp, (char *)NULL);

		find_includes(filecontent, ip, ip, 0);
		freefile(filecontent);
		recursive_pr_include(ip, ip->i_file, basename(*fp));
		inc_clean();
	}
	if (printed)
		printf("\n");
#if defined(vms)
	if (sawF) {
		while (FstartedAt != FfinishedAt) {
			free(*FstartedAt);
			FstartedAt++;
		}
		free(*FfinishedAt);
	}
#endif
	exit(0);
}

struct filepointer *getfile(file)
	char	*file;
{
	register int	fd;
	struct filepointer	*content;
	struct stat	st;

	content = (struct filepointer *)malloc(sizeof(struct filepointer));
#ifdef vms
	if ((fd = open(file, O_RDONLY,0,"ctx=stm","rfm=stmlf")) < 0) {
#else
	if ((fd = open(file, O_RDONLY)) < 0) {
#endif /*VMS*/
		warning("cannot open \"%s\"\n", file);

		content->f_p = content->f_base = content->f_end = malloc(1);
		*content->f_p = '\0';
		return(content);
	}
	fstat(fd, &st);
	content->f_len = st.st_size+1;
	content->f_base = malloc(content->f_len);
	if (content->f_base == NULL)
		fatal("cannot allocate mem\n");
	if (read(fd, content->f_base, st.st_size) != st.st_size)
		fatal("cannot read all of %s\n", file);
	close(fd);
	content->f_p = content->f_base;
	content->f_end = content->f_base + st.st_size;
	*content->f_end = '\0';
	content->f_line = 0;
#ifdef vms
    {
	char    *p;
	for(p = content->f_base; p < content->f_end; p++) {
	    if(!*p) *p = '\n';
	}
    }
#endif
	return(content);
}

freefile(fp)
	struct filepointer	*fp;
{
	free(fp->f_base);
	free(fp);
}

char *copy(str)
	register char	*str;
{
	register char	*p = malloc(strlen(str) + 1);

	strcpy(p, str);
	return(p);
}

match(str, list)
	register char	*str, **list;
{
	register int	i;

	for (i=0; *list; i++, list++)
		if (strcmp(str, *list) == 0)
			return(i);
	return(-1);
}

/*
 * Get the next line.  We only return lines beginning with '#' since that
 * is all this program is ever interested in.
 */
char *getline(filep)
	register struct filepointer	*filep;
{
	register char	*p,	/* walking pointer */
			*eof,	/* end of file pointer */
			*bol;	/* beginning of line pointer */
	register	lineno;	/* line number */

	p = filep->f_p;
	eof = filep->f_end;
	if (p >= eof)
		return((char *)NULL);
	lineno = filep->f_line;

	for(bol = p--; ++p < eof; ) {
		if (*p == '/' && *(p+1) == '*') { /* consume comments */
			*p++ = ' ', *p++ = ' ';
			while (*p) {
				if (*p == '*' && *(p+1) == '/') {
					*p++ = ' ', *p = ' ';
					break;
				}
				else if (*p == '\n')
					lineno++;
				*p++ = ' ';
			}
			continue;
		}
		else if (*p == '\n') {
			lineno++;
			if (*bol == '#') {
				register char *cp;

				*p++ = '\0';
				/* punt lines with just # (yacc generated) */
				for (cp = bol+1; 
				     *cp && (*cp == ' ' || *cp == '\t'); cp++);
				if (*cp) goto done;
			}
			bol = p+1;
		}
	}
	if (*bol != '#')
		bol = NULL;
done:
	filep->f_p = p;
	filep->f_line = lineno;
	return(bol);
}

char *basename(file)
	register char	*file;
{
	register char	*p;

#if !defined(vms)/**/
	for (p=file+strlen(file); p>file && *p != '/'; p--) ;
#else
	for (p=file+strlen(file); p>file && *p != ']' && *p != ':'; p--) ;
#endif/**/

#if !defined(vms)/**/
	if (*p == '/')
#else
	if ((*p == ']') || (*p == ':'))
#endif/**/
		p++;

	file = copy(p);
	for(p=file+strlen(file); p>file && *p != '.'; p--) ;

	if (*p == '.')
		*p = '\0';
	return(file);
}

#if defined(USG) && !defined(CRAY)
int rename (from, to)
    char *from, *to;
{
    (void) unlink (to);
    if (link (from, to) == 0) {
	unlink (from);
	return 0;
    } else {
	return -1;
    }
}
#endif /* USG */

redirect(line, makefile)
	char	*line,
		*makefile;
{
	struct stat	st;
	FILE	*fdin, *fdout;
	char	backup[ BUFSIZ ],
		buf[ BUFSIZ ];
	boolean	found = FALSE;
	int	len;

	/*
	 * if makefile is "-" then let it pour onto stdout.
	 */
	if (makefile && *makefile == '-' && *(makefile+1) == '\0')
		return;

	/*
	 * use a default makefile is not specified.
	 */
	if (!makefile) {
		if (stat("makefile", &st) == 0)
			makefile = "makefile";
		else if (stat("Makefile", &st) == 0)
			makefile = "Makefile";
		else
			fatal("[mM]akefile is not present\n");
	}
	else
	    stat(makefile, &st);
	if ((fdin = fopen(makefile, "r")) == NULL)
		fatal("cannot open \"%s\"\n", makefile);
#if defined(vms)
	{
		char	*ptr;

		strcpy(backup, makefile);
		ptr = strrchr(backup, ']');
		if (ptr != NULL) {
			ptr++;
			ptr = strrchr(ptr, '.');
		}
		else
			ptr = strrchr(backup, '.');
		if (ptr != NULL) {
			ptr++;
			switch (*ptr) {
				case '\0' :
					strcat(backup, "bak");
					break;
				case ';'  :
					ptr--;
					*ptr = '\0';
					strcat(backup, "bak");
					break;
				default   :
					ptr--;
					*ptr = '_';
					strcat(backup, ".bak");
					break;
			}
		}
		else
			sprintf(backup, "%s.bak", makefile);
	}
#else
	sprintf(backup, "%s.bak", makefile);\
#endif
#ifndef vms
	unlink(backup);
#endif /*VMS*/
	if (rename(makefile, backup) < 0)
		fatal("cannot rename %s to %s\n", makefile, backup);
	if ((fdout = freopen(makefile, "w", stdout)) == NULL)
		fatal("cannot open \"%s\"\n", backup);
	len = strlen(line);
	while (fgets(buf, BUFSIZ, fdin) && !found) {
		if (*buf == '#' && strncmp(line, buf, len) == 0)
			found = TRUE;
		fputs(buf, fdout);
	}
	if (!found) {
		if (verbose)
		warning("Adding new delimiting line \"%s\" and dependencies...\n",
			line);
		puts(line); /* same as fputs(fdout); but with newline */
	}
	fflush(fdout);
#if defined(USG) || defined(vms)
	chmod(makefile, st.st_mode);
#else
        fchmod(fileno(fdout), st.st_mode);
#endif /* USG */
}

/*VARARGS*/
fatal(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
    char *x0;
{
	warning(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
	exit (1);
}

/*VARARGS0*/
warning(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
    char *x0;
{
	fprintf(stderr, "%s:  ", ProgramName);
	fprintf(stderr, x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
}
