/*	@(#)calc.h 1.1 90/12/20 SMI	*/

/*	compilation parameters */
 
#define but_dx  50		/* spacing between buttons */
#define but_dy  50
#define mid_dy	12
#define bot_dy	12+20

#define firstbx 20		/* first button position */
#define firstby dstk_dy+110

#define firstlx 15		/* first label position */
#define firstly dstk_dy+88

#define num_dig 30		/* # digits in display */

#define tdisp_x 400		/* treg digit position */
#define tdisp_y 35
#define zdisp_x 400		/* zreg digit position */
#define zdisp_y 45
#define ydisp_x 400		/* yreg digit position */
#define ydisp_y 55
#define xdisp_x 400		/* xreg digit position */
#define xdisp_y 65
#define mdisp_x 30		/* xreg digit position */
#define mdisp_y 25
#define dstk_dy 0		/* display stack height */

#define	hexdisp_x 30		/* first digit position, second row */
#define	hexdisp_y dstk_dy+70

#define dig_dx  18		/* spacing between digits */

#define point_dx 14		/* distance between digit and dp */
#define point_dy 20

#define firstax 40		/* first annunciator position */
#define firstay dstk_dy+50
#define seconday dstk_dy+95	/* first annunciator, 2nd row */

#define ann_dx  50		/* spacing between annunciators */

#define	small_width	225	/* size when small */
#define	small_height	firstby+mid_dy



#define	BIN	0
#define	OCT	1
#define	DEC	2
#define	HEX	3

#define	BLANK	-1
#define	DASH	-2


/*******
 *
 * State variables:
 *
 *  radix - current radix 0=bin, 1=oct, 2=dec, 3=hex
 *
 *  Display_Type - FIX/SCI/ENG.  If a fixed point number won't fit the
 *		display, the calculator defaults to SCI.
 *
 *  Display_Digits - number of digits precision.  Max for FIX is 9.  Max
 *		for SCI or ENG is 6.
 *
 *  Pending_Op - Set after a previx button (f,g,STO,RCL etc) is pressed.
 *		Alters the meaning of the next key pressed.
 *
 *  Pending_Push - Indicates that the next key-in data will push the stack.
 *		Usually true, false after CLX.
 *
 *  Display_State - XREG/KEY_IN.  Indicates what is being displayed.  Normally
 *		XREG, changed to KEY_IN during input.
 *
 *  Key_In, Key_Pos - Data being keyed in.
 *
 *  xreg,yreg,zreg,treg - the stack.
 *
 *********/

	int	radix ;

	enum	{FIX, SCI, ENG} Display_Type ;
	int	Display_Digits ;

	enum	Trig_State_t { DEG, RAD, GRD } Trig_State ;

	enum	Pending_Op_t {NORM, Fx, Gx, RCL, STO, STOa,
		STOs, STOx, STOd, P_FIX, P_SCI, P_ENG, HYP,
		HYPINV } Pending_Op ;

	int	Pending_Lift ;

	enum	{XREG, KEY_IN, ERROR} Display_State ;

	int	Display_E, Display_0x ;


/* Key_Pos is an index into the display showing where the next char will go
   Point_Pos is an index to where the decimal point is, or -1
   Key_Exp is a flag indicating that the exponent is being keyed in
   Exp_Posn is the position that the exponent sign is in
*/
	int	Key_Pos, Point_Pos, Key_Sign,
		Key_Exp_Sign, Key_Exp ;
	int	Exp_Posn ;

	double	xreg, yreg, zreg, treg, Lastx ;

	double	Memory_Regs[10], Memory_Reg_I ;


static  int	Disp_Max[4] = {40,15,12,12} ;


