static char sccsid[] =
"@(#)calc.c 1.8 92/10/08 By Ed Falk, Copyr 1987 Sun Micro" ;
/**********
 *
 *
 *	 @@@@   @@@   @       @@@@  @@@@@   @@@    @@@   @
 *	@      @   @  @      @        @    @   @  @   @  @
 *	@      @@@@@  @      @        @    @   @  @   @  @
 *	@      @   @  @      @        @    @   @  @   @  @
 *	 @@@@  @   @  @@@@@   @@@@    @     @@@    @@@   @@@@@
 *
 *	CALCTOOL - HP calculator emulator
 *
 *	This program will come up looking vaguely like an HP-11 calculator.
 *	you can press the buttons with the mouse or type keys in that
 *	are mapped to calculator buttons.
 *
 *
 *	key to button mapping:
 *
 *	0-9	0-9
 *	A-F	(hex chars, no mapping)
 *	a-f	(hex chars, no mapping)
 *	.	.
 *	+	add
 *	-	minus
 *	*	multiply
 *	/	divide
 *	<space>	enter
 *	<cr>	enter
 *	,	enter
 *	<del>	backarrow
 *	<bs>	backarrow
 *	f	f	(not in hex mode)
 *	g	g
 *	e	EEX	(not in hex mode)
 *	x	x<>y	(not in hex mode if "0x" mode on)
 *	c	chs	(not in hex mode)
 *	>	>>
 *	<	<<
 *	&	AND
 *	|	OR
 *	^	XOR
 *	~	NOT
 *	s	STO
 *	r	RCL
 *      k	K
 *	?	HELP
 *	
 *
 *
 *
 *
 *	Edward A. Falk
 *	Sun Microsystems
 *
 *	Mar, 1986
 *
 *
 **********/

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>
#include <suntool/menu.h>
#include <math.h>
#include <strings.h>
#include "calc.h"

/****
 *
 * Constants,  typedefs, externals, globals, statics, macros
 *
 ****/



#define	BIN	0
#define	OCT	1
#define	DEC	2
#define	HEX	3

#define	BLANK	-1
#define	DASH	-2


	/* image definitions */


	/* main icon */

static short  icon_image[] = {
#include "calc.icon"
};
/* DEFINE_ICON_FROM_IMAGE (calc_icon, icon_image) ; */
mpr_static(icon_pixrect, 64, 46, 1, icon_image) ;


	/* key images */

#include "keys.h"

static	Icon	icon ;

static	Frame base_frame, help_frame = NULL ;

static	Panel	panel ;

static	Menu	Const_Menu, Conv_Menu ;

static	Textsw	help_sw = NULL ;

static	Panel_item	Keys[4][10][3] ;

static	Panel_item	TDisplay, ZDisplay, YDisplay, XDisplay ;
static	Panel_item	Disp, HexDisplay ;

static	Panel_item	a_user, a_rad, a_grd, a_f, a_radix, a_xradix ;

static	Event	*Current_Event ;

static	struct pixfont *font, *disp_font ;


static	double	Powrs[11][4] = {
	{      1.0,            1.0,            1.0,                1.0 },
        {      2.0,            8.0,           10.0,               16.0 },
        {      4.0,           64.0,          100.0,              256.0 },
        {      8.0,          512.0,         1000.0,             4096.0 },
        {     16.0,         4096.0,        10000.0,            65536.0 },
        {     32.0,        32768.0,       100000.0,          1048576.0 },
        {     64.0,       262144.0,      1000000.0,         16777216.0 },
        {    128.0,      2097152.0,     10000000.0,        268435456.0 },
        {    256.0,     16777216.0,    100000000.0,       4294967296.0 },
        {    512.0,    134217728.0,   1000000000.0,      68719476736.0 },
        {   1024.0,   1073741824.0,  10000000000.0,    1099511627776.0 } } ;


	/* fake events to feed to panel_accept_key  */

static	Event	dig_events[16], dp_event, comma_event, minus_event, del_event ;
static	Event	space_event, plus_event ;



static	int	Del_Flag ;		/* to warn routines of incoming del */


	/* proc definitions */

static	Panel_setting	Kbd_Proc() ;
static	void	Button_Proc() ;
typedef	caddr_t	(*fptr)() ;
static	fptr	Old_done_proc ;



	double	Conversion ;		/* global variable */
	double	Constant ;		/* global variable */




/*
#define	min(x,y)	((x)<(y)?(x):(y))
#define max(x,y)	((x)>(y)?(x):(y))
*/
#define abs(x)		((x)<0?-(x):(x))

#define	eat_line	while(getchar()!='\n')


extern	int	Cmd_Parse() ;

/*
 * changes by Doug Landauer:
 *
 * Allow the tool to come up to a user-specified size (i.e., implement
 * the -Ws arguments).  If it's bigger than necessary, we shrink it to
 * fit around the buttons.  If it's smaller, we believe the user.
 *
 * wbs_width & height are kept so that I could implement a
 * single button to flip back and forth from tiny to all
 * buttons showing.
 */
	int	orig_width, orig_height;
	int	wbs_width, wbs_height;
	int	is_small;



main(argc,argv)
int	argc ;
char	*argv[] ;
{
	font = pf_open("/usr/lib/fonts/fixedwidthfonts/serif.r.10") ;
	disp_font = pf_open("/usr/lib/fonts/fixedwidthfonts/gallant.r.19") ;

	icon = icon_create(ICON_HEIGHT,46, ICON_IMAGE, &icon_pixrect, 0);

	base_frame = window_create(NULL, FRAME,
	    /* FRAME_ICON,		&calc_icon, */
	    FRAME_ICON,		icon,
	    FRAME_LABEL,	"Calculator",
	    WIN_ERROR_MSG,	"can't create window.",
	    FRAME_ARGS,		argc, argv,
	    0) ;

	orig_width = (int)window_get( base_frame, WIN_WIDTH );
	orig_height = (int)window_get( base_frame, WIN_HEIGHT );

	panel = window_create(base_frame, PANEL,
	    WIN_FONT, font,
	    PANEL_BLINK_CARET, 0,
	    WIN_CONSUME_KBD_EVENTS, KEY_RIGHT(1), KEY_RIGHT(2), KEY_RIGHT(3),
	    KEY_RIGHT(4), KEY_RIGHT(5), KEY_RIGHT(6), KEY_RIGHT(7),
	    KEY_RIGHT(8), KEY_RIGHT(9), KEY_RIGHT(10), KEY_RIGHT(11),
	    KEY_RIGHT(12), KEY_RIGHT(13), KEY_RIGHT(14), KEY_RIGHT(15), 0,
	    0 ) ;


	radix = DEC ;
	Display_Type = FIX ;
	Display_Digits = 2 ;
	Pending_Op = NORM ;
	Trig_State = DEG ;
	Display_State = XREG ;
	xreg = yreg = zreg = treg = 0.0 ;
	Display_E = 0 ;
	Display_0x = 0 ;
	Key_Pos = 0 ;

	Define_Keys() ;		/* place keys on panel and set up procs */
	Define_Events() ;	/* define the fake events		*/
	Paint_Panel() ;		/* put trim on panel			*/
	Define_Display() ;	/* put up display			*/
	Define_Anns() ;		/* put annunciators on display		*/
	Define_Menus() ;	/* conversion & constant menus		*/
	Update_Displays() ;	/* reset displays			*/
	Update_Anns() ;
	window_fit(panel) ;
	window_fit(base_frame) ;
	wbs_width = (int)window_get( base_frame, WIN_WIDTH );
	wbs_height = (int)window_get( base_frame, WIN_HEIGHT );

	if( orig_width < wbs_width )
 	    is_small = 1;
	else
 	    orig_width = small_width;

 	if( orig_height < wbs_height )
 	    is_small = 1;
	else
	{
	    int h = wbs_height - (int)window_get( panel, WIN_HEIGHT ) ;
 	    orig_height = small_height + h ;
	}

	if(is_small)
	  get_small() ;

	window_main_loop(base_frame) ;
	exit(0) ;
}

get_small()
{
	window_set( base_frame, WIN_WIDTH, orig_width, 0 );
	window_set( base_frame, WIN_HEIGHT, orig_height, 0 );
	panel_set(Keys[0][0][0], PANEL_LABEL_IMAGE, &p_key11g, 0 ) ;
	is_small = 1 ;
}


get_big()
{
	window_set( base_frame, WIN_WIDTH, wbs_width, 0 );
	window_set( base_frame, WIN_HEIGHT, wbs_height, 0 );
	panel_set(Keys[0][0][0], PANEL_LABEL_IMAGE, &p_key11t, 0 ) ;
	is_small = 0 ;
}


static
Define_Keys()
{
extern	void	Conv_Event() ;

	int	i,j ;
	int	x,y ;

	static	struct pixrect	*p_keys[4][10][3] = {
	   {{ &p_key11t, &p_key11m, &p_key11b },
	    { &p_key12t, &p_key12m, &p_key12b },
	    { &p_key13t, &p_key13m, &p_key13b },
	    { &p_key14t, &p_key14m, &p_key14b },
	    { &p_key15t, &p_key15m, &p_key15b },
	    { &p_key16t, &p_key16m, &p_key16b },
	    { &p_key17t, &p_key17m, &p_key17b },
	    { &p_key18t, &p_key18m, &p_key18b },
	    { &p_key19t, &p_key19m, &p_key19b },
	    { &p_key10t, &p_key10m, &p_key10b }},
	   {{ &p_key21t, &p_key21m, &p_key21b },
	    { &p_key22t, &p_key22m, &p_key22b },
	    { &p_key23t, &p_key23m, &p_key23b },
	    { &p_key24t, &p_key24m, &p_key24b },
	    { &p_key25t, &p_key25m, &p_key25b },
	    { &p_key26t, &p_key26m, &p_key26b },
	    { &p_key27t, &p_key27m, &p_key27b },
	    { &p_key28t, &p_key28m, &p_key28b },
	    { &p_key29t, &p_key29m, &p_key29b },
	    { &p_key20t, &p_key20m, &p_key20b }},
	   {{ &p_key31t, &p_key31m, &p_key31b },
	    { &p_key32t, &p_key32m, &p_key32b },
	    { &p_key33t, &p_key33m, &p_key33b },
	    { &p_key34t, &p_key34m, &p_key34b },
	    { &p_key35t, &p_key35m, &p_key35b },
	    { &p_key36t, &p_key36m, &p_key36b },
	    { &p_key37t, &p_key37m, &p_key37b },
	    { &p_key38t, &p_key38m, &p_key38b },
	    { &p_key39t, &p_key39m, &p_key39b },
	    { &p_key30t, &p_key30m, &p_key30b }},
	   {{ &p_key41t, &p_key41m, &p_key41b },
	    { &p_key42t, &p_key42m, &p_key42b },
	    { &p_key43t, &p_key43m, &p_key43b },
	    { &p_key44t, &p_key44m, &p_key44b },
	    { &p_key45t, &p_key45m, &p_key45b },
	    {         0,         0,         0 },
	    { &p_key47t, &p_key47m, &p_key47b },
	    { &p_key48t, &p_key48m, &p_key48b },
	    { &p_key49t, &p_key49m, &p_key49b },
	    { &p_key40t, &p_key40m, &p_key40b }}} ;


	y = firstby ;
	for(i=0; i<4; i++)
	{
	    x = firstbx ;
	    for(j=0; j<10; j++)
	    {
		if ( (i!=3) || (j!=5) ) {
		    Keys[i][j][0] = panel_create_item(panel, PANEL_BUTTON,
			    PANEL_ITEM_X, x, PANEL_ITEM_Y, y,
			    PANEL_LABEL_IMAGE, p_keys[i][j][0],
			    PANEL_NOTIFY_PROC, Button_Proc,
			    PANEL_CLIENT_DATA, (i+1)*100+((j+1)%10)*10,
			    0 ) ;
		    Keys[i][j][1] = panel_create_item(panel, PANEL_BUTTON,
			    PANEL_ITEM_X, x, PANEL_ITEM_Y, y+mid_dy,
			    PANEL_LABEL_IMAGE, p_keys[i][j][1],
			    PANEL_NOTIFY_PROC, Button_Proc,
			    PANEL_CLIENT_DATA, (i+1)*100+((j+1)%10)*10 +1,
			    0 ) ;
		    Keys[i][j][2] = panel_create_item(panel, PANEL_BUTTON,
			    PANEL_ITEM_X, x, PANEL_ITEM_Y, y+bot_dy,
			    PANEL_LABEL_IMAGE, p_keys[i][j][2],
			    PANEL_NOTIFY_PROC, Button_Proc,
			    PANEL_CLIENT_DATA, (i+1)*100+((j+1)%10)*10 +2,
			    0 ) ;
		}
		x += but_dx ;
	    }
	    y += but_dy ;
	}

	panel_set ( Keys[2][5][2],
	    PANEL_ITEM_Y, firstby+2*but_dy+mid_dy+64,
	    0 ) ;

	panel_set ( Keys[2][0][0], PANEL_EVENT_PROC, Conv_Event, 0) ;
	panel_set ( Keys[2][0][2], PANEL_EVENT_PROC, Conv_Event, 0) ;
}



static
Define_Events()
{

	int	i ;
static	char	digits[] = "0123456789abcdef" ;

	for (i=0;i<16;i++) {
	    event_set_id(&dig_events[i],digits[i]) ;
	    event_set_down(&dig_events[i]) ;
	    event_set_shiftmask(&dig_events[i],0) ;
	}
	event_set_id(&dp_event,'.') ;
	event_set_down(&dp_event) ;
	event_set_shiftmask(&dp_event,0) ;

	event_set_id(&comma_event,',') ;
	event_set_down(&comma_event) ;
	event_set_shiftmask(&comma_event,0) ;

	event_set_id(&minus_event,'-') ;
	event_set_down(&minus_event) ;
	event_set_shiftmask(&minus_event,0) ;

	event_set_id(&del_event,'\177') ;
	event_set_down(&del_event) ;
	event_set_shiftmask(&del_event,0) ;

	event_set_id(&space_event,' ') ;
	event_set_down(&space_event) ;
	event_set_shiftmask(&space_event,0) ;

	event_set_id(&plus_event,'+') ;
	event_set_down(&plus_event) ;
	event_set_shiftmask(&plus_event,0) ;
}




static
Define_Display()
{
	TDisplay = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_ITEM_X, tdisp_x, PANEL_ITEM_Y, tdisp_y,
	    PANEL_LABEL_FONT, font,
	    0 ) ;

	ZDisplay = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_ITEM_X, zdisp_x, PANEL_ITEM_Y, zdisp_y,
	    PANEL_LABEL_FONT, font,
	    0 ) ;

	YDisplay = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_ITEM_X, ydisp_x, PANEL_ITEM_Y, ydisp_y,
	    PANEL_LABEL_FONT, font,
	    0 ) ;

	XDisplay = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_ITEM_X, xdisp_x, PANEL_ITEM_Y, xdisp_y,
	    PANEL_LABEL_FONT, font,
	    0 ) ;

	Disp = panel_create_item( panel, PANEL_TEXT,
	    PANEL_ITEM_X, mdisp_x, PANEL_ITEM_Y, mdisp_y,
	    PANEL_VALUE_FONT, disp_font,
	    PANEL_NOTIFY_LEVEL, PANEL_ALL,
	    PANEL_ACCEPT_KEYSTROKE, 1,
	    PANEL_NOTIFY_PROC, Kbd_Proc,
	    PANEL_VALUE_DISPLAY_LENGTH, num_dig,
	    0 ) ;

	HexDisplay = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_ITEM_X, hexdisp_x, PANEL_ITEM_Y, hexdisp_y,
	    PANEL_LABEL_FONT, disp_font,
	    0 ) ;
}




static
Define_Anns()
{
	int	x,y ;

	x = firstax ;	y = firstay ;

	a_f = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_LABEL_X, x, PANEL_LABEL_Y, y,
	    PANEL_LABEL_STRING, "",
	    0 ) ;

	x += ann_dx ;

	a_rad = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_LABEL_X, x, PANEL_LABEL_Y, y,
	    PANEL_LABEL_STRING, "",
	    0 ) ;

	x += ann_dx ;

	a_radix = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_LABEL_X, x, PANEL_LABEL_Y, y,
	    PANEL_LABEL_STRING, "",
	    0 ) ;

	a_xradix = panel_create_item( panel, PANEL_MESSAGE,
	    PANEL_LABEL_X, x, PANEL_LABEL_Y, seconday,
	    PANEL_LABEL_STRING, "",
	    0 ) ;

	return ;
}



Update_Anns()
{
	char	*annunciator ;

	if (Pending_Op == Fx)	  annunciator = "f" ;
	else if (Pending_Op == Gx) annunciator = "g" ;
	else			  annunciator = "" ;
	panel_set( a_f, PANEL_LABEL_STRING, annunciator, 0 ) ;

	if (Trig_State == DEG)		annunciator = "" ;
	else if (Trig_State == RAD)	annunciator = "RAD" ;
	else				annunciator = "GRAD" ;
	panel_set( a_rad, PANEL_LABEL_STRING, annunciator, 0 ) ;

	if (radix == BIN)		annunciator = "BIN" ;
	else if (radix == OCT)		annunciator = "OCT" ;
	else if (radix == DEC)		annunciator = "" ;
	else 				annunciator = "HEX" ;
	panel_set( a_radix, PANEL_LABEL_STRING, annunciator, 0 ) ;

	if (radix == HEX)	annunciator = "" ;
	else			annunciator = "HEX" ;
	panel_set( a_xradix, PANEL_LABEL_STRING, annunciator, 0 ) ;

	return ;
}


static
Paint_Panel()
{
	/* nothing at the moment */
}



static	void
Conv_Event(item,event)
	Panel_item	item ;
	Event		*event ;
{
static	double	table1[] = {.3048, 0.39370, 1.609344, 1.150779, 0.028349525,
		.4535924e, 14.59390, 16.38706, .9463529e, 4.448222,
		4.186800, .5} ;
static	double	table2[] = {2.7182818284, 2.997925e+08, 9.80665,
		6.67e-11, 6.626e-34} ;

	int	iret, ibut ;

	if(event_id(event) == MS_RIGHT && event_is_down(event) &&
	   item == Keys[2][0][0])
	{
	  iret = (int) menu_show(Conv_Menu, panel, event, 0) ;
	  if (iret > 0)
	  {
	    Conversion = table1[iret-1] ;
	    But_Parse(310) ;			/* "conv" button */
	  }
	}
	else if(event_id(event) == MS_RIGHT && event_is_down(event) &&
		item == Keys[2][0][2])
	{
	  iret = (int) menu_show(Const_Menu, panel, event, 0) ;
	  if (iret > 0)
	  {
	    Constant = table2[iret-1] ;
	    But_Parse(312) ;			/* "const" button */
	  }
	}
	else
	  panel_default_handle_event(item,event) ;
}





static
Define_Menus()
{
	Conv_Menu = menu_create(MENU_STRINGS,
	    "ft/m", "in/cm", "mi/km", "n.mi/mi", "ozm/g", "lbm/kg",
	    "slug/kg", "ci/ml", "qt/l", "lb/nt", "cal/joule",
	    "vax/sun3", 0,
	  0 ) ;

	Const_Menu = menu_create(MENU_STRINGS,
	    "e", "c (m/sec)", "g (m/sec2)", "G (m3/kg/sec2)",
	    "h (joule-sec)", 0,
	  0 ) ;
}




/********
 *
 * This routine updates both displays according to the value in xreg
 * or Key_In, depending on the state of Display_State
 *
 ********/
static
Update_Displays()
{
	if(Display_State == XREG)
	{
	  Upd_One_Display( TDisplay, DEC, treg, PANEL_LABEL_STRING );
	  Upd_One_Display( ZDisplay, DEC, zreg, PANEL_LABEL_STRING );
	  Upd_One_Display( YDisplay, DEC, yreg, PANEL_LABEL_STRING );
	  Upd_One_Display( XDisplay, DEC, xreg, PANEL_LABEL_STRING );
	  Upd_One_Display( Disp, radix, xreg, PANEL_VALUE );
	  if( radix == HEX )
	    Upd_One_Display( HexDisplay, DEC, xreg, PANEL_LABEL_STRING );
	  else
	    Upd_One_Display( HexDisplay, HEX, xreg, PANEL_LABEL_STRING );
	}    
        else if ( Display_State == ERROR )
        {
	  Gen_Display( Disp, "Error", PANEL_VALUE ) ;
	  Gen_Display( HexDisplay, "Error", PANEL_LABEL_STRING ) ;
        }
 
	return ;
}


/******
 *
 * This routine updates one display, according to the value in regval;
 * it assumes that Display_State == XREG.
 *
 ******/

Upd_One_Display( whichDisplay, aRadix, regval, attrName )
	Panel_item	whichDisplay;
	int		aRadix;         /* which radix for this display */
	double		regval;
	int		attrName ;
{

	char	oline[num_dig] ;
	char	*optr ;

	double	val ;

static	double	Exp_P1[10][4] = {
	{ 1.0,          1.0,             1.0,    1.0 },
	{ 1.0,          1.0,             1.0,    1.0 },
	{ 0.5,          0.125,           0.1,    0.0625 } ,
	{ 0.25,         0.015625,        0.01,   3.90625e-03 } ,
	{ 0.125,        1.953125e-03,    0.001,  2.44140625e-04 } ,
	{ 0.0625,       2.44140625e-04,  1.0e-4, 1.525878906e-05 } ,
	{ 0.03125,      3.051757813e-05, 1.0e-5, 9.536743164e-07 } ,
	{ 0.015625,     3.814697266e-06, 1.0e-6, 5.960464478e-08 } ,
	{ 0.0078125,    4.768371582e-07, 1.0e-7, 3.725290298e-09 } ,
	{ 3.90625e-03,  5.960464478e-08, 1.0e-8, 2.328306437e-10 } } ;
/*	{ 1.953125e-03, 7.450580597e-09, 1.0e-9, 1.455191523e-11 } , */
static	double	Max_Fix[4] = {   6.871947674e+10,
				 3.245185537e+32,
				 1.000000000e+36,
				 2.230074520e+43 } ;

	optr = oline ;

	val = fabs (regval) ;

	if(regval<0.0)
	    *optr++ = '-' ;
	/* else */
	    /* *optr++ = ' ' ; */

	if(Display_0x && (aRadix==OCT || aRadix==HEX))
	    *optr++ = '0' ;
	if(Display_0x && aRadix==HEX)
	    *optr++ = 'x' ;

	if (Display_Type == SCI  ||
	    Display_Type == FIX && val!=0.0 &&
	      (val>Max_Fix[aRadix] ||
	       val<Exp_P1[Display_Digits][aRadix]))
	    Gen_Digits(val, 0, &optr, aRadix ) ;

	else if (Display_Type == ENG) 
	    Gen_Digits(val, 1, &optr, aRadix ) ;

	else
	    Gen_Fixed(val, &optr, num_dig-1, aRadix ) ;
	    
	*optr++ = '\0' ;
	Gen_Display( whichDisplay, oline, attrName ) ;

	return ;
}



/******
 *
 * place digits on screen
 *
 *****/

static
Gen_Display( whichDisplay, oline, attrName )
	Panel_item	whichDisplay;
	char	*oline ;
{
	panel_set( whichDisplay, attrName, oline, 0 ) ;
}



/*****
 *
 * convert scientific or engineering mode
 *
 *****/

static
Gen_Digits(Val, Eng, optr, aRadix )
	double	Val ;		/* value to convert */
	int	Eng ;		/* Engineering flag */
	char	**optr ;	/* pointer to where next character goes */
	int	aRadix ;	/* which radix for this display */
{
	double	Mant ;		/* mantissa */
	int	Exp = 0 ;	/* exponent */
	double	Atmp ;
static	char	digits[] = "0123456789abcdef" ;

	Mant = Val ;
	Atmp = 1.0 / Powrs[10][aRadix] ;

	if (Mant != 0.0)
	{
	    while (Mant>=Powrs[10][aRadix])
	    {
		Exp += 10 ;
		Mant *= Atmp ;
	    }

	    while ( (!Eng && Mant>=Powrs[1][aRadix]) ||
		    ( Eng && (Mant>=Powrs[3][aRadix] || Exp%3!=0)) )
	    {
		Exp += 1 ;
		Mant /= Powrs[1][aRadix];
	    }

	    while (Mant < Atmp)
	    {
		Exp -= 10 ;
		Mant *= Powrs[10][aRadix] ;
	    }

	    while (Mant < 1.0 || (Eng && Exp%3!=0) ) 
	    {
		Exp -= 1 ;
		Mant *= Powrs[1][aRadix] ;
	    }
	}


	Gen_Fixed( Mant, optr, num_dig-6, aRadix ) ;

	if (Display_E) *(*optr)++ = 'e' ;
	else           *(*optr)++ = ' ' ;

	if (Exp<0)
	{
	    Exp = -Exp ;
	    *(*optr)++ = '-' ;
	}
	else
	    *(*optr)++ = '+' ;

	if ( (*(*optr) = digits[Exp/((int) Powrs[2][radix])]) !='0')
	    (*optr)++  ;
	Exp %= (int) Powrs[2][aRadix] ;
	*(*optr)++ = digits[Exp/((int) Powrs[1][aRadix])] ;
	Exp %= (int) Powrs[1][aRadix] ;
	*(*optr)++ = digits[Exp] ;

	return ;
}



static
Gen_Fixed(Val, optr, cmax, aRadix )
	double	Val ;		/* value to convert */
	char	**optr ;	/* pointer to next character to add */
	int	cmax ;		/* max number of characters to generate */
	int	aRadix ;	/* which radix for this display */
{
	int	ndig ;		/* total # digits to generate */
	int	ddig ;		/* number of digits to left of . */
	int	dval ;
static	char	digits[] = "0123456789abcdef" ;


	Val += .5/Powrs[Display_Digits][aRadix] ;

	if (Val<1.0)
	{
	    ddig = 0 ;
	    *(*optr)++ = '0' ;
	    cmax-- ;
	}
	else
	{
	    for( ddig=0 ; Val>=1.0 ; ddig++ )
		Val/=Powrs[1][aRadix] ;
	}

	/* (we lose one character for the decimal point) */

	ndig = min(ddig+Display_Digits, --cmax ) ;

	while ( ndig-- > 0 )
	{
	    if(ddig-- == 0 )
		*(*optr)++ = '.' ;
	    Val*=Powrs[1][aRadix] ;
	    dval = Val ;
	    *(*optr)++ = digits[dval] ;
	    Val -= (int) Val ;
	}

	return ;
}





/*********
 *
 * this routine receives all button notifications.  The button ID is passed
 * to But_Parse
 *
 ********/

static void
Button_Proc(item, event)
	Panel_item	item ;
	Event		*event ;
{
	Current_Event = event ;
	But_Parse((int) panel_get(item, PANEL_CLIENT_DATA)) ;

	return ;
}




/****
 *
 * This routine receives all events from the panel background.
 * ascii events are translated into buttons and sent to But_Parse.
 * All other events are ignored
 *
 ****/


static Panel_setting
Kbd_Proc(item, event) 
	Panel_item item ;
	Event	*event ;
{
	int	k ;
	int	chr ;

/*
 *	key to button mapping:
 *
 *	0-9	0-9
 *	A-F	(hex chars, no mapping)
 *	a-f	(hex chars, no mapping)
 *	.	.
 *	+	add
 *	-	minus
 *	*	multiply
 *	/	divide
 *	<space>	enter
 *	<cr>	enter
 *	,	enter
 *	<del>	backarrow
 *	<bs>	backarrow
 *	f	f	(not in hex mode)
 *	g	g
 *	e	EEX	(not in hex mode)
 *	x	x<>y
 *	c	chs	(not in hex mode)
 *	>	>>
 *	<	<<
 *	&	AND
 *	|	OR
 *	^	XOR
 *	~	NOT
 *	s	STO
 *	r	RCL
 */


	Current_Event = event ;
	k = 0 ;

	chr = event_id(event) ;

	if (chr>='A' && chr<='F')
	    k = 111 + (chr-'A')*10 ;

	else if (radix==HEX && chr>='a' && chr<='f')
	    k = 111 + (chr-'a')*10 ;

	else if (radix==HEX && Display_0x && (chr=='x' || chr=='X'))
	    k = 0 ;

	else
	    switch (event_id(event))
	    {
		case KEY_RIGHT(1) : k = 171 ; break ;
		case KEY_RIGHT(2) : k = 181 ; break ;
		case KEY_RIGHT(3) : k = 191 ; break ;
		case KEY_RIGHT(4) : k = 271 ; break ;
		case KEY_RIGHT(5) : k = 281 ; break ;
		case KEY_RIGHT(6) : k = 291 ; break ;
		case KEY_RIGHT(7) : k = 371 ; break ;
		case KEY_RIGHT(8) : k = 381 ; break ;
		case KEY_RIGHT(9) : k = 391 ; break ;
		case KEY_RIGHT(10) : k = 471 ; break ;
		case KEY_RIGHT(11) : k = 481 ; break ;
		case KEY_RIGHT(12) : k = 491 ; break ;
		case KEY_RIGHT(13) : k = 361 ; break ;
		case KEY_RIGHT(14) : k = 401 ; break ;
		case KEY_RIGHT(15) : k = 301 ; break ;
		case '0' : k = 471 ; break ;
		case '1' : k = 371 ; break ;
		case '2' : k = 381 ; break ;
		case '3' : k = 391 ; break ;
		case '4' : k = 271 ; break ;
		case '5' : k = 281 ; break ;
		case '6' : k = 291 ; break ;
		case '7' : k = 171 ; break ;
		case '8' : k = 181 ; break ;
		case '9' : k = 191 ; break ;
		case '.' : k = 481 ; break ;
		case '+' : k = 401 ; break ;
		case '-' : k = 301 ; break ;
		case '*' : k = 201 ; break ;
		case '/' : k = 101 ; break ;
		case ' ' :
		case '\n':
		case '\r':
		case ',' : k = 361 ; break ;
		case '\177' : Del_Flag = item == Disp ;
		case '\b': k = 351 ; break ;
		case '\025' :
		case '\027' : k = 352 ; break ;
		case 'f' : k = 421 ; break ;
		case 'g' : k = 431 ; break ;
		case 'e' : k = 261 ; break ;
		case 'x' : k = 341 ; break ;
		case 'c' : k = 491 ; break ;
		case '<' : k = 240 ; break ;
		case '>' : k = 250 ; break ;
		case '&' : k = 150 ; break ;
		case '|' : k = 152 ; break ;
		case '^' : k = 160 ; break ;
		case '~' : k = 142 ; break ;
		case 's' : k = 441 ; break ;
		case 'r' : k = 451 ; break ;
		case 'k' : k = 360 ; break ;
		case '?' : k = 410 ; break ;
		default : ;
	    }

	if (k>0)
	{
	    Cmd_Parse(k) ;
	    Update_Displays() ;
	}

	Del_Flag = 0 ;

	return(PANEL_NONE) ;

}




static
But_Parse(Key_Code)
	int	Key_Code ;
{
	Cmd_Parse(Key_Code) ;
	Update_Displays() ;
}




Close_Calc()
{
	window_set(base_frame, FRAME_CLOSED, 1, 0 ) ;
}



Quit_Calc()
{
	window_done(base_frame) ;
}




	/* various calculator function */

Add_Digit(n)		/* add a digit to the number being keyed in */
	int	n ;
{
static	int	Max[4] = {1, 7, 9, 15} ;


	if ( n <= Max[radix] ) {

	    if ( Display_State!=KEY_IN )
		Enter_Input_Mode() ;

	    Add_Panel_Char(Disp, &dig_events[n]) ;
	    Key_Pos++ ;
	}

	return ;
}



Add_DP()		/* add a decimal point to the number being keyed in */
{
	if ( Display_State!=KEY_IN )
	    Enter_Input_Mode() ;

	if (Point_Pos==-1 && !Key_Exp)
	{
	    Add_Panel_Char(Disp, &dp_event) ;
	    Point_Pos = Key_Pos++ ;
	}


	return ;
}



Backarrow()
{
	if( Key_Pos > 1 ) {
	    if(--Key_Pos == Point_Pos) Point_Pos = -1 ;
	    if (!Del_Flag) Add_Panel_Char(Disp, &del_event) ;
	    if(Key_Pos<=Exp_Posn) Key_Exp = 0 ;
	}
	else if (Del_Flag) Add_Panel_Char(Disp, &space_event) ;
}



Add_Exp()
{

	if ( Display_State != KEY_IN )
	{
	    Enter_Input_Mode() ;
	    Add_Digit(1) ;
	    Add_DP() ;
	    Add_Digit(0) ;
	}

	if ( !Key_Exp )
	{
	    if(Point_Pos==-1) Add_DP() ;
	    Add_Panel_Char(Disp, &space_event) ;
	    Add_Panel_Char(Disp, &plus_event) ;
	    Exp_Posn = ++Key_Pos ;
	    Key_Pos++ ;
	
	    Key_Exp = 1 ;
	}
}



Add_Negate()			/* here for CHS */
{
	char	line[80] ;
	char	*chr ;
	char	*oval ;

	oval = (char *) panel_get_value ( Disp ) ;
	if (oval != line ) strcpy(line,oval) ;

	if (Key_Exp) {
	    chr = line + Exp_Posn ;
	    if (*chr=='+') *chr = '-' ;
	    else	   *chr = '+' ;
	}
	else {
	    chr = line ;
	    if (*chr==' ') *chr = '-' ;
	    else	   *chr = ' ' ;
	}
	

	panel_set_value ( Disp, line ) ;

	return ;
}



Add_Number()			/* Convert key-in buffer to a number */
{
static	int	Powr[4] = {2, 8, 10, 16} ;
	int	i ;
	int	inum ;
	int	Exp ;
	int	Exp_Sign ;
	char	*line ;

/*
If I've done this right, the format of the key-in buffer is
	buffer :: <s><int_part><frac_part><exp_part>
	s :: ' ' | '-' | (nil)
	int_part :: <digits> | (nil)
	frac_part :: .<digits> | (nil)
	exp_part :== ' '<s><digits> | (nil)
*/

	line = panel_get_value( Disp ) ;

	xreg = 0.0 ;
	Exp = 0 ;


	if (*line == ' ')      Key_Sign = 1 ;
	else if (*line == '-') Key_Sign = -1 ;
	else line-- ;


	while((inum = char_val(*++line)) >= 0)
	    xreg = xreg*Powr[radix] + inum ;


	if(*line=='.')
	    for(i=1; (inum = char_val(*++line)) >= 0; i++)
		xreg += inum/Powrs[i][radix] ;


	while(*line==' ') line++ ;

	if(*line!='\0') {
	    if(*line=='-') Exp_Sign = -1 ;
	    else	   Exp_Sign = 1 ;
	    while((inum = char_val(*++line)) >= 0) {
		Exp = Exp*Powr[radix] + inum ;
	    }
	    Exp *= Exp_Sign ;
	}

	xreg *= Key_Sign ;

	if(Key_Exp)
	    xreg *= pow((double)Powr[radix], (double)Exp) ;

	Display_State = XREG ;
}



static
char_val(chr)
	char	chr ;
{
	if      (chr>='0' && chr<='9') return(chr-'0') ;
	else if (chr>='A' && chr<='F') return(chr-'A'+10) ;
	else if (chr>='a' && chr<='f') return(chr-'a'+10) ;
	else return(-1) ;
}





static
Enter_Input_Mode()
{
	if (Pending_Lift) { treg = zreg ; zreg = yreg ; yreg = xreg ; } 
	Display_State=KEY_IN ;
	Key_Pos = 1 ;  
	Point_Pos = -1 ;
	Key_Exp = 0 ;

	panel_set_value( Disp, " " ) ;
}



static
Add_Panel_Char(object, event)
	Panel_item object ;
	Event	*event ;
{
	panel_set ( object, PANEL_NOTIFY_LEVEL, PANEL_NONE, 0 ) ;
	panel_accept_key ( object, event ) ;
	panel_set ( object, PANEL_NOTIFY_LEVEL, PANEL_ALL, 0 ) ;
}


caddr_t
done_proc(menu, menu_item)
	Menu	menu ;
	Menu_item	menu_item ;
{
	window_set(help_frame, WIN_SHOW, FALSE, 0 ) ;
}


static	int	frame_width = -1 ;
static	int	frame_height = -1 ;

Calc_Help()
{
static	unsigned long	help_info[] = {
#include "info.h"
} ;

	if ( help_frame==NULL)
	{
	  help_frame = window_create(base_frame, FRAME,
		FRAME_DONE_PROC, done_proc, 0) ;
	  help_sw = window_create(help_frame, TEXTSW,
		TEXTSW_CONTENTS, help_info,
		TEXTSW_BROWSING, TRUE,
		TEXTSW_DISABLE_CD, TRUE,
		TEXTSW_DISABLE_LOAD, TRUE,
		TEXTSW_FIRST, 0,
		TEXTSW_MENU, window_get(help_frame, WIN_MENU),
		TEXTSW_READ_ONLY, TRUE,
		TEXTSW_LINE_BREAK_ACTION, TEXTSW_CLIP,
		WIN_FONT, font,
		TEXTSW_FONT, font,
		0 ) ;
	}
	window_set(help_frame, WIN_SHOW, TRUE, 0 ) ;
}
