/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _ulaw_h
#define _ulaw_h

#include "conf.h"

extern short           _uLaw2Linear[];
extern unsigned char  *_linear2ULaw;

#define ULAW_MAGIC	0x2e736e64	/* ".snd" ulaw file header */
#define ULAW_HDRSIZE	24		/* minimum ulaw header size */

#define ulaw_to_linear(ulaw8) (_uLaw2Linear[(unsigned char)(ulaw8)])
#define linear_to_ulaw(lin16) (_linear2ULaw[(short)(lin16) >> 3])

#endif /* _ulaw_h */
