/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _spool_h
#define _spool_h

#include "conf.h"
#include "rplay.h"
#include "sound.h"
#include "buffer.h"

#define SPOOL_NULL	0
#define SPOOL_PLAY	1
#define SPOOL_PAUSE	2
#define SPOOL_WAIT	3

#define SPOOL_MIN_ID	1
#define SPOOL_MAX_ID	999

typedef struct _spool
{
	int			id;
	int			state;
	int			curr_sound;
	int			curr_count;
	int			list_count;
	SOUND			*sound[SOUND_LIST_SIZE];
	char			*ptr;
	char			*end;
	RPLAY			*rp;
	RPLAY_ATTRS		*curr_attrs;
	struct sockaddr_in	sin;
} SPOOL;

extern SPOOL	spool[SPOOL_SIZE];
extern int	spool_size;
extern int	spool_prio;

#ifdef __STDC__
extern void	spool_init();
extern int	spool_match(RPLAY *match,  void (*action)(SPOOL *), struct sockaddr_in sin);
extern SPOOL	*spool_next(int priority);
extern void	spool_ready(SOUND *sound);
extern void	spool_remove(SOUND *sound);
extern BUFFER	*spool_list_create();
extern void	spool_clear(SPOOL *sp);
extern void	spool_setprio(void);
extern int	spool_id(void);
extern void	spool_stop(SPOOL *sp);
extern void	spool_pause(SPOOL *sp);
extern void	spool_continue(SPOOL *sp);
#else
extern void	spool_init();
extern int	spool_match(/* RPLAY *match,  void (*action)(SPOOL *), struct sockaddr_in sin */);
extern SPOOL	*spool_next(/* int priority */);
extern void	spool_ready(/* SOUND *sound */);
extern void	spool_remove(/* SOUND *sound */);
extern BUFFER	*spool_list_create();
extern void	spool_clear(/* SPOOL *sp */);
extern void	spool_setprio();
extern int	spool_id();
extern void	spool_stop(/* SPOOL *sp */);
extern void	spool_pause(/* SPOOL *sp */);
extern void	spool_continue(/* SPOOL *sp */);
#endif

#endif /* _spool_h */
