/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _hash_h
#define _hash_h

#include "conf.h"

#ifdef __STDC__
extern void	hash_init(int hash_table_size);
extern char	*hash_get(char *hash_key);
extern void	hash_put(char *hash_key, char *data);
extern void	hash_delete(char *hash_key);
extern char	*hash_name(char *pathname);
#else
extern void	hash_init(/* int hash_table_size */);
extern char	*hash_get(/* char *hash_key */);
extern void	hash_put(/* char *hash_key, char *data */);
extern void	hash_delete(/* char *hash_key */);
extern char	*hash_name(/* char *pathname */);
#endif

#endif /* _hash_h */
