/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _cache_h
#define _cache_h

#include "conf.h"

extern int	cache_max_size;

#ifdef __STDC__
extern void	cache_init(char *dir_name);
extern char	*cache_first();
extern char	*cache_next();
extern int	cache_size();
extern void	cache_read();
extern char	*cache_name(char *sound);
extern int	cache_free(int size);
#ifdef MMAP
extern char	*cache_create(char *name, int size);
#else
extern int	cache_create(char *name, int size);
#endif /* MMAP */
#else
extern void	cache_init(/* char *dir_name */);
extern char	*cache_first();
extern char	*cache_next();
extern int	cache_size();
extern void	cache_read();
extern char	*cache_name(/* char *sound */);
extern int	cache_free(/* int size */);
#ifdef MMAP
extern char	*cache_create(/* char *name, int size */);
#else
extern int	cache_create(/* char *name, int size */);
#endif /* MMAP */
#endif

#endif /* _cache_h */
